/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.thread;

import com.ibm.jinwoo.thread.Monitor;
import com.ibm.jinwoo.thread.MonitorModel;
import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class JinwooRenderer
extends DefaultTreeCellRenderer {
    MonitorModel model;
    static NumberFormat nf = NumberFormat.getNumberInstance();

    public JinwooRenderer() {
    }

    public JinwooRenderer(MonitorModel m) {
        this.model = m;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        int id = ((Monitor)value).owner;
        if (id == -1) {
            this.setText("[TotalSize/Size] ThreadName (ObjectName) " + nf.format(this.model.rootChildren.length));
        } else {
            Monitor m1;
            TreePath tp = tree.getPathForRow(row);
            if (tp != null && (m1 = (Monitor)tp.getLastPathComponent()) != null && tp.getPathCount() > 2) {
                TreePath tpp = tp.getParentPath();
                while (tpp != null) {
                    if (m1.owner == ((Monitor)tpp.getLastPathComponent()).owner) {
                        this.setIcon(new ImageIcon(this.getClass().getResource("/Dup16.gif")));
                        break;
                    }
                    tpp = tpp.getParentPath();
                }
            }
            if (((Monitor)value).isDeadlock) {
                this.setIcon(new ImageIcon(this.getClass().getResource("/deadlock_view.gif")));
            } else {
                switch (this.model.getThreadState(id)) {
                    case 0: {
                        this.setIcon(new ImageIcon(this.getClass().getResource("/run.gif")));
                        break;
                    }
                    case 1: {
                        this.setIcon(new ImageIcon(this.getClass().getResource("/condition.gif")));
                        break;
                    }
                    case 2: {
                        this.setIcon(new ImageIcon(this.getClass().getResource("/monitor_wait.gif")));
                        break;
                    }
                    case 3: {
                        this.setIcon(new ImageIcon(this.getClass().getResource("/suspend.gif")));
                        break;
                    }
                    case 4: {
                        this.setIcon(new ImageIcon(this.getClass().getResource("/waiting.gif")));
                        break;
                    }
                    case 5: {
                        this.setIcon(new ImageIcon(this.getClass().getResource("/block.gif")));
                        break;
                    }
                    case 6: {
                        this.setIcon(new ImageIcon(this.getClass().getResource("/park.gif")));
                    }
                }
            }
            if (this.model.child[id] != null) {
                if (this.model.objectName[id] == -1) {
                    this.setText("[" + nf.format(this.model.total[id]) + "/" + nf.format(this.model.size[id]) + "] " + this.model.getThreadName(id));
                } else {
                    this.setText("[" + nf.format(this.model.total[id]) + "/" + nf.format(this.model.size[id]) + "] " + this.model.getThreadName(id) + " (" + this.model.objectArray[this.model.objectName[id]] + ")");
                }
            } else if (this.model.objectName[id] >= 0) {
                this.setText(String.valueOf(this.model.getThreadName(id)) + " (" + this.model.objectArray[this.model.objectName[id]] + ")");
            } else {
                this.setText(this.model.getThreadName(id));
            }
        }
        return this;
    }
}

