/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.thread;

import com.ibm.jinwoo.thread.CompareCell;
import com.ibm.jinwoo.thread.Configuration;
import com.ibm.jinwoo.thread.MonitorCompareTableCellRenderer;
import com.ibm.jinwoo.thread.MonitorCompareTableModel;
import com.ibm.jinwoo.thread.MonitorDump;
import com.ibm.jinwoo.thread.ThreadDump;
import com.ibm.jinwoo.thread.ThreadFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.html.HTMLDocument;

public class MonitorCompareFrame
extends JInternalFrame
implements ListSelectionListener {
    Configuration cfg;
    private int dividerLocation = 100;
    private JScrollPane ivjCompareScrollPane = null;
    private JSplitPane ivjCompareSplitPane = null;
    private JTable ivjCompareTable = null;
    private JScrollPane ivjDetailScrollPane = null;
    private JTextPane ivjDetailTextPane = null;
    public ThreadDump[] threadDumps = null;
    private MonitorCompareTableModel tt = null;
    private JSplitPane ivjDetailSplitPane = null;
    private JList ivjThreadList = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JList ivjBlockList = null;
    private JLabel ivjJLabelBlocking = null;
    private JLabel ivjJLabelWaiting = null;
    private JPanel ivjJPanel1 = null;
    private JScrollPane ivjJScrollPane1 = null;
    private JScrollPane ivjListScrollPane = null;

    public MonitorCompareFrame() {
        this.initialize();
    }

    public MonitorCompareFrame(ThreadDump[] td) {
        this.threadDumps = td;
        this.initialize();
    }

    public MonitorCompareFrame(String title) {
        super(title);
    }

    public MonitorCompareFrame(String title, ThreadDump[] td) {
        super(title);
        this.threadDumps = td;
        this.initialize();
    }

    public MonitorCompareFrame(String title, ThreadDump[] td, Configuration c) {
        super(title);
        this.cfg = c;
        this.threadDumps = td;
        this.initialize();
    }

    public MonitorCompareFrame(String title, boolean resizable) {
        super(title, resizable);
    }

    public MonitorCompareFrame(String title, boolean resizable, boolean closable) {
        super(title, resizable, closable);
    }

    public MonitorCompareFrame(String title, boolean resizable, boolean closable, boolean maximizable) {
        super(title, resizable, closable, maximizable);
    }

    public MonitorCompareFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        super(title, resizable, closable, maximizable, iconifiable);
    }

    public void blockList_MouseClicked(MouseEvent mouseEvent) {
        if (this.getBlockList().getSelectedIndex() != -1) {
            int selectedColumn = this.getCompareTable().getSelectedColumn();
            int i = 0;
            while (i < this.tt.hi[selectedColumn - 1].name.length) {
                if (this.tt.hi[selectedColumn - 1].name[i].compareTo((String)this.getBlockList().getSelectedValue()) == 0) {
                    String stackTrace = "<table border=\"1\"><tr><th><B>Thread Name</B></th><th>" + this.tt.hi[selectedColumn - 1].name[i] + "<tr><td><B>State</B></td><td>" + this.tt.hi[selectedColumn - 1].getState(i);
                    String monString = "";
                    String m1 = this.tt.hi[selectedColumn - 1].getOwningMonitor(i);
                    if (m1 != null) {
                        monString = String.valueOf(monString) + "Owns Monitor Lock on " + m1;
                    }
                    if ((m1 = this.tt.hi[selectedColumn - 1].getWaitingMonitor(i)) != null) {
                        if (monString.length() != 0) {
                            monString = String.valueOf(monString) + "<BR>";
                        }
                        monString = String.valueOf(monString) + "Waiting for Monitor Lock on " + m1;
                    }
                    stackTrace = monString.length() == 0 ? String.valueOf(stackTrace) + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Monitor</B></td><td>" + monString + "</td></tr>";
                    stackTrace = this.tt.hi[selectedColumn - 1].javaStack[i] == null ? String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td>No Java stack trace available</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td><td>" + this.tt.hi[selectedColumn - 1].javaStack[i] + "</td></tr>";
                    stackTrace = this.tt.hi[selectedColumn - 1].nativeStack[i] != null ? String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td><td>" + this.tt.hi[selectedColumn - 1].nativeStack[i] + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Stack Trace</B></td>No stack trace available</td></tr>";
                    this.getDetailTextPane().setText(ThreadFrame.getCopyFriendlyString(stackTrace));
                    this.getDetailTextPane().setCaretPosition(0);
                }
                ++i;
            }
        }
    }

    public void compareTable_KeyReleased(KeyEvent keyEvent) {
        this.compareTable_MouseClicked(null);
    }

    public void compareTable_MouseClicked(MouseEvent mouseEvent) {
        DefaultListModel<Object> listModel = new DefaultListModel<Object>();
        this.getThreadList().setModel(listModel);
        DefaultListModel<Object> listModel2 = new DefaultListModel<Object>();
        this.getBlockList().setModel(listModel2);
        this.getDetailTextPane().setText("");
        int selectedThread = -1;
        int selectedRow = this.getCompareTable().getSelectedRow();
        int selectedColumn = this.getCompareTable().getSelectedColumn();
        if (selectedColumn == 0) {
            this.getDetailTextPane().setText(this.tt.threadNames[selectedRow]);
        } else {
            int i;
            int i2 = 0;
            while (i2 < this.tt.hi[selectedColumn - 1].sys_thread.length) {
                if (this.tt.hi[selectedColumn - 1].sys_thread[i2] == this.tt.threadID[selectedRow]) {
                    String stackTrace = "<table border=\"1\"><tr><th><B>Thread Name</B></th><th>" + this.tt.hi[selectedColumn - 1].name[i2] + "<tr><td><B>State</B></td><td>" + this.tt.hi[selectedColumn - 1].getState(i2);
                    selectedThread = i2;
                    String monString = "";
                    String m1 = this.tt.hi[selectedColumn - 1].getOwningMonitors(i2);
                    if (m1 != null) {
                        monString = String.valueOf(monString) + "Owns Monitor Lock on " + m1;
                    }
                    if ((m1 = this.tt.hi[selectedColumn - 1].getWaitingMonitors(i2)) != null) {
                        if (monString.length() != 0) {
                            monString = String.valueOf(monString) + "<BR>";
                        }
                        monString = String.valueOf(monString) + "Waiting for Monitor Lock on " + m1;
                    }
                    stackTrace = monString.length() == 0 ? String.valueOf(stackTrace) + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Monitor</B></td><td>" + monString + "</td></tr>";
                    stackTrace = this.tt.hi[selectedColumn - 1].javaStack[i2] == null ? String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td>No Java stack trace available</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td><td>" + this.tt.hi[selectedColumn - 1].javaStack[i2] + "</td></tr>";
                    stackTrace = this.tt.hi[selectedColumn - 1].nativeStack[i2] != null ? String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td><td>" + this.tt.hi[selectedColumn - 1].nativeStack[i2] + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td>No Native stack trace available</td></tr>";
                    this.getDetailTextPane().setText(ThreadFrame.getCopyFriendlyString(stackTrace));
                    this.getDetailTextPane().setCaretPosition(0);
                    break;
                }
                ++i2;
            }
            MonitorDump[] md = this.tt.hi[selectedColumn - 1].mdump;
            ArrayList waitingThreads = null;
            int i3 = 0;
            while (i3 < md.length) {
                if (this.tt.threadID[selectedRow] == md[i3].owner) {
                    if (waitingThreads == null) {
                        waitingThreads = new ArrayList(md[i3].waiting);
                    } else {
                        waitingThreads.addAll(md[i3].waiting);
                    }
                }
                ++i3;
            }
            this.setJLabelWaiting(0);
            if (waitingThreads != null) {
                if (this.getDetailSplitPane().getDividerLocation() != 1) {
                    this.dividerLocation = this.getDetailSplitPane().getDividerLocation();
                }
                if (this.dividerLocation == 0) {
                    this.dividerLocation = 100;
                }
                this.getDetailSplitPane().setDividerLocation(this.dividerLocation);
                ArrayList<String> nameList = new ArrayList<String>();
                int i4 = 0;
                while (i4 < waitingThreads.size()) {
                    int j = 0;
                    while (j < this.tt.hi[selectedColumn - 1].sys_thread.length) {
                        if ((Long)waitingThreads.get(i4) == this.tt.hi[selectedColumn - 1].sys_thread[j]) {
                            nameList.add(this.tt.hi[selectedColumn - 1].name[j]);
                        }
                        ++j;
                    }
                    ++i4;
                }
                if (nameList.size() != 0) {
                    Object[] sortedName = nameList.toArray(new String[nameList.size()]);
                    Arrays.sort(sortedName, 0, sortedName.length);
                    i = 0;
                    while (i < sortedName.length) {
                        listModel.addElement(sortedName[i]);
                        ++i;
                    }
                    this.setJLabelWaiting(listModel.getSize());
                    nameList = null;
                }
            }
            MonitorDump[] mdump = md;
            ArrayList<String> blockList = new ArrayList<String>();
            i = 0;
            while (i < mdump.length) {
                if (mdump[i] != null && mdump[i].waiting != null && mdump[i].waiting.size() != 0 && mdump[i].owner != -1L) {
                    int j = 0;
                    while (j < mdump[i].waiting.size()) {
                        if ((Long)mdump[i].waiting.get(j) == this.tt.hi[selectedColumn - 1].sys_thread[selectedThread] && !blockList.contains(this.tt.hi[selectedColumn - 1].name[this.tt.hi[selectedColumn - 1].getIndexFromSysThread(mdump[i].owner)])) {
                            blockList.add(this.tt.hi[selectedColumn - 1].name[this.tt.hi[selectedColumn - 1].getIndexFromSysThread(mdump[i].owner)]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.setJLabelBlocking(0);
            if (blockList.size() != 0) {
                if (this.getDetailSplitPane().getDividerLocation() != 1) {
                    this.dividerLocation = this.getDetailSplitPane().getDividerLocation();
                }
                if (this.dividerLocation == 0) {
                    this.dividerLocation = 100;
                }
                this.getDetailSplitPane().setDividerLocation(this.dividerLocation);
                Object[] sortedName = blockList.toArray(new String[blockList.size()]);
                Arrays.sort(sortedName, 0, sortedName.length);
                int i5 = 0;
                while (i5 < sortedName.length) {
                    listModel2.addElement(sortedName[i5]);
                    ++i5;
                }
                this.setJLabelBlocking(listModel2.getSize());
                blockList = null;
            } else if (waitingThreads == null) {
                if (this.getDetailSplitPane().getDividerLocation() != 1) {
                    this.dividerLocation = this.getDetailSplitPane().getDividerLocation();
                }
                this.getDetailSplitPane().setDividerLocation(1);
            }
        }
    }

    private void connEtoC1(MouseEvent arg1) {
        try {
            this.compareTable_MouseClicked(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(KeyEvent arg1) {
        try {
            this.compareTable_KeyReleased(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(MouseEvent arg1) {
        try {
            this.threadList_MouseClicked(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(MouseEvent arg1) {
        try {
            this.blockList_MouseClicked(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JList getBlockList() {
        if (this.ivjBlockList == null) {
            try {
                this.ivjBlockList = new JList();
                this.ivjBlockList.setName("BlockList");
                this.ivjBlockList.setBounds(0, 0, 160, 120);
                this.ivjBlockList.addListSelectionListener(this);
                this.ivjBlockList.setDragEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBlockList;
    }

    private JScrollPane getCompareScrollPane() {
        if (this.ivjCompareScrollPane == null) {
            try {
                this.ivjCompareScrollPane = new JScrollPane();
                this.ivjCompareScrollPane.setName("CompareScrollPane");
                this.ivjCompareScrollPane.setVerticalScrollBarPolicy(22);
                this.ivjCompareScrollPane.setHorizontalScrollBarPolicy(32);
                this.getCompareScrollPane().setViewportView(this.getCompareTable());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCompareScrollPane;
    }

    private JSplitPane getCompareSplitPane() {
        if (this.ivjCompareSplitPane == null) {
            try {
                this.ivjCompareSplitPane = new JSplitPane(1);
                this.ivjCompareSplitPane.setName("CompareSplitPane");
                this.ivjCompareSplitPane.setDividerLocation(300);
                this.ivjCompareSplitPane.setOneTouchExpandable(true);
                this.ivjCompareSplitPane.setContinuousLayout(false);
                this.getCompareSplitPane().add((Component)this.getCompareScrollPane(), "left");
                this.getCompareSplitPane().add((Component)this.getDetailSplitPane(), "right");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCompareSplitPane;
    }

    private JTable getCompareTable() {
        if (this.ivjCompareTable == null) {
            try {
                this.ivjCompareTable = new JTable();
                this.ivjCompareTable.setName("CompareTable");
                this.getCompareScrollPane().setColumnHeaderView(this.ivjCompareTable.getTableHeader());
                this.getCompareScrollPane().getViewport().setBackingStoreEnabled(true);
                this.ivjCompareTable.setCellSelectionEnabled(true);
                this.ivjCompareTable.setBounds(0, 0, 200, 200);
                this.ivjCompareTable.setDragEnabled(true);
                this.ivjCompareTable.setDefaultRenderer(CompareCell.class, new MonitorCompareTableCellRenderer(this.cfg));
                this.tt = new MonitorCompareTableModel(this.threadDumps);
                this.ivjCompareTable.setModel(this.tt);
                this.getCompareScrollPane().setViewportView(this.ivjCompareTable);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCompareTable;
    }

    private JScrollPane getDetailScrollPane() {
        if (this.ivjDetailScrollPane == null) {
            try {
                this.ivjDetailScrollPane = new JScrollPane();
                this.ivjDetailScrollPane.setName("DetailScrollPane");
                this.getDetailScrollPane().setViewportView(this.getDetailTextPane());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDetailScrollPane;
    }

    private JSplitPane getDetailSplitPane() {
        if (this.ivjDetailSplitPane == null) {
            try {
                this.ivjDetailSplitPane = new JSplitPane(1);
                this.ivjDetailSplitPane.setName("DetailSplitPane");
                this.ivjDetailSplitPane.setOneTouchExpandable(true);
                this.ivjDetailSplitPane.setDividerLocation(70);
                this.getDetailSplitPane().add((Component)this.getDetailScrollPane(), "right");
                this.getDetailSplitPane().add((Component)this.getJPanel1(), "left");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDetailSplitPane;
    }

    private JTextPane getDetailTextPane() {
        if (this.ivjDetailTextPane == null) {
            try {
                this.ivjDetailTextPane = new JTextPane();
                this.ivjDetailTextPane.setName("DetailTextPane");
                this.ivjDetailTextPane.setDocument(new HTMLDocument());
                this.ivjDetailTextPane.setBounds(0, 0, 408, 424);
                this.ivjDetailTextPane.setEditable(false);
                this.ivjDetailTextPane.setContentType("text/html");
                this.ivjDetailTextPane.setDragEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDetailTextPane;
    }

    private JLabel getJLabelBlocking() {
        if (this.ivjJLabelBlocking == null) {
            try {
                this.ivjJLabelBlocking = new JLabel();
                this.ivjJLabelBlocking.setName("JLabelBlocking");
                this.ivjJLabelBlocking.setText("Blocked by : 0");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabelBlocking;
    }

    private JLabel getJLabelWaiting() {
        if (this.ivjJLabelWaiting == null) {
            try {
                this.ivjJLabelWaiting = new JLabel();
                this.ivjJLabelWaiting.setName("JLabelWaiting");
                this.ivjJLabelWaiting.setText("Waiting Threads : 0");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabelWaiting;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setLayout(new GridBagLayout());
                GridBagConstraints constraintsJLabelWaiting = new GridBagConstraints();
                constraintsJLabelWaiting.gridx = 1;
                constraintsJLabelWaiting.gridy = 1;
                constraintsJLabelWaiting.insets = new Insets(7, 3, 3, 2);
                this.getJPanel1().add((Component)this.getJLabelWaiting(), constraintsJLabelWaiting);
                GridBagConstraints constraintsListScrollPane = new GridBagConstraints();
                constraintsListScrollPane.gridx = 1;
                constraintsListScrollPane.gridy = 2;
                constraintsListScrollPane.fill = 1;
                constraintsListScrollPane.weightx = 1.0;
                constraintsListScrollPane.weighty = 1.0;
                constraintsListScrollPane.ipadx = 76;
                constraintsListScrollPane.ipady = 280;
                constraintsListScrollPane.insets = new Insets(3, 0, 4, 0);
                this.getJPanel1().add((Component)this.getListScrollPane(), constraintsListScrollPane);
                GridBagConstraints constraintsJScrollPane1 = new GridBagConstraints();
                constraintsJScrollPane1.gridx = 1;
                constraintsJScrollPane1.gridy = 4;
                constraintsJScrollPane1.fill = 1;
                constraintsJScrollPane1.weightx = 1.0;
                constraintsJScrollPane1.weighty = 1.0;
                constraintsJScrollPane1.ipadx = 76;
                constraintsJScrollPane1.ipady = 137;
                constraintsJScrollPane1.insets = new Insets(3, 0, 9, 0);
                this.getJPanel1().add((Component)this.getJScrollPane1(), constraintsJScrollPane1);
                GridBagConstraints constraintsJLabelBlocking = new GridBagConstraints();
                constraintsJLabelBlocking.gridx = 1;
                constraintsJLabelBlocking.gridy = 3;
                constraintsJLabelBlocking.ipadx = 15;
                constraintsJLabelBlocking.insets = new Insets(4, 8, 2, 13);
                this.getJPanel1().add((Component)this.getJLabelBlocking(), constraintsJLabelBlocking);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.getJScrollPane1().setViewportView(this.getBlockList());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane1;
    }

    private JScrollPane getListScrollPane() {
        if (this.ivjListScrollPane == null) {
            try {
                this.ivjListScrollPane = new JScrollPane();
                this.ivjListScrollPane.setName("ListScrollPane");
                this.getListScrollPane().setViewportView(this.getThreadList());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjListScrollPane;
    }

    private JList getThreadList() {
        if (this.ivjThreadList == null) {
            try {
                this.ivjThreadList = new JList();
                this.ivjThreadList.setName("ThreadList");
                this.ivjThreadList.setBounds(0, 0, 160, 120);
                this.ivjThreadList.addListSelectionListener(this);
                this.ivjThreadList.setDragEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjThreadList;
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() throws Exception {
        this.getCompareTable().addMouseListener(this.ivjEventHandler);
        this.getCompareTable().addKeyListener(this.ivjEventHandler);
        this.getThreadList().addMouseListener(this.ivjEventHandler);
        this.getBlockList().addMouseListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("MonitorCompareFrame");
            this.setClosable(true);
            this.setIconifiable(true);
            this.setVisible(true);
            this.setFrameIcon(new ImageIcon(this.getClass().getResource("/client_types_16.gif")));
            this.setSize(618, 522);
            this.setMaximizable(true);
            this.setResizable(true);
            this.setContentPane(this.getCompareSplitPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            MonitorCompareFrame aMonitorCompareFrame = new MonitorCompareFrame();
            frame.setContentPane(aMonitorCompareFrame);
            frame.setSize(aMonitorCompareFrame.getSize());
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.show();
            Insets insets = frame.getInsets();
            frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JInternalFrame");
            exception.printStackTrace(System.out);
        }
    }

    private void setJLabelBlocking(int n) {
        this.ivjJLabelBlocking.setText("Blocked by : " + n);
    }

    private void setJLabelWaiting(int n) {
        this.ivjJLabelWaiting.setText("Waiting Threads : " + n);
    }

    public void threadList_MouseClicked(MouseEvent mouseEvent) {
        if (this.getThreadList().getSelectedIndex() != -1) {
            int selectedColumn = this.getCompareTable().getSelectedColumn();
            int i = 0;
            while (i < this.tt.hi[selectedColumn - 1].name.length) {
                if (this.tt.hi[selectedColumn - 1].name[i].compareTo((String)this.getThreadList().getSelectedValue()) == 0) {
                    String stackTrace = "<table border=\"1\"><tr><th><B>Thread Name</B></th><th>" + this.tt.hi[selectedColumn - 1].name[i] + "<tr><td><B>State</B></td><td>" + this.tt.hi[selectedColumn - 1].getState(i);
                    String monString = "";
                    String m1 = this.tt.hi[selectedColumn - 1].getOwningMonitor(i);
                    if (m1 != null) {
                        monString = String.valueOf(monString) + "Owns Monitor Lock on " + m1;
                    }
                    if ((m1 = this.tt.hi[selectedColumn - 1].getWaitingMonitor(i)) != null) {
                        if (monString.length() != 0) {
                            monString = String.valueOf(monString) + "<BR>";
                        }
                        monString = String.valueOf(monString) + "Waiting for Monitor Lock on " + m1;
                    }
                    stackTrace = monString.length() == 0 ? String.valueOf(stackTrace) + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Monitor</B></td><td>" + monString + "</td></tr>";
                    stackTrace = this.tt.hi[selectedColumn - 1].javaStack[i] == null ? String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td>No Java stack trace available</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td><td>" + this.tt.hi[selectedColumn - 1].javaStack[i] + "</td></tr>";
                    stackTrace = this.tt.hi[selectedColumn - 1].nativeStack[i] != null ? String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td><td>" + this.tt.hi[selectedColumn - 1].nativeStack[i] + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Stack Trace</B></td>No stack trace available</td></tr>";
                    this.getDetailTextPane().setText(ThreadFrame.getCopyFriendlyString(stackTrace));
                    this.getDetailTextPane().setCaretPosition(0);
                }
                ++i;
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        JList list;
        if (!e.getValueIsAdjusting() && (list = (JList)e.getSource()).getSelectedIndex() != -1) {
            int selectedColumn = this.getCompareTable().getSelectedColumn();
            int i = 0;
            while (i < this.tt.hi[selectedColumn - 1].name.length) {
                if (this.tt.hi[selectedColumn - 1].name[i].compareTo((String)list.getSelectedValue()) == 0) {
                    String stackTrace = "<table border=\"1\"><tr><th><B>Thread Name</B></th><th>" + this.tt.hi[selectedColumn - 1].name[i] + "<tr><td><B>State</B></td><td>" + this.tt.hi[selectedColumn - 1].getState(i);
                    String monString = "";
                    String m1 = this.tt.hi[selectedColumn - 1].getOwningMonitor(i);
                    if (m1 != null) {
                        monString = String.valueOf(monString) + "Owns Monitor Lock on " + m1;
                    }
                    if ((m1 = this.tt.hi[selectedColumn - 1].getWaitingMonitor(i)) != null) {
                        if (monString.length() != 0) {
                            monString = String.valueOf(monString) + "<BR>";
                        }
                        monString = String.valueOf(monString) + "Waiting for Monitor Lock on " + m1;
                    }
                    stackTrace = monString.length() == 0 ? String.valueOf(stackTrace) + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Monitor</B></td><td>" + monString + "</td></tr>";
                    stackTrace = this.tt.hi[selectedColumn - 1].javaStack[i] == null ? String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td>No Java stack trace available</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td><td>" + this.tt.hi[selectedColumn - 1].javaStack[i] + "</td></tr>";
                    stackTrace = this.tt.hi[selectedColumn - 1].nativeStack[i] != null ? String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td><td>" + this.tt.hi[selectedColumn - 1].nativeStack[i] + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Stack Trace</B></td>No stack trace available</td></tr>";
                    this.getDetailTextPane().setText(ThreadFrame.getCopyFriendlyString(stackTrace));
                    this.getDetailTextPane().setCaretPosition(0);
                }
                ++i;
            }
        }
    }

    class IvjEventHandler
    implements KeyListener,
    MouseListener {
        IvjEventHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getSource() == MonitorCompareFrame.this.getCompareTable()) {
                MonitorCompareFrame.this.connEtoC2(e);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getSource() == MonitorCompareFrame.this.getCompareTable()) {
                MonitorCompareFrame.this.connEtoC1(e);
            }
            if (e.getSource() == MonitorCompareFrame.this.getThreadList()) {
                MonitorCompareFrame.this.connEtoC3(e);
            }
            if (e.getSource() == MonitorCompareFrame.this.getBlockList()) {
                MonitorCompareFrame.this.connEtoC4(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

