/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.thread;

import com.ibm.jinwoo.thread.CompareTableCellRenderer;
import com.ibm.jinwoo.thread.Configuration;
import com.ibm.jinwoo.thread.MonitorCompareCell;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class MonitorCompareTableCellRenderer
extends JLabel
implements TableCellRenderer {
    Configuration cfg;

    public MonitorCompareTableCellRenderer() {
        this.initialize();
    }

    public MonitorCompareTableCellRenderer(Configuration c) {
        this.cfg = c;
        this.initialize();
    }

    public MonitorCompareTableCellRenderer(String text) {
        super(text);
        this.initialize();
    }

    public MonitorCompareTableCellRenderer(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.initialize();
    }

    public MonitorCompareTableCellRenderer(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.initialize();
    }

    public MonitorCompareTableCellRenderer(Icon image) {
        super(image);
        this.initialize();
    }

    public MonitorCompareTableCellRenderer(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.initialize();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        MonitorCompareCell cc = (MonitorCompareCell)value;
        Color borderColor = table.getBackground();
        boolean left = false;
        boolean right = false;
        this.setBackground(table.getBackground());
        this.setText("");
        if (cc != null) {
            int state = cc.threadDump[cc.index].state[cc.threadIndex];
            if (state == 0) {
                borderColor = this.cfg.runnable;
                this.setIcon(new ImageIcon(this.getClass().getResource("/run.gif")));
            } else if (state == 1) {
                borderColor = this.cfg.condition;
                this.setIcon(new ImageIcon(this.getClass().getResource("/condition.gif")));
            } else if (state == 2) {
                borderColor = this.cfg.monitor;
                this.setIcon(new ImageIcon(this.getClass().getResource("/monitor_wait.gif")));
            } else if (state == 3) {
                borderColor = this.cfg.suspended;
                this.setIcon(new ImageIcon(this.getClass().getResource("/suspend.gif")));
            } else if (state == 4) {
                borderColor = this.cfg.object;
                this.setIcon(new ImageIcon(this.getClass().getResource("/waiting.gif")));
            } else if (state == 5) {
                borderColor = this.cfg.blocked;
                this.setIcon(new ImageIcon(this.getClass().getResource("/block.gif")));
            } else if (state == 6) {
                borderColor = this.cfg.park;
                this.setIcon(new ImageIcon(this.getClass().getResource("/park.gif")));
            }
            if (cc.threadDump[cc.index].isDeadlock[cc.threadIndex]) {
                borderColor = this.cfg.deadlock;
                this.setIcon(new ImageIcon(this.getClass().getResource("/deadlock_view.gif")));
            }
        }
        if (cc != null && cc.threadDump[cc.index].javaStack[cc.threadIndex] != null) {
            int i;
            int idx;
            if (cc.index != 0 && cc.threadDump[cc.index - 1].threadHash2.containsKey(cc.tid)) {
                idx = -1;
                i = 0;
                while (i < cc.threadDump[cc.index - 1].sys_thread.length) {
                    if (cc.threadDump[cc.index - 1].sys_thread[i] == cc.tid) {
                        idx = i;
                        break;
                    }
                    ++i;
                }
                if (cc.threadDump[cc.index - 1].javaStack[idx] != null && cc.threadDump[cc.index - 1].javaStack[idx].compareTo(cc.threadDump[cc.index].javaStack[cc.threadIndex]) == 0) {
                    this.setBackground(this.cfg.hang);
                    left = true;
                }
            }
            if (cc.index < cc.threadDump.length - 1 && cc.threadDump[cc.index + 1].threadHash2.containsKey(cc.tid)) {
                idx = -1;
                i = 0;
                while (i < cc.threadDump[cc.index + 1].sys_thread.length) {
                    if (cc.threadDump[cc.index + 1].sys_thread[i] == cc.tid) {
                        idx = i;
                        break;
                    }
                    ++i;
                }
                if (cc.threadDump[cc.index + 1].javaStack[idx] != null && cc.threadDump[cc.index + 1].javaStack[idx].compareTo(cc.threadDump[cc.index].javaStack[cc.threadIndex]) == 0) {
                    this.setBackground(this.cfg.hang);
                    right = true;
                }
            }
            this.setText(cc.threadDump[cc.index].getCurrentMethod(cc.threadIndex));
        }
        if (isSelected) {
            this.setBorder(BorderFactory.createMatteBorder(2, 0, 2, 0, table.getSelectionBackground()));
        } else if (right && left) {
            this.setBorder(BorderFactory.createMatteBorder(2, 0, 2, 0, borderColor));
        } else if (right) {
            this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 0, borderColor));
        } else if (left) {
            this.setBorder(BorderFactory.createMatteBorder(2, 0, 2, 2, borderColor));
        } else {
            this.setBorder(BorderFactory.createMatteBorder(2, 0, 2, 0, borderColor));
        }
        return this;
    }

    private void handleException(Throwable exception) {
    }

    private void initialize() {
        try {
            this.setName("MonitorCompareTableCellRenderer");
            this.setOpaque(true);
            this.setText("MonitorCompareTableCellRenderer");
            this.setSize(200, 14);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            CompareTableCellRenderer aCompareTableCellRenderer = new CompareTableCellRenderer();
            frame.setContentPane(aCompareTableCellRenderer);
            frame.setSize(aCompareTableCellRenderer.getSize());
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.show();
            Insets insets = frame.getInsets();
            frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of com.ibm.jinwoo.thread.CompareTableCellRenderer");
            exception.printStackTrace(System.out);
        }
    }
}

