/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.thread;

import com.ibm.jinwoo.thread.CompareCell;
import com.ibm.jinwoo.thread.MonitorCompareCell;
import com.ibm.jinwoo.thread.SortableHeaderIcon;
import com.ibm.jinwoo.thread.ThreadDump;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class MonitorCompareTableModel
extends AbstractTableModel {
    long[] threadArray;
    static SimpleDateFormat dateFormatter2 = new SimpleDateFormat("MMM d HH:mm:ss yyyy");
    public static final boolean DESCENDING = true;
    public static final boolean ASCENDING = false;
    public boolean direction = true;
    String[] columnNames = null;
    public String[] threadNames = null;
    public long[] threadID = null;
    ThreadDump[] hi;
    Hashtable tidHash = new Hashtable();
    int sortedColumn = 0;
    int tidCounter = 0;
    public JTableHeader tableHeader;
    public long[][] sortedArrary;
    private MouseListener mouseListener;
    private TableModelListener tableModelListener;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();

    public MonitorCompareTableModel() {
    }

    public MonitorCompareTableModel(ThreadDump[] h) {
        this.hi = h;
        this.sortedColumn = 0;
        this.tidCounter = 0;
        this.columnNames = new String[h.length + 1];
        this.columnNames[0] = "Thread";
        Long newTid = null;
        int i = 0;
        while (i < h.length) {
            this.columnNames[i + 1] = h[i].timeStamp != 0L ? String.valueOf(h[i].fileName) + " [" + dateFormatter2.format(new Date(h[i].timeStamp)) + "]" : h[i].fileName;
            h[i].threadHash2 = new Hashtable();
            int j = 0;
            while (j < h[i].mdump.length) {
                if (h[i].mdump[j].owner != -1L) {
                    newTid = new Long(h[i].mdump[j].owner);
                    h[i].threadHash2.put(newTid, new Integer(j));
                    if (!this.tidHash.contains(newTid)) {
                        this.tidHash.put(new Integer(this.tidCounter++), newTid);
                    }
                }
                ++j;
            }
            ++i;
        }
        this.threadNames = new String[this.tidCounter];
        this.threadID = new long[this.tidCounter];
        this.tidCounter = 0;
        boolean found = false;
        int i2 = 0;
        while (i2 < this.tidHash.size()) {
            found = false;
            Long tid = (Long)this.tidHash.get(new Integer(i2));
            int j = 0;
            while (j < h.length) {
                int k = 0;
                while (k < h[j].sys_thread.length) {
                    if (tid == h[j].sys_thread[k]) {
                        this.threadID[this.tidCounter] = h[j].sys_thread[k];
                        this.threadNames[this.tidCounter++] = h[j].name[k];
                        found = true;
                        break;
                    }
                    ++k;
                }
                if (found) break;
                ++j;
            }
            ++i2;
        }
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
    }

    public MonitorCompareTableModel(ThreadDump[] h, int col) {
        this.hi = h;
        this.sortedColumn = col;
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
    }

    public Class getColumnClass(int c) {
        if (c == 0) {
            return String.class;
        }
        return CompareCell.class;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Icon getHeaderIcon(int column, int size) {
        if (column != this.sortedColumn) {
            return null;
        }
        return new SortableHeaderIcon(this.direction, size);
    }

    @Override
    public int getRowCount() {
        return this.tidHash.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Long tid = (Long)this.tidHash.get(new Integer(row));
        if (col == 0) {
            return this.threadNames[row];
        }
        if (!this.hi[col - 1].threadHash2.containsKey(tid)) {
            return null;
        }
        int idx = (Integer)this.hi[col - 1].threadHash2.get(tid);
        int i = 0;
        while (i < this.hi[col - 1].sys_thread.length) {
            if (this.hi[col - 1].sys_thread[i] == this.hi[col - 1].mdump[idx].owner) {
                idx = i;
                return new MonitorCompareCell(this.hi, col - 1, idx, tid);
            }
            ++i;
        }
        return null;
    }

    public void setTableHeader(JTableHeader tableHeader) {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer defaultRenderer = this.tableHeader.getDefaultRenderer();
            if (defaultRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)defaultRenderer).tableCellRenderer);
            }
        }
        this.tableHeader = tableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
            this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer()));
        }
    }

    public void sortColumn(int column, boolean direction) {
        if (column == this.sortedColumn) {
            this.direction = !direction;
            this.fireTableDataChanged();
            return;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int viewColumn;
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel columnModel = h.getColumnModel();
            int column = columnModel.getColumn(viewColumn = columnModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (column != -1) {
                MonitorCompareTableModel.this.sortColumn(column, MonitorCompareTableModel.this.direction);
                if (MonitorCompareTableModel.this.tableHeader != null) {
                    MonitorCompareTableModel.this.tableHeader.repaint();
                }
            }
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                l.setHorizontalTextPosition(2);
                int modelColumn = table.convertColumnIndexToModel(column);
                l.setIcon(MonitorCompareTableModel.this.getHeaderIcon(modelColumn, l.getFont().getSize()));
            }
            return c;
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            int column = e.getColumn();
            MonitorCompareTableModel.this.fireTableDataChanged();
        }
    }
}

