/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.thread;

import com.ibm.jinwoo.thread.Arrays2;
import com.ibm.jinwoo.thread.Monitor;
import com.ibm.jinwoo.thread.MonitorDump;
import com.ibm.jinwoo.thread.ThreadDump;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class MonitorModel
implements TreeModel {
    ThreadDump tdump;
    MonitorDump[] mdump;
    Monitor rootNode;
    int[] rootChildren;
    boolean[] hasParent;
    boolean[] visited;
    boolean[] isPseudoRoot;
    long[] threadArray;
    int[] owner;
    int[] total;
    int[] size;
    int[] parent;
    int[] recursiveParent;
    int[][] child;
    boolean[] counted;
    int[] objectName;
    int[] id;
    String[] objectArray;
    boolean[] isHeapLock;
    boolean[] waitingHeapLock;
    int[][] owningObject;
    Hashtable nodeCounter = new Hashtable();

    public MonitorModel() {
    }

    public MonitorModel(ThreadDump td) {
        Long newOwner;
        this.tdump = td;
        this.mdump = td.mdump;
        this.rootNode = new Monitor();
        this.rootNode.owner = -1;
        this.rootNode.threadName = "Thread Name";
        this.rootNode.objectName = "Object Name";
        Hashtable<Integer, Long> threadHash = new Hashtable<Integer, Long>();
        int index = 0;
        int i = 0;
        while (i < this.mdump.length) {
            newOwner = new Long(this.mdump[i].owner);
            if (!threadHash.containsValue(newOwner)) {
                threadHash.put(new Integer(index++), newOwner);
            }
            if (this.mdump[i].waiting != null && this.mdump[i].waiting.size() != 0) {
                int j = 0;
                while (j < this.mdump[i].waiting.size()) {
                    newOwner = (Long)this.mdump[i].waiting.get(j);
                    if (!threadHash.containsValue(newOwner)) {
                        threadHash.put(new Integer(index++), newOwner);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.hasParent = new boolean[threadHash.size()];
        this.isPseudoRoot = new boolean[threadHash.size()];
        this.counted = new boolean[threadHash.size()];
        this.objectName = new int[threadHash.size()];
        this.threadArray = new long[threadHash.size()];
        this.visited = new boolean[threadHash.size()];
        this.total = new int[threadHash.size()];
        this.size = new int[threadHash.size()];
        this.parent = new int[threadHash.size()];
        this.recursiveParent = new int[threadHash.size()];
        i = 0;
        while (i < this.recursiveParent.length) {
            this.recursiveParent[i] = -1;
            ++i;
        }
        this.child = new int[threadHash.size()][];
        this.objectArray = new String[this.mdump.length];
        this.owner = new int[threadHash.size()];
        this.id = new int[threadHash.size()];
        this.isHeapLock = new boolean[threadHash.size()];
        this.waitingHeapLock = new boolean[threadHash.size()];
        this.owningObject = new int[threadHash.size()][];
        i = 0;
        while (i < this.owner.length) {
            this.owner[i] = -1;
            this.objectName[i] = -1;
            this.parent[i] = -1;
            ++i;
        }
        Enumeration<Object> enum2 = threadHash.elements();
        int idx = 0;
        int idx2 = 0;
        while (enum2.hasMoreElements()) {
            this.threadArray[idx++] = (Long)enum2.nextElement();
        }
        Arrays.sort(this.threadArray);
        int i2 = 0;
        while (i2 < this.id.length) {
            this.id[i2] = this.tdump.getIndexFromSysThread(this.threadArray[i2]);
            ++i2;
        }
        threadHash.clear();
        threadHash = null;
        i2 = 0;
        while (i2 < this.mdump.length) {
            this.objectArray[i2] = this.mdump[i2].objectName;
            if (this.mdump[i2].waiting != null && this.mdump[i2].waiting.size() != 0 && (idx = Arrays.binarySearch(this.threadArray, this.mdump[i2].owner)) != -1) {
                int[] temp;
                if (this.owningObject[idx] == null) {
                    this.owningObject[idx] = new int[1];
                    this.owningObject[idx][0] = i2;
                } else {
                    temp = new int[this.owningObject[idx].length];
                    System.arraycopy(this.owningObject[idx], 0, temp, 0, temp.length);
                    this.owningObject[idx] = new int[temp.length + 1];
                    this.owningObject[idx][0] = i2;
                    System.arraycopy(temp, 0, this.owningObject[idx], this.owningObject[idx].length - temp.length, temp.length);
                }
                if (this.mdump[i2].isHeapLock()) {
                    this.isHeapLock[idx] = true;
                }
                int n = idx;
                this.size[n] = this.size[n] + this.mdump[i2].waiting.size();
                if (this.child[idx] == null) {
                    this.child[idx] = new int[this.mdump[i2].waiting.size()];
                } else {
                    temp = new int[this.child[idx].length];
                    System.arraycopy(this.child[idx], 0, temp, 0, temp.length);
                    this.child[idx] = new int[this.size[idx]];
                    System.arraycopy(temp, 0, this.child[idx], this.child[idx].length - temp.length, temp.length);
                }
                int j = 0;
                while (j < this.mdump[i2].waiting.size()) {
                    newOwner = (Long)this.mdump[i2].waiting.get(j);
                    idx2 = Arrays.binarySearch(this.threadArray, newOwner);
                    if (idx2 != -1) {
                        if (this.mdump[i2].isHeapLock()) {
                            this.waitingHeapLock[idx2] = true;
                        }
                        this.hasParent[idx2] = true;
                        this.objectName[idx2] = i2;
                        this.owner[idx2] = idx;
                        this.child[idx][j] = idx2;
                        this.recursiveParent[idx2] = idx;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        Vector<Integer> rv = new Vector<Integer>();
        int i3 = 0;
        while (i3 < this.hasParent.length) {
            if (!this.hasParent[i3]) {
                this.calculateTotal(i3);
                rv.addElement(new Integer(i3));
            }
            ++i3;
        }
        this.markPseudoRoot();
        i3 = 0;
        while (i3 < this.hasParent.length) {
            if (!this.visited[i3] && this.child[i3] != null && this.isPseudoRoot[i3]) {
                this.calculateTotal(i3);
                rv.addElement(new Integer(i3));
            }
            ++i3;
        }
        enum2 = rv.elements();
        idx = 0;
        this.rootChildren = new int[rv.size()];
        while (enum2.hasMoreElements()) {
            this.rootChildren[idx++] = (Integer)enum2.nextElement();
        }
        rv.clear();
        int[][] tempRoot = new int[2][this.rootChildren.length];
        int i4 = 0;
        while (i4 < this.rootChildren.length) {
            tempRoot[0][i4] = this.total[this.rootChildren[i4]];
            tempRoot[1][i4] = this.rootChildren[i4];
            ++i4;
        }
        Arrays2.sort(tempRoot);
        i4 = 0;
        while (i4 < this.rootChildren.length) {
            this.rootChildren[this.rootChildren.length - 1 - i4] = tempRoot[1][i4];
            ++i4;
        }
        tempRoot = null;
        i4 = 0;
        while (i4 < this.child.length) {
            if (this.child[i4] != null) {
                int[][] tempChild = new int[2][this.child[i4].length];
                int j = 0;
                while (j < this.child[i4].length) {
                    tempChild[0][j] = this.total[this.child[i4][j]];
                    tempChild[1][j] = this.child[i4][j];
                    ++j;
                }
                Arrays2.sort(tempChild);
                j = 0;
                while (j < this.child[i4].length) {
                    this.child[i4][this.child[i4].length - 1 - j] = tempChild[1][j];
                    ++j;
                }
            }
            ++i4;
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    public void calculateTotal(int r) {
        boolean anyChild = false;
        Stack<Integer> stack = new Stack<Integer>();
        this.total[r] = this.size[r];
        this.visited[r] = true;
        stack.push(new Integer(r));
        while (!stack.empty()) {
            int cNode;
            int index;
            int i;
            int aNode = (Integer)stack.peek();
            anyChild = false;
            if (this.child[aNode] != null) {
                i = 0;
                while (i < this.child[aNode].length) {
                    index = this.child[aNode][i];
                    if (index >= 0 && !this.visited[cNode = index]) {
                        this.parent[cNode] = aNode;
                        this.visited[cNode] = true;
                        this.total[cNode] = this.size[cNode];
                        stack.push(new Integer(cNode));
                        anyChild = true;
                    }
                    ++i;
                }
            }
            if (anyChild || this.child[aNode = ((Integer)stack.pop()).intValue()] == null) continue;
            i = 0;
            while (i < this.child[aNode].length) {
                index = this.child[aNode][i];
                if (index >= 0 && this.parent[cNode = index] == aNode && !this.counted[cNode]) {
                    int n = aNode;
                    this.total[n] = this.total[n] + this.total[cNode];
                    this.counted[cNode] = true;
                }
                ++i;
            }
        }
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (((Monitor)parent).owner == -1) {
            Monitor m = new Monitor();
            m.owner = this.rootChildren[index];
            m.isHeapLock = this.isHeapLock[m.owner];
            m.waitingHeapLock = this.waitingHeapLock[m.owner];
            if (this.id[m.owner] != -1 && this.tdump.isDeadlock[this.id[m.owner]]) {
                m.isDeadlock = true;
            }
            return m;
        }
        if (this.child[((Monitor)parent).owner] == null) {
            return null;
        }
        Monitor m = new Monitor();
        m.owner = this.child[((Monitor)parent).owner][index];
        m.isHeapLock = this.isHeapLock[m.owner];
        m.waitingHeapLock = this.waitingHeapLock[m.owner];
        m.objectName = this.objectArray[this.objectName[m.owner]];
        if (this.id[m.owner] != -1 && this.tdump.isDeadlock[this.id[m.owner]]) {
            m.isDeadlock = true;
        }
        return m;
    }

    @Override
    public int getChildCount(Object parent) {
        if (((Monitor)parent).owner == -1) {
            return this.rootChildren.length;
        }
        if (this.child[((Monitor)parent).owner] != null) {
            return this.child[((Monitor)parent).owner].length;
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object c) {
        if (((Monitor)parent).owner == -1) {
            int i = 0;
            while (i < this.rootChildren.length) {
                if (((Monitor)c).owner == this.rootChildren[i]) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        if (this.child[((Monitor)parent).owner] != null) {
            int i = 0;
            while (i < this.child[((Monitor)parent).owner].length) {
                if (((Monitor)c).owner == this.child[((Monitor)parent).owner][i]) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public String getOwningObjects(int index) {
        if (index != -1 && this.owningObject[index] != null && this.owningObject[index].length != 0) {
            String objects = new String();
            boolean isFirst = true;
            int i = 0;
            while (i < this.owningObject[index].length) {
                if (isFirst) {
                    objects = this.objectArray[this.owningObject[index][i]];
                    isFirst = false;
                } else {
                    objects = String.valueOf(objects) + " , " + this.objectArray[this.owningObject[index][i]];
                }
                ++i;
            }
            return objects;
        }
        return null;
    }

    public Object getParent(Object parent) {
        int d;
        if (((Monitor)parent).owner == -1) {
            return this.rootNode;
        }
        Monitor m = new Monitor();
        m.owner = this.recursiveParent[((Monitor)parent).owner];
        if (m.owner == -1) {
            return this.rootNode;
        }
        m.isHeapLock = this.isHeapLock[m.owner];
        m.waitingHeapLock = this.waitingHeapLock[m.owner];
        int obj = this.objectName[m.owner];
        if (obj != -1) {
            m.objectName = this.objectArray[obj];
        }
        if ((d = this.id[m.owner]) != -1 && this.id[m.owner] != -1 && this.tdump.isDeadlock[d]) {
            m.isDeadlock = true;
        }
        return m;
    }

    @Override
    public Object getRoot() {
        return this.rootNode;
    }

    public String getSummary(Monitor node) {
        String oo;
        if (node == null) {
            return "";
        }
        if (node.owner == -1) {
            return "";
        }
        if (this.id[node.owner] == -1) {
            return "";
        }
        String stackTrace = "Thread Name : " + this.tdump.name[this.id[node.owner]] + "<BR>State : " + this.tdump.getState(this.id[node.owner]) + "<BR>";
        if (node.isHeapLock) {
            stackTrace = String.valueOf(stackTrace) + "Owns Heap Lock<BR>";
        }
        if (node.waitingHeapLock) {
            stackTrace = String.valueOf(stackTrace) + "Waiting for Heap Lock<BR>";
        }
        if (node.objectName != null) {
            stackTrace = String.valueOf(stackTrace) + "Waiting for Monitor Lock on " + node.objectName + "<BR>";
        }
        if ((oo = this.getOwningObjects(node.owner)) != null) {
            stackTrace = String.valueOf(stackTrace) + "Owns Monitor Lock on " + oo + "<BR>";
        }
        stackTrace = this.tdump.javaStack[this.id[node.owner]] == null ? String.valueOf(stackTrace) + "No Java Stack available<BR>" : String.valueOf(stackTrace) + "Java Stack<BR>" + this.tdump.javaStack[this.id[node.owner]] + "<BR>";
        if (this.tdump.nativeStack[this.id[node.owner]] != null) {
            stackTrace = String.valueOf(stackTrace) + "Native Stack<BR>" + this.tdump.nativeStack[this.id[node.owner]];
        }
        return stackTrace;
    }

    public int getThreadDumpIndex(Monitor node) {
        if (node == null) {
            return -1;
        }
        if (node.owner == -1) {
            return -1;
        }
        return this.id[node.owner];
    }

    public String getThreadName(int index) {
        long threadID = this.threadArray[index];
        int i = 0;
        while (i < this.tdump.sys_thread.length) {
            if (threadID == this.tdump.sys_thread[i]) {
                return this.tdump.name[i];
            }
            ++i;
        }
        return "Unknown";
    }

    public int getThreadState(int index) {
        long threadID = this.threadArray[index];
        int i = 0;
        while (i < this.tdump.sys_thread.length) {
            if (threadID == this.tdump.sys_thread[i]) {
                return this.tdump.state[i];
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (((Monitor)node).owner == -1) {
            return this.rootChildren.length == 0;
        }
        return this.child[((Monitor)node).owner] == null;
    }

    public boolean isRecursive(Object node) {
        int up;
        if (((Monitor)node).owner == -1) {
            return false;
        }
        HashSet<Integer> nodeSet = new HashSet<Integer>();
        Integer newNode = null;
        int count = 0;
        int current = ((Monitor)node).owner;
        while ((up = this.recursiveParent[current]) != -1) {
            current = up;
            newNode = new Integer(up);
            count = this.nodeCounter.containsKey(newNode) ? (Integer)this.nodeCounter.get(newNode) : 0;
            if (up == ((Monitor)node).owner) {
                this.nodeCounter.put(newNode, new Integer(++count));
                return count > 3;
            }
            if (!nodeSet.isEmpty() && nodeSet.contains(newNode)) {
                return false;
            }
            nodeSet.add(newNode);
        }
        return false;
    }

    public boolean isRootChild(Object node) {
        return false;
    }

    public void markPseudoRoot() {
        Hashtable<Integer, String> hash = new Hashtable<Integer, String>();
        boolean[] checked = new boolean[this.hasParent.length];
        int i = 0;
        while (i < this.hasParent.length) {
            if (!this.visited[i] && this.child[i] != null && !checked[i]) {
                int p;
                hash.clear();
                int c = i;
                checked[c] = true;
                Integer newInt = new Integer(c);
                hash.put(newInt, "");
                while ((p = this.owner[c]) != -1) {
                    if (checked[p]) {
                        newInt = new Integer(p);
                        if (!hash.containsKey(newInt)) break;
                        this.isPseudoRoot[c] = true;
                        break;
                    }
                    checked[p] = true;
                    newInt = new Integer(p);
                    if (hash.containsKey(newInt)) {
                        this.isPseudoRoot[c] = true;
                        break;
                    }
                    hash.put(newInt, "");
                    c = p;
                }
            }
            ++i;
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }
}

