/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.thread;

import com.ibm.jinwoo.thread.Arrays2;
import com.ibm.jinwoo.thread.MonitorDump;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JTree;

public class ThreadDump {
    public JTree nativeMemoryTree = null;
    public String homeDir = null;
    public String dllDir = null;
    public String sysCP = null;
    public String osLevel = null;
    public String architecture = null;
    public String numberOfCPU = null;
    public String userArgs = "";
    static final String[] AGGREGATION = new String[]{"ThreadManager.JobsProcessorThread.InternalThread", "WLMMonitorSleeper", "Deferrable Alarm", "HAManager.thread.pool", "WebContainer", "Servlet.Engine.Transports :", "ServerSocket", "ORB.thread.pool", "SoapConnectorThreadPool", "Alarm", "Thread"};
    long xmx;
    public boolean isNewFormat;
    public String fileName;
    public boolean isIBM;
    public boolean isJ9;
    public String gcHistory = null;
    public String[] name;
    public long[] tid;
    public int[] priority;
    public long[] sys_thread;
    public long[] nid;
    public int[] macro;
    public int[] state;
    public String[] javaStack;
    public String[] nativeStack;
    public Hashtable threadHash = null;
    public Hashtable threadHash2 = null;
    public MonitorDump[] mdump;
    public String summary;
    public List deadlock;
    public int javaHeap;
    public int numberOfRunnable;
    public String warning;
    public long[][] sortedArray;
    public long[][] sortedMethod;
    public int[] nameArray;
    public int[] currentMethodArray;
    public int[] stateArray;
    public int[] idArray;
    public long af;
    public long gc;
    public long free;
    public long allocated;
    public long timeStamp;
    public long pid;
    public long currentTid;
    public boolean[] isDeadlock;
    public String[] pattern;
    public long inuse;

    public String getAggregationSummary() {
        long emptyMethod = 0L;
        String summary = "";
        ArrayList<String> methodList = new ArrayList<String>();
        int i = 0;
        while (i < this.name.length) {
            String methodName = this.getName(i);
            if (methodName != null) {
                if (methodName.length() != 0) {
                    int result = this.getCommonThreadName(methodName);
                    if (result >= 0 && !methodList.contains(AGGREGATION[result])) {
                        methodList.add(AGGREGATION[result]);
                    }
                } else if (methodName.length() == 0) {
                    ++emptyMethod;
                }
            }
            ++i;
        }
        String[] methodArray = methodList.toArray(new String[methodList.size()]);
        this.sortedMethod = new long[2][methodArray.length];
        methodList.clear();
        int i2 = 0;
        while (i2 < methodArray.length) {
            this.sortedMethod[0][i2] = 0L;
            this.sortedMethod[1][i2] = i2;
            ++i2;
        }
        boolean j = false;
        int[] value = new int[AGGREGATION.length];
        int i3 = 0;
        while (i3 < value.length) {
            value[i3] = 0;
            ++i3;
        }
        i3 = 0;
        while (i3 < this.name.length) {
            int result = this.getCommonThreadName(this.getName(i3));
            if (result >= 0) {
                int k = 0;
                while (k < methodArray.length) {
                    if (methodArray[k].compareTo(AGGREGATION[result]) == 0) {
                        long[] lArray = this.sortedMethod[0];
                        int n = k;
                        lArray[n] = lArray[n] + 1L;
                    }
                    ++k;
                }
            }
            ++i3;
        }
        Arrays2.sort(this.sortedMethod);
        summary = "<UL><LI>Thread Aggregation Analysis<BR><table border=\"1\"><tr><th>Thread Type</th><th>Number of Threads : " + this.getTotalThread() + "</th><th>Percentage</th></tr>";
        i3 = methodArray.length - 1;
        while (i3 >= 0) {
            summary = String.valueOf(summary) + "<tr><td>" + methodArray[(int)this.sortedMethod[1][i3]] + "</td><td>" + this.sortedMethod[0][i3] + "</td><td>" + Math.round((float)this.sortedMethod[0][i3] * 100.0f / (float)this.name.length) + " (%)</td></tr>";
            --i3;
        }
        if (emptyMethod != 0L) {
            summary = String.valueOf(summary) + "<tr><td>Unknown method : " + emptyMethod + "<tr><td>" + Math.round((float)emptyMethod * 100.0f / (float)this.name.length) + " (%))</td></tr>";
        } else if (summary.length() != 0) {
            summary = String.valueOf(summary) + "<BR>";
        }
        return String.valueOf(summary) + "</table></UL>";
    }

    public long getBlocked() {
        long count = 0L;
        int i = 0;
        while (i < this.state.length) {
            if (this.state[i] == 5) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int getCommonThreadName(String key) {
        if (key == null) {
            return -1;
        }
        if (key.length() == 0) {
            return -1;
        }
        int i = 0;
        while (i < AGGREGATION.length) {
            if (key.indexOf(AGGREGATION[i]) >= 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getCurrentMethod(int r) {
        int j;
        if (this.javaStack[r] == null || this.javaStack[r].length() == 0) {
            return "NO JAVA STACK";
        }
        if (this.pattern[r] != null) {
            return this.pattern[r];
        }
        if (this.macro[r] == 1) {
            return "IDLE";
        }
        if (this.macro[r] == 2) {
            return "KEEP-ALIVE";
        }
        if (this.macro[r] == 3) {
            return "LISTEN";
        }
        if (this.macro[r] == 4) {
            return "READ REQUEST";
        }
        int i = this.javaStack[r].indexOf("<BR>");
        if (i != -1 && (j = this.javaStack[r].indexOf("at ")) != -1) {
            return this.javaStack[r].substring(j + 3, i);
        }
        return "NO JAVA STACK";
    }

    public long getDeadlock() {
        long count = 0L;
        int i = 0;
        while (i < this.isDeadlock.length) {
            if (this.isDeadlock[i]) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int getIndexFromName(String threadName) {
        int i = 0;
        while (i < this.name.length) {
            if (threadName.compareTo(this.name[i]) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getIndexFromSysThread(long id) {
        int idx = Arrays.binarySearch(this.sortedArray[0], id);
        if (idx < 0) {
            return -1;
        }
        return (int)this.sortedArray[1][idx];
    }

    public String getJavaStack(int idx) {
        return this.javaStack[idx];
    }

    public String getMethodSummary() {
        long emptyMethod = 0L;
        String summary = "";
        ArrayList<String> methodList = new ArrayList<String>();
        int i = 0;
        while (i < this.name.length) {
            String methodName = this.getSortedCurrentMethod(i);
            if (methodName.length() != 0 && !methodList.contains(methodName)) {
                methodList.add(methodName);
            } else if (methodName.length() == 0) {
                ++emptyMethod;
            }
            ++i;
        }
        String[] methodArray = methodList.toArray(new String[methodList.size()]);
        this.sortedMethod = new long[2][methodArray.length];
        methodList.clear();
        int i2 = 0;
        while (i2 < methodArray.length) {
            this.sortedMethod[0][i2] = 1L;
            this.sortedMethod[1][i2] = i2;
            ++i2;
        }
        int j = 0;
        int i3 = 0;
        while (i3 < this.name.length) {
            if (i3 < this.name.length - 1 && this.getSortedCurrentMethod(i3).length() != 0 && this.getSortedCurrentMethod(i3 + 1).length() != 0) {
                if (this.getSortedCurrentMethod(i3).compareTo(this.getSortedCurrentMethod(i3 + 1)) == 0) {
                    long[] lArray = this.sortedMethod[0];
                    int n = j;
                    lArray[n] = lArray[n] + 1L;
                } else {
                    ++j;
                }
            }
            ++i3;
        }
        Arrays2.sort(this.sortedMethod);
        summary = "<UL><LI>Thread Method Analysis<BR><table border=\"1\"><tr><th>Method Name</th><th>Number of Threads : " + this.getTotalThread() + "</th><th>Percentage</th></tr>";
        i3 = methodArray.length - 1;
        while (i3 >= 0) {
            summary = String.valueOf(summary) + "<tr><td>" + methodArray[(int)this.sortedMethod[1][i3]] + "</td><td>" + this.sortedMethod[0][i3] + "</td><td>" + Math.round((float)this.sortedMethod[0][i3] * 100.0f / (float)this.name.length) + " (%)</td></tr>";
            --i3;
        }
        if (emptyMethod != 0L) {
            summary = String.valueOf(summary) + "<tr><td>Unknown method : " + emptyMethod + "<tr><td>" + Math.round((float)emptyMethod * 100.0f / (float)this.name.length) + " (%))</td></tr>";
        } else if (summary.length() != 0) {
            summary = String.valueOf(summary) + "<BR>";
        }
        return String.valueOf(summary) + "</table></UL>";
    }

    public String getMethodSummary(int sn) {
        long emptyMethod = 0L;
        String summary = "";
        ArrayList<String> methodList = new ArrayList<String>();
        int i = 0;
        while (i < this.name.length) {
            String methodName = this.getSortedCurrentMethod(i);
            if (methodName.length() != 0 && !methodList.contains(methodName)) {
                methodList.add(methodName);
            } else if (methodName.length() == 0) {
                ++emptyMethod;
            }
            ++i;
        }
        String[] methodArray = methodList.toArray(new String[methodList.size()]);
        this.sortedMethod = new long[2][methodArray.length];
        methodList.clear();
        int i2 = 0;
        while (i2 < methodArray.length) {
            this.sortedMethod[0][i2] = 1L;
            this.sortedMethod[1][i2] = i2;
            ++i2;
        }
        int j = 0;
        int i3 = 0;
        while (i3 < this.name.length) {
            if (i3 < this.name.length - 1 && this.getSortedCurrentMethod(i3).length() != 0 && this.getSortedCurrentMethod(i3 + 1).length() != 0) {
                if (this.getSortedCurrentMethod(i3).compareTo(this.getSortedCurrentMethod(i3 + 1)) == 0) {
                    long[] lArray = this.sortedMethod[0];
                    int n = j;
                    lArray[n] = lArray[n] + 1L;
                } else {
                    ++j;
                }
            }
            ++i3;
        }
        Arrays2.sort(this.sortedMethod);
        summary = "<UL><LI><a name=\"TM" + sn + "\">Thread Method Analysis</a><BR><table border=\"1\"><tr><th>Method Name</th><th>Number of Threads : " + this.getTotalThread() + "</th><th>Percentage</th></tr>";
        i3 = methodArray.length - 1;
        while (i3 >= 0) {
            summary = String.valueOf(summary) + "<tr><td>" + methodArray[(int)this.sortedMethod[1][i3]] + "</td><td>" + this.sortedMethod[0][i3] + "</td><td>" + Math.round((float)this.sortedMethod[0][i3] * 100.0f / (float)this.name.length) + " (%)</td></tr>";
            --i3;
        }
        if (emptyMethod != 0L) {
            summary = String.valueOf(summary) + "<tr><td>Unknown method : " + emptyMethod + "<tr><td>" + Math.round((float)emptyMethod * 100.0f / (float)this.name.length) + " (%))</td></tr>";
        } else if (summary.length() != 0) {
            summary = String.valueOf(summary) + "<BR>";
        }
        return String.valueOf(summary) + "</table></UL>";
    }

    public String getName(int idx) {
        return this.name[idx];
    }

    public Long getNativeID(int idx) {
        return new Long(this.nid[idx]);
    }

    public String getNativeStack(int idx) {
        return this.nativeStack[idx];
    }

    public long getOWait() {
        long count = 0L;
        int i = 0;
        while (i < this.state.length) {
            if (this.state[i] == 4) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public String getOwningMonitor(int idx) {
        if (this.mdump == null) {
            return null;
        }
        int i = 0;
        while (i < this.mdump.length) {
            if (this.mdump[i].owner == this.sys_thread[idx]) {
                return this.mdump[i].objectName;
            }
            ++i;
        }
        return null;
    }

    public MonitorDump getOwningMonitorDump(int idx) {
        if (this.mdump == null) {
            return null;
        }
        int i = 0;
        while (i < this.mdump.length) {
            if (this.mdump[i].owner == this.sys_thread[idx]) {
                return this.mdump[i];
            }
            ++i;
        }
        return null;
    }

    public String getOwningMonitors(int idx) {
        boolean isFirst = true;
        String monitors = null;
        if (this.mdump == null) {
            return null;
        }
        int i = 0;
        while (i < this.mdump.length) {
            if (this.mdump[i].owner == this.sys_thread[idx]) {
                if (isFirst) {
                    isFirst = false;
                    monitors = new String(this.mdump[i].objectName);
                } else {
                    monitors = String.valueOf(monitors) + " , " + this.mdump[i].objectName;
                }
            }
            ++i;
        }
        return monitors;
    }

    public long getRunnable() {
        long count = 0L;
        int i = 0;
        while (i < this.state.length) {
            if (this.state[i] == 0) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public String getSortedCurrentMethod(int idx) {
        return this.getCurrentMethod(this.currentMethodArray[idx]);
    }

    public String getSortedName(int idx) {
        return this.name[this.nameArray[idx]];
    }

    public String getStackTrace(int selectedRow) {
        String stackTrace = "Thread Name : " + this.getName(selectedRow) + "<BR><BR>State : " + this.getState(selectedRow) + "<BR><BR>";
        String m1 = this.getOwningMonitors(selectedRow);
        if (m1 != null) {
            stackTrace = String.valueOf(stackTrace) + "Owns Monitor Lock on " + m1 + "<BR><BR>";
        }
        if ((m1 = this.getWaitingMonitors(selectedRow)) != null) {
            stackTrace = String.valueOf(stackTrace) + "Waiting for Monitor Lock on " + m1 + "<BR><BR>";
        }
        stackTrace = this.javaStack[selectedRow] != null ? String.valueOf(stackTrace) + "Java Stack :<BR>" + this.javaStack[selectedRow] : String.valueOf(stackTrace) + "No Java Stack Trace<BR>";
        stackTrace = this.nativeStack[selectedRow] != null ? String.valueOf(stackTrace) + "<BR>Native Stack :<BR>" + this.nativeStack[selectedRow] : String.valueOf(stackTrace) + "<BR>No Native Stack Trace<BR>";
        if (stackTrace.length() == 0) {
            stackTrace = "No stack trace available";
        }
        return stackTrace;
    }

    public String getState(int idx) {
        String deadlock = this.isDeadlock[idx] ? "Deadlock/" : "";
        switch (this.state[idx]) {
            case 0: {
                return String.valueOf(deadlock) + "Runnable";
            }
            case 1: {
                return String.valueOf(deadlock) + "Waiting on condition";
            }
            case 2: {
                return String.valueOf(deadlock) + "Waiting on monitor";
            }
            case 3: {
                return String.valueOf(deadlock) + "Suspended";
            }
            case 4: {
                return String.valueOf(deadlock) + "in Object.wait()";
            }
            case 5: {
                return String.valueOf(deadlock) + "Blocked";
            }
            case 6: {
                return String.valueOf(deadlock) + "Parked";
            }
        }
        return null;
    }

    public String getStateColor(int idx) {
        if (this.isDeadlock[idx]) {
            return "bgcolor=\"# \"";
        }
        String deadlock = "";
        switch (this.state[idx]) {
            case 0: {
                return String.valueOf(deadlock) + "Runnable";
            }
            case 1: {
                return String.valueOf(deadlock) + "Waiting on condition";
            }
            case 2: {
                return String.valueOf(deadlock) + "Waiting on monitor";
            }
            case 3: {
                return String.valueOf(deadlock) + "Suspended";
            }
            case 4: {
                return String.valueOf(deadlock) + "in Object.wait()";
            }
            case 5: {
                return String.valueOf(deadlock) + "Blocked";
            }
            case 6: {
                return String.valueOf(deadlock) + "Parked";
            }
        }
        return null;
    }

    public long getSuspended() {
        long count = 0L;
        int i = 0;
        while (i < this.state.length) {
            if (this.state[i] == 3) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public long getSys_ThreadFromTID(long tid) {
        int i = 0;
        while (i < this.sys_thread.length) {
            if (tid == this.tid[i]) {
                return this.sys_thread[i];
            }
            ++i;
        }
        return -1L;
    }

    public long getTotalThread() {
        return this.state.length;
    }

    public String getWaitingMonitor(int idx) {
        if (this.mdump == null) {
            return null;
        }
        int i = 0;
        while (i < this.mdump.length) {
            if (this.mdump[i] != null && this.mdump[i].waiting != null && this.mdump[i].waiting.size() != 0) {
                int j = 0;
                while (j < this.mdump[i].waiting.size()) {
                    if ((Long)this.mdump[i].waiting.get(j) == this.sys_thread[idx]) {
                        return this.mdump[i].objectName;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public String getWaitingMonitors(int idx) {
        String monitors = null;
        boolean isFirst = true;
        if (this.mdump == null) {
            return null;
        }
        int i = 0;
        while (i < this.mdump.length) {
            if (this.mdump[i] != null && this.mdump[i].waiting != null && this.mdump[i].waiting.size() != 0) {
                int j = 0;
                while (j < this.mdump[i].waiting.size()) {
                    if ((Long)this.mdump[i].waiting.get(j) == this.sys_thread[idx]) {
                        if (isFirst) {
                            monitors = new String(this.mdump[i].objectName);
                            isFirst = false;
                        } else {
                            monitors = String.valueOf(monitors) + " , " + this.mdump[i].objectName;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return monitors;
    }

    public long getWCondition() {
        long count = 0L;
        int i = 0;
        while (i < this.state.length) {
            if (this.state[i] == 1) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public long getWMonitor() {
        long count = 0L;
        int i = 0;
        while (i < this.state.length) {
            if (this.state[i] == 2) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public long getParked() {
        long count = 0L;
        int i = 0;
        while (i < this.state.length) {
            if (this.state[i] == 6) {
                ++count;
            }
            ++i;
        }
        return count;
    }
}

