/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.thread;

import com.ibm.jinwoo.thread.Configuration;
import com.ibm.jinwoo.thread.MonitorDump;
import com.ibm.jinwoo.thread.ThreadDump;
import com.ibm.jinwoo.thread.ThreadTableCellRenderer;
import com.ibm.jinwoo.thread.ThreadTableCellRenderer2;
import com.ibm.jinwoo.thread.ThreadTableCellRenderer3;
import com.ibm.jinwoo.thread.ThreadTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.html.HTMLDocument;

public class ThreadFrame
extends JInternalFrame
implements ListSelectionListener {
    private int dividerLocation = 100;
    private ThreadDump threadDump = null;
    private ThreadTableModel tt = null;
    private JTextPane ivjStackTextPane = null;
    private JSplitPane ivjThreadSplitPane = null;
    private JScrollPane ivjThreadScrollPane = null;
    private JTable ivjThreadTable = null;
    private JScrollPane ivjStackScrollPane = null;
    private Configuration cfg = null;
    private String summaryText = null;
    private JSplitPane ivjJSplitPane1 = null;
    private JScrollPane ivjListScrollPane = null;
    private JList ivjThreadList = null;
    private JPanel ivjJPanel1 = null;
    private JScrollPane ivjJScrollPane1 = null;
    private JList ivjBlockList = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JLabel ivjJLabelBlocking = null;
    private JLabel ivjJLabelWaiting = null;

    public ThreadFrame() {
        this.initialize();
    }

    public ThreadFrame(ThreadDump td) {
        this.threadDump = td;
        this.initialize();
    }

    public ThreadFrame(String title) {
        super(title);
        this.initialize();
    }

    public ThreadFrame(String title, ThreadDump td) {
        super(title);
        this.threadDump = td;
        this.initialize();
    }

    public ThreadFrame(String title, ThreadDump td, Configuration c) {
        super(title);
        this.threadDump = td;
        this.cfg = c;
        this.summaryText = this.getSummary(td);
        this.initialize();
    }

    public ThreadFrame(String title, boolean resizable) {
        super(title, resizable);
        this.initialize();
    }

    public ThreadFrame(String title, boolean resizable, boolean closable) {
        super(title, resizable, closable);
        this.initialize();
    }

    public ThreadFrame(String title, boolean resizable, boolean closable, boolean maximizable) {
        super(title, resizable, closable, maximizable);
        this.initialize();
    }

    public ThreadFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        super(title, resizable, closable, maximizable, iconifiable);
        this.initialize();
    }

    public void blockList_MouseClicked(MouseEvent mouseEvent) {
        int selectedRow = -1;
        if (this.getBlockList().getSelectedIndex() != -1) {
            selectedRow = -1;
            int i = 0;
            while (i < this.threadDump.name.length) {
                if (this.threadDump.name[i].compareTo((String)this.getBlockList().getSelectedValue()) == 0) {
                    selectedRow = i;
                    break;
                }
                ++i;
            }
            if (selectedRow == -1) {
                return;
            }
            String stackTrace = "<table border=\"1\"><tr><th><B>Thread Name</B></th><th>" + this.threadDump.getName(selectedRow) + "<tr><td><B>State</B></td><td>" + this.threadDump.getState(selectedRow);
            String m1 = this.threadDump.getOwningMonitors(selectedRow);
            String monString = "";
            if (m1 != null) {
                monString = "Owns Monitor Lock on " + m1;
            }
            if ((m1 = this.threadDump.getWaitingMonitors(selectedRow)) != null) {
                monString = monString.length() == 0 ? String.valueOf(monString) + "Waiting for Monitor Lock on " + m1 : String.valueOf(monString) + "<BR>Waiting for Monitor Lock on " + m1;
            }
            stackTrace = monString.length() == 0 ? String.valueOf(stackTrace) + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Monitor</B></td><td>" + monString + "</td></tr>";
            stackTrace = this.threadDump.javaStack[selectedRow] != null ? String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td><td>" + this.threadDump.javaStack[selectedRow] + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td>No Java stack trace available</td></tr>";
            stackTrace = this.threadDump.nativeStack[selectedRow] != null ? String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td><td>" + this.threadDump.nativeStack[selectedRow] + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td>No Native stack trace available</td></tr>";
            if (stackTrace.length() == 0) {
                stackTrace = "<tr><td><B>Stack Trace</B></td>No stack trace available</td></tr>";
            }
            this.getStackTextPane().setText(ThreadFrame.getCopyFriendlyString(stackTrace));
            this.getStackTextPane().setCaretPosition(0);
        }
    }

    private void connEtoC1(MouseEvent arg1) {
        try {
            this.threadTable_MouseClicked(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(MouseEvent arg1) {
        try {
            this.threadList_MouseClicked(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(MouseEvent arg1) {
        try {
            this.blockList_MouseClicked(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JList getBlockList() {
        if (this.ivjBlockList == null) {
            try {
                this.ivjBlockList = new JList();
                this.ivjBlockList.setName("BlockList");
                this.ivjBlockList.setBounds(0, 0, 160, 120);
                this.ivjBlockList.addListSelectionListener(this);
                this.ivjBlockList.setDragEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBlockList;
    }

    public String getHTMLColor(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        String R = r <= 15 ? "0" + Integer.toHexString(r) : Integer.toHexString(r);
        String G = g <= 15 ? "0" + Integer.toHexString(g) : Integer.toHexString(g);
        String B = b <= 15 ? "0" + Integer.toHexString(b) : Integer.toHexString(b);
        return String.valueOf(R) + G + B;
    }

    private JLabel getJLabelBlocking() {
        if (this.ivjJLabelBlocking == null) {
            try {
                this.ivjJLabelBlocking = new JLabel();
                this.ivjJLabelBlocking.setName("JLabelBlocking");
                this.ivjJLabelBlocking.setText("Blocked by : 0");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabelBlocking;
    }

    private JLabel getJLabelWaiting() {
        if (this.ivjJLabelWaiting == null) {
            try {
                this.ivjJLabelWaiting = new JLabel();
                this.ivjJLabelWaiting.setName("JLabelWaiting");
                this.ivjJLabelWaiting.setText("Waiting Threads : 0");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabelWaiting;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setLayout(new GridBagLayout());
                GridBagConstraints constraintsJLabelWaiting = new GridBagConstraints();
                constraintsJLabelWaiting.gridx = 1;
                constraintsJLabelWaiting.gridy = 1;
                constraintsJLabelWaiting.insets = new Insets(7, 3, 3, 2);
                this.getJPanel1().add((Component)this.getJLabelWaiting(), constraintsJLabelWaiting);
                GridBagConstraints constraintsListScrollPane = new GridBagConstraints();
                constraintsListScrollPane.gridx = 1;
                constraintsListScrollPane.gridy = 2;
                constraintsListScrollPane.fill = 1;
                constraintsListScrollPane.weightx = 1.0;
                constraintsListScrollPane.weighty = 1.0;
                constraintsListScrollPane.ipadx = 76;
                constraintsListScrollPane.ipady = 280;
                constraintsListScrollPane.insets = new Insets(3, 0, 4, 0);
                this.getJPanel1().add((Component)this.getListScrollPane(), constraintsListScrollPane);
                GridBagConstraints constraintsJScrollPane1 = new GridBagConstraints();
                constraintsJScrollPane1.gridx = 1;
                constraintsJScrollPane1.gridy = 4;
                constraintsJScrollPane1.fill = 1;
                constraintsJScrollPane1.weightx = 1.0;
                constraintsJScrollPane1.weighty = 1.0;
                constraintsJScrollPane1.ipadx = 76;
                constraintsJScrollPane1.ipady = 137;
                constraintsJScrollPane1.insets = new Insets(3, 0, 9, 0);
                this.getJPanel1().add((Component)this.getJScrollPane1(), constraintsJScrollPane1);
                GridBagConstraints constraintsJLabelBlocking = new GridBagConstraints();
                constraintsJLabelBlocking.gridx = 1;
                constraintsJLabelBlocking.gridy = 3;
                constraintsJLabelBlocking.ipadx = 15;
                constraintsJLabelBlocking.insets = new Insets(4, 8, 2, 13);
                this.getJPanel1().add((Component)this.getJLabelBlocking(), constraintsJLabelBlocking);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.getJScrollPane1().setViewportView(this.getBlockList());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane1;
    }

    private JSplitPane getJSplitPane1() {
        if (this.ivjJSplitPane1 == null) {
            try {
                this.ivjJSplitPane1 = new JSplitPane(1);
                this.ivjJSplitPane1.setName("JSplitPane1");
                this.ivjJSplitPane1.setOneTouchExpandable(true);
                this.ivjJSplitPane1.setDividerLocation(150);
                this.getJSplitPane1().add((Component)this.getJPanel1(), "left");
                this.getJSplitPane1().add((Component)this.getStackScrollPane(), "right");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSplitPane1;
    }

    private JScrollPane getListScrollPane() {
        if (this.ivjListScrollPane == null) {
            try {
                this.ivjListScrollPane = new JScrollPane();
                this.ivjListScrollPane.setName("ListScrollPane");
                this.getListScrollPane().setViewportView(this.getThreadList());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjListScrollPane;
    }

    private JScrollPane getStackScrollPane() {
        if (this.ivjStackScrollPane == null) {
            try {
                this.ivjStackScrollPane = new JScrollPane();
                this.ivjStackScrollPane.setName("StackScrollPane");
                this.getStackScrollPane().setViewportView(this.getStackTextPane());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStackScrollPane;
    }

    private JTextPane getStackTextPane() {
        if (this.ivjStackTextPane == null) {
            try {
                this.ivjStackTextPane = new JTextPane();
                this.ivjStackTextPane.setName("StackTextPane");
                this.ivjStackTextPane.setDocument(new HTMLDocument());
                this.ivjStackTextPane.setBounds(0, 0, 535, 527);
                this.ivjStackTextPane.setEditable(false);
                this.ivjStackTextPane.setContentType("text/html");
                this.ivjStackTextPane.setDragEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStackTextPane;
    }

    public String getSummary(ThreadDump td) {
        if (td != null) {
            long total = td.getTotalThread();
            long runnable = td.getRunnable();
            long condition = td.getWCondition();
            long monitor = td.getWMonitor();
            long suspended = td.getSuspended();
            long wait = td.getOWait();
            long blocked = td.getBlocked();
            long deadlock = td.getDeadlock();
            long parked = td.getParked();
            String summary = "<UL><LI>Thread Status Analysis</a><BR><BR><table border=\"1\"><tr><th>Status</th><th>Number of Threads : " + total + "</th><th>Percentage</th><tr><td bgcolor=\"#" + this.getHTMLColor(this.cfg.deadlock) + "\"><img src=\"" + this.getClass().getResource("/deadlock_view.gif") + "\"> Deadlock</td><td>" + deadlock + "</td><td>" + Math.round((float)deadlock * 100.0f / (float)total) + " (%)</td></tr><tr><td bgcolor=\"#" + this.getHTMLColor(this.cfg.runnable) + "\"><img src=\"" + this.getClass().getResource("/run.gif") + "\"> Runnable</td><td>" + runnable + "</td><td>" + Math.round((float)runnable * 100.0f / (float)total) + " (%)</td></tr><tr><td bgcolor=\"#" + this.getHTMLColor(this.cfg.condition) + "\"><img src=\"" + this.getClass().getResource("/condition.gif") + "\"> Waiting on condition</td><td>" + condition + "</td><td>" + Math.round((float)condition * 100.0f / (float)total) + " (%)</td></tr><tr><td bgcolor=\"#" + this.getHTMLColor(this.cfg.monitor) + "\"><img src=\"" + this.getClass().getResource("/monitor_wait.gif") + "\"> Waiting on monitor</td><td>" + monitor + "</td><td>" + Math.round((float)monitor * 100.0f / (float)total) + " (%)</td></tr><tr><td bgcolor=\"#" + this.getHTMLColor(this.cfg.suspended) + "\"><img src=\"" + this.getClass().getResource("/suspend.gif") + "\"> Suspended</td><td>" + suspended + "</td><td>" + Math.round((float)suspended * 100.0f / (float)total) + " (%)</td></tr><tr><td bgcolor=\"#" + this.getHTMLColor(this.cfg.object) + "\"><img src=\"" + this.getClass().getResource("/waiting.gif") + "\"> Object.wait()</td><td>" + wait + "</td><td>" + Math.round((float)wait * 100.0f / (float)total) + " (%)</td></tr><tr><td bgcolor=\"#" + this.getHTMLColor(this.cfg.blocked) + "\"><img src=\"" + this.getClass().getResource("/block.gif") + "\"> Blocked</td><td>" + blocked + "</td><td>" + Math.round((float)blocked * 100.0f / (float)total) + " (%)</td></tr><tr><td bgcolor=\"#" + this.getHTMLColor(this.cfg.park) + "\"><img src=\"" + this.getClass().getResource("/park.gif") + "\"> Parked</td><td>" + parked + "</td><td>" + Math.round((float)parked * 100.0f / (float)total) + " (%)</td></tr></table></UL>";
            return String.valueOf(summary) + td.getMethodSummary() + td.getAggregationSummary() + td.warning + td.summary;
        }
        return "";
    }

    private JList getThreadList() {
        if (this.ivjThreadList == null) {
            try {
                this.ivjThreadList = new JList();
                this.ivjThreadList.setName("ThreadList");
                this.ivjThreadList.setBounds(0, 0, 160, 120);
                this.ivjThreadList.addListSelectionListener(this);
                this.ivjThreadList.setDragEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjThreadList;
    }

    private JScrollPane getThreadScrollPane() {
        if (this.ivjThreadScrollPane == null) {
            try {
                this.ivjThreadScrollPane = new JScrollPane();
                this.ivjThreadScrollPane.setName("ThreadScrollPane");
                this.ivjThreadScrollPane.setVerticalScrollBarPolicy(22);
                this.ivjThreadScrollPane.setHorizontalScrollBarPolicy(32);
                this.getThreadScrollPane().setViewportView(this.getThreadTable());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjThreadScrollPane;
    }

    private JSplitPane getThreadSplitPane() {
        if (this.ivjThreadSplitPane == null) {
            try {
                this.ivjThreadSplitPane = new JSplitPane(1);
                this.ivjThreadSplitPane.setName("ThreadSplitPane");
                this.ivjThreadSplitPane.setDividerLocation(300);
                this.ivjThreadSplitPane.setOneTouchExpandable(true);
                this.getThreadSplitPane().add((Component)this.getThreadScrollPane(), "left");
                this.getThreadSplitPane().add((Component)this.getJSplitPane1(), "right");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjThreadSplitPane;
    }

    private JTable getThreadTable() {
        if (this.ivjThreadTable == null) {
            try {
                this.ivjThreadTable = new JTable();
                this.ivjThreadTable.setName("ThreadTable");
                this.getThreadScrollPane().setColumnHeaderView(this.ivjThreadTable.getTableHeader());
                this.getThreadScrollPane().getViewport().setBackingStoreEnabled(true);
                this.ivjThreadTable.setBounds(0, 0, 64, 46);
                this.ivjThreadTable = new JTable(){
                    TableCellRenderer renderer;
                    TableCellRenderer renderer2;
                    TableCellRenderer renderer3;
                    {
                        this.renderer = new ThreadTableCellRenderer(ThreadFrame.this.cfg);
                        this.renderer2 = new ThreadTableCellRenderer2(ThreadFrame.this.cfg);
                        this.renderer3 = new ThreadTableCellRenderer3(ThreadFrame.this.cfg, ThreadFrame.this.threadDump);
                    }

                    @Override
                    public TableCellRenderer getCellRenderer(int row, int column) {
                        if (this.getColumnName(column).compareTo(ThreadTableModel.columnNames[0]) == 0) {
                            return this.renderer3;
                        }
                        if (this.getColumnName(column).compareTo(ThreadTableModel.columnNames[1]) == 0) {
                            return this.renderer;
                        }
                        if (this.getColumnName(column).compareTo(ThreadTableModel.columnNames[2]) == 0) {
                            return this.renderer2;
                        }
                        return super.getCellRenderer(row, column);
                    }
                };
                this.tt = new ThreadTableModel(this.threadDump);
                this.ivjThreadTable.setModel(this.tt);
                this.tt.setTableHeader(this.ivjThreadTable.getTableHeader());
                this.getThreadScrollPane().setViewportView(this.ivjThreadTable);
                ListSelectionModel rowSM = this.ivjThreadTable.getSelectionModel();
                rowSM.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        int i;
                        if (e.getValueIsAdjusting()) {
                            return;
                        }
                        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                        if (lsm.isSelectionEmpty()) {
                            ThreadFrame.this.getJSplitPane1().setDividerLocation(1);
                            ThreadFrame.this.getStackTextPane().setText(ThreadFrame.this.summaryText);
                            ThreadFrame.this.getStackTextPane().setCaretPosition(0);
                            return;
                        }
                        int selectedRow = lsm.getMinSelectionIndex();
                        if (((ThreadFrame)ThreadFrame.this).tt.direction) {
                            selectedRow = ((ThreadFrame)ThreadFrame.this).threadDump.nameArray.length - selectedRow - 1;
                        }
                        selectedRow = ((ThreadFrame)ThreadFrame.this).tt.sortedColumn == 0 ? ((ThreadFrame)ThreadFrame.this).threadDump.nameArray[selectedRow] : (((ThreadFrame)ThreadFrame.this).tt.sortedColumn == 1 ? ((ThreadFrame)ThreadFrame.this).threadDump.stateArray[selectedRow] : ((ThreadFrame)ThreadFrame.this).threadDump.currentMethodArray[selectedRow]);
                        String stackTrace = "<table border=\"1\"><tr><th><B>Thread Name</B></th><th>" + ThreadFrame.this.threadDump.getName(selectedRow) + "<tr><td><B>State</B></td><td>" + ThreadFrame.this.threadDump.getState(selectedRow);
                        String m1 = ThreadFrame.this.threadDump.getOwningMonitors(selectedRow);
                        String monString = "";
                        if (m1 != null) {
                            monString = "Owns Monitor Lock on " + m1;
                        }
                        if ((m1 = ThreadFrame.this.threadDump.getWaitingMonitors(selectedRow)) != null) {
                            monString = monString.length() == 0 ? String.valueOf(monString) + "Waiting for Monitor Lock on " + m1 : String.valueOf(monString) + "<BR>Waiting for Monitor Lock on " + m1;
                        }
                        stackTrace = monString.length() == 0 ? String.valueOf(stackTrace) + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Monitor</B></td><td>" + monString + "</td></tr>";
                        stackTrace = ((ThreadFrame)ThreadFrame.this).threadDump.javaStack[selectedRow] != null ? String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td><td>" + ((ThreadFrame)ThreadFrame.this).threadDump.javaStack[selectedRow] + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td>No Java stack trace available</td></tr>";
                        stackTrace = ((ThreadFrame)ThreadFrame.this).threadDump.nativeStack[selectedRow] != null ? String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td><td>" + ((ThreadFrame)ThreadFrame.this).threadDump.nativeStack[selectedRow] + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td>No Native stack trace available</td></tr>";
                        if (stackTrace.length() == 0) {
                            stackTrace = "<tr><td><B>Stack Trace</B></td>No stack trace available</td></tr>";
                        }
                        ThreadFrame.this.getStackTextPane().setText(ThreadFrame.getCopyFriendlyString(stackTrace));
                        ThreadFrame.this.getStackTextPane().setCaretPosition(0);
                        DefaultListModel<Object> listModel = new DefaultListModel<Object>();
                        ThreadFrame.this.getThreadList().setModel(listModel);
                        DefaultListModel<Object> listModel2 = new DefaultListModel<Object>();
                        ThreadFrame.this.getBlockList().setModel(listModel2);
                        MonitorDump[] md = ((ThreadFrame)ThreadFrame.this).threadDump.mdump;
                        if (md == null) {
                            return;
                        }
                        ArrayList waitingThreads = null;
                        int i2 = 0;
                        while (i2 < md.length) {
                            if (((ThreadFrame)ThreadFrame.this).threadDump.sys_thread[selectedRow] == md[i2].owner) {
                                if (waitingThreads == null) {
                                    waitingThreads = new ArrayList(md[i2].waiting);
                                } else {
                                    waitingThreads.addAll(md[i2].waiting);
                                }
                            }
                            ++i2;
                        }
                        ThreadFrame.this.setJLabelWaiting(0);
                        if (waitingThreads != null) {
                            if (ThreadFrame.this.getJSplitPane1().getDividerLocation() != 1) {
                                ThreadFrame.this.dividerLocation = ThreadFrame.this.getJSplitPane1().getDividerLocation();
                            }
                            if (ThreadFrame.this.dividerLocation == 0) {
                                ThreadFrame.this.dividerLocation = 100;
                            }
                            ThreadFrame.this.getJSplitPane1().setDividerLocation(ThreadFrame.this.dividerLocation);
                            ArrayList<String> nameList = new ArrayList<String>();
                            int i3 = 0;
                            while (i3 < waitingThreads.size()) {
                                int j = 0;
                                while (j < ((ThreadFrame)ThreadFrame.this).threadDump.sys_thread.length) {
                                    if ((Long)waitingThreads.get(i3) == ((ThreadFrame)ThreadFrame.this).threadDump.sys_thread[j] && !nameList.contains(((ThreadFrame)ThreadFrame.this).threadDump.name[j])) {
                                        nameList.add(((ThreadFrame)ThreadFrame.this).threadDump.name[j]);
                                    }
                                    ++j;
                                }
                                ++i3;
                            }
                            if (nameList.size() != 0) {
                                Object[] sortedName = nameList.toArray(new String[nameList.size()]);
                                Arrays.sort(sortedName, 0, sortedName.length);
                                i = 0;
                                while (i < sortedName.length) {
                                    listModel.addElement(sortedName[i]);
                                    ++i;
                                }
                                ThreadFrame.this.setJLabelWaiting(listModel.getSize());
                                nameList = null;
                            }
                        }
                        MonitorDump[] mdump = md;
                        ArrayList<String> blockList = new ArrayList<String>();
                        i = 0;
                        while (i < mdump.length) {
                            if (mdump[i] != null && mdump[i].waiting != null && mdump[i].waiting.size() != 0 && mdump[i].owner != -1L) {
                                int j = 0;
                                while (j < mdump[i].waiting.size()) {
                                    if ((Long)mdump[i].waiting.get(j) == ((ThreadFrame)ThreadFrame.this).threadDump.sys_thread[selectedRow] && !blockList.contains(((ThreadFrame)ThreadFrame.this).threadDump.name[ThreadFrame.this.threadDump.getIndexFromSysThread(mdump[i].owner)])) {
                                        blockList.add(((ThreadFrame)ThreadFrame.this).threadDump.name[ThreadFrame.this.threadDump.getIndexFromSysThread(mdump[i].owner)]);
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        ThreadFrame.this.setJLabelBlocking(0);
                        if (blockList.size() != 0) {
                            if (ThreadFrame.this.getJSplitPane1().getDividerLocation() != 1) {
                                ThreadFrame.this.dividerLocation = ThreadFrame.this.getJSplitPane1().getDividerLocation();
                            }
                            if (ThreadFrame.this.dividerLocation == 0) {
                                ThreadFrame.this.dividerLocation = 100;
                            }
                            ThreadFrame.this.getJSplitPane1().setDividerLocation(ThreadFrame.this.dividerLocation);
                            Object[] sortedName = blockList.toArray(new String[blockList.size()]);
                            Arrays.sort(sortedName, 0, sortedName.length);
                            int i4 = 0;
                            while (i4 < sortedName.length) {
                                listModel2.addElement(sortedName[i4]);
                                ++i4;
                            }
                            ThreadFrame.this.setJLabelBlocking(listModel2.getSize());
                            blockList = null;
                        } else if (waitingThreads == null) {
                            if (ThreadFrame.this.getJSplitPane1().getDividerLocation() != 1) {
                                ThreadFrame.this.dividerLocation = ThreadFrame.this.getJSplitPane1().getDividerLocation();
                            }
                            ThreadFrame.this.getJSplitPane1().setDividerLocation(1);
                        }
                    }
                });
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjThreadTable;
    }

    private void handleException(Throwable exception) {
        exception.printStackTrace(System.out);
    }

    private void initConnections() throws Exception {
        this.getThreadTable().addMouseListener(this.ivjEventHandler);
        this.getThreadList().addMouseListener(this.ivjEventHandler);
        this.getBlockList().addMouseListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("ThreadFrame");
            this.setIconifiable(true);
            this.setClosable(true);
            this.setVisible(true);
            this.setFrameIcon(new ImageIcon(this.getClass().getResource("/thread_ob.gif")));
            this.setSize(964, 560);
            this.setMaximizable(true);
            this.setResizable(true);
            this.setContentPane(this.getThreadSplitPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.getStackTextPane().setText(this.summaryText);
        this.getStackTextPane().setCaretPosition(0);
        this.getJSplitPane1().setDividerLocation(0);
    }

    public static String getCopyFriendlyString(String source) {
        return source.replace("<BR>", "&#x0A;<BR>");
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            ThreadFrame aThreadFrame = new ThreadFrame();
            frame.setContentPane(aThreadFrame);
            frame.setSize(aThreadFrame.getSize());
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.show();
            Insets insets = frame.getInsets();
            frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JInternalFrame");
            exception.printStackTrace(System.out);
        }
    }

    private void setJLabelBlocking(int n) {
        this.ivjJLabelBlocking.setText("Blocked by : " + n);
    }

    private void setJLabelWaiting(int n) {
        this.ivjJLabelWaiting.setText("Waiting Threads : " + n);
    }

    public void threadList_MouseClicked(MouseEvent mouseEvent) {
        int selectedRow = -1;
        if (this.getThreadList().getSelectedIndex() != -1) {
            selectedRow = -1;
            int i = 0;
            while (i < this.threadDump.name.length) {
                if (this.threadDump.name[i].compareTo((String)this.getThreadList().getSelectedValue()) == 0) {
                    selectedRow = i;
                    break;
                }
                ++i;
            }
            if (selectedRow == -1) {
                return;
            }
            String stackTrace = "<table border=\"1\"><tr><th><B>Thread Name</B></th><th>" + this.threadDump.getName(selectedRow) + "<tr><td><B>State</B></td><td>" + this.threadDump.getState(selectedRow);
            String m1 = this.threadDump.getOwningMonitors(selectedRow);
            String monString = "";
            if (m1 != null) {
                monString = "Owns Monitor Lock on " + m1;
            }
            if ((m1 = this.threadDump.getWaitingMonitors(selectedRow)) != null) {
                monString = monString.length() == 0 ? String.valueOf(monString) + "Waiting for Monitor Lock on " + m1 : String.valueOf(monString) + "<BR>Waiting for Monitor Lock on " + m1;
            }
            stackTrace = monString.length() == 0 ? String.valueOf(stackTrace) + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Monitor</B></td><td>" + monString + "</td></tr>";
            stackTrace = this.threadDump.javaStack[selectedRow] != null ? String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td><td>" + this.threadDump.javaStack[selectedRow] + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td>No Java stack trace available</td></tr>";
            stackTrace = this.threadDump.nativeStack[selectedRow] != null ? String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td><td>" + this.threadDump.nativeStack[selectedRow] + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td>No Native stack trace available</td></tr>";
            if (stackTrace.length() == 0) {
                stackTrace = "<tr><td><B>Stack Trace</B></td>No stack trace available</td></tr>";
            }
            this.getStackTextPane().setText(ThreadFrame.getCopyFriendlyString(stackTrace));
            this.getStackTextPane().setCaretPosition(0);
        }
    }

    public void threadTable_MouseClicked(MouseEvent mouseEvent) {
        int i;
        int selectedRow = this.getThreadTable().getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        if (this.tt.direction) {
            selectedRow = this.threadDump.nameArray.length - selectedRow - 1;
        }
        selectedRow = this.tt.sortedColumn == 0 ? this.threadDump.nameArray[selectedRow] : (this.tt.sortedColumn == 1 ? this.threadDump.stateArray[selectedRow] : (this.tt.sortedColumn == 2 ? this.threadDump.idArray[selectedRow] : this.threadDump.currentMethodArray[selectedRow]));
        String stackTrace = "<table border=\"1\"><tr><th><B>Thread Name</B></th><th>" + this.threadDump.getName(selectedRow) + "<tr><td><B>State</B></td><td>" + this.threadDump.getState(selectedRow);
        String m1 = this.threadDump.getOwningMonitors(selectedRow);
        String monString = "";
        if (m1 != null) {
            monString = "Owns Monitor Lock on " + m1;
        }
        if ((m1 = this.threadDump.getWaitingMonitors(selectedRow)) != null) {
            monString = monString.length() == 0 ? String.valueOf(monString) + "Waiting for Monitor Lock on " + m1 : String.valueOf(monString) + "<BR>Waiting for Monitor Lock on " + m1;
        }
        stackTrace = monString.length() == 0 ? String.valueOf(stackTrace) + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Monitor</B></td><td>" + monString + "</td></tr>";
        stackTrace = this.threadDump.javaStack[selectedRow] != null ? String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td><td>" + this.threadDump.javaStack[selectedRow] + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td>No Java stack trace available</td></tr>";
        stackTrace = this.threadDump.nativeStack[selectedRow] != null ? String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td><td>" + this.threadDump.nativeStack[selectedRow] + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td>No Native stack trace available</td></tr>";
        if (stackTrace.length() == 0) {
            stackTrace = "<tr><td><B>Stack Trace</B></td>No stack trace available</td></tr>";
        }
        this.getStackTextPane().setText(ThreadFrame.getCopyFriendlyString(stackTrace));
        this.getStackTextPane().setCaretPosition(0);
        DefaultListModel<Object> listModel = new DefaultListModel<Object>();
        this.getThreadList().setModel(listModel);
        DefaultListModel<Object> listModel2 = new DefaultListModel<Object>();
        this.getBlockList().setModel(listModel2);
        MonitorDump[] md = this.threadDump.mdump;
        if (md == null) {
            return;
        }
        ArrayList waitingThreads = null;
        int i2 = 0;
        while (i2 < md.length) {
            if (this.threadDump.sys_thread[selectedRow] == md[i2].owner) {
                if (waitingThreads == null) {
                    waitingThreads = new ArrayList(md[i2].waiting);
                } else {
                    waitingThreads.addAll(md[i2].waiting);
                }
            }
            ++i2;
        }
        this.setJLabelWaiting(0);
        if (waitingThreads != null) {
            if (this.getJSplitPane1().getDividerLocation() != 1) {
                this.dividerLocation = this.getJSplitPane1().getDividerLocation();
            }
            if (this.dividerLocation == 0) {
                this.dividerLocation = 100;
            }
            this.getJSplitPane1().setDividerLocation(this.dividerLocation);
            ArrayList<String> nameList = new ArrayList<String>();
            int i3 = 0;
            while (i3 < waitingThreads.size()) {
                int j = 0;
                while (j < this.threadDump.sys_thread.length) {
                    if ((Long)waitingThreads.get(i3) == this.threadDump.sys_thread[j] && !nameList.contains(this.threadDump.name[j])) {
                        nameList.add(this.threadDump.name[j]);
                    }
                    ++j;
                }
                ++i3;
            }
            if (nameList.size() != 0) {
                Object[] sortedName = nameList.toArray(new String[nameList.size()]);
                Arrays.sort(sortedName, 0, sortedName.length);
                i = 0;
                while (i < sortedName.length) {
                    listModel.addElement(sortedName[i]);
                    ++i;
                }
                this.setJLabelWaiting(listModel.getSize());
                nameList = null;
            }
        }
        MonitorDump[] mdump = md;
        ArrayList<String> blockList = new ArrayList<String>();
        i = 0;
        while (i < mdump.length) {
            if (mdump[i] != null && mdump[i].waiting != null && mdump[i].waiting.size() != 0 && mdump[i].owner != -1L) {
                int j = 0;
                while (j < mdump[i].waiting.size()) {
                    if ((Long)mdump[i].waiting.get(j) == this.threadDump.sys_thread[selectedRow] && !blockList.contains(this.threadDump.name[this.threadDump.getIndexFromSysThread(mdump[i].owner)])) {
                        blockList.add(this.threadDump.name[this.threadDump.getIndexFromSysThread(mdump[i].owner)]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.setJLabelBlocking(0);
        if (blockList.size() != 0) {
            if (this.getJSplitPane1().getDividerLocation() != 1) {
                this.dividerLocation = this.getJSplitPane1().getDividerLocation();
            }
            if (this.dividerLocation == 0) {
                this.dividerLocation = 100;
            }
            this.getJSplitPane1().setDividerLocation(this.dividerLocation);
            Object[] sortedName = blockList.toArray(new String[blockList.size()]);
            Arrays.sort(sortedName, 0, sortedName.length);
            int i4 = 0;
            while (i4 < sortedName.length) {
                listModel2.addElement(sortedName[i4]);
                ++i4;
            }
            this.setJLabelBlocking(listModel2.getSize());
            blockList = null;
        } else if (waitingThreads == null) {
            if (this.getJSplitPane1().getDividerLocation() != 1) {
                this.dividerLocation = this.getJSplitPane1().getDividerLocation();
            }
            this.getJSplitPane1().setDividerLocation(1);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        JList list;
        int selectedRow = -1;
        if (!e.getValueIsAdjusting() && (list = (JList)e.getSource()).getSelectedIndex() != -1) {
            selectedRow = -1;
            int i = 0;
            while (i < this.threadDump.name.length) {
                if (this.threadDump.name[i].compareTo((String)list.getSelectedValue()) == 0) {
                    selectedRow = i;
                    break;
                }
                ++i;
            }
            if (selectedRow == -1) {
                return;
            }
            String stackTrace = "<table border=\"1\"><tr><th><B>Thread Name</B></th><th>" + this.threadDump.getName(selectedRow) + "<tr><td><B>State</B></td><td>" + this.threadDump.getState(selectedRow);
            String m1 = this.threadDump.getOwningMonitors(selectedRow);
            String monString = "";
            if (m1 != null) {
                monString = "Owns Monitor Lock on " + m1;
            }
            if ((m1 = this.threadDump.getWaitingMonitors(selectedRow)) != null) {
                monString = monString.length() == 0 ? String.valueOf(monString) + "Waiting for Monitor Lock on " + m1 : String.valueOf(monString) + "<BR>Waiting for Monitor Lock on " + m1;
            }
            stackTrace = monString.length() == 0 ? String.valueOf(stackTrace) + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Monitor</B></td><td>" + monString + "</td></tr>";
            stackTrace = this.threadDump.javaStack[selectedRow] != null ? String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td><td>" + this.threadDump.javaStack[selectedRow] + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td>No Java stack trace available</td></tr>";
            stackTrace = this.threadDump.nativeStack[selectedRow] != null ? String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td><td>" + this.threadDump.nativeStack[selectedRow] + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td>No Native stack trace available</td></tr>";
            if (stackTrace.length() == 0) {
                stackTrace = "<tr><td><B>Stack Trace</B></td>No stack trace available</td></tr>";
            }
            this.getStackTextPane().setText(ThreadFrame.getCopyFriendlyString(stackTrace));
            this.getStackTextPane().setCaretPosition(0);
        }
    }

    class IvjEventHandler
    implements MouseListener {
        IvjEventHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getSource() == ThreadFrame.this.getThreadTable()) {
                ThreadFrame.this.connEtoC1(e);
            }
            if (e.getSource() == ThreadFrame.this.getThreadList()) {
                ThreadFrame.this.connEtoC2(e);
            }
            if (e.getSource() == ThreadFrame.this.getBlockList()) {
                ThreadFrame.this.connEtoC3(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

