/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.thread;

import com.ibm.jinwoo.thread.CompareTableCellRenderer;
import com.ibm.jinwoo.thread.Configuration;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ThreadTableCellRenderer
extends JLabel
implements TableCellRenderer {
    Configuration cfg;

    public ThreadTableCellRenderer() {
        this.initialize();
    }

    public ThreadTableCellRenderer(Configuration c) {
        this.cfg = c;
        this.initialize();
    }

    public ThreadTableCellRenderer(String text) {
        super(text);
        this.initialize();
    }

    public ThreadTableCellRenderer(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.initialize();
    }

    public ThreadTableCellRenderer(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.initialize();
    }

    public ThreadTableCellRenderer(Icon image) {
        super(image);
        this.initialize();
    }

    public ThreadTableCellRenderer(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.initialize();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String cc = (String)value;
        if (cc != null) {
            this.setText(cc);
            if (cc.startsWith("Deadlock")) {
                this.setBackground(this.cfg.deadlock);
                this.setIcon(new ImageIcon(this.getClass().getResource("/deadlock_view.gif")));
            } else if (cc.compareTo("Runnable") == 0) {
                this.setBackground(this.cfg.runnable);
                this.setIcon(new ImageIcon(this.getClass().getResource("/run.gif")));
            } else if (cc.compareTo("Waiting on condition") == 0) {
                this.setBackground(this.cfg.condition);
                this.setIcon(new ImageIcon(this.getClass().getResource("/condition.gif")));
            } else if (cc.compareTo("Waiting on monitor") == 0) {
                this.setBackground(this.cfg.monitor);
                this.setIcon(new ImageIcon(this.getClass().getResource("/monitor_wait.gif")));
            } else if (cc.compareTo("Suspended") == 0) {
                this.setBackground(this.cfg.suspended);
                this.setIcon(new ImageIcon(this.getClass().getResource("/suspend.gif")));
            } else if (cc.compareTo("Blocked") == 0) {
                this.setBackground(this.cfg.blocked);
                this.setIcon(new ImageIcon(this.getClass().getResource("/block.gif")));
            } else if (cc.compareTo("Parked") == 0) {
                this.setBackground(this.cfg.park);
                this.setIcon(new ImageIcon(this.getClass().getResource("/park.gif")));
            } else {
                this.setBackground(this.cfg.object);
                this.setIcon(new ImageIcon(this.getClass().getResource("/waiting.gif")));
            }
            return this;
        }
        return null;
    }

    private void handleException(Throwable exception) {
    }

    private void initialize() {
        try {
            this.setName("ThreadTableCellRenderer");
            this.setOpaque(true);
            this.setText("");
            this.setSize(145, 14);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            CompareTableCellRenderer aCompareTableCellRenderer = new CompareTableCellRenderer();
            frame.setContentPane(aCompareTableCellRenderer);
            frame.setSize(aCompareTableCellRenderer.getSize());
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.show();
            Insets insets = frame.getInsets();
            frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of com.ibm.jinwoo.thread.CompareTableCellRenderer");
            exception.printStackTrace(System.out);
        }
    }
}

