/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.thread;

import com.ibm.jinwoo.thread.CompareTableCellRenderer;
import com.ibm.jinwoo.thread.Configuration;
import com.ibm.jinwoo.thread.ThreadDump;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ThreadTableCellRenderer3
extends JLabel
implements TableCellRenderer {
    Configuration cfg;
    ThreadDump threadDump;

    public ThreadTableCellRenderer3() {
        this.initialize();
    }

    public ThreadTableCellRenderer3(Configuration c) {
        this.cfg = c;
        this.initialize();
    }

    public ThreadTableCellRenderer3(Configuration c, ThreadDump d) {
        this.threadDump = d;
        this.cfg = c;
        this.initialize();
    }

    public ThreadTableCellRenderer3(String text) {
        super(text);
        this.initialize();
    }

    public ThreadTableCellRenderer3(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.initialize();
    }

    public ThreadTableCellRenderer3(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.initialize();
    }

    public ThreadTableCellRenderer3(Icon image) {
        super(image);
        this.initialize();
    }

    public ThreadTableCellRenderer3(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.initialize();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String cc = (String)value;
        if (cc != null) {
            this.setText(cc);
            if (this.threadDump != null) {
                int i = 0;
                while (i < this.threadDump.name.length) {
                    if (this.threadDump.name[i].compareTo(cc) == 0) {
                        if (this.threadDump.getWaitingMonitor(i) != null) {
                            this.setIcon(new ImageIcon(this.getClass().getResource("/monitor_wait.gif")));
                        } else if (this.threadDump.getOwningMonitors(i) != null) {
                            this.setIcon(new ImageIcon(this.getClass().getResource("/thread_and_monitor_view.gif")));
                        } else {
                            this.setIcon(null);
                        }
                    }
                    ++i;
                }
            }
            return this;
        }
        return null;
    }

    private void handleException(Throwable exception) {
    }

    private void initialize() {
        try {
            this.setName("ThreadTableCellRenderer3");
            this.setText("ThreadTableCellRenderer3");
            this.setSize(152, 14);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            CompareTableCellRenderer aCompareTableCellRenderer = new CompareTableCellRenderer();
            frame.setContentPane(aCompareTableCellRenderer);
            frame.setSize(aCompareTableCellRenderer.getSize());
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.show();
            Insets insets = frame.getInsets();
            frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of com.ibm.jinwoo.thread.CompareTableCellRenderer");
            exception.printStackTrace(System.out);
        }
    }
}

