/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.FpuState;
import jpcsp.Allegrex.Instructions;
import jpcsp.Allegrex.VfpuState;
import jpcsp.Allegrex.compiler.CodeBlock;
import jpcsp.Allegrex.compiler.CodeInstruction;
import jpcsp.Allegrex.compiler.Compiler;
import jpcsp.Allegrex.compiler.CompilerClassLoader;
import jpcsp.Allegrex.compiler.CompilerParameterReader;
import jpcsp.Allegrex.compiler.CompilerTypeInformation;
import jpcsp.Allegrex.compiler.CompilerTypeManager;
import jpcsp.Allegrex.compiler.ICompilerContext;
import jpcsp.Allegrex.compiler.IExecutable;
import jpcsp.Allegrex.compiler.Profiler;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Allegrex.compiler.SequenceSWCodeInstruction;
import jpcsp.Allegrex.compiler.VfpuPfxDstState;
import jpcsp.Allegrex.compiler.VfpuPfxSrcState;
import jpcsp.Allegrex.compiler.VfpuPfxState;
import jpcsp.Allegrex.compiler.nativeCode.NativeCodeInstruction;
import jpcsp.Allegrex.compiler.nativeCode.NativeCodeManager;
import jpcsp.Allegrex.compiler.nativeCode.NativeCodeSequence;
import jpcsp.Allegrex.compiler.nativeCode.Nop;
import jpcsp.Emulator;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEUidClass;
import jpcsp.HLE.HLEUidObjectMapping;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.StringInfo;
import jpcsp.HLE.TErrorPointer32;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer16;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.TPointer64;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.HLE.modules.HLEModuleFunction;
import jpcsp.HLE.modules.HLEModuleManager;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.State;
import jpcsp.hardware.Interrupts;
import jpcsp.memory.FastMemory;
import jpcsp.memory.SafeFastMemory;
import jpcsp.util.ClassAnalyzer;
import org.apache.log4j.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class CompilerContext
implements ICompilerContext {
    protected static Logger log = Compiler.log;
    private CompilerClassLoader classLoader;
    private CodeBlock codeBlock;
    private int numberInstructionsToBeSkipped;
    private boolean skipDelaySlot;
    private MethodVisitor mv;
    private CodeInstruction codeInstruction;
    private static final boolean storeCpuLocal = true;
    private static final boolean storeMemoryIntLocal = false;
    private static final int LOCAL_CPU = 0;
    private static final int LOCAL_INSTRUCTION_COUNT = 1;
    private static final int LOCAL_MEMORY_INT = 2;
    private static final int LOCAL_TMP1 = 3;
    private static final int LOCAL_TMP2 = 4;
    private static final int LOCAL_TMP3 = 5;
    private static final int LOCAL_TMP4 = 6;
    private static final int LOCAL_TMP_VD0 = 7;
    private static final int LOCAL_TMP_VD1 = 8;
    private static final int LOCAL_TMP_VD2 = 9;
    private static final int LOCAL_MAX = 10;
    private static final int DEFAULT_MAX_STACK_SIZE = 11;
    private static final int SYSCALL_MAX_STACK_SIZE = 100;
    private static final int LOCAL_ERROR_POINTER = 5;
    private boolean enableIntructionCounting = false;
    public Set<Integer> analysedAddresses = new HashSet<Integer>();
    public Stack<Integer> blocksToBeAnalysed = new Stack();
    private int currentInstructionCount;
    private int preparedRegisterForStore = -1;
    private boolean memWritePrepared = false;
    private boolean hiloPrepared = false;
    private int methodMaxInstructions;
    private NativeCodeManager nativeCodeManager;
    private final VfpuPfxSrcState vfpuPfxsState = new VfpuPfxSrcState();
    private final VfpuPfxSrcState vfpuPfxtState = new VfpuPfxSrcState();
    private final VfpuPfxDstState vfpuPfxdState = new VfpuPfxDstState();
    private Label interpretPfxLabel = null;
    private boolean pfxVdOverlap = false;
    private static final String runtimeContextInternalName = Type.getInternalName(RuntimeContext.class);
    private static final String processorDescriptor = Type.getDescriptor(Processor.class);
    private static final String cpuDescriptor = Type.getDescriptor(CpuState.class);
    private static final String cpuInternalName = Type.getInternalName(CpuState.class);
    private static final String instructionsInternalName = Type.getInternalName(Instructions.class);
    private static final String instructionInternalName = Type.getInternalName(Common.Instruction.class);
    private static final String instructionDescriptor = Type.getDescriptor(Common.Instruction.class);
    private static final String sceKernalThreadInfoInternalName = Type.getInternalName(SceKernelThreadInfo.class);
    private static final String sceKernalThreadInfoDescriptor = Type.getDescriptor(SceKernelThreadInfo.class);
    private static final String stringDescriptor = Type.getDescriptor(String.class);
    private static final String memoryDescriptor = Type.getDescriptor(Memory.class);
    private static final String memoryInternalName = Type.getInternalName(Memory.class);
    private static final String profilerInternalName = Type.getInternalName(Profiler.class);
    public static final String executableDescriptor = Type.getDescriptor(IExecutable.class);
    public static final String executableInternalName = Type.getInternalName(IExecutable.class);
    private static final String arraycopyDescriptor = "(" + Type.getDescriptor(Object.class) + "I" + Type.getDescriptor(Object.class) + "II)V";
    private static Set<Integer> fastSyscalls;
    private int instanceIndex;
    private NativeCodeSequence preparedCallNativeCodeBlock = null;
    private int maxStackSize = 11;
    private CompilerTypeManager compilerTypeManager;

    public CompilerContext(CompilerClassLoader classLoader, int instanceIndex) {
        Compiler compiler = Compiler.getInstance();
        this.classLoader = classLoader;
        this.instanceIndex = instanceIndex;
        this.nativeCodeManager = compiler.getNativeCodeManager();
        this.methodMaxInstructions = compiler.getDefaultMethodMaxInstructions();
        this.compilerTypeManager = compiler.getCompilerTypeManager();
        if (Profiler.isProfilerEnabled()) {
            this.enableIntructionCounting = true;
        }
        if (fastSyscalls == null) {
            fastSyscalls = new TreeSet<Integer>();
            this.addFastSyscall(987073420);
            this.addFastSyscall(286125210);
            this.addFastSyscall(-926083700);
            this.addFastSyscall(-1167355166);
            this.addFastSyscall(-513696388);
            this.addFastSyscall(-613183691);
            this.addFastSyscall(-2101586057);
            this.addFastSyscall(916379037);
            this.addFastSyscall(-1242112889);
            this.addFastSyscall(-522813112);
            this.addFastSyscall(884603550);
            this.addFastSyscall(-461487900);
            this.addFastSyscall(526865069);
            this.addFastSyscall(1957582890);
            this.addFastSyscall(1755605909);
        }
    }

    private void addFastSyscall(int nid) {
        fastSyscalls.add(HLEModuleManager.getInstance().getSyscallFromNid(nid));
    }

    public CompilerClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(CompilerClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public CodeBlock getCodeBlock() {
        return this.codeBlock;
    }

    public void setCodeBlock(CodeBlock codeBlock) {
        this.codeBlock = codeBlock;
    }

    public NativeCodeManager getNativeCodeManager() {
        return this.nativeCodeManager;
    }

    private void loadCpu() {
        this.mv.visitVarInsn(25, 0);
    }

    private void loadProcessor() {
        this.mv.visitFieldInsn(178, runtimeContextInternalName, "processor", processorDescriptor);
    }

    private void loadMemory() {
        this.mv.visitFieldInsn(178, runtimeContextInternalName, "memory", memoryDescriptor);
    }

    private void loadModule(String moduleName) {
        this.mv.visitFieldInsn(178, Type.getInternalName(Modules.class), moduleName + "Module", "Ljpcsp/HLE/modules/" + moduleName + ";");
    }

    private void loadFpr() {
        this.mv.visitFieldInsn(178, runtimeContextInternalName, "fpr", "[F");
    }

    private void loadVprFloat() {
        this.mv.visitFieldInsn(178, runtimeContextInternalName, "vprFloat", "[F");
    }

    private void loadVprInt() {
        this.mv.visitFieldInsn(178, runtimeContextInternalName, "vprInt", "[I");
    }

    @Override
    public void loadRegister(int reg) {
        if (reg == 0) {
            this.loadImm(0);
        } else {
            this.loadCpu();
            this.mv.visitFieldInsn(180, cpuInternalName, this.getGprFieldName(reg), "I");
        }
    }

    @Override
    public void loadFRegister(int reg) {
        this.loadFpr();
        this.loadImm(reg);
        this.mv.visitInsn(48);
    }

    private Float getPfxSrcCstValue(VfpuPfxSrcState pfxSrcState, int n) {
        if (pfxSrcState == null || pfxSrcState.isUnknown() || !pfxSrcState.pfxSrc.enabled || !pfxSrcState.pfxSrc.cst[n]) {
            return null;
        }
        float value = 0.0f;
        switch (pfxSrcState.pfxSrc.swz[n]) {
            case 0: {
                value = pfxSrcState.pfxSrc.abs[n] ? 3.0f : 0.0f;
                break;
            }
            case 1: {
                value = pfxSrcState.pfxSrc.abs[n] ? 0.33333334f : 1.0f;
                break;
            }
            case 2: {
                value = pfxSrcState.pfxSrc.abs[n] ? 0.25f : 2.0f;
                break;
            }
            case 3: {
                float f = value = pfxSrcState.pfxSrc.abs[n] ? 0.16666667f : 0.5f;
            }
        }
        if (pfxSrcState.pfxSrc.neg[n]) {
            value = 0.0f - value;
        }
        if (log.isTraceEnabled() && pfxSrcState.isKnown() && pfxSrcState.pfxSrc.enabled) {
            log.trace((Object)String.format("PFX    %08X - getPfxSrcCstValue %d -> %f", this.getCodeInstruction().getAddress(), n, Float.valueOf(value)));
        }
        return new Float(value);
    }

    private void convertVFloatToInt() {
        this.mv.visitMethodInsn(184, Type.getInternalName(Float.class), "floatToRawIntBits", "(F)I");
    }

    private void convertVIntToFloat() {
        this.mv.visitMethodInsn(184, Type.getInternalName(Float.class), "intBitsToFloat", "(I)F");
    }

    private void applyPfxSrcPostfix(VfpuPfxSrcState pfxSrcState, int n, boolean isFloat) {
        if (pfxSrcState == null || pfxSrcState.isUnknown() || !pfxSrcState.pfxSrc.enabled) {
            return;
        }
        if (pfxSrcState.pfxSrc.abs[n]) {
            if (log.isTraceEnabled() && pfxSrcState.isKnown() && pfxSrcState.pfxSrc.enabled) {
                log.trace((Object)String.format("PFX    %08X - applyPfxSrcPostfix abs(%d)", this.getCodeInstruction().getAddress(), n));
            }
            if (isFloat) {
                this.mv.visitMethodInsn(184, Type.getInternalName(Math.class), "abs", "(F)F");
            } else {
                this.loadImm(Integer.MAX_VALUE);
                this.mv.visitInsn(126);
            }
        }
        if (pfxSrcState.pfxSrc.neg[n]) {
            if (log.isTraceEnabled() && pfxSrcState.isKnown() && pfxSrcState.pfxSrc.enabled) {
                log.trace((Object)String.format("PFX    %08X - applyPfxSrcPostfix neg(%d)", this.getCodeInstruction().getAddress(), n));
            }
            if (isFloat) {
                this.mv.visitInsn(118);
            } else {
                this.loadImm(Integer.MIN_VALUE);
                this.mv.visitInsn(130);
            }
        }
    }

    private int getPfxSrcIndex(VfpuPfxSrcState pfxSrcState, int n) {
        if (pfxSrcState == null || pfxSrcState.isUnknown() || !pfxSrcState.pfxSrc.enabled || pfxSrcState.pfxSrc.cst[n]) {
            return n;
        }
        if (log.isTraceEnabled() && pfxSrcState.isKnown() && pfxSrcState.pfxSrc.enabled) {
            log.trace((Object)String.format("PFX    %08X - getPfxSrcIndex %d -> %d", this.getCodeInstruction().getAddress(), n, pfxSrcState.pfxSrc.swz[n]));
        }
        return pfxSrcState.pfxSrc.swz[n];
    }

    private void loadVRegister(int m, int c, int r, boolean isFloat) {
        int index = VfpuState.getVprIndex(m, c, r);
        if (isFloat) {
            this.loadVprFloat();
            this.loadImm(index);
            this.mv.visitInsn(48);
        } else {
            this.loadVprInt();
            this.loadImm(index);
            this.mv.visitInsn(46);
        }
    }

    private void loadCstValue(Float cstValue, boolean isFloat) {
        if (isFloat) {
            this.mv.visitLdcInsn((Object)Float.valueOf(cstValue.floatValue()));
        } else {
            this.loadImm(Float.floatToRawIntBits(cstValue.floatValue()));
        }
    }

    private void loadVRegister(int vsize, int reg, int n, VfpuPfxSrcState pfxSrcState, boolean isFloat) {
        if (log.isTraceEnabled() && pfxSrcState != null && pfxSrcState.isKnown() && pfxSrcState.pfxSrc.enabled) {
            log.trace((Object)String.format("PFX    %08X - loadVRegister %d, %d, %d", this.getCodeInstruction().getAddress(), vsize, reg, n));
        }
        int m = reg >> 2 & 7;
        int i = reg >> 0 & 3;
        switch (vsize) {
            case 1: {
                int s = reg >> 5 & 3;
                Float cstValue = this.getPfxSrcCstValue(pfxSrcState, n);
                if (cstValue != null) {
                    this.loadCstValue(cstValue, isFloat);
                    break;
                }
                this.loadVRegister(m, i, s, isFloat);
                this.applyPfxSrcPostfix(pfxSrcState, n, isFloat);
                break;
            }
            case 2: {
                int s = (reg & 0x40) >> 5;
                Float cstValue = this.getPfxSrcCstValue(pfxSrcState, n);
                if (cstValue != null) {
                    this.loadCstValue(cstValue, isFloat);
                    break;
                }
                int index = this.getPfxSrcIndex(pfxSrcState, n);
                if ((reg & 0x20) != 0) {
                    this.loadVRegister(m, s + index, i, isFloat);
                } else {
                    this.loadVRegister(m, i, s + index, isFloat);
                }
                this.applyPfxSrcPostfix(pfxSrcState, n, isFloat);
                break;
            }
            case 3: {
                int s = (reg & 0x40) >> 6;
                Float cstValue = this.getPfxSrcCstValue(pfxSrcState, n);
                if (cstValue != null) {
                    this.loadCstValue(cstValue, isFloat);
                    break;
                }
                int index = this.getPfxSrcIndex(pfxSrcState, n);
                if ((reg & 0x20) != 0) {
                    this.loadVRegister(m, s + index, i, isFloat);
                } else {
                    this.loadVRegister(m, i, s + index, isFloat);
                }
                this.applyPfxSrcPostfix(pfxSrcState, n, isFloat);
                break;
            }
            case 4: {
                int s = (reg & 0x40) >> 5;
                Float cstValue = this.getPfxSrcCstValue(pfxSrcState, n);
                if (cstValue != null) {
                    this.loadCstValue(cstValue, isFloat);
                    break;
                }
                int index = this.getPfxSrcIndex(pfxSrcState, n + s & 3);
                if ((reg & 0x20) != 0) {
                    this.loadVRegister(m, index, i, isFloat);
                } else {
                    this.loadVRegister(m, i, index, isFloat);
                }
                this.applyPfxSrcPostfix(pfxSrcState, n, isFloat);
                break;
            }
        }
    }

    public void prepareRegisterForStore(int reg) {
        if (this.preparedRegisterForStore < 0) {
            this.loadCpu();
            this.preparedRegisterForStore = reg;
        }
    }

    private String getGprFieldName(int reg) {
        return Common.gprNames[reg].replace('$', '_');
    }

    public void storeRegister(int reg) {
        if (this.preparedRegisterForStore == reg) {
            this.mv.visitFieldInsn(181, cpuInternalName, this.getGprFieldName(reg), "I");
            this.preparedRegisterForStore = -1;
        } else {
            this.loadCpu();
            this.mv.visitInsn(95);
            this.mv.visitFieldInsn(181, cpuInternalName, this.getGprFieldName(reg), "I");
        }
    }

    public void storeRegister(int reg, int constantValue) {
        if (this.preparedRegisterForStore == reg) {
            this.preparedRegisterForStore = -1;
        } else {
            this.loadCpu();
        }
        this.loadImm(constantValue);
        this.mv.visitFieldInsn(181, cpuInternalName, this.getGprFieldName(reg), "I");
    }

    public void prepareFRegisterForStore(int reg) {
        if (this.preparedRegisterForStore < 0) {
            this.loadFpr();
            this.loadImm(reg);
            this.preparedRegisterForStore = reg;
        }
    }

    public void storeFRegister(int reg) {
        if (this.preparedRegisterForStore == reg) {
            this.mv.visitInsn(81);
            this.preparedRegisterForStore = -1;
        } else {
            this.loadFpr();
            this.mv.visitInsn(95);
            this.loadImm(reg);
            this.mv.visitInsn(95);
            this.mv.visitInsn(81);
        }
    }

    private boolean isPfxDstMasked(VfpuPfxDstState pfxDstState, int n) {
        if (pfxDstState == null || pfxDstState.isUnknown() || !pfxDstState.pfxDst.enabled) {
            return false;
        }
        return pfxDstState.pfxDst.msk[n];
    }

    private void applyPfxDstPostfix(VfpuPfxDstState pfxDstState, int n, boolean isFloat) {
        if (pfxDstState == null || pfxDstState.isUnknown() || !pfxDstState.pfxDst.enabled) {
            return;
        }
        switch (pfxDstState.pfxDst.sat[n]) {
            case 1: {
                if (log.isTraceEnabled() && pfxDstState != null && pfxDstState.isKnown() && pfxDstState.pfxDst.enabled) {
                    log.trace((Object)String.format("PFX    %08X - applyPfxDstPostfix %d [0:1]", this.getCodeInstruction().getAddress(), n));
                }
                if (!isFloat) {
                    this.convertVIntToFloat();
                }
                this.mv.visitLdcInsn((Object)Float.valueOf(1.0f));
                this.mv.visitMethodInsn(184, Type.getInternalName(Math.class), "min", "(FF)F");
                this.mv.visitLdcInsn((Object)Float.valueOf(0.0f));
                this.mv.visitMethodInsn(184, Type.getInternalName(Math.class), "max", "(FF)F");
                if (isFloat) break;
                this.convertVFloatToInt();
                break;
            }
            case 3: {
                if (log.isTraceEnabled() && pfxDstState != null && pfxDstState.isKnown() && pfxDstState.pfxDst.enabled) {
                    log.trace((Object)String.format("PFX    %08X - applyPfxDstPostfix %d [-1:1]", this.getCodeInstruction().getAddress(), n));
                }
                if (!isFloat) {
                    this.convertVIntToFloat();
                }
                this.mv.visitLdcInsn((Object)Float.valueOf(1.0f));
                this.mv.visitMethodInsn(184, Type.getInternalName(Math.class), "min", "(FF)F");
                this.mv.visitLdcInsn((Object)Float.valueOf(-1.0f));
                this.mv.visitMethodInsn(184, Type.getInternalName(Math.class), "max", "(FF)F");
                if (isFloat) break;
                this.convertVFloatToInt();
            }
        }
    }

    private void prepareVRegisterForStore(int m, int c, int r, boolean isFloat) {
        int index = VfpuState.getVprIndex(m, c, r);
        if (isFloat) {
            this.loadVprInt();
            this.loadImm(index);
            this.loadVprFloat();
            this.loadImm(index);
        } else {
            this.loadVprFloat();
            this.loadImm(index);
            this.loadVprInt();
            this.loadImm(index);
        }
    }

    public void prepareVRegisterForStore(int vsize, int reg, int n, VfpuPfxDstState pfxDstState, boolean isFloat) {
        if (this.preparedRegisterForStore < 0) {
            if (!this.isPfxDstMasked(pfxDstState, n)) {
                int m = reg >> 2 & 7;
                int i = reg >> 0 & 3;
                switch (vsize) {
                    case 1: {
                        int s = reg >> 5 & 3;
                        this.prepareVRegisterForStore(m, i, s, isFloat);
                        break;
                    }
                    case 2: {
                        int s = (reg & 0x40) >> 5;
                        if ((reg & 0x20) != 0) {
                            this.prepareVRegisterForStore(m, s + n, i, isFloat);
                            break;
                        }
                        this.prepareVRegisterForStore(m, i, s + n, isFloat);
                        break;
                    }
                    case 3: {
                        int s = (reg & 0x40) >> 6;
                        if ((reg & 0x20) != 0) {
                            this.prepareVRegisterForStore(m, s + n, i, isFloat);
                            break;
                        }
                        this.prepareVRegisterForStore(m, i, s + n, isFloat);
                        break;
                    }
                    case 4: {
                        int s = (reg & 0x40) >> 5;
                        if ((reg & 0x20) != 0) {
                            this.prepareVRegisterForStore(m, n + s & 3, i, isFloat);
                            break;
                        }
                        this.prepareVRegisterForStore(m, i, n + s & 3, isFloat);
                    }
                }
            }
            this.preparedRegisterForStore = reg;
        }
    }

    private void storeVRegister(int vsize, int reg, int n, VfpuPfxDstState pfxDstState, boolean isFloat) {
        if (log.isTraceEnabled() && pfxDstState != null && pfxDstState.isKnown() && pfxDstState.pfxDst.enabled) {
            log.trace((Object)String.format("PFX    %08X - storeVRegister %d, %d, %d", this.getCodeInstruction().getAddress(), vsize, reg, n));
        }
        if (this.preparedRegisterForStore == reg) {
            if (this.isPfxDstMasked(pfxDstState, n)) {
                if (log.isTraceEnabled() && pfxDstState != null && pfxDstState.isKnown() && pfxDstState.pfxDst.enabled) {
                    log.trace((Object)String.format("PFX    %08X - storeVRegister %d masked", this.getCodeInstruction().getAddress(), n));
                }
                this.mv.visitInsn(87);
            } else {
                this.applyPfxDstPostfix(pfxDstState, n, isFloat);
                if (isFloat) {
                    this.mv.visitInsn(91);
                    this.mv.visitInsn(81);
                    this.convertVFloatToInt();
                    this.mv.visitInsn(79);
                } else {
                    this.mv.visitInsn(91);
                    this.mv.visitInsn(79);
                    this.convertVIntToFloat();
                    this.mv.visitInsn(81);
                }
            }
            this.preparedRegisterForStore = -1;
        } else {
            log.error((Object)"storeVRegister with non-prepared register is not supported");
        }
    }

    public void loadFcr31() {
        this.loadCpu();
        this.mv.visitFieldInsn(180, cpuInternalName, "fcr31", Type.getDescriptor(FpuState.Fcr31.class));
    }

    public void loadVcr() {
        this.loadCpu();
        this.mv.visitFieldInsn(180, cpuInternalName, "vcr", Type.getDescriptor(VfpuState.Vcr.class));
    }

    @Override
    public void loadHilo() {
        this.loadCpu();
        this.mv.visitFieldInsn(180, cpuInternalName, "hilo", Type.getDescriptor(Long.TYPE));
    }

    @Override
    public void prepareHiloForStore() {
        this.loadCpu();
        this.hiloPrepared = true;
    }

    @Override
    public void storeHilo() {
        if (!this.hiloPrepared) {
            this.loadCpu();
            this.mv.visitInsn(91);
            this.mv.visitInsn(87);
        }
        this.mv.visitFieldInsn(181, cpuInternalName, "hilo", Type.getDescriptor(Long.TYPE));
        this.hiloPrepared = false;
    }

    @Override
    public void loadFcr31c() {
        this.loadFcr31();
        this.mv.visitFieldInsn(180, Type.getInternalName(FpuState.Fcr31.class), "c", "Z");
    }

    @Override
    public void prepareFcr31cForStore() {
        this.loadFcr31();
    }

    @Override
    public void storeFcr31c() {
        this.mv.visitFieldInsn(181, Type.getInternalName(FpuState.Fcr31.class), "c", "Z");
    }

    public void loadVcrCc() {
        this.loadVcrCc(this.codeInstruction.getOpcode() >> 18 & 7);
    }

    @Override
    public void loadVcrCc(int cc) {
        this.loadVcr();
        this.mv.visitFieldInsn(180, Type.getInternalName(VfpuState.Vcr.class), "cc", "[Z");
        this.loadImm(cc);
        this.mv.visitInsn(51);
    }

    private void loadLocalVar(int localVar) {
        this.mv.visitVarInsn(21, localVar);
    }

    private void loadInstruction(Common.Instruction insn) {
        String classInternalName = instructionsInternalName;
        if (insn == Common.UNK) {
            classInternalName = Type.getInternalName(Common.class);
        }
        this.mv.visitFieldInsn(178, classInternalName, insn.name().replace('.', '_').replace(' ', '_'), instructionDescriptor);
    }

    private void storePc() {
        this.loadCpu();
        this.loadImm(this.codeInstruction.getAddress());
        this.mv.visitFieldInsn(181, cpuInternalName, "pc", "I");
    }

    private void visitContinueToAddress(int returnAddress, boolean returnOnUnknownAddress) {
        Label continueLabel = new Label();
        Label isReturnAddress = new Label();
        this.mv.visitInsn(89);
        this.loadImm(returnAddress);
        this.visitJump(159, isReturnAddress);
        if (returnOnUnknownAddress) {
            this.visitJump();
        } else {
            this.loadImm(returnAddress);
            this.mv.visitMethodInsn(184, runtimeContextInternalName, "jump", "(II)V");
            this.mv.visitJumpInsn(167, continueLabel);
        }
        this.mv.visitLabel(isReturnAddress);
        this.mv.visitInsn(87);
        this.mv.visitLabel(continueLabel);
    }

    public void visitJump() {
        this.flushInstructionCount(true, false);
        this.checkSync();
        this.endMethod();
        this.mv.visitInsn(172);
    }

    public void prepareCall(int address, int returnAddress, int returnRegister) {
        this.preparedCallNativeCodeBlock = null;
        if (!Profiler.isProfilerEnabled()) {
            this.preparedCallNativeCodeBlock = this.nativeCodeManager.getCompiledNativeCodeBlock(address);
        }
        if (this.preparedCallNativeCodeBlock == null && returnRegister != 0) {
            this.prepareRegisterForStore(returnRegister);
            this.loadImm(returnAddress);
            this.storeRegister(returnRegister);
        }
    }

    public void visitCall(int address, int returnAddress, int returnRegister, boolean returnRegisterModified, boolean returnOnUnknownAddress) {
        this.flushInstructionCount(false, false);
        if (this.preparedCallNativeCodeBlock != null) {
            if (!this.preparedCallNativeCodeBlock.getNativeCodeSequenceClass().equals(Nop.class)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Inlining call at 0x%08X to %s", this.getCodeInstruction().getAddress(), this.preparedCallNativeCodeBlock));
                }
                this.visitNativeCodeSequence(this.preparedCallNativeCodeBlock, address, null);
            }
        } else {
            this.mv.visitMethodInsn(184, CompilerContext.getClassName(address, this.instanceIndex), this.getStaticExecMethodName(), this.getStaticExecMethodDesc());
            this.visitContinueToAddress(returnAddress, returnOnUnknownAddress);
        }
        this.preparedCallNativeCodeBlock = null;
    }

    public void visitCall(int returnAddress, int returnRegister) {
        this.flushInstructionCount(false, false);
        if (returnRegister != 0) {
            this.storeRegister(returnRegister, returnAddress);
        }
        this.mv.visitMethodInsn(184, runtimeContextInternalName, "call", "(I)I");
        this.visitContinueToAddress(returnAddress, false);
    }

    public void visitCall(int address, String methodName) {
        this.flushInstructionCount(false, false);
        this.mv.visitMethodInsn(184, CompilerContext.getClassName(address, this.instanceIndex), methodName, "()V");
    }

    public void visitIntepreterCall(int opcode, Common.Instruction insn) {
        this.loadInstruction(insn);
        this.loadProcessor();
        this.loadImm(opcode);
        this.mv.visitMethodInsn(182, instructionInternalName, "interpret", "(" + processorDescriptor + "I)V");
    }

    private boolean isFastSyscall(int code) {
        return fastSyscalls.contains(code);
    }

    private void loadParameter(CompilerParameterReader parameterReader, HLEModuleFunction func, Class<?> parameterType, Annotation[] parameterAnnotations, Label afterSyscallLabel, Label catchSceKernelErrorException) {
        int i$;
        if (parameterType == Processor.class) {
            this.loadProcessor();
            parameterReader.incrementCurrentStackSize();
        } else if (parameterType == CpuState.class) {
            this.loadCpu();
            parameterReader.incrementCurrentStackSize();
        } else if (parameterType == Integer.TYPE) {
            parameterReader.loadNextInt();
            parameterReader.incrementCurrentStackSize();
        } else if (parameterType == Float.TYPE) {
            parameterReader.loadNextFloat();
            parameterReader.incrementCurrentStackSize();
        } else if (parameterType == Long.TYPE) {
            parameterReader.loadNextLong();
            parameterReader.incrementCurrentStackSize(2);
        } else if (parameterType == Boolean.TYPE) {
            parameterReader.loadNextInt();
            parameterReader.incrementCurrentStackSize();
        } else if (parameterType == String.class) {
            parameterReader.loadNextInt();
            int maxLength = 16384;
            Annotation[] arr$ = parameterAnnotations;
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                Annotation parameterAnnotation = arr$[i$];
                if (!(parameterAnnotation instanceof StringInfo)) continue;
                StringInfo stringInfo = (StringInfo)parameterAnnotation;
                maxLength = stringInfo.maxLength();
                break;
            }
            this.loadImm(maxLength);
            this.mv.visitMethodInsn(184, runtimeContextInternalName, "readStringNZ", "(II)" + Type.getDescriptor(String.class));
            parameterReader.incrementCurrentStackSize();
        } else if (parameterType == PspString.class) {
            parameterReader.loadNextInt();
            int maxLength = 16384;
            boolean canBeNull = false;
            for (Annotation parameterAnnotation : parameterAnnotations) {
                if (parameterAnnotation instanceof StringInfo) {
                    StringInfo stringInfo = (StringInfo)parameterAnnotation;
                    maxLength = stringInfo.maxLength();
                }
                if (!(parameterAnnotation instanceof CanBeNull)) continue;
                canBeNull = true;
            }
            this.loadImm(maxLength);
            this.loadImm(canBeNull);
            this.mv.visitMethodInsn(184, runtimeContextInternalName, "readPspStringNZ", "(IIZ)" + Type.getDescriptor(PspString.class));
            parameterReader.incrementCurrentStackSize();
        } else if (parameterType == TPointer.class || parameterType == TPointer16.class || parameterType == TPointer32.class || parameterType == TPointer64.class || parameterType == TErrorPointer32.class) {
            this.mv.visitTypeInsn(187, Type.getInternalName(parameterType));
            this.mv.visitInsn(89);
            this.loadMemory();
            parameterReader.loadNextInt();
            boolean canBeNull = false;
            Annotation[] arr$ = parameterAnnotations;
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                Annotation parameterAnnotation = arr$[i$];
                if (!(parameterAnnotation instanceof CanBeNull)) continue;
                canBeNull = true;
                break;
            }
            if (this.checkMemoryAccess() && afterSyscallLabel != null) {
                Label addressGood = new Label();
                if (canBeNull) {
                    this.mv.visitInsn(89);
                    this.mv.visitJumpInsn(153, addressGood);
                }
                this.mv.visitInsn(89);
                this.mv.visitMethodInsn(184, runtimeContextInternalName, "checkMemoryPointer", "(I)Z");
                this.mv.visitJumpInsn(154, addressGood);
                this.storeRegister(2, -2147483389);
                parameterReader.popAllStack(4);
                this.mv.visitJumpInsn(167, afterSyscallLabel);
                this.mv.visitLabel(addressGood);
            }
            if (parameterType == TPointer16.class || parameterType == TPointer32.class || parameterType == TPointer64.class) {
                this.loadImm(canBeNull);
                this.mv.visitMethodInsn(183, Type.getInternalName(parameterType), "<init>", "(" + memoryDescriptor + "IZ)V");
            } else {
                this.mv.visitMethodInsn(183, Type.getInternalName(parameterType), "<init>", "(" + memoryDescriptor + "I)V");
            }
            if (parameterType == TErrorPointer32.class) {
                parameterReader.setHasErrorPointer(true);
                this.mv.visitInsn(89);
                this.mv.visitVarInsn(58, 5);
            }
            parameterReader.incrementCurrentStackSize();
        } else if (pspAbstractMemoryMappedStructure.class.isAssignableFrom(parameterType)) {
            parameterReader.loadNextInt();
            boolean canBeNull = false;
            Annotation[] arr$ = parameterAnnotations;
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                Annotation parameterAnnotation = arr$[i$];
                if (!(parameterAnnotation instanceof CanBeNull)) continue;
                canBeNull = true;
                break;
            }
            if (this.checkMemoryAccess() && afterSyscallLabel != null) {
                Label addressGood = new Label();
                if (canBeNull) {
                    this.mv.visitInsn(89);
                    this.mv.visitJumpInsn(153, addressGood);
                }
                this.mv.visitInsn(89);
                this.mv.visitMethodInsn(184, runtimeContextInternalName, "checkMemoryPointer", "(I)Z");
                this.mv.visitJumpInsn(154, addressGood);
                this.storeRegister(2, -2147483389);
                parameterReader.popAllStack(1);
                this.mv.visitJumpInsn(167, afterSyscallLabel);
                this.mv.visitLabel(addressGood);
            }
            this.mv.visitTypeInsn(187, Type.getInternalName(parameterType));
            this.mv.visitInsn(89);
            this.mv.visitMethodInsn(183, Type.getInternalName(parameterType), "<init>", "()V");
            this.mv.visitInsn(90);
            this.mv.visitInsn(95);
            this.loadMemory();
            this.mv.visitInsn(95);
            this.mv.visitMethodInsn(182, Type.getInternalName(parameterType), "read", "(" + memoryDescriptor + "I)V");
            parameterReader.incrementCurrentStackSize();
        } else {
            HLEUidClass hleUidClass = parameterType.getAnnotation(HLEUidClass.class);
            if (hleUidClass != null) {
                int errorValueOnNotFound = hleUidClass.errorValueOnNotFound();
                this.mv.visitLdcInsn((Object)parameterType.getName());
                parameterReader.loadNextInt();
                this.mv.visitMethodInsn(184, Type.getInternalName(HLEUidObjectMapping.class), "getObject", "(" + Type.getDescriptor(String.class) + "I)" + Type.getDescriptor(Object.class));
                if (afterSyscallLabel != null) {
                    Label foundUid = new Label();
                    this.mv.visitInsn(89);
                    this.mv.visitJumpInsn(199, foundUid);
                    this.storeRegister(2, errorValueOnNotFound);
                    parameterReader.popAllStack(1);
                    this.mv.visitJumpInsn(167, afterSyscallLabel);
                    this.mv.visitLabel(foundUid);
                }
                this.mv.visitTypeInsn(192, Type.getInternalName(parameterType));
                parameterReader.incrementCurrentStackSize();
            } else {
                log.error((Object)String.format("Unsupported sycall parameter type '%s'", parameterType.getName()));
                Emulator.PauseEmuWithStatus(32);
            }
        }
        Method methodToCheck = null;
        if (afterSyscallLabel != null) {
            for (Annotation parameterAnnotation : parameterAnnotations) {
                if (!(parameterAnnotation instanceof CheckArgument)) continue;
                CheckArgument checkArgument = (CheckArgument)parameterAnnotation;
                try {
                    methodToCheck = func.getHLEModule().getClass().getMethod(checkArgument.value(), parameterType);
                }
                catch (Exception e) {
                    log.error((Object)String.format("CheckArgument method '%s' not found in %s", checkArgument.value(), func.getModuleName()), (Throwable)e);
                }
                break;
            }
        }
        if (methodToCheck != null) {
            this.loadModule(func.getModuleName());
            this.mv.visitInsn(95);
            Label tryStart = new Label();
            Label tryEnd = new Label();
            this.mv.visitTryCatchBlock(tryStart, tryEnd, catchSceKernelErrorException, Type.getInternalName(SceKernelErrorException.class));
            this.mv.visitLabel(tryStart);
            this.mv.visitMethodInsn(182, Type.getInternalName(methodToCheck.getDeclaringClass()), methodToCheck.getName(), "(" + Type.getDescriptor(parameterType) + ")" + Type.getDescriptor(parameterType));
            this.mv.visitLabel(tryEnd);
        }
        parameterReader.incrementCurrentParameterIndex();
    }

    private void storeReturnValue(HLEModuleFunction func, Class<?> returnType) {
        if (returnType != Void.TYPE) {
            if (returnType == Integer.TYPE) {
                this.storeRegister(2);
            } else if (returnType == Boolean.TYPE) {
                this.storeRegister(2);
            } else if (returnType == Long.TYPE) {
                this.mv.visitInsn(92);
                this.mv.visitLdcInsn((Object)0xFFFFFFFFL);
                this.mv.visitInsn(127);
                this.mv.visitInsn(136);
                this.storeRegister(2);
                this.loadImm(32);
                this.mv.visitInsn(123);
                this.mv.visitInsn(136);
                this.storeRegister(3);
            } else if (returnType == Float.TYPE) {
                this.storeFRegister(0);
            } else {
                HLEUidClass hleUidClass = returnType.getAnnotation(HLEUidClass.class);
                if (hleUidClass != null) {
                    if (hleUidClass.moduleMethodUidGenerator().length() <= 0) {
                        this.mv.visitLdcInsn((Object)returnType.getName());
                        this.mv.visitInsn(95);
                        this.mv.visitMethodInsn(184, Type.getInternalName(HLEUidObjectMapping.class), "createUidForObject", "(" + Type.getDescriptor(String.class) + Type.getDescriptor(Object.class) + ")I");
                        this.storeRegister(2);
                    } else {
                        this.mv.visitLdcInsn((Object)returnType.getName());
                        this.mv.visitInsn(95);
                        this.loadModule(func.getModuleName());
                        this.mv.visitMethodInsn(182, Type.getInternalName(func.getHLEModuleMethod().getDeclaringClass()), hleUidClass.moduleMethodUidGenerator(), "()I");
                        this.mv.visitInsn(95);
                        this.mv.visitMethodInsn(184, Type.getInternalName(HLEUidObjectMapping.class), "addObjectMap", "(" + Type.getDescriptor(String.class) + "I" + Type.getDescriptor(Object.class) + ")I");
                        this.storeRegister(2);
                    }
                } else {
                    log.error((Object)String.format("Unsupported sycall return value type '%s'", returnType.getName()));
                }
            }
        }
    }

    private void loadModuleLoggger(HLEModuleFunction func, boolean useDirectModuleLogger) {
        if (useDirectModuleLogger) {
            this.mv.visitFieldInsn(178, Type.getInternalName(func.getHLEModuleMethod().getDeclaringClass()), "log", Type.getDescriptor(Logger.class));
        } else {
            this.mv.visitLdcInsn((Object)func.getModuleName());
            this.mv.visitMethodInsn(184, Type.getInternalName(Modules.class), "getLogger", "(" + Type.getDescriptor(String.class) + ")" + Type.getDescriptor(Logger.class));
        }
    }

    private void logSyscall(HLEModuleFunction func, String logPrefix, String logCheckFunction, String logFunction, boolean useDirectModuleLogger) {
        this.loadModuleLoggger(func, useDirectModuleLogger);
        this.mv.visitMethodInsn(182, Type.getInternalName(Logger.class), logCheckFunction, "()Z");
        Label loggingDisabled = new Label();
        this.mv.visitJumpInsn(153, loggingDisabled);
        this.loadModuleLoggger(func, useDirectModuleLogger);
        StringBuilder formatString = new StringBuilder();
        if (logPrefix != null) {
            formatString.append(logPrefix);
        }
        formatString.append(func.getFunctionName());
        ClassAnalyzer.ParameterInfo[] parameters = new ClassAnalyzer().getParameters(func.getFunctionName(), func.getHLEModuleMethod().getDeclaringClass());
        if (parameters != null) {
            this.loadImm(parameters.length);
            this.mv.visitTypeInsn(189, Type.getInternalName(Object.class));
            CompilerParameterReader parameterReader = new CompilerParameterReader(this);
            Annotation[][] paramsAnotations = func.getHLEModuleMethod().getParameterAnnotations();
            int paramIndex = 0;
            int objectArrayIndex = 0;
            for (ClassAnalyzer.ParameterInfo parameter : parameters) {
                Class<?> parameterType = parameter.type;
                CompilerTypeInformation typeInformation = this.compilerTypeManager.getCompilerTypeInformation(parameterType);
                this.mv.visitInsn(89);
                this.loadImm(objectArrayIndex);
                formatString.append(paramIndex > 0 ? ", " : " ");
                formatString.append(parameter.name);
                formatString.append("=");
                formatString.append(typeInformation.formatString);
                if (typeInformation.boxingTypeInternalName != null) {
                    this.mv.visitTypeInsn(187, typeInformation.boxingTypeInternalName);
                    this.mv.visitInsn(89);
                }
                this.loadParameter(parameterReader, func, parameterType, paramsAnotations[paramIndex], null, null);
                if (typeInformation.boxingTypeInternalName != null) {
                    this.mv.visitMethodInsn(183, typeInformation.boxingTypeInternalName, "<init>", typeInformation.boxingMethodDescriptor);
                }
                this.mv.visitInsn(83);
                ++paramIndex;
                ++objectArrayIndex;
            }
            this.mv.visitLdcInsn((Object)formatString.toString());
            this.mv.visitInsn(95);
            this.mv.visitMethodInsn(184, Type.getInternalName(String.class), "format", "(" + Type.getDescriptor(String.class) + "[" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(String.class));
        } else {
            this.mv.visitLdcInsn((Object)formatString.toString());
        }
        this.mv.visitMethodInsn(182, Type.getInternalName(Logger.class), logFunction, "(" + Type.getDescriptor(Object.class) + ")V");
        this.mv.visitLabel(loggingDisabled);
    }

    private void visitSyscall(HLEModuleFunction func, boolean fastSyscall) {
        this.maxStackSize = 100;
        if (!fastSyscall) {
            this.mv.visitMethodInsn(184, runtimeContextInternalName, "preSyscall", "()V");
        }
        Label afterSyscallLabel = new Label();
        if (func.checkInsideInterrupt()) {
            this.mv.visitMethodInsn(184, Type.getInternalName(IntrManager.class), "getInstance", "()" + Type.getDescriptor(IntrManager.class));
            this.mv.visitMethodInsn(182, Type.getInternalName(IntrManager.class), "isInsideInterrupt", "()Z");
            Label notInsideInterrupt = new Label();
            this.mv.visitJumpInsn(153, notInsideInterrupt);
            this.mv.visitFieldInsn(178, Type.getInternalName(Modules.class), "log", Type.getDescriptor(Logger.class));
            this.mv.visitMethodInsn(182, Type.getInternalName(Logger.class), "isDebugEnabled", "()Z");
            Label notDebug = new Label();
            this.mv.visitJumpInsn(153, notDebug);
            this.mv.visitFieldInsn(178, Type.getInternalName(Modules.class), "log", Type.getDescriptor(Logger.class));
            this.mv.visitLdcInsn((Object)String.format("%s returning errorCode 0x%08X (ERROR_KERNEL_WAIT_CAN_NOT_WAIT)", func.getFunctionName(), -2147352153));
            this.mv.visitMethodInsn(182, Type.getInternalName(Logger.class), "debug", "(" + Type.getDescriptor(Object.class) + ")V");
            this.mv.visitLabel(notDebug);
            this.storeRegister(2, -2147352476);
            this.mv.visitJumpInsn(167, afterSyscallLabel);
            this.mv.visitLabel(notInsideInterrupt);
        }
        if (func.checkDispatchThreadEnabled()) {
            this.loadModule("ThreadManForUser");
            this.mv.visitMethodInsn(182, Type.getInternalName(ThreadManForUser.class), "isDispatchThreadEnabled", "()Z");
            Label returnError = new Label();
            this.mv.visitJumpInsn(153, returnError);
            this.mv.visitMethodInsn(184, Type.getInternalName(Interrupts.class), "isInterruptsEnabled", "()Z");
            Label noError = new Label();
            this.mv.visitJumpInsn(154, noError);
            this.mv.visitLabel(returnError);
            this.mv.visitFieldInsn(178, Type.getInternalName(Modules.class), "log", Type.getDescriptor(Logger.class));
            this.mv.visitMethodInsn(182, Type.getInternalName(Logger.class), "isDebugEnabled", "()Z");
            Label notDebug = new Label();
            this.mv.visitJumpInsn(153, notDebug);
            this.mv.visitFieldInsn(178, Type.getInternalName(Modules.class), "log", Type.getDescriptor(Logger.class));
            this.mv.visitLdcInsn((Object)String.format("%s returning errorCode 0x%08X (ERROR_KERNEL_WAIT_CAN_NOT_WAIT)", func.getFunctionName(), -2147352153));
            this.mv.visitMethodInsn(182, Type.getInternalName(Logger.class), "debug", "(" + Type.getDescriptor(Object.class) + ")V");
            this.mv.visitLabel(notDebug);
            this.storeRegister(2, -2147352153);
            this.mv.visitJumpInsn(167, afterSyscallLabel);
            this.mv.visitLabel(noError);
        }
        if (func.isUnimplemented()) {
            this.logSyscall(func, "Unimplemented ", "isInfoEnabled", "warn", false);
        }
        if (func.getLoggingLevel() != null) {
            String logCheckFunction = "isInfoEnabled";
            if ("trace".equals(func.getLoggingLevel())) {
                logCheckFunction = "isTraceEnabled";
            } else if ("debug".equals(func.getLoggingLevel())) {
                logCheckFunction = "isDebugEnabled";
            }
            this.logSyscall(func, null, logCheckFunction, func.getLoggingLevel(), true);
        }
        CompilerParameterReader parameterReader = new CompilerParameterReader(this);
        this.loadModule(func.getModuleName());
        parameterReader.incrementCurrentStackSize();
        Label tryStart = new Label();
        Label tryEnd = new Label();
        Label catchSceKernelErrorException = new Label();
        this.mv.visitTryCatchBlock(tryStart, tryEnd, catchSceKernelErrorException, Type.getInternalName(SceKernelErrorException.class));
        Class<?>[] parameterTypes = func.getHLEModuleMethod().getParameterTypes();
        Class<?> returnType = func.getHLEModuleMethod().getReturnType();
        StringBuilder methodDescriptor = new StringBuilder();
        methodDescriptor.append("(");
        Annotation[][] paramsAnotations = func.getHLEModuleMethod().getParameterAnnotations();
        int paramIndex = 0;
        for (Class<?> parameterType : parameterTypes) {
            methodDescriptor.append(Type.getDescriptor(parameterType));
            this.loadParameter(parameterReader, func, parameterType, paramsAnotations[paramIndex], afterSyscallLabel, catchSceKernelErrorException);
            ++paramIndex;
        }
        methodDescriptor.append(")");
        methodDescriptor.append(Type.getDescriptor(returnType));
        this.mv.visitLabel(tryStart);
        this.mv.visitMethodInsn(182, Type.getInternalName(func.getHLEModuleMethod().getDeclaringClass()), func.getFunctionName(), methodDescriptor.toString());
        this.storeReturnValue(func, returnType);
        if (parameterReader.hasErrorPointer()) {
            this.mv.visitVarInsn(25, 5);
            this.loadImm(0);
            this.mv.visitMethodInsn(182, Type.getInternalName(TErrorPointer32.class), "setValue", "(I)V");
        }
        this.mv.visitLabel(tryEnd);
        this.mv.visitJumpInsn(167, afterSyscallLabel);
        this.mv.visitLabel(catchSceKernelErrorException);
        this.mv.visitFieldInsn(180, Type.getInternalName(SceKernelErrorException.class), "errorCode", "I");
        this.mv.visitFieldInsn(178, Type.getInternalName(Modules.class), "log", Type.getDescriptor(Logger.class));
        this.mv.visitMethodInsn(182, Type.getInternalName(Logger.class), "isDebugEnabled", "()Z");
        Label notDebug = new Label();
        this.mv.visitJumpInsn(153, notDebug);
        this.mv.visitInsn(89);
        this.mv.visitTypeInsn(187, Type.getInternalName(Integer.class));
        this.mv.visitInsn(90);
        this.mv.visitInsn(95);
        this.mv.visitMethodInsn(183, Type.getInternalName(Integer.class), "<init>", "(I)V");
        this.loadImm(1);
        this.mv.visitTypeInsn(189, Type.getInternalName(Object.class));
        this.mv.visitInsn(90);
        this.mv.visitInsn(95);
        this.loadImm(0);
        this.mv.visitInsn(95);
        this.mv.visitInsn(83);
        this.mv.visitLdcInsn((Object)String.format("%s returning errorCode 0x%%08X", func.getFunctionName()));
        this.mv.visitInsn(95);
        this.mv.visitMethodInsn(184, Type.getInternalName(String.class), "format", "(" + Type.getDescriptor(String.class) + "[" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(String.class));
        this.mv.visitFieldInsn(178, Type.getInternalName(Modules.class), "log", Type.getDescriptor(Logger.class));
        this.mv.visitInsn(95);
        this.mv.visitMethodInsn(182, Type.getInternalName(Logger.class), "debug", "(" + Type.getDescriptor(Object.class) + ")V");
        this.mv.visitLabel(notDebug);
        if (parameterReader.hasErrorPointer()) {
            this.mv.visitVarInsn(25, 5);
            this.mv.visitInsn(95);
            this.mv.visitMethodInsn(182, Type.getInternalName(TErrorPointer32.class), "setValue", "(I)V");
            this.storeRegister(2, 0);
        } else {
            this.storeRegister(2);
        }
        CodeInstruction previousInstruction = this.codeBlock.getCodeInstruction(this.codeInstruction.getAddress() - 4);
        if (previousInstruction != null && previousInstruction.getInsn() == Instructions.JR) {
            int jumpRegister = previousInstruction.getOpcode() >> 21 & 0x1F;
            this.loadRegister(jumpRegister);
        }
        this.mv.visitLabel(afterSyscallLabel);
        if (fastSyscall) {
            this.mv.visitMethodInsn(184, runtimeContextInternalName, "postSyscallFast", "()V");
        } else {
            this.mv.visitMethodInsn(184, runtimeContextInternalName, "postSyscall", "()V");
        }
    }

    public void visitSyscall(int opcode) {
        this.flushInstructionCount(false, false);
        int code = opcode >> 6 & 0xFFFFF;
        if (code == 1048575) {
            this.storePc();
        }
        HLEModuleFunction func = HLEModuleManager.getInstance().getFunctionFromSyscallCode(code);
        boolean fastSyscall = this.isFastSyscall(code);
        if (func == null) {
            this.loadImm(code);
            if (fastSyscall) {
                this.mv.visitMethodInsn(184, runtimeContextInternalName, "syscallFast", "(I)V");
            } else {
                this.mv.visitMethodInsn(184, runtimeContextInternalName, "syscall", "(I)V");
            }
        } else {
            this.visitSyscall(func, fastSyscall);
        }
    }

    public void startClass(ClassVisitor cv) {
        cv.visitSource(this.getCodeBlock().getClassName() + ".java", null);
    }

    public void startSequenceMethod() {
        this.mv.visitFieldInsn(178, runtimeContextInternalName, "cpu", cpuDescriptor);
        this.mv.visitVarInsn(58, 0);
        if (this.enableIntructionCounting) {
            this.currentInstructionCount = 0;
            this.mv.visitInsn(3);
            this.mv.visitVarInsn(54, 1);
        }
        this.startNonBranchingCodeSequence();
    }

    public void endSequenceMethod() {
        this.flushInstructionCount(false, true);
        this.mv.visitInsn(177);
    }

    public void checkSync() {
        if (RuntimeContext.enableDaemonThreadSync) {
            Label doNotWantSync = new Label();
            this.mv.visitFieldInsn(178, runtimeContextInternalName, "wantSync", "Z");
            this.mv.visitJumpInsn(153, doNotWantSync);
            this.mv.visitMethodInsn(184, runtimeContextInternalName, "sync", "()V");
            this.mv.visitLabel(doNotWantSync);
        }
    }

    private void startInternalMethod() {
        Label notReplacedLabel = new Label();
        this.mv.visitFieldInsn(178, this.codeBlock.getClassName(), this.getReplaceFieldName(), executableDescriptor);
        this.mv.visitJumpInsn(198, notReplacedLabel);
        this.mv.visitFieldInsn(178, this.codeBlock.getClassName(), this.getReplaceFieldName(), executableDescriptor);
        this.mv.visitMethodInsn(185, executableInternalName, this.getExecMethodName(), this.getExecMethodDesc());
        this.mv.visitInsn(172);
        this.mv.visitLabel(notReplacedLabel);
        if (Profiler.isProfilerEnabled()) {
            this.loadImm(this.getCodeBlock().getStartAddress());
            this.mv.visitMethodInsn(184, profilerInternalName, "addCall", "(I)V");
        }
    }

    public void startMethod() {
        this.startInternalMethod();
        this.startSequenceMethod();
    }

    private void flushInstructionCount(boolean local, boolean last) {
        if (this.enableIntructionCounting) {
            if (local) {
                if (this.currentInstructionCount > 0) {
                    this.mv.visitIincInsn(1, this.currentInstructionCount);
                }
            } else {
                this.mv.visitFieldInsn(178, runtimeContextInternalName, "currentThread", sceKernalThreadInfoDescriptor);
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(180, sceKernalThreadInfoInternalName, "runClocks", "J");
                this.mv.visitVarInsn(21, 1);
                if (this.currentInstructionCount > 0) {
                    this.loadImm(this.currentInstructionCount);
                    this.mv.visitInsn(96);
                }
                if (Profiler.isProfilerEnabled()) {
                    this.mv.visitInsn(89);
                    this.loadImm(this.getCodeBlock().getStartAddress());
                    this.mv.visitMethodInsn(184, profilerInternalName, "addInstructionCount", "(II)V");
                }
                this.mv.visitInsn(133);
                this.mv.visitInsn(97);
                this.mv.visitFieldInsn(181, sceKernalThreadInfoInternalName, "runClocks", "J");
                if (!last) {
                    this.mv.visitInsn(3);
                    this.mv.visitVarInsn(54, 1);
                }
            }
            this.currentInstructionCount = 0;
        }
    }

    private void endInternalMethod() {
    }

    public void endMethod() {
        this.endInternalMethod();
        this.flushInstructionCount(false, true);
    }

    public void beforeInstruction(CodeInstruction codeInstruction) {
        if (this.enableIntructionCounting) {
            if (codeInstruction.isBranchTarget()) {
                this.flushInstructionCount(true, false);
            }
            ++this.currentInstructionCount;
        }
        codeInstruction.getLabel(false);
    }

    private void startNonBranchingCodeSequence() {
        this.vfpuPfxsState.reset();
        this.vfpuPfxtState.reset();
        this.vfpuPfxdState.reset();
    }

    private boolean isNonBranchingCodeSequence(CodeInstruction codeInstruction) {
        return !codeInstruction.isBranchTarget() && !codeInstruction.isBranching();
    }

    public void startInstruction(CodeInstruction codeInstruction) {
        int lineNumber = codeInstruction.getAddress() - this.getCodeBlock().getLowestAddress();
        if (lineNumber >= 0 && lineNumber <= 65535) {
            this.mv.visitLineNumber(lineNumber, codeInstruction.getLabel());
        }
        if (RuntimeContext.enableDebugger) {
            this.loadImm(codeInstruction.getAddress());
            this.mv.visitMethodInsn(184, runtimeContextInternalName, "syncDebugger", "(I)V");
        }
        if (!this.isNonBranchingCodeSequence(codeInstruction)) {
            this.startNonBranchingCodeSequence();
        }
        if (codeInstruction.hasFlags(2048)) {
            this.disablePfxSrc(this.vfpuPfxtState);
        }
    }

    private void disablePfxSrc(VfpuPfxSrcState pfxSrcState) {
        pfxSrcState.pfxSrc.enabled = false;
        pfxSrcState.setKnown(true);
    }

    private void disablePfxDst(VfpuPfxDstState pfxDstState) {
        pfxDstState.pfxDst.enabled = false;
        pfxDstState.setKnown(true);
    }

    public void endInstruction() {
        if (this.codeInstruction != null) {
            if (this.codeInstruction.hasFlags(256)) {
                this.disablePfxSrc(this.vfpuPfxsState);
            }
            if (this.codeInstruction.hasFlags(512)) {
                this.disablePfxSrc(this.vfpuPfxtState);
            }
            if (this.codeInstruction.hasFlags(1024)) {
                this.disablePfxDst(this.vfpuPfxdState);
            }
        }
    }

    public void visitJump(int opcode, CodeInstruction target) {
        if (target.getAddress() <= this.getCodeInstruction().getAddress()) {
            this.checkSync();
            if (Profiler.isProfilerEnabled()) {
                this.loadImm(this.getCodeInstruction().getAddress());
                this.mv.visitMethodInsn(184, profilerInternalName, "addBackBranch", "(I)V");
            }
        }
        this.visitJump(opcode, target.getLabel());
    }

    public void visitJump(int opcode, Label label) {
        this.flushInstructionCount(true, false);
        this.mv.visitJumpInsn(opcode, label);
    }

    public void visitJump(int opcode, int address) {
        this.flushInstructionCount(true, false);
        if (opcode == 167) {
            this.loadImm(address);
            this.visitJump();
        } else {
            log.error((Object)"Not implemented: branching to an unknown address");
            if (opcode == 165 || opcode == 166 || opcode == 159 || opcode == 160 || opcode == 162 || opcode == 163 || opcode == 164 || opcode == 161) {
                this.mv.visitInsn(87);
            }
            this.mv.visitInsn(87);
            this.loadImm(address);
            this.visitJump();
        }
    }

    public static String getClassName(int address, int instanceIndex) {
        return "_S1_" + instanceIndex + "_" + Integer.toHexString(address).toUpperCase();
    }

    public static int getClassAddress(String name) {
        String hexAddress = name.substring(name.lastIndexOf("_") + 1);
        return Integer.parseInt(hexAddress, 16);
    }

    public static int getClassInstanceIndex(String name) {
        int startIndex = name.indexOf("_", 1);
        int endIndex = name.lastIndexOf("_");
        String instanceIndex = name.substring(startIndex + 1, endIndex);
        return Integer.parseInt(instanceIndex);
    }

    public String getExecMethodName() {
        return "exec";
    }

    public String getExecMethodDesc() {
        return "()I";
    }

    public String getReplaceFieldName() {
        return "e";
    }

    public String getReplaceMethodName() {
        return "setExecutable";
    }

    public String getReplaceMethodDesc() {
        return "(" + executableDescriptor + ")V";
    }

    public String getGetMethodName() {
        return "getExecutable";
    }

    public String getGetMethodDesc() {
        return "()" + executableDescriptor;
    }

    public String getStaticExecMethodName() {
        return "s";
    }

    public String getStaticExecMethodDesc() {
        return "()I";
    }

    public boolean isAutomaticMaxLocals() {
        return false;
    }

    public int getMaxLocals() {
        return 10;
    }

    public boolean isAutomaticMaxStack() {
        return false;
    }

    public int getMaxStack() {
        return this.maxStackSize;
    }

    public void visitPauseEmuWithStatus(MethodVisitor mv, int status) {
        this.loadImm(status);
        mv.visitMethodInsn(184, runtimeContextInternalName, "pauseEmuWithStatus", "(I)V");
    }

    public void visitLogInfo(MethodVisitor mv, String message) {
        mv.visitLdcInsn((Object)message);
        mv.visitMethodInsn(184, runtimeContextInternalName, "logInfo", "(" + stringDescriptor + ")V");
    }

    @Override
    public MethodVisitor getMethodVisitor() {
        return this.mv;
    }

    public void setMethodVisitor(MethodVisitor mv) {
        this.mv = mv;
    }

    @Override
    public CodeInstruction getCodeInstruction() {
        return this.codeInstruction;
    }

    @Override
    public CodeInstruction getCodeInstruction(int address) {
        return this.getCodeBlock().getCodeInstruction(address);
    }

    public void setCodeInstruction(CodeInstruction codeInstruction) {
        this.codeInstruction = codeInstruction;
    }

    @Override
    public int getSaValue() {
        return this.codeInstruction.getSaValue();
    }

    @Override
    public int getRsRegisterIndex() {
        return this.codeInstruction.getRsRegisterIndex();
    }

    @Override
    public int getRtRegisterIndex() {
        return this.codeInstruction.getRtRegisterIndex();
    }

    @Override
    public int getRdRegisterIndex() {
        return this.codeInstruction.getRdRegisterIndex();
    }

    @Override
    public void loadRs() {
        this.loadRegister(this.getRsRegisterIndex());
    }

    @Override
    public void loadRt() {
        this.loadRegister(this.getRtRegisterIndex());
    }

    @Override
    public void loadRd() {
        this.loadRegister(this.getRdRegisterIndex());
    }

    @Override
    public void loadSaValue() {
        this.loadImm(this.getSaValue());
    }

    public void loadRegisterIndex(int registerIndex) {
        this.loadImm(registerIndex);
    }

    public void loadRsIndex() {
        this.loadRegisterIndex(this.getRsRegisterIndex());
    }

    public void loadRtIndex() {
        this.loadRegisterIndex(this.getRtRegisterIndex());
    }

    public void loadRdIndex() {
        this.loadRegisterIndex(this.getRdRegisterIndex());
    }

    @Override
    public int getImm16(boolean signedImm) {
        return this.codeInstruction.getImm16(signedImm);
    }

    @Override
    public int getImm14(boolean signedImm) {
        return this.codeInstruction.getImm14(signedImm);
    }

    @Override
    public void loadImm16(boolean signedImm) {
        this.loadImm(this.getImm16(signedImm));
    }

    @Override
    public void loadImm(int imm) {
        switch (imm) {
            case -1: {
                this.mv.visitInsn(2);
                break;
            }
            case 0: {
                this.mv.visitInsn(3);
                break;
            }
            case 1: {
                this.mv.visitInsn(4);
                break;
            }
            case 2: {
                this.mv.visitInsn(5);
                break;
            }
            case 3: {
                this.mv.visitInsn(6);
                break;
            }
            case 4: {
                this.mv.visitInsn(7);
                break;
            }
            case 5: {
                this.mv.visitInsn(8);
                break;
            }
            default: {
                if (-128 <= imm && imm < 127) {
                    this.mv.visitIntInsn(16, imm);
                    break;
                }
                if (Short.MIN_VALUE <= imm && imm < Short.MAX_VALUE) {
                    this.mv.visitIntInsn(17, imm);
                    break;
                }
                this.mv.visitLdcInsn((Object)new Integer(imm));
            }
        }
    }

    public void loadImm(boolean imm) {
        this.mv.visitInsn(imm ? 4 : 3);
    }

    public void loadPspNaNInt() {
        this.mv.visitFieldInsn(178, Type.getInternalName(VfpuState.class), "pspNaNint", "I");
    }

    @Override
    public void compileInterpreterInstruction() {
        this.visitIntepreterCall(this.codeInstruction.getOpcode(), this.codeInstruction.getInsn());
    }

    @Override
    public void compileRTRSIMM(String method, boolean signedImm) {
        this.loadCpu();
        this.loadRtIndex();
        this.loadRsIndex();
        this.loadImm16(signedImm);
        this.mv.visitMethodInsn(182, cpuInternalName, method, "(III)V");
    }

    @Override
    public void compileRDRT(String method) {
        this.loadCpu();
        this.loadRdIndex();
        this.loadRtIndex();
        this.mv.visitMethodInsn(182, cpuInternalName, method, "(II)V");
    }

    @Override
    public void storeRd() {
        this.storeRegister(this.getRdRegisterIndex());
    }

    @Override
    public void storeRd(int constantValue) {
        this.storeRegister(this.getRdRegisterIndex(), constantValue);
    }

    @Override
    public void storeRt() {
        this.storeRegister(this.getRtRegisterIndex());
    }

    @Override
    public void storeRt(int constantValue) {
        this.storeRegister(this.getRtRegisterIndex(), constantValue);
    }

    @Override
    public boolean isRdRegister0() {
        return this.getRdRegisterIndex() == 0;
    }

    @Override
    public boolean isRtRegister0() {
        return this.getRtRegisterIndex() == 0;
    }

    @Override
    public boolean isRsRegister0() {
        return this.getRsRegisterIndex() == 0;
    }

    @Override
    public void prepareRdForStore() {
        this.prepareRegisterForStore(this.getRdRegisterIndex());
    }

    @Override
    public void prepareRtForStore() {
        this.prepareRegisterForStore(this.getRtRegisterIndex());
    }

    private void loadMemoryInt() {
        this.mv.visitFieldInsn(178, runtimeContextInternalName, "memoryInt", "[I");
    }

    @Override
    public void memRead32(int registerIndex, int offset) {
        if (RuntimeContext.memoryInt == null) {
            this.loadMemory();
        } else {
            this.loadMemoryInt();
        }
        this.prepareMemIndex(registerIndex, offset, true, 32);
        if (RuntimeContext.memoryInt == null) {
            this.mv.visitMethodInsn(182, memoryInternalName, "read32", "(I)I");
        } else {
            this.mv.visitInsn(46);
        }
    }

    @Override
    public void memRead16(int registerIndex, int offset) {
        if (RuntimeContext.memoryInt == null) {
            this.loadMemory();
        } else {
            this.loadMemoryInt();
        }
        this.loadRegister(registerIndex);
        if (offset != 0) {
            this.loadImm(offset);
            this.mv.visitInsn(96);
        }
        if (RuntimeContext.memoryInt == null) {
            this.mv.visitMethodInsn(182, memoryInternalName, "read16", "(I)I");
        } else {
            if (this.checkMemoryAccess()) {
                this.loadImm(this.codeInstruction.getAddress());
                this.mv.visitMethodInsn(184, runtimeContextInternalName, "checkMemoryRead16", "(II)I");
                this.loadImm(1);
                this.mv.visitInsn(124);
            } else {
                this.loadImm(2);
                this.mv.visitInsn(120);
                this.loadImm(3);
                this.mv.visitInsn(124);
            }
            this.mv.visitInsn(89);
            this.loadImm(1);
            this.mv.visitInsn(126);
            this.loadImm(4);
            this.mv.visitInsn(120);
            this.storeTmp1();
            this.loadImm(1);
            this.mv.visitInsn(124);
            this.mv.visitInsn(46);
            this.loadTmp1();
            this.mv.visitInsn(124);
            this.loadImm(65535);
            this.mv.visitInsn(126);
        }
    }

    @Override
    public void memRead8(int registerIndex, int offset) {
        if (RuntimeContext.memoryInt == null) {
            this.loadMemory();
        } else {
            this.loadMemoryInt();
        }
        this.loadRegister(registerIndex);
        if (offset != 0) {
            this.loadImm(offset);
            this.mv.visitInsn(96);
        }
        if (RuntimeContext.memoryInt == null) {
            this.mv.visitMethodInsn(182, memoryInternalName, "read8", "(I)I");
        } else {
            if (this.checkMemoryAccess()) {
                this.loadImm(this.codeInstruction.getAddress());
                this.mv.visitMethodInsn(184, runtimeContextInternalName, "checkMemoryRead8", "(II)I");
            } else {
                this.loadImm(2);
                this.mv.visitInsn(120);
                this.loadImm(2);
                this.mv.visitInsn(124);
            }
            this.mv.visitInsn(89);
            this.loadImm(3);
            this.mv.visitInsn(126);
            this.loadImm(3);
            this.mv.visitInsn(120);
            this.storeTmp1();
            this.loadImm(2);
            this.mv.visitInsn(124);
            this.mv.visitInsn(46);
            this.loadTmp1();
            this.mv.visitInsn(124);
            this.loadImm(255);
            this.mv.visitInsn(126);
        }
    }

    private void prepareMemIndex(int registerIndex, int offset, boolean isRead, int width) {
        this.loadRegister(registerIndex);
        if (offset != 0) {
            this.loadImm(offset);
            this.mv.visitInsn(96);
        }
        if (RuntimeContext.memoryInt != null) {
            if (registerIndex == 29) {
                this.loadImm(2);
                this.mv.visitInsn(124);
            } else if (this.checkMemoryAccess()) {
                this.loadImm(this.codeInstruction.getAddress());
                String checkMethodName = String.format("checkMemory%s%d", isRead ? "Read" : "Write", width);
                this.mv.visitMethodInsn(184, runtimeContextInternalName, checkMethodName, "(II)I");
                this.loadImm(2);
                this.mv.visitInsn(124);
            } else {
                this.loadImm(2);
                this.mv.visitInsn(120);
                this.loadImm(4);
                this.mv.visitInsn(124);
            }
        }
    }

    @Override
    public void prepareMemWrite32(int registerIndex, int offset) {
        if (RuntimeContext.memoryInt == null) {
            this.loadMemory();
        } else {
            this.loadMemoryInt();
        }
        this.prepareMemIndex(registerIndex, offset, false, 32);
        this.memWritePrepared = true;
    }

    @Override
    public void memWrite32(int registerIndex, int offset) {
        if (!this.memWritePrepared) {
            if (RuntimeContext.memoryInt == null) {
                this.loadMemory();
            } else {
                this.loadMemoryInt();
            }
            this.mv.visitInsn(95);
            this.loadRegister(registerIndex);
            if (offset != 0) {
                this.loadImm(offset);
                this.mv.visitInsn(96);
            }
            if (this.checkMemoryAccess()) {
                this.loadImm(this.codeInstruction.getAddress());
                this.mv.visitMethodInsn(184, runtimeContextInternalName, "checkMemoryWrite32", "(II)I");
            }
            this.mv.visitInsn(95);
        }
        if (RuntimeContext.memoryInt == null) {
            this.mv.visitMethodInsn(182, memoryInternalName, "write32", "(II)V");
        } else {
            this.mv.visitInsn(79);
        }
        this.memWritePrepared = false;
    }

    @Override
    public void prepareMemWrite16(int registerIndex, int offset) {
        if (RuntimeContext.memoryInt == null) {
            this.loadMemory();
        } else {
            this.loadMemoryInt();
        }
        this.loadRegister(registerIndex);
        if (offset != 0) {
            this.loadImm(offset);
            this.mv.visitInsn(96);
        }
        if (RuntimeContext.memoryInt != null && this.checkMemoryAccess()) {
            this.loadImm(this.codeInstruction.getAddress());
            this.mv.visitMethodInsn(184, runtimeContextInternalName, "checkMemoryWrite16", "(II)I");
        }
        this.memWritePrepared = true;
    }

    @Override
    public void memWrite16(int registerIndex, int offset) {
        if (!this.memWritePrepared) {
            if (RuntimeContext.memoryInt == null) {
                this.loadMemory();
            } else {
                this.loadMemoryInt();
            }
            this.mv.visitInsn(95);
            this.loadRegister(registerIndex);
            if (offset != 0) {
                this.loadImm(offset);
                this.mv.visitInsn(96);
            }
            if (RuntimeContext.memoryInt != null && this.checkMemoryAccess()) {
                this.loadImm(this.codeInstruction.getAddress());
                this.mv.visitMethodInsn(184, runtimeContextInternalName, "checkMemoryWrite16", "(II)I");
            }
            this.mv.visitInsn(95);
        }
        if (RuntimeContext.memoryInt == null) {
            this.mv.visitMethodInsn(182, memoryInternalName, "write16", "(IS)V");
        } else {
            this.loadImm(65535);
            this.mv.visitInsn(126);
            this.storeTmp2();
            this.mv.visitInsn(89);
            this.loadImm(2);
            this.mv.visitInsn(126);
            this.loadImm(3);
            this.mv.visitInsn(120);
            this.storeTmp1();
            if (this.checkMemoryAccess()) {
                this.loadImm(2);
                this.mv.visitInsn(122);
            } else {
                this.loadImm(2);
                this.mv.visitInsn(120);
                this.loadImm(4);
                this.mv.visitInsn(124);
            }
            this.mv.visitInsn(92);
            this.mv.visitInsn(46);
            this.loadImm(65535);
            this.loadTmp1();
            this.mv.visitInsn(120);
            this.loadImm(-1);
            this.mv.visitInsn(130);
            this.mv.visitInsn(126);
            this.loadTmp2();
            this.loadTmp1();
            this.mv.visitInsn(120);
            this.mv.visitInsn(128);
            this.mv.visitInsn(79);
        }
        this.memWritePrepared = false;
    }

    @Override
    public void prepareMemWrite8(int registerIndex, int offset) {
        if (RuntimeContext.memoryInt == null) {
            this.loadMemory();
        } else {
            this.loadMemoryInt();
        }
        this.loadRegister(registerIndex);
        if (offset != 0) {
            this.loadImm(offset);
            this.mv.visitInsn(96);
        }
        if (RuntimeContext.memoryInt != null && this.checkMemoryAccess()) {
            this.loadImm(this.codeInstruction.getAddress());
            this.mv.visitMethodInsn(184, runtimeContextInternalName, "checkMemoryWrite8", "(II)I");
        }
        this.memWritePrepared = true;
    }

    @Override
    public void memWrite8(int registerIndex, int offset) {
        if (!this.memWritePrepared) {
            if (RuntimeContext.memoryInt == null) {
                this.loadMemory();
            } else {
                this.loadMemoryInt();
            }
            this.mv.visitInsn(95);
            this.loadRegister(registerIndex);
            if (offset != 0) {
                this.loadImm(offset);
                this.mv.visitInsn(96);
            }
            if (RuntimeContext.memoryInt != null && this.checkMemoryAccess()) {
                this.loadImm(this.codeInstruction.getAddress());
                this.mv.visitMethodInsn(184, runtimeContextInternalName, "checkMemoryWrite8", "(II)I");
            }
            this.mv.visitInsn(95);
        }
        if (RuntimeContext.memoryInt == null) {
            this.mv.visitMethodInsn(182, memoryInternalName, "write8", "(IB)V");
        } else {
            this.loadImm(255);
            this.mv.visitInsn(126);
            this.storeTmp2();
            this.mv.visitInsn(89);
            this.loadImm(3);
            this.mv.visitInsn(126);
            this.loadImm(3);
            this.mv.visitInsn(120);
            this.storeTmp1();
            if (this.checkMemoryAccess()) {
                this.loadImm(2);
                this.mv.visitInsn(122);
            } else {
                this.loadImm(2);
                this.mv.visitInsn(120);
                this.loadImm(4);
                this.mv.visitInsn(124);
            }
            this.mv.visitInsn(92);
            this.mv.visitInsn(46);
            this.loadImm(255);
            this.loadTmp1();
            this.mv.visitInsn(120);
            this.loadImm(-1);
            this.mv.visitInsn(130);
            this.mv.visitInsn(126);
            this.loadTmp2();
            this.loadTmp1();
            this.mv.visitInsn(120);
            this.mv.visitInsn(128);
            this.mv.visitInsn(79);
        }
        this.memWritePrepared = false;
    }

    @Override
    public void memWriteZero8(int registerIndex, int offset) {
        if (RuntimeContext.memoryInt == null) {
            this.loadMemory();
        } else {
            this.loadMemoryInt();
        }
        this.loadRegister(registerIndex);
        if (offset != 0) {
            this.loadImm(offset);
            this.mv.visitInsn(96);
        }
        if (RuntimeContext.memoryInt != null && this.checkMemoryAccess()) {
            this.loadImm(this.codeInstruction.getAddress());
            this.mv.visitMethodInsn(184, runtimeContextInternalName, "checkMemoryWrite8", "(II)I");
        }
        if (RuntimeContext.memoryInt == null) {
            this.loadImm(0);
            this.mv.visitMethodInsn(182, memoryInternalName, "write8", "(IB)V");
        } else {
            this.mv.visitInsn(89);
            this.loadImm(3);
            this.mv.visitInsn(126);
            this.loadImm(3);
            this.mv.visitInsn(120);
            this.storeTmp1();
            if (this.checkMemoryAccess()) {
                this.loadImm(2);
                this.mv.visitInsn(122);
            } else {
                this.loadImm(2);
                this.mv.visitInsn(120);
                this.loadImm(4);
                this.mv.visitInsn(124);
            }
            this.mv.visitInsn(92);
            this.mv.visitInsn(46);
            this.loadImm(255);
            this.loadTmp1();
            this.mv.visitInsn(120);
            this.loadImm(-1);
            this.mv.visitInsn(130);
            this.mv.visitInsn(126);
            this.mv.visitInsn(79);
        }
    }

    @Override
    public void compileSyscall() {
        this.visitSyscall(this.codeInstruction.getOpcode());
    }

    @Override
    public void convertUnsignedIntToLong() {
        this.mv.visitInsn(133);
        this.mv.visitLdcInsn((Object)0xFFFFFFFFL);
        this.mv.visitInsn(127);
    }

    public int getMethodMaxInstructions() {
        return this.methodMaxInstructions;
    }

    public void setMethodMaxInstructions(int methodMaxInstructions) {
        this.methodMaxInstructions = methodMaxInstructions;
    }

    private boolean checkMemoryAccess() {
        if (RuntimeContext.memoryInt == null) {
            return false;
        }
        return RuntimeContext.memory instanceof SafeFastMemory;
    }

    public void compileDelaySlotAsBranchTarget(CodeInstruction codeInstruction) {
        if (codeInstruction.getInsn() == Instructions.NOP) {
            return;
        }
        boolean skipDelaySlotInstruction = true;
        CodeInstruction previousInstruction = this.getCodeBlock().getCodeInstruction(codeInstruction.getAddress() - 4);
        if (previousInstruction != null && Compiler.isEndBlockInsn(previousInstruction.getAddress(), previousInstruction.getOpcode(), previousInstruction.getInsn())) {
            skipDelaySlotInstruction = false;
        }
        Label afterDelaySlot = null;
        if (skipDelaySlotInstruction) {
            afterDelaySlot = new Label();
            this.mv.visitJumpInsn(167, afterDelaySlot);
        }
        codeInstruction.compile(this, this.mv);
        if (skipDelaySlotInstruction) {
            this.mv.visitLabel(afterDelaySlot);
        }
    }

    public void compileExecuteInterpreter(int startAddress) {
        this.loadImm(startAddress);
        this.mv.visitMethodInsn(184, runtimeContextInternalName, "executeInterpreter", "(I)I");
        this.endMethod();
        this.mv.visitInsn(172);
    }

    private void visitNativeCodeSequence(NativeCodeSequence nativeCodeSequence, int address, NativeCodeInstruction nativeCodeInstruction) {
        StringBuilder methodSignature = new StringBuilder("(");
        int numberParameters = nativeCodeSequence.getNumberParameters();
        for (int i = 0; i < numberParameters; ++i) {
            this.loadImm(nativeCodeSequence.getParameterValue(i, address));
            methodSignature.append("I");
        }
        methodSignature.append(")V");
        this.mv.visitMethodInsn(184, Type.getInternalName(nativeCodeSequence.getNativeCodeSequenceClass()), nativeCodeSequence.getMethodName(), methodSignature.toString());
        if (nativeCodeInstruction != null && nativeCodeInstruction.isBranching()) {
            CodeInstruction targetInstruction = this.getCodeBlock().getCodeInstruction(nativeCodeInstruction.getBranchingTo());
            if (targetInstruction != null) {
                this.visitJump(167, targetInstruction);
            } else {
                this.visitJump(167, nativeCodeInstruction.getBranchingTo());
            }
        }
    }

    public void compileNativeCodeSequence(NativeCodeSequence nativeCodeSequence, NativeCodeInstruction nativeCodeInstruction) {
        this.visitNativeCodeSequence(nativeCodeSequence, nativeCodeInstruction.getAddress(), nativeCodeInstruction);
        if (nativeCodeSequence.isReturning()) {
            this.loadRegister(31);
            this.endInternalMethod();
            this.mv.visitInsn(172);
        }
        if (this.getCodeBlock().getLength() == nativeCodeSequence.getNumOpcodes() && !nativeCodeSequence.hasBranchInstruction()) {
            this.nativeCodeManager.setCompiledNativeCodeBlock(this.getCodeBlock().getStartAddress(), nativeCodeSequence);
            if (log.isDebugEnabled() || nativeCodeSequence.getNativeCodeSequenceClass().equals(Nop.class)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Replacing CodeBlock at 0x%08X (%08X-0x%08X, length %d) by %s", this.getCodeBlock().getStartAddress(), this.getCodeBlock().getLowestAddress(), this.codeBlock.getHighestAddress(), this.codeBlock.getLength(), nativeCodeSequence));
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)String.format("Replacing CodeBlock at 0x%08X by Native Code '%s'", this.getCodeBlock().getStartAddress(), nativeCodeSequence.getName()));
            }
        } else {
            int endAddress = this.getCodeInstruction().getAddress() + (nativeCodeSequence.getNumOpcodes() - 1) * 4;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Replacing CodeSequence at 0x%08X-0x%08X by Native Code %s", this.getCodeInstruction().getAddress(), endAddress, nativeCodeSequence));
            } else if (log.isInfoEnabled()) {
                log.info((Object)String.format("Replacing CodeSequence at 0x%08X-0x%08X by Native Code '%s'", this.getCodeInstruction().getAddress(), endAddress, nativeCodeSequence.getName()));
            }
        }
    }

    public int getNumberInstructionsToBeSkipped() {
        return this.numberInstructionsToBeSkipped;
    }

    public boolean isSkipDelaySlot() {
        return this.skipDelaySlot;
    }

    @Override
    public void skipInstructions(int numberInstructionsToBeSkipped, boolean skipDelaySlot) {
        this.numberInstructionsToBeSkipped = numberInstructionsToBeSkipped;
        this.skipDelaySlot = skipDelaySlot;
    }

    @Override
    public int getFdRegisterIndex() {
        return this.codeInstruction.getFdRegisterIndex();
    }

    @Override
    public int getFsRegisterIndex() {
        return this.codeInstruction.getFsRegisterIndex();
    }

    @Override
    public int getFtRegisterIndex() {
        return this.codeInstruction.getFtRegisterIndex();
    }

    @Override
    public void loadFd() {
        this.loadFRegister(this.getFdRegisterIndex());
    }

    @Override
    public void loadFs() {
        this.loadFRegister(this.getFsRegisterIndex());
    }

    @Override
    public void loadFt() {
        this.loadFRegister(this.getFtRegisterIndex());
    }

    @Override
    public void prepareFdForStore() {
        this.prepareFRegisterForStore(this.getFdRegisterIndex());
    }

    @Override
    public void prepareFtForStore() {
        this.prepareFRegisterForStore(this.getFtRegisterIndex());
    }

    @Override
    public void storeFd() {
        this.storeFRegister(this.getFdRegisterIndex());
    }

    @Override
    public void storeFt() {
        this.storeFRegister(this.getFtRegisterIndex());
    }

    @Override
    public void loadFCr() {
        this.loadFRegister(this.getCrValue());
    }

    @Override
    public void prepareFCrForStore() {
        this.prepareFRegisterForStore(this.getCrValue());
    }

    @Override
    public void prepareVcrCcForStore(int cc) {
        if (this.preparedRegisterForStore < 0) {
            this.loadVcr();
            this.mv.visitFieldInsn(180, Type.getInternalName(VfpuState.Vcr.class), "cc", "[Z");
            this.loadImm(cc);
            this.preparedRegisterForStore = cc;
        }
    }

    @Override
    public void storeVcrCc(int cc) {
        if (this.preparedRegisterForStore == cc) {
            this.mv.visitInsn(84);
            this.preparedRegisterForStore = -1;
        } else {
            this.loadVcr();
            this.mv.visitFieldInsn(180, Type.getInternalName(VfpuState.Vcr.class), "cc", "[Z");
            this.mv.visitInsn(95);
            this.loadImm(cc);
            this.mv.visitInsn(95);
            this.mv.visitInsn(84);
        }
    }

    @Override
    public int getCrValue() {
        return this.codeInstruction.getCrValue();
    }

    @Override
    public void storeFCr() {
        this.storeFRegister(this.getCrValue());
    }

    @Override
    public int getVdRegisterIndex() {
        return this.codeInstruction.getVdRegisterIndex();
    }

    @Override
    public int getVsRegisterIndex() {
        return this.codeInstruction.getVsRegisterIndex();
    }

    @Override
    public int getVtRegisterIndex() {
        return this.codeInstruction.getVtRegisterIndex();
    }

    @Override
    public int getVsize() {
        return this.codeInstruction.getVsize();
    }

    @Override
    public void loadVs(int n) {
        this.loadVRegister(this.getVsize(), this.getVsRegisterIndex(), n, this.vfpuPfxsState, true);
    }

    @Override
    public void loadVsInt(int n) {
        this.loadVRegister(this.getVsize(), this.getVsRegisterIndex(), n, this.vfpuPfxsState, false);
    }

    @Override
    public void loadVt(int n) {
        this.loadVRegister(this.getVsize(), this.getVtRegisterIndex(), n, this.vfpuPfxtState, true);
    }

    @Override
    public void loadVtInt(int n) {
        this.loadVRegister(this.getVsize(), this.getVtRegisterIndex(), n, this.vfpuPfxtState, false);
    }

    @Override
    public void loadVt(int vsize, int n) {
        this.loadVRegister(vsize, this.getVtRegisterIndex(), n, this.vfpuPfxtState, true);
    }

    @Override
    public void loadVtInt(int vsize, int n) {
        this.loadVRegister(vsize, this.getVtRegisterIndex(), n, this.vfpuPfxtState, false);
    }

    @Override
    public void loadVt(int vsize, int vt, int n) {
        this.loadVRegister(vsize, vt, n, this.vfpuPfxtState, true);
    }

    @Override
    public void loadVtInt(int vsize, int vt, int n) {
        this.loadVRegister(vsize, vt, n, this.vfpuPfxtState, false);
    }

    @Override
    public void loadVd(int n) {
        this.loadVRegister(this.getVsize(), this.getVdRegisterIndex(), n, null, true);
    }

    @Override
    public void loadVdInt(int n) {
        this.loadVRegister(this.getVsize(), this.getVdRegisterIndex(), n, null, false);
    }

    @Override
    public void loadVd(int vsize, int n) {
        this.loadVRegister(vsize, this.getVdRegisterIndex(), n, null, true);
    }

    @Override
    public void loadVdInt(int vsize, int n) {
        this.loadVRegister(vsize, this.getVdRegisterIndex(), n, null, false);
    }

    @Override
    public void loadVd(int vsize, int vd, int n) {
        this.loadVRegister(vsize, vd, n, null, true);
    }

    @Override
    public void loadVdInt(int vsize, int vd, int n) {
        this.loadVRegister(vsize, vd, n, null, false);
    }

    @Override
    public void prepareVdForStore(int n) {
        this.prepareVdForStore(this.getVsize(), n);
    }

    @Override
    public void prepareVdForStore(int vsize, int n) {
        this.prepareVdForStore(vsize, this.getVdRegisterIndex(), n);
    }

    @Override
    public void prepareVdForStore(int vsize, int vd, int n) {
        if (!this.pfxVdOverlap || n >= vsize - 1) {
            this.prepareVRegisterForStore(vsize, vd, n, this.vfpuPfxdState, true);
        }
    }

    @Override
    public void prepareVdForStoreInt(int n) {
        this.prepareVdForStoreInt(this.getVsize(), n);
    }

    @Override
    public void prepareVdForStoreInt(int vsize, int n) {
        this.prepareVdForStoreInt(vsize, this.getVdRegisterIndex(), n);
    }

    @Override
    public void prepareVdForStoreInt(int vsize, int vd, int n) {
        if (!this.pfxVdOverlap || n >= vsize - 1) {
            this.prepareVRegisterForStore(vsize, vd, n, this.vfpuPfxdState, false);
        }
    }

    @Override
    public void prepareVtForStore(int n) {
        this.prepareVRegisterForStore(this.getVsize(), this.getVtRegisterIndex(), n, null, true);
    }

    @Override
    public void prepareVtForStore(int vsize, int n) {
        this.prepareVRegisterForStore(vsize, this.getVtRegisterIndex(), n, null, true);
    }

    @Override
    public void prepareVtForStoreInt(int n) {
        this.prepareVRegisterForStore(this.getVsize(), this.getVtRegisterIndex(), n, null, false);
    }

    @Override
    public void prepareVtForStoreInt(int vsize, int n) {
        this.prepareVRegisterForStore(vsize, this.getVtRegisterIndex(), n, null, false);
    }

    @Override
    public void storeVd(int n) {
        this.storeVd(this.getVsize(), n);
    }

    @Override
    public void storeVdInt(int n) {
        this.storeVdInt(this.getVsize(), n);
    }

    @Override
    public void storeVd(int vsize, int n) {
        this.storeVd(vsize, this.getVdRegisterIndex(), n);
    }

    @Override
    public void storeVdInt(int vsize, int n) {
        this.storeVdInt(vsize, this.getVdRegisterIndex(), n);
    }

    @Override
    public void storeVd(int vsize, int vd, int n) {
        if (this.pfxVdOverlap && n < vsize - 1) {
            this.storeFTmpVd(n, true);
        } else {
            this.storeVRegister(vsize, vd, n, this.vfpuPfxdState, true);
        }
    }

    @Override
    public void storeVdInt(int vsize, int vd, int n) {
        if (this.pfxVdOverlap && n < vsize - 1) {
            this.storeFTmpVd(n, false);
        } else {
            this.storeVRegister(vsize, vd, n, this.vfpuPfxdState, false);
        }
    }

    @Override
    public void storeVt(int n) {
        this.storeVRegister(this.getVsize(), this.getVtRegisterIndex(), n, null, true);
    }

    @Override
    public void storeVtInt(int n) {
        this.storeVRegister(this.getVsize(), this.getVtRegisterIndex(), n, null, false);
    }

    @Override
    public void storeVt(int vsize, int n) {
        this.storeVRegister(vsize, this.getVtRegisterIndex(), n, null, true);
    }

    @Override
    public void storeVtInt(int vsize, int n) {
        this.storeVRegister(vsize, this.getVtRegisterIndex(), n, null, false);
    }

    @Override
    public void storeVt(int vsize, int vt, int n) {
        this.storeVRegister(vsize, vt, n, null, true);
    }

    @Override
    public void storeVtInt(int vsize, int vt, int n) {
        this.storeVRegister(vsize, vt, n, null, false);
    }

    @Override
    public void prepareVtForStore(int vsize, int vt, int n) {
        this.prepareVRegisterForStore(vsize, vt, n, null, true);
    }

    @Override
    public void prepareVtForStoreInt(int vsize, int vt, int n) {
        this.prepareVRegisterForStore(vsize, vt, n, null, false);
    }

    @Override
    public int getImm7() {
        return this.codeInstruction.getImm7();
    }

    @Override
    public int getImm5() {
        return this.codeInstruction.getImm5();
    }

    @Override
    public int getImm4() {
        return this.codeInstruction.getImm4();
    }

    @Override
    public int getImm3() {
        return this.codeInstruction.getImm3();
    }

    @Override
    public void loadVs(int vsize, int n) {
        this.loadVRegister(vsize, this.getVsRegisterIndex(), n, this.vfpuPfxsState, true);
    }

    @Override
    public void loadVsInt(int vsize, int n) {
        this.loadVRegister(vsize, this.getVsRegisterIndex(), n, this.vfpuPfxsState, false);
    }

    @Override
    public void loadVs(int vsize, int vs, int n) {
        this.loadVRegister(vsize, vs, n, this.vfpuPfxsState, true);
    }

    @Override
    public void loadVsInt(int vsize, int vs, int n) {
        this.loadVRegister(vsize, vs, n, this.vfpuPfxsState, false);
    }

    @Override
    public void loadTmp1() {
        this.loadLocalVar(3);
    }

    @Override
    public void loadTmp2() {
        this.loadLocalVar(4);
    }

    @Override
    public void loadLTmp1() {
        this.mv.visitVarInsn(22, 3);
    }

    @Override
    public void loadFTmp1() {
        this.mv.visitVarInsn(23, 3);
    }

    @Override
    public void loadFTmp2() {
        this.mv.visitVarInsn(23, 4);
    }

    @Override
    public void loadFTmp3() {
        this.mv.visitVarInsn(23, 5);
    }

    @Override
    public void loadFTmp4() {
        this.mv.visitVarInsn(23, 6);
    }

    private void loadFTmpVd(int n, boolean isFloat) {
        int opcode;
        int n2 = opcode = isFloat ? 23 : 21;
        if (n == 0) {
            this.mv.visitVarInsn(opcode, 7);
        } else if (n == 1) {
            this.mv.visitVarInsn(opcode, 8);
        } else {
            this.mv.visitVarInsn(opcode, 9);
        }
    }

    @Override
    public void storeTmp1() {
        this.mv.visitVarInsn(54, 3);
    }

    @Override
    public void storeTmp2() {
        this.mv.visitVarInsn(54, 4);
    }

    @Override
    public void storeLTmp1() {
        this.mv.visitVarInsn(55, 3);
    }

    @Override
    public void storeFTmp1() {
        this.mv.visitVarInsn(56, 3);
    }

    @Override
    public void storeFTmp2() {
        this.mv.visitVarInsn(56, 4);
    }

    @Override
    public void storeFTmp3() {
        this.mv.visitVarInsn(56, 5);
    }

    @Override
    public void storeFTmp4() {
        this.mv.visitVarInsn(56, 6);
    }

    private void storeFTmpVd(int n, boolean isFloat) {
        int opcode;
        int n2 = opcode = isFloat ? 56 : 54;
        if (n == 0) {
            this.mv.visitVarInsn(opcode, 7);
        } else if (n == 1) {
            this.mv.visitVarInsn(opcode, 8);
        } else {
            this.mv.visitVarInsn(opcode, 9);
        }
    }

    @Override
    public VfpuPfxDstState getPfxdState() {
        return this.vfpuPfxdState;
    }

    @Override
    public VfpuPfxSrcState getPfxsState() {
        return this.vfpuPfxsState;
    }

    @Override
    public VfpuPfxSrcState getPfxtState() {
        return this.vfpuPfxtState;
    }

    private void startPfxCompiled(VfpuPfxState vfpuPfxState, String name, String descriptor, String internalName, boolean isFloat) {
        if (vfpuPfxState.isUnknown()) {
            if (this.interpretPfxLabel == null) {
                this.interpretPfxLabel = new Label();
            }
            this.loadVcr();
            this.mv.visitFieldInsn(180, Type.getInternalName(VfpuState.Vcr.class), name, descriptor);
            this.mv.visitFieldInsn(180, internalName, "enabled", "Z");
            this.mv.visitJumpInsn(154, this.interpretPfxLabel);
        }
    }

    @Override
    public void startPfxCompiled() {
        this.startPfxCompiled(true);
    }

    @Override
    public void startPfxCompiled(boolean isFloat) {
        this.interpretPfxLabel = null;
        if (this.codeInstruction.hasFlags(256)) {
            this.startPfxCompiled(this.vfpuPfxsState, "pfxs", Type.getDescriptor(VfpuState.Vcr.PfxSrc.class), Type.getInternalName(VfpuState.Vcr.PfxSrc.class), isFloat);
        }
        if (this.codeInstruction.hasFlags(512)) {
            this.startPfxCompiled(this.vfpuPfxtState, "pfxt", Type.getDescriptor(VfpuState.Vcr.PfxSrc.class), Type.getInternalName(VfpuState.Vcr.PfxSrc.class), isFloat);
        }
        if (this.codeInstruction.hasFlags(1024)) {
            this.startPfxCompiled(this.vfpuPfxdState, "pfxd", Type.getDescriptor(VfpuState.Vcr.PfxDst.class), Type.getInternalName(VfpuState.Vcr.PfxDst.class), isFloat);
        }
        this.pfxVdOverlap = false;
        if (this.getCodeInstruction().hasFlags(1280)) {
            this.pfxVdOverlap |= this.isVsVdOverlap();
        }
        if (this.getCodeInstruction().hasFlags(1536)) {
            this.pfxVdOverlap |= this.isVtVdOverlap();
        }
    }

    @Override
    public void endPfxCompiled() {
        this.endPfxCompiled(true);
    }

    @Override
    public void endPfxCompiled(boolean isFloat) {
        this.endPfxCompiled(this.getVsize(), isFloat);
    }

    @Override
    public void endPfxCompiled(int vsize) {
        this.endPfxCompiled(vsize, true);
    }

    @Override
    public void endPfxCompiled(int vsize, boolean isFloat) {
        this.endPfxCompiled(vsize, isFloat, true);
    }

    @Override
    public void endPfxCompiled(int vsize, boolean isFloat, boolean doFlush) {
        if (doFlush) {
            this.flushPfxCompiled(vsize, this.getVdRegisterIndex(), isFloat);
        }
        if (this.interpretPfxLabel != null) {
            Label continueLabel = new Label();
            this.mv.visitJumpInsn(167, continueLabel);
            this.mv.visitLabel(this.interpretPfxLabel);
            this.compileInterpreterInstruction();
            this.mv.visitLabel(continueLabel);
            this.interpretPfxLabel = null;
        }
        this.pfxVdOverlap = false;
    }

    @Override
    public void flushPfxCompiled(int vsize, int vd, boolean isFloat) {
        if (this.pfxVdOverlap) {
            this.pfxVdOverlap = false;
            for (int n = 0; n < vsize - 1; ++n) {
                if (isFloat) {
                    this.prepareVdForStore(vsize, vd, n);
                } else {
                    this.prepareVdForStoreInt(vsize, vd, n);
                }
                this.loadFTmpVd(n, isFloat);
                if (isFloat) {
                    this.storeVd(vsize, vd, n);
                    continue;
                }
                this.storeVdInt(vsize, vd, n);
            }
            this.pfxVdOverlap = true;
        }
    }

    @Override
    public boolean isPfxConsumed(int flag) {
        CodeInstruction codeInstruction;
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("PFX -> %08X: %s", this.getCodeInstruction().getAddress(), this.getCodeInstruction().getInsn().disasm(this.getCodeInstruction().getAddress(), this.getCodeInstruction().getOpcode())));
        }
        int address = this.getCodeInstruction().getAddress();
        do {
            codeInstruction = this.getCodeBlock().getCodeInstruction(address += 4);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("PFX    %08X: %s", codeInstruction.getAddress(), codeInstruction.getInsn().disasm(codeInstruction.getAddress(), codeInstruction.getOpcode())));
            }
            if (codeInstruction != null && this.isNonBranchingCodeSequence(codeInstruction)) continue;
            return false;
        } while (!codeInstruction.hasFlags(flag));
        return codeInstruction.hasFlags(4096);
    }

    private boolean isVxVdOverlap(VfpuPfxSrcState pfxSrcState, int registerIndex) {
        if (!pfxSrcState.isKnown()) {
            return false;
        }
        int vsize = this.getVsize();
        int vd = this.getVdRegisterIndex();
        if (registerIndex != vd) {
            if (vsize != 3) {
                return false;
            }
            if ((registerIndex & 0x3F) != (vd & 0x3F)) {
                return false;
            }
        }
        if (!pfxSrcState.pfxSrc.enabled) {
            return true;
        }
        for (int n = 0; n < vsize; ++n) {
            if (pfxSrcState.pfxSrc.cst[n] || pfxSrcState.pfxSrc.swz[n] == n) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVsVdOverlap() {
        return this.isVxVdOverlap(this.vfpuPfxsState, this.getVsRegisterIndex());
    }

    @Override
    public boolean isVtVdOverlap() {
        return this.isVxVdOverlap(this.vfpuPfxtState, this.getVtRegisterIndex());
    }

    private boolean canUseVFPUInt(int vsize) {
        if (this.vfpuPfxsState.isKnown() && this.vfpuPfxsState.pfxSrc.enabled) {
            for (int i = 0; i < vsize; ++i) {
                if (this.vfpuPfxsState.pfxSrc.swz[i] == i) continue;
                return false;
            }
        }
        return !this.vfpuPfxdState.isKnown() || !this.vfpuPfxdState.pfxDst.enabled;
    }

    @Override
    public void compileVFPUInstr(Object cstBefore, int opcode, String mathFunction) {
        int vsize = this.getVsize();
        boolean useVt = this.getCodeInstruction().hasFlags(512);
        if (mathFunction == null && opcode == 0 && !useVt && cstBefore == null && this.canUseVFPUInt(vsize)) {
            this.startPfxCompiled(false);
            for (int n = 0; n < vsize; ++n) {
                this.prepareVdForStoreInt(n);
                this.loadVsInt(n);
                this.storeVdInt(n);
            }
            this.endPfxCompiled(vsize, false);
        } else {
            this.startPfxCompiled(true);
            for (int n = 0; n < vsize; ++n) {
                this.prepareVdForStore(n);
                if (cstBefore != null) {
                    this.mv.visitLdcInsn(cstBefore);
                }
                this.loadVs(n);
                if (useVt) {
                    this.loadVt(n);
                }
                if (mathFunction != null) {
                    if ("abs".equals(mathFunction)) {
                        this.mv.visitMethodInsn(184, Type.getInternalName(Math.class), mathFunction, "(F)F");
                    } else if ("max".equals(mathFunction) || "min".equals(mathFunction)) {
                        this.mv.visitMethodInsn(184, Type.getInternalName(Math.class), mathFunction, "(FF)F");
                    } else {
                        this.mv.visitInsn(141);
                        this.mv.visitMethodInsn(184, Type.getInternalName(Math.class), mathFunction, "(D)D");
                        this.mv.visitInsn(144);
                    }
                }
                Label doneStore = null;
                if (opcode != 0) {
                    Label doneOpcode = null;
                    if (opcode == 110 && cstBefore == null) {
                        doneOpcode = new Label();
                        doneStore = new Label();
                        Label notZeroByZero = new Label();
                        Label notZeroByZeroPop = new Label();
                        this.mv.visitInsn(92);
                        this.mv.visitInsn(11);
                        this.mv.visitInsn(150);
                        this.mv.visitJumpInsn(154, notZeroByZeroPop);
                        this.mv.visitInsn(11);
                        this.mv.visitInsn(150);
                        this.mv.visitJumpInsn(154, notZeroByZero);
                        this.convertVFloatToInt();
                        this.loadImm(Integer.MIN_VALUE);
                        this.mv.visitInsn(126);
                        this.mv.visitInsn(95);
                        this.convertVFloatToInt();
                        this.loadImm(Integer.MIN_VALUE);
                        this.mv.visitInsn(126);
                        this.mv.visitInsn(130);
                        this.storeTmp1();
                        this.mv.visitInsn(94);
                        this.mv.visitInsn(88);
                        this.loadPspNaNInt();
                        this.loadTmp1();
                        this.mv.visitInsn(128);
                        int preparedRegister = this.preparedRegisterForStore;
                        this.storeVdInt(n);
                        this.preparedRegisterForStore = preparedRegister;
                        this.mv.visitJumpInsn(167, doneStore);
                        this.mv.visitLabel(notZeroByZeroPop);
                        this.mv.visitInsn(87);
                        this.mv.visitLabel(notZeroByZero);
                    }
                    this.mv.visitInsn(opcode);
                    if (doneOpcode != null) {
                        this.mv.visitLabel(doneOpcode);
                    }
                }
                this.storeVd(n);
                if (doneStore == null) continue;
                this.mv.visitLabel(doneStore);
            }
            this.endPfxCompiled(vsize, true);
        }
    }

    public void visitHook(NativeCodeSequence nativeCodeSequence) {
        this.mv.visitMethodInsn(184, Type.getInternalName(nativeCodeSequence.getNativeCodeSequenceClass()), nativeCodeSequence.getMethodName(), "()V");
    }

    @Override
    public boolean compileVFPULoad(int registerIndex, int offset, int vt, int count) {
        if (RuntimeContext.memoryInt == null) {
            return false;
        }
        if ((vt & 0x20) != 0) {
            return false;
        }
        this.loadMemoryInt();
        this.loadRegister(registerIndex);
        if (offset != 0) {
            this.loadImm(offset);
            this.mv.visitInsn(96);
        }
        if (this.checkMemoryAccess()) {
            this.loadImm(this.getCodeInstruction().getAddress());
            this.mv.visitMethodInsn(184, Type.getInternalName(RuntimeContext.class), "checkMemoryRead32", "(II)I");
            this.loadImm(2);
            this.mv.visitInsn(124);
        } else {
            this.loadImm(2);
            this.mv.visitInsn(120);
            this.loadImm(4);
            this.mv.visitInsn(124);
        }
        this.loadVprInt();
        int vprIndex = VfpuState.getVprIndex(vt >> 2 & 7, vt & 3, (vt & 0x40) >> 6);
        this.loadImm(vprIndex);
        this.loadImm(count);
        this.mv.visitMethodInsn(184, Type.getInternalName(System.class), "arraycopy", arraycopyDescriptor);
        for (int i = 0; i < count; ++i) {
            this.loadVprFloat();
            this.loadImm(vprIndex + i);
            this.loadVprInt();
            this.loadImm(vprIndex + i);
            this.mv.visitInsn(46);
            this.convertVIntToFloat();
            this.mv.visitInsn(81);
        }
        return true;
    }

    @Override
    public boolean compileVFPUStore(int registerIndex, int offset, int vt, int count) {
        if (RuntimeContext.memoryInt == null) {
            return false;
        }
        if ((vt & 0x20) != 0) {
            return false;
        }
        this.loadVprInt();
        int vprIndex = VfpuState.getVprIndex(vt >> 2 & 7, vt & 3, (vt & 0x40) >> 6);
        this.loadImm(vprIndex);
        this.loadMemoryInt();
        this.loadRegister(registerIndex);
        if (offset != 0) {
            this.loadImm(offset);
            this.mv.visitInsn(96);
        }
        if (this.checkMemoryAccess()) {
            this.loadImm(this.getCodeInstruction().getAddress());
            this.mv.visitMethodInsn(184, Type.getInternalName(RuntimeContext.class), "checkMemoryWrite32", "(II)I");
            this.loadImm(2);
            this.mv.visitInsn(124);
        } else {
            this.loadImm(2);
            this.mv.visitInsn(120);
            this.loadImm(4);
            this.mv.visitInsn(124);
        }
        this.loadImm(count);
        this.mv.visitMethodInsn(184, Type.getInternalName(System.class), "arraycopy", arraycopyDescriptor);
        return true;
    }

    public void optimizeSequence(List<CodeInstruction> codeInstructions) {
        CodeInstruction codeInstruction;
        if (RuntimeContext.memoryInt == null) {
            return;
        }
        if (Profiler.isProfilerEnabled()) {
            return;
        }
        if (State.debugger != null) {
            return;
        }
        int decreaseSpInstruction = -1;
        int stackSize = 0;
        int currentInstructionIndex = 0;
        int maxSpOffset = Integer.MAX_VALUE;
        int swSequenceCount = 0;
        int[] storeSpInstructions = null;
        int[] storeSpRegisters = null;
        LinkedList<CodeInstruction> storeSpCodeInstructions = null;
        boolean[] modifiedRegisters = new boolean[32];
        Arrays.fill(modifiedRegisters, false);
        Iterator<CodeInstruction> i$ = codeInstructions.iterator();
        while (!(!i$.hasNext() || (codeInstruction = i$.next()).isBranching() || codeInstruction.hasFlags(4) || codeInstruction.isBranchTarget() && this.codeBlock.getStartAddress() != codeInstruction.getAddress())) {
            int simm16;
            int rt;
            int rs;
            Common.Instruction insn = codeInstruction.getInsn();
            if (decreaseSpInstruction >= 0 && insn == Instructions.SW) {
                rs = codeInstruction.getRsRegisterIndex();
                rt = codeInstruction.getRtRegisterIndex();
                if (rs == 29) {
                    simm16 = codeInstruction.getImm16(true);
                    if (!modifiedRegisters[rt]) {
                        int index;
                        if (simm16 >= 0 && simm16 < stackSize && (simm16 & 3) == 0 && simm16 < maxSpOffset && storeSpInstructions[index = simm16 >> 2] < 0) {
                            storeSpCodeInstructions.add(codeInstruction);
                            storeSpInstructions[index] = currentInstructionIndex;
                            storeSpRegisters[index] = rt;
                            ++swSequenceCount;
                        }
                    } else {
                        maxSpOffset = Math.min(maxSpOffset, simm16);
                    }
                }
            }
            if (insn == Instructions.ADDI || insn == Instructions.ADDIU) {
                rs = codeInstruction.getRsRegisterIndex();
                rt = codeInstruction.getRtRegisterIndex();
                simm16 = codeInstruction.getImm16(true);
                if (rt == 29 && rs == 29 && simm16 < 0) {
                    decreaseSpInstruction = currentInstructionIndex;
                    stackSize = -codeInstruction.getImm16(true);
                    storeSpInstructions = new int[stackSize >> 2];
                    Arrays.fill(storeSpInstructions, -1);
                    storeSpRegisters = new int[storeSpInstructions.length];
                    Arrays.fill(storeSpRegisters, -1);
                    storeSpCodeInstructions = new LinkedList<CodeInstruction>();
                } else if (rs == 29 && simm16 >= 0) {
                    maxSpOffset = Math.min(maxSpOffset, simm16);
                }
            } else if (insn == Instructions.ADD || insn == Instructions.ADDU) {
                rs = codeInstruction.getRsRegisterIndex();
                rt = codeInstruction.getRtRegisterIndex();
                if (rs == 29 || rt == 29) {
                    break;
                }
            } else if (insn == Instructions.LW || insn == Instructions.SWC1 || insn == Instructions.LWC1) {
                rs = codeInstruction.getRsRegisterIndex();
                int simm162 = codeInstruction.getImm16(true);
                if (rs == 29 && simm162 >= 0) {
                    maxSpOffset = Math.min(maxSpOffset, simm162);
                }
            } else if (insn == Instructions.SVQ || insn == Instructions.LVQ) {
                rs = codeInstruction.getRsRegisterIndex();
                int simm14 = codeInstruction.getImm14(true);
                if (rs == 29 && simm14 >= 0) {
                    maxSpOffset = Math.min(maxSpOffset, simm14);
                }
            }
            if (codeInstruction.hasFlags(8192)) {
                modifiedRegisters[codeInstruction.getRtRegisterIndex()] = true;
            }
            if (codeInstruction.hasFlags(16384)) {
                modifiedRegisters[codeInstruction.getRdRegisterIndex()] = true;
            }
            if (maxSpOffset <= 0) break;
            ++currentInstructionIndex;
        }
        if (swSequenceCount > 1) {
            int[] offsets = new int[swSequenceCount];
            int[] registers = new int[swSequenceCount];
            int index = 0;
            for (int i = 0; i < storeSpInstructions.length && index < swSequenceCount; ++i) {
                if (storeSpInstructions[i] < 0) continue;
                offsets[index] = i << 2;
                registers[index] = storeSpRegisters[i];
                ++index;
            }
            codeInstructions.removeAll(storeSpCodeInstructions);
            SequenceSWCodeInstruction sequenceSWCodeInstruction = new SequenceSWCodeInstruction(29, offsets, registers);
            sequenceSWCodeInstruction.setAddress(((CodeInstruction)storeSpCodeInstructions.get(0)).getAddress());
            codeInstructions.add(decreaseSpInstruction + 1, sequenceSWCodeInstruction);
        }
    }

    private boolean compileSWsequenceZR(int baseRegister, int[] offsets, int[] registers) {
        int copyLength;
        int i;
        for (i = 0; i < registers.length; ++i) {
            if (registers[i] == 0) continue;
            return false;
        }
        for (i = 1; i < offsets.length; ++i) {
            if (offsets[i] == offsets[i - 1] + 4) continue;
            return false;
        }
        int offset = offsets[0];
        int length = offsets.length;
        do {
            copyLength = Math.min(length, FastMemory.zero.length);
            this.mv.visitFieldInsn(178, Type.getInternalName(FastMemory.class), "zero", "[I");
            this.loadImm(0);
            this.loadMemoryInt();
            this.prepareMemIndex(baseRegister, offset, false, 32);
            this.loadImm(copyLength);
            this.mv.visitMethodInsn(184, Type.getInternalName(System.class), "arraycopy", arraycopyDescriptor);
            offset += copyLength;
        } while ((length -= copyLength) > 0);
        return true;
    }

    private boolean compileSWLWsequence(int baseRegister, int[] offsets, int[] registers, boolean isLW) {
        if (RuntimeContext.memoryInt == null) {
            return false;
        }
        if (Profiler.isProfilerEnabled()) {
            return false;
        }
        if (State.debugger != null) {
            return false;
        }
        if (!isLW && this.compileSWsequenceZR(baseRegister, offsets, registers)) {
            return true;
        }
        int offset = offsets[0];
        this.prepareMemIndex(baseRegister, offset, isLW, 32);
        this.storeTmp1();
        for (int i = 0; i < offsets.length; ++i) {
            int rt = registers[i];
            if (offset != offsets[i]) {
                this.mv.visitIincInsn(3, offsets[i] - offset >> 2);
                offset = offsets[i];
            }
            if (isLW) {
                if (rt == 0) continue;
                this.prepareRegisterForStore(rt);
                this.loadMemoryInt();
                this.loadTmp1();
                this.mv.visitInsn(46);
                this.storeRegister(rt);
                continue;
            }
            this.loadMemoryInt();
            this.loadTmp1();
            this.loadRegister(rt);
            this.mv.visitInsn(79);
        }
        return true;
    }

    @Override
    public boolean compileSWsequence(int baseRegister, int[] offsets, int[] registers) {
        return this.compileSWLWsequence(baseRegister, offsets, registers, false);
    }

    @Override
    public boolean compileLWsequence(int baseRegister, int[] offsets, int[] registers) {
        return this.compileSWLWsequence(baseRegister, offsets, registers, true);
    }
}

