/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Debugger.DisassemblerModule;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class RegisterTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private static final Font tableFont = new Font("Courier new", 0, 12);
    private HashMap<String, Color> highlights;

    public RegisterTable(String[] regnames) {
        this.setFont(tableFont);
        this.setDefaultRenderer(String.class, new RegisterNameRenderer());
        this.setDefaultRenderer(Register.class, new RegisterValueRenderer());
        this.setDefaultEditor(Register.class, new RegisterValueEditor());
        this.setSelectionMode(0);
        this.setRegisters(regnames);
    }

    public RegisterTable() {
        this.setFont(tableFont);
        this.setDefaultRenderer(String.class, new RegisterNameRenderer());
        this.setDefaultRenderer(Register.class, new RegisterValueRenderer());
        this.setDefaultEditor(Register.class, new RegisterValueEditor());
        this.setSelectionMode(0);
    }

    public final void setRegisters(String[] regnames) {
        this.setModel(new RegisterTableModel(regnames));
    }

    public void highlightRegister(String regname, Color color) {
        if (regname.startsWith("$")) {
            regname = regname.substring(1);
        }
        this.highlights.put(regname.toLowerCase(), color);
        this.repaint();
    }

    public void clearRegisterHighlights() {
        this.highlights.clear();
        this.repaint();
    }

    @Override
    public void setModel(TableModel dataModel) {
        if (dataModel != null) {
            super.setModel(dataModel);
        }
    }

    public void resetChanges() {
        ((RegisterTableModel)this.getModel()).resetChanges();
    }

    public int getAddressAt(int rowIndex) {
        return ((Register)((RegisterTableModel)this.getModel()).getValueAt((int)rowIndex, (int)1)).value;
    }

    private class RegisterTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private List<Register> reginfo = new LinkedList<Register>();

        public RegisterTableModel(String[] regnames) {
            for (int i = 0; i < regnames.length; ++i) {
                this.reginfo.add(new Register(regnames[i]));
            }
        }

        public void resetChanges() {
            Iterator<Register> it = this.reginfo.iterator();
            while (it.hasNext()) {
                it.next().changed = false;
            }
            this.fireTableDataChanged();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Register.class;
                }
            }
            throw new IndexOutOfBoundsException("column index out of range");
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "REG";
                }
                case 1: {
                    return "HEX";
                }
            }
            throw new IndexOutOfBoundsException("column index out of range");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.reginfo.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.reginfo.get((int)rowIndex).name;
                }
                case 1: {
                    return this.reginfo.get(rowIndex);
                }
            }
            throw new IndexOutOfBoundsException("column index out of range");
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            int value;
            if (aValue instanceof Integer) {
                value = (Integer)aValue;
            } else if (aValue instanceof String) {
                try {
                    value = Integer.decode((String)aValue);
                }
                catch (NumberFormatException nfe) {
                    return;
                }
            } else {
                throw new IllegalArgumentException("setValueAt() will only handle Integer and String objects");
            }
            boolean bl = this.reginfo.get((int)rowIndex).changed = value != this.reginfo.get((int)rowIndex).value;
            if (this.reginfo.get((int)rowIndex).changed) {
                this.reginfo.get((int)rowIndex).value = value;
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }
    }

    private class RegisterValueRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public RegisterValueRenderer() {
            this.setFont(tableFont);
            this.setBackground(RegisterTable.this.selectionBackground);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            Register reg = (Register)table.getModel().getValueAt(row, column);
            this.setText(String.format("0x%08X", reg.value));
            if (reg.changed) {
                this.setForeground(Color.RED);
                this.setFont(this.getFont().deriveFont(1));
            } else {
                this.setForeground(Color.BLACK);
                this.setFont(this.getFont().deriveFont(0));
            }
            this.setOpaque(isSelected);
            return this;
        }
    }

    class RegisterValueEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public RegisterValueEditor() {
            super(new JTextField());
            JTextField tf = (JTextField)this.getComponent();
            tf.setFont(tableFont);
        }

        @Override
        public Object getCellEditorValue() {
            return ((JTextField)this.getComponent()).getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            final JTextField tf = (JTextField)this.getComponent();
            tf.setText(String.format("0x%X", ((Register)table.getModel().getValueAt((int)row, (int)column)).value));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    tf.select(2, tf.getText().length());
                }
            });
            return tf;
        }
    }

    private class RegisterNameRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public RegisterNameRenderer() {
            this.setFont(tableFont);
            this.setBackground(RegisterTable.this.selectionBackground);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String reg = (String)table.getModel().getValueAt(row, column);
            this.setText(reg);
            reg = reg.toLowerCase();
            if (RegisterTable.this.highlights.containsKey(reg)) {
                if (isSelected) {
                    this.setBackground(((Color)RegisterTable.this.highlights.get(reg)).darker());
                } else {
                    this.setBackground((Color)RegisterTable.this.highlights.get(reg));
                }
                this.setOpaque(true);
            } else {
                this.setBackground(RegisterTable.this.selectionBackground);
                this.setOpaque(isSelected);
            }
            return this;
        }
    }

    private class Register {
        public String name;
        public int value;
        public boolean changed;

        public Register(String name) {
            this.name = name;
            this.value = 0;
            this.changed = false;
            RegisterTable.this.highlights = new HashMap();
        }

        public String toString() {
            return String.format("0x%08X", this.value);
        }
    }
}

