/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Debugger.FileLogger;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import jpcsp.Debugger.FileLogger.FileHandleInfo;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.modules150.IoFileMgrForUser;
import jpcsp.State;
import jpcsp.WindowPropSaver;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.settings.Settings;
import jpcsp.util.Constants;

public class FileLoggerFrame
extends JFrame
implements Runnable,
IoFileMgrForUser.IIoListener {
    private static final long serialVersionUID = 8455039521164613143L;
    private FileHandleModel fileHandleModel = new FileHandleModel();
    private FileCommandModel fileCommandModel = new FileCommandModel();
    private Thread refreshThread;
    private volatile boolean dirty;
    private volatile boolean sortRequired;
    private HashMap<Integer, FileHandleInfo> fileHandleIdMap;
    private List<FileHandleInfo> fileHandleList;
    private List<FileCommandInfo> fileCommandList;
    private FileCommandInfo lastFileCommand;
    private JCheckBox cbFileTrace;
    private JTable commandLogTable;
    private JMenuItem copyItem;
    private JTable fileHandleTable;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JMenuItem saveAsItem;

    public FileLoggerFrame() {
        this.initComponents();
        this.postInit();
        this.refreshThread = new Thread((Runnable)this, "FileLogger");
        this.refreshThread.start();
        if (Settings.getInstance().readBool("emu.debug.enablefilelogger")) {
            this.cbFileTrace.setSelected(true);
            Modules.IoFileMgrForUserModule.registerIoListener(this);
        }
        WindowPropSaver.loadWindowProperties(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        FileLoggerFrame fileLoggerFrame = this.getInstance();
        synchronized (fileLoggerFrame) {
            if (!this.dirty) {
                this.dirty = true;
                this.getInstance().notify();
            }
        }
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.copyItem = new JMenuItem();
        this.saveAsItem = new JMenuItem();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.commandLogTable = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.fileHandleTable = new JTable();
        this.cbFileTrace = new JCheckBox();
        this.copyItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
        this.copyItem.setText(bundle.getString("FileLoggerFrame.copyItem.text"));
        this.copyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileLoggerFrame.this.copyItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.copyItem);
        this.saveAsItem.setText(bundle.getString("FileLoggerFrame.saveAsItem.text"));
        this.saveAsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileLoggerFrame.this.saveAsItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.saveAsItem);
        this.setDefaultCloseOperation(2);
        this.setTitle(bundle.getString("FileLoggerFrame.title"));
        this.setMinimumSize(new Dimension(400, 200));
        this.jSplitPane1.setDividerLocation(100);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setMinimumSize(new Dimension(179, 100));
        this.commandLogTable.setModel(this.fileCommandModel);
        this.commandLogTable.setInheritsPopupMenu(true);
        this.commandLogTable.setMinimumSize(new Dimension(200, 100));
        this.commandLogTable.setName(bundle.getString("FileLoggerFrame.commandLogTable.name"));
        this.commandLogTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                FileLoggerFrame.this.tableMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                FileLoggerFrame.this.tableMouseReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.commandLogTable);
        this.jSplitPane1.setBottomComponent(this.jScrollPane1);
        this.fileHandleTable.setModel(this.fileHandleModel);
        this.fileHandleTable.setInheritsPopupMenu(true);
        this.fileHandleTable.setMinimumSize(new Dimension(200, 100));
        this.fileHandleTable.setName(bundle.getString("FileLoggerFrame.fileHandleTable.name"));
        this.fileHandleTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                FileLoggerFrame.this.tableMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                FileLoggerFrame.this.tableMouseReleased(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.fileHandleTable);
        this.jSplitPane1.setTopComponent(this.jScrollPane2);
        this.cbFileTrace.setText(bundle.getString("FileLoggerFrame.cbFileTrace.text"));
        this.cbFileTrace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileLoggerFrame.this.cbFileTraceActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cbFileTrace).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jSplitPane1, -1, 628, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.cbFileTrace).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 257, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void tableMousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void tableMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void copyItemActionPerformed(ActionEvent evt) {
        JTable source = (JTable)((JPopupMenu)((JMenuItem)evt.getSource()).getParent()).getInvoker();
        ActionEvent ae = new ActionEvent(source, 1001, "");
        source.getActionMap().get("copy").actionPerformed(ae);
    }

    private void saveAsItemActionPerformed(ActionEvent evt) {
        ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(bundle.getString("FileLoggerFrame.strSaveTable.text"));
        fc.setSelectedFile(new File(State.discId + "_fileio.txt"));
        fc.setCurrentDirectory(new File("."));
        fc.addChoosableFileFilter(Constants.fltTextFiles);
        fc.setFileFilter(Constants.fltTextFiles);
        if (fc.showSaveDialog(this) == 0) {
            int rc;
            File f = fc.getSelectedFile();
            if (f.exists() && (rc = JOptionPane.showConfirmDialog(this, bundle.getString("ConsoleWindow.strFileExists.text"), bundle.getString("ConsoleWindow.strFileExistsTitle.text"), 0, 2)) != 0) {
                return;
            }
            try {
                JTable source = (JTable)((JPopupMenu)((JMenuItem)evt.getSource()).getParent()).getInvoker();
                String data = "";
                for (int j = 0; j < source.getColumnCount(); ++j) {
                    data = data + source.getColumnName(j) + ";";
                }
                data = data.substring(0, data.length() - 1) + System.getProperty("line.separator");
                for (int i = 0; i < source.getRowCount(); ++i) {
                    for (int j = 0; j < source.getColumnCount(); ++j) {
                        data = data + source.getModel().getValueAt(i, j) + ";";
                    }
                    data = data.substring(0, data.length() - 1) + System.getProperty("line.separator");
                }
                FileWriter os = new FileWriter(f);
                os.write(data);
                os.close();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, bundle.getString("FileLoggerFrame.strSaveFailed.text") + ioe.getLocalizedMessage());
            }
        }
    }

    private FileLoggerFrame getInstance() {
        return this;
    }

    private void cbFileTraceActionPerformed(ActionEvent evt) {
        if (this.cbFileTrace.isSelected()) {
            Modules.IoFileMgrForUserModule.registerIoListener(this);
            Settings.getInstance().writeBool("emu.debug.enablefilelogger", true);
        } else {
            Modules.IoFileMgrForUserModule.unregisterIoListener(this);
            Settings.getInstance().writeBool("emu.debug.enablefilelogger", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Runnable refresher = new Runnable(){

            @Override
            public void run() {
                if (FileLoggerFrame.this.sortRequired) {
                    FileLoggerFrame.this.sortRequired = false;
                    FileLoggerFrame.this.sortLists();
                }
                int max = FileLoggerFrame.this.jScrollPane1.getVerticalScrollBar().getMaximum();
                FileLoggerFrame.this.jScrollPane1.getVerticalScrollBar().setValue(max);
                max = FileLoggerFrame.this.jScrollPane2.getVerticalScrollBar().getMaximum();
                FileLoggerFrame.this.jScrollPane2.getVerticalScrollBar().setValue(max);
                FileLoggerFrame.this.fileHandleModel.fireTableDataChanged();
                FileLoggerFrame.this.fileCommandModel.fireTableDataChanged();
            }
        };
        while (true) {
            try {
                while (true) {
                    FileLoggerFrame fileLoggerFrame = this;
                    synchronized (fileLoggerFrame) {
                        while (!this.dirty) {
                            this.wait();
                        }
                        this.dirty = false;
                    }
                    if (this.getInstance().isVisible()) {
                        SwingUtilities.invokeAndWait(refresher);
                    }
                    Thread.sleep(200L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public final void postInit() {
        TableColumnModel columns = this.fileHandleTable.getColumnModel();
        columns.getColumn(0).setPreferredWidth(75);
        columns.getColumn(1).setPreferredWidth(500);
        columns.getColumn(2).setPreferredWidth(75);
        columns.getColumn(3).setPreferredWidth(75);
        this.fileHandleTable.setDefaultRenderer(Object.class, new FileHandleRenderer());
        columns = this.commandLogTable.getColumnModel();
        columns.getColumn(0).setPreferredWidth(75);
        columns.getColumn(1).setPreferredWidth(90);
        columns.getColumn(2).setPreferredWidth(50);
        columns.getColumn(4).setPreferredWidth(75);
        columns.getColumn(5).setPreferredWidth(275);
        this.resetLogging();
    }

    public void test() {
        System.err.println("test start");
        this.resetLogging();
        this.sceIoOpen(1, 0x8800000, "test1.txt", 255, 255, "rw");
        this.sceIoOpen(2, 0x8800000, "test2.txt", 255, 255, "rw");
        this.sceIoOpen(3, 0x8800000, System.currentTimeMillis() + ".txt", 255, 255, "rw");
        this.sceIoClose(0, 1);
        this.sceIoClose(0, 2);
        this.sceIoOpen(1, 0x8800000, "test1.txt", 255, 255, "rw");
        this.sceIoRead(0, 1, 0x8800000, 1024, 0, 0L, null, null);
        System.err.println("test done");
    }

    public synchronized void resetLogging() {
        this.fileHandleIdMap = new HashMap();
        this.fileHandleList = new LinkedList<FileHandleInfo>();
        this.fileCommandList = new LinkedList<FileCommandInfo>();
        if (!this.dirty) {
            this.dirty = true;
            this.getInstance().notify();
        }
    }

    private void sortLists() {
        Collection<FileHandleInfo> c = this.fileHandleIdMap.values();
        this.fileHandleList = new LinkedList<FileHandleInfo>(c);
        Collections.sort(this.fileHandleList);
    }

    private void logFileCommand(FileCommandInfo info) {
        if (this.lastFileCommand != null && info.equals(this.lastFileCommand)) {
            ++this.lastFileCommand.occurences;
        } else {
            this.fileCommandList.add(info);
            this.lastFileCommand = info;
        }
    }

    @Override
    public void sceIoSync(int result, int device_addr, String device, int unknown) {
        this.logFileCommand(new FileCommandInfo("sync", result, String.format("device=0x%08X('%s') unknown=0x%08X", device_addr, device, unknown)));
    }

    @Override
    public void sceIoPollAsync(int result, int uid, int res_addr) {
        this.logFileCommand(new FileCommandInfo(uid, "poll async", result, String.format("result=0x%08X", res_addr)));
    }

    @Override
    public void sceIoWaitAsync(int result, int uid, int res_addr) {
        this.logFileCommand(new FileCommandInfo(uid, "wait async", result, String.format("result=0x%08X", res_addr)));
    }

    @Override
    public void sceIoOpen(int result, int filename_addr, String filename, int flags, int permissions, String mode) {
        UmdIsoReader iso;
        if (result >= 0) {
            FileHandleInfo info = new FileHandleInfo(result, filename);
            this.fileHandleIdMap.put(result, info);
            this.sortRequired = true;
        }
        String filelog = String.format("path=0x%08X('%s')", filename_addr, filename);
        if (filename.startsWith("disc0:/sce_lbn") && (iso = Modules.IoFileMgrForUserModule.getIsoReader()) != null) {
            int sep;
            String filePath = filename;
            int fileStart = Integer.decode((filePath = filePath.substring(14)).substring(0, sep = filePath.indexOf("_size")));
            String resolved = iso.getFileName(fileStart);
            if (resolved != null) {
                filelog = String.format("path=0x%08X('%s', '%s')", filename_addr, filename, resolved);
            }
        }
        filelog = filelog + String.format(" flags=0x%04X, permissions=0x%04X(%s)", flags, permissions, mode);
        this.logFileCommand(new FileCommandInfo("open", result, filelog));
    }

    @Override
    public void sceIoClose(int result, int uid) {
        FileHandleInfo info;
        if (result >= 0 && (info = this.fileHandleIdMap.get(uid)) != null) {
            info.isOpen(false);
        }
        this.logFileCommand(new FileCommandInfo(uid, "close", result, ""));
    }

    @Override
    public void sceIoWrite(int result, int uid, int data_addr, int size, int bytesWritten) {
        FileHandleInfo info = this.fileHandleIdMap.get(uid);
        if (result >= 0 && info != null) {
            info.bytesWritten += bytesWritten;
        }
        this.logFileCommand(new FileCommandInfo(uid, "write", result, String.format("data=0x%08X size=0x%08X", data_addr, size)));
    }

    @Override
    public void sceIoRead(int result, int uid, int data_addr, int size, int bytesRead, long position, SeekableDataInput dataInput, IVirtualFile vFile) {
        FileHandleInfo info = this.fileHandleIdMap.get(uid);
        if (result >= 0 && info != null) {
            info.bytesRead += bytesRead;
        }
        this.logFileCommand(new FileCommandInfo(uid, "read", result, String.format("data=0x%08X size=0x%08X", data_addr, size)));
    }

    @Override
    public void sceIoCancel(int result, int uid) {
        this.logFileCommand(new FileCommandInfo(uid, "cancel", result, ""));
    }

    private String getWhenceName(int whence) {
        switch (whence) {
            case 0: {
                return whence + "(set)";
            }
            case 1: {
                return whence + "(cur)";
            }
            case 2: {
                return whence + "(end)";
            }
        }
        return "" + whence;
    }

    @Override
    public void sceIoSeek32(int result, int uid, int offset, int whence) {
        this.logFileCommand(new FileCommandInfo(uid, "seek32", result, String.format("offset=0x%08X whence=%s", offset, this.getWhenceName(whence))));
    }

    @Override
    public void sceIoSeek64(long result, int uid, long offset, int whence) {
        this.logFileCommand(new FileCommandInfo(uid, "seek64", (int)result, String.format("offset=0x%08X whence=%s", offset, this.getWhenceName(whence))));
    }

    @Override
    public void sceIoMkdir(int result, int path_addr, String path, int permissions) {
        this.logFileCommand(new FileCommandInfo("mkdir", result, String.format("path=0x%08X('%s') permissions=%04X", path_addr, path, permissions)));
    }

    @Override
    public void sceIoRmdir(int result, int path_addr, String path) {
        this.logFileCommand(new FileCommandInfo("rmdir", result, String.format("path=0x%08X('%s')", path_addr, path)));
    }

    @Override
    public void sceIoChdir(int result, int path_addr, String path) {
        this.logFileCommand(new FileCommandInfo("chdir", result, String.format("path=0x%08X('%s')", path_addr, path)));
    }

    @Override
    public void sceIoDopen(int result, int path_addr, String path) {
        this.logFileCommand(new FileCommandInfo("dopen", result, String.format("path=0x%08X('%s')", path_addr, path)));
    }

    @Override
    public void sceIoDread(int result, int uid, int dirent_addr) {
        this.logFileCommand(new FileCommandInfo(uid, "dread", result, String.format("dirent=0x%08X", dirent_addr)));
    }

    @Override
    public void sceIoDclose(int result, int uid) {
        this.logFileCommand(new FileCommandInfo(uid, "dclose", result, ""));
    }

    @Override
    public void sceIoDevctl(int result, int device_addr, String device, int cmd, int indata_addr, int inlen, int outdata_addr, int outlen) {
        this.logFileCommand(new FileCommandInfo("devctl", result, String.format("device=0x%08X('%s') cmd=0x%08X indata=0x%08X inlen=0x%08X outdata=0x%08X outlen=0x%08X", device_addr, device, cmd, indata_addr, inlen, outdata_addr, outlen)));
    }

    @Override
    public void sceIoIoctl(int result, int uid, int cmd, int indata_addr, int inlen, int outdata_addr, int outlen) {
        this.logFileCommand(new FileCommandInfo(uid, "ioctl", result, String.format("cmd=0x%08X indata=0x%08X inlen=0x%08X outdata=0x%08X outlen=0x%08X", cmd, indata_addr, inlen, outdata_addr, outlen)));
    }

    @Override
    public void sceIoAssign(int result, int dev1_addr, String dev1, int dev2_addr, String dev2, int dev3_addr, String dev3, int mode, int unk1, int unk2) {
        this.logFileCommand(new FileCommandInfo("assign", result, String.format("dev1=0x%08X('%s') dev2=0x%08X('%s') dev3=0x%08X('%s') mode=0x%08X unk1=0x%08X unk2=0x%08X", dev1_addr, dev1, dev2_addr, dev2, dev3_addr, dev3, mode, unk1, unk2)));
    }

    @Override
    public void sceIoGetStat(int result, int path_addr, String path, int stat_addr) {
        this.logFileCommand(new FileCommandInfo("stat", result, String.format("path=0x%08X('%s') stat=0x%08X", path_addr, path, stat_addr)));
    }

    @Override
    public void sceIoRemove(int result, int path_addr, String path) {
        this.logFileCommand(new FileCommandInfo("remove", result, String.format("path=0x%08X('%s')", path_addr, path)));
    }

    @Override
    public void sceIoChstat(int result, int path_addr, String path, int stat_addr, int bits) {
        this.logFileCommand(new FileCommandInfo("chstat", result, String.format("path=0x%08X('%s') stat=0x%08X bits=0x%08X", path_addr, path, stat_addr, bits)));
    }

    @Override
    public void sceIoRename(int result, int path_addr, String path, int new_path_addr, String newpath) {
        this.logFileCommand(new FileCommandInfo("rename", result, String.format("path=0x%08X('%s') newpath=0x%08X('%s')", path_addr, path, new_path_addr, newpath)));
    }

    @Override
    public void dispose() {
        Emulator.getMainGUI().endWindowDialog();
        super.dispose();
    }

    private class FileCommandInfo {
        public final boolean hasFd;
        public final int threadId;
        public final String threadName;
        public final int fd;
        public final String command;
        public final int result;
        public final String parameters;
        public int occurences;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FileCommandInfo(boolean hasFd, int fd, String command, int result, String parameters) {
            this.hasFd = hasFd;
            this.threadId = Modules.ThreadManForUserModule.getCurrentThreadID();
            this.threadName = Modules.ThreadManForUserModule.getThreadName(this.threadId);
            this.fd = fd;
            this.command = command;
            this.result = result;
            this.parameters = parameters;
            this.occurences = 1;
            FileLoggerFrame fileLoggerFrame2 = FileLoggerFrame.this.getInstance();
            synchronized (fileLoggerFrame2) {
                if (!FileLoggerFrame.this.dirty) {
                    FileLoggerFrame.this.dirty = true;
                    FileLoggerFrame.this.getInstance().notify();
                }
            }
        }

        public FileCommandInfo(int fd, String command, int result, String parameters) {
            this(true, fd, command, result, parameters);
        }

        public FileCommandInfo(String command, int result, String parameters) {
            this(false, -2, command, result, parameters);
        }

        public boolean equals(Object _obj) {
            if (_obj instanceof FileCommandInfo) {
                FileCommandInfo obj = (FileCommandInfo)_obj;
                return this.threadId == obj.threadId && this.fd == obj.fd && this.command.equals(obj.command) && this.result == obj.result && this.parameters.equals(obj.parameters);
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 43 * hash + this.threadId;
            hash = 43 * hash + this.fd;
            hash = 43 * hash + (this.command != null ? this.command.hashCode() : 0);
            hash = 43 * hash + this.result;
            hash = 43 * hash + (this.parameters != null ? this.parameters.hashCode() : 0);
            return hash;
        }
    }

    private class FileCommandModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -5088674695489235024L;

        private FileCommandModel() {
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public int getRowCount() {
            if (FileLoggerFrame.this.fileCommandList != null) {
                return FileLoggerFrame.this.fileCommandList.size();
            }
            return 0;
        }

        @Override
        public String getColumnName(int columnIndex) {
            ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
            switch (columnIndex) {
                case 0: {
                    return bundle.getString("FileLoggerFrame.strThreadID.text");
                }
                case 1: {
                    return bundle.getString("FileLoggerFrame.strThreadName.text");
                }
                case 2: {
                    return bundle.getString("FileLoggerFrame.strFileID.text");
                }
                case 3: {
                    return bundle.getString("FileLoggerFrame.strCommand.text");
                }
                case 4: {
                    return bundle.getString("FileLoggerFrame.strResult.text");
                }
                case 5: {
                    return bundle.getString("FileLoggerFrame.strParameters.text");
                }
            }
            throw new IllegalArgumentException("invalid column index");
        }

        @Override
        public Object getValueAt(int row, int col) {
            FileCommandInfo info = (FileCommandInfo)FileLoggerFrame.this.fileCommandList.get(row);
            if (info != null) {
                switch (col) {
                    case 0: {
                        return String.format("0x%08X", info.threadId);
                    }
                    case 1: {
                        return info.threadName;
                    }
                    case 2: {
                        return info.hasFd ? String.format("0x%04X", info.fd) : "";
                    }
                    case 3: {
                        return info.occurences == 1 ? info.command : info.command + " " + info.occurences + "x";
                    }
                    case 4: {
                        return String.format("0x%08X", info.result);
                    }
                    case 5: {
                        return info.parameters;
                    }
                }
            }
            return null;
        }
    }

    private class FileHandleModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -109193689444035593L;

        private FileHandleModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            if (FileLoggerFrame.this.fileHandleList != null) {
                return FileLoggerFrame.this.fileHandleList.size();
            }
            return 0;
        }

        @Override
        public String getColumnName(int columnIndex) {
            ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
            switch (columnIndex) {
                case 0: {
                    return bundle.getString("FileLoggerFrame.strFileID.text");
                }
                case 1: {
                    return bundle.getString("FileLoggerFrame.strFileName.text");
                }
                case 2: {
                    return bundle.getString("FileLoggerFrame.strRead.text");
                }
                case 3: {
                    return bundle.getString("FileLoggerFrame.strWrite.text");
                }
            }
            throw new IllegalArgumentException("invalid column index");
        }

        @Override
        public Object getValueAt(int row, int col) {
            FileHandleInfo info = (FileHandleInfo)FileLoggerFrame.this.fileHandleList.get(row);
            if (info != null) {
                switch (col) {
                    case 0: {
                        return String.format("0x%04X", info.fd);
                    }
                    case 1: {
                        return info.filename;
                    }
                    case 2: {
                        return info.bytesRead;
                    }
                    case 3: {
                        return info.bytesWritten;
                    }
                }
            }
            return null;
        }
    }

    public class FileHandleRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -792377736132676194L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            FileHandleInfo info;
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            c.setForeground(Color.black);
            if (FileLoggerFrame.this.fileHandleList != null && !(info = (FileHandleInfo)FileLoggerFrame.this.fileHandleList.get(row)).isOpen()) {
                c.setForeground(Color.gray);
            }
            return c;
        }
    }
}

