/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Debugger;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules150.sceDisplay;
import jpcsp.Memory;
import jpcsp.WindowPropSaver;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.ImageReader;

public class ImageViewer
extends JFrame {
    private static final long serialVersionUID = 8837780642045065242L;
    private int startAddress = 0x4000000;
    private int bufferWidth = 512;
    private int imageWidth = 480;
    private int imageHeight = 272;
    private boolean imageSwizzle = false;
    private boolean useAlpha = false;
    private int backgroundColor = 0;
    private int pixelFormat = 3;
    private int clutAddress = 0;
    private int clutNumberBlocks = 32;
    private int clutFormat = 3;
    private int clutStart = 0;
    private int clutShift = 0;
    private int clutMask = 255;
    private static final Color[] backgroundColors = new Color[]{Color.WHITE, Color.BLACK, Color.RED, Color.GREEN, Color.BLUE, Color.GRAY};
    private JTextField addressField;
    private JComboBox backgroundColorField;
    private JButton btnGoToAddress;
    private JButton btnGoToFB;
    private JButton btnGoToGE;
    private JTextField bufferWidthField;
    private JTextField clutAddressField;
    private JComboBox clutFormatField;
    private JTextField clutNumberBlocksField;
    private JTextField heightField;
    private JLabel lblAddress;
    private JLabel lblBackgroundColor;
    private JLabel lblBufferWidth;
    private JLabel lblCLUT;
    private JLabel lblCLUTFormat;
    private JLabel lblCLUTNumberBlocks;
    private JLabel lblHeight;
    private JLabel lblPixelFormat;
    private JLabel lblWidth;
    private JPanel memoryImage;
    private JComboBox pixelFormatField;
    private JCheckBox swizzleField;
    private JCheckBox useAlphaField;
    private JTextField widthField;

    public ImageViewer() {
        this.initComponents();
        this.copyValuesToFields();
        WindowPropSaver.loadWindowProperties(this);
    }

    public void SafeRefreshImage() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageViewer.this.RefreshImage();
            }
        });
    }

    public void RefreshImage() {
        this.goToAddress();
    }

    private void valuesUpdated() {
        this.memoryImage.setSize(this.memoryImage.getPreferredSize());
        this.repaint();
    }

    private void goToAddress() {
        try {
            this.startAddress = Integer.decode(this.addressField.getText());
            this.imageWidth = Integer.decode(this.widthField.getText());
            this.imageHeight = Integer.decode(this.heightField.getText());
            this.bufferWidth = Integer.decode(this.bufferWidthField.getText());
            this.clutAddress = Integer.decode(this.clutAddressField.getText());
            this.clutNumberBlocks = Integer.decode(this.clutNumberBlocksField.getText());
        }
        catch (NumberFormatException nfe) {
            ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
            JOptionPane.showMessageDialog(this, bundle.getString("ImageViewer.strInvalidNumber.text") + " " + nfe.getLocalizedMessage());
            return;
        }
        this.pixelFormat = this.pixelFormatField.getSelectedIndex();
        this.imageSwizzle = this.swizzleField.isSelected();
        this.useAlpha = this.useAlphaField.isSelected();
        this.backgroundColor = this.backgroundColorField.getSelectedIndex();
        this.clutFormat = this.clutFormatField.getSelectedIndex();
        this.copyValuesToFields();
        this.valuesUpdated();
    }

    private void copyValuesToFields() {
        this.addressField.setText(String.format("0x%08X", this.startAddress));
        this.widthField.setText(String.format("%d", this.imageWidth));
        this.heightField.setText(String.format("%d", this.imageHeight));
        this.bufferWidthField.setText(String.format("%d", this.bufferWidth));
        this.pixelFormatField.setSelectedIndex(this.pixelFormat);
        this.swizzleField.setSelected(this.imageSwizzle);
        this.useAlphaField.setSelected(this.useAlpha);
        this.backgroundColorField.setSelectedIndex(this.backgroundColor);
        this.clutAddressField.setText(String.format("0x%08X", this.clutAddress));
        this.clutNumberBlocksField.setText(String.format("%d", this.clutNumberBlocks));
        this.clutFormatField.setSelectedIndex(this.clutFormat);
    }

    private void goToBufferInfo(sceDisplay.BufferInfo bufferInfo) {
        this.startAddress = bufferInfo.topAddr;
        this.imageWidth = bufferInfo.width;
        this.imageHeight = bufferInfo.height;
        this.bufferWidth = bufferInfo.bufferWidth;
        this.pixelFormat = bufferInfo.pixelFormat;
        this.imageSwizzle = false;
        this.useAlpha = false;
        this.copyValuesToFields();
        this.valuesUpdated();
    }

    @Override
    public void dispose() {
        Emulator.getMainGUI().endWindowDialog();
        super.dispose();
    }

    private void initComponents() {
        this.addressField = new JTextField();
        this.lblWidth = new JLabel();
        this.widthField = new JTextField();
        this.lblHeight = new JLabel();
        this.heightField = new JTextField();
        this.lblBufferWidth = new JLabel();
        this.bufferWidthField = new JTextField();
        this.lblAddress = new JLabel();
        this.lblPixelFormat = new JLabel();
        this.pixelFormatField = new JComboBox();
        this.swizzleField = new JCheckBox();
        this.lblCLUT = new JLabel();
        this.clutAddressField = new JTextField();
        this.lblCLUTNumberBlocks = new JLabel();
        this.clutNumberBlocksField = new JTextField();
        this.lblCLUTFormat = new JLabel();
        this.clutFormatField = new JComboBox();
        this.lblBackgroundColor = new JLabel();
        this.backgroundColorField = new JComboBox();
        this.btnGoToAddress = new JButton();
        this.btnGoToGE = new JButton();
        this.btnGoToFB = new JButton();
        this.useAlphaField = new JCheckBox();
        this.memoryImage = new MemoryImage();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
        this.setTitle(bundle.getString("ImageViewer.title"));
        this.setMinimumSize(new Dimension(532, 500));
        this.addressField.setFont(new Font("Courier New", 0, 12));
        this.addressField.setHorizontalAlignment(0);
        this.addressField.setText("0x00000000");
        this.addressField.setToolTipText(bundle.getString("ImageViewer.addressField.toolTipText"));
        this.addressField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ImageViewer.this.keyPressed(evt);
            }
        });
        this.lblWidth.setText(bundle.getString("ImageViewer.lblWidth.text"));
        this.widthField.setHorizontalAlignment(0);
        this.widthField.setText("480");
        this.widthField.setToolTipText(bundle.getString("ImageViewer.widthField.toolTipText"));
        this.widthField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ImageViewer.this.keyPressed(evt);
            }
        });
        this.lblHeight.setText(bundle.getString("ImageViewer.lblHeight.text"));
        this.heightField.setHorizontalAlignment(0);
        this.heightField.setText("272");
        this.heightField.setToolTipText(bundle.getString("ImageViewer.heightField.toolTipText"));
        this.heightField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ImageViewer.this.keyPressed(evt);
            }
        });
        this.lblBufferWidth.setText(bundle.getString("ImageViewer.lblBufferWidth.text"));
        this.bufferWidthField.setHorizontalAlignment(0);
        this.bufferWidthField.setText("512");
        this.bufferWidthField.setToolTipText(bundle.getString("ImageViewer.bufferWidthField.toolTipText"));
        this.bufferWidthField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ImageViewer.this.keyPressed(evt);
            }
        });
        this.lblAddress.setText(bundle.getString("ImageViewer.lblAddress.text"));
        this.lblPixelFormat.setText(bundle.getString("ImageViewer.lblPixelFormat.text"));
        this.pixelFormatField.setModel(new DefaultComboBoxModel<String>(new String[]{"565", "5551", "4444", "8888", "Indexed 4", "Indexed 8", "Indexed 16", "Indexed 32", "DXT1", "DXT3", "DXT5"}));
        this.pixelFormatField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageViewer.this.changeImageActionPerformed(evt);
            }
        });
        this.swizzleField.setText(bundle.getString("ImageViewer.swizzleField.text"));
        this.swizzleField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageViewer.this.changeImageActionPerformed(evt);
            }
        });
        this.lblCLUT.setText(bundle.getString("ImageViewer.lblCLUT.text"));
        this.clutAddressField.setFont(new Font("Courier New", 0, 12));
        this.clutAddressField.setHorizontalAlignment(0);
        this.clutAddressField.setText("0x00000000");
        this.clutAddressField.setToolTipText(bundle.getString("ImageViewer.clutAddressField.toolTipText"));
        this.clutAddressField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ImageViewer.this.keyPressed(evt);
            }
        });
        this.lblCLUTNumberBlocks.setText(bundle.getString("ImageViewer.lblCLUTNumberBlocks.text"));
        this.clutNumberBlocksField.setHorizontalAlignment(0);
        this.clutNumberBlocksField.setText("32");
        this.clutNumberBlocksField.setToolTipText(bundle.getString("ImageViewer.clutNumberBlocksField.toolTipText"));
        this.clutNumberBlocksField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ImageViewer.this.keyPressed(evt);
            }
        });
        this.lblCLUTFormat.setText(bundle.getString("ImageViewer.lblCLUTFormat.text"));
        this.clutFormatField.setModel(new DefaultComboBoxModel<String>(new String[]{"565", "5551", "4444", "8888"}));
        this.clutFormatField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageViewer.this.changeImageActionPerformed(evt);
            }
        });
        this.lblBackgroundColor.setText(bundle.getString("ImageViewer.lblBackgroundColor.text"));
        this.backgroundColorField.setModel(new DefaultComboBoxModel<String>(new String[]{"White", "Black", "Red", "Green", "Blue", "Gray"}));
        this.backgroundColorField.setSelectedItem("Black");
        this.backgroundColorField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageViewer.this.changeImageActionPerformed(evt);
            }
        });
        this.btnGoToAddress.setText(bundle.getString("ImageViewer.btnGoToAddress.text"));
        this.btnGoToAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageViewer.this.btnGoToAddressActionPerformed(evt);
            }
        });
        this.btnGoToGE.setText(bundle.getString("ImageViewer.btnGoToGE.text"));
        this.btnGoToGE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageViewer.this.btnGoToGEActionPerformed(evt);
            }
        });
        this.btnGoToFB.setText(bundle.getString("ImageViewer.btnGoToFB.text"));
        this.btnGoToFB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageViewer.this.btnGoToFBActionPerformed(evt);
            }
        });
        this.useAlphaField.setText(bundle.getString("ImageViewer.useAlphaField.text"));
        this.useAlphaField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageViewer.this.changeImageActionPerformed(evt);
            }
        });
        this.memoryImage.setBackground(new Color(0, 0, 0));
        this.memoryImage.setBorder(BorderFactory.createLineBorder(new Color(255, 0, 0), 10));
        GroupLayout memoryImageLayout = new GroupLayout(this.memoryImage);
        this.memoryImage.setLayout(memoryImageLayout);
        memoryImageLayout.setHorizontalGroup(memoryImageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 480, Short.MAX_VALUE));
        memoryImageLayout.setVerticalGroup(memoryImageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 272, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPixelFormat).addComponent(this.lblAddress).addComponent(this.lblCLUT)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.addressField, GroupLayout.Alignment.LEADING).addComponent(this.clutAddressField).addComponent(this.pixelFormatField, GroupLayout.Alignment.LEADING, -2, -1, -2))).addGroup(layout.createSequentialGroup().addComponent(this.lblBackgroundColor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.backgroundColorField, 0, -1, Short.MAX_VALUE))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(26, 26, 26).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.swizzleField).addGap(18, 18, 18)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.widthField, -2, 50, -2).addGap(35, 35, 35))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useAlphaField).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.heightField, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblBufferWidth).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bufferWidthField, -2, 50, -2)))).addGroup(layout.createSequentialGroup().addComponent(this.lblCLUTNumberBlocks).addGap(15, 15, 15).addComponent(this.clutNumberBlocksField, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblCLUTFormat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clutFormatField, -2, -1, -2)))).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblWidth).addGap(74, 74, 74).addComponent(this.lblHeight)))).addComponent(this.memoryImage, -2, -1, -2)).addGap(0, 8, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.btnGoToAddress, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.btnGoToGE, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.btnGoToFB, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addressField, -2, -1, -2).addComponent(this.lblWidth).addComponent(this.widthField, -2, -1, -2).addComponent(this.lblHeight).addComponent(this.heightField, -2, -1, -2).addComponent(this.lblBufferWidth).addComponent(this.bufferWidthField, -2, -1, -2).addComponent(this.lblAddress)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPixelFormat).addComponent(this.pixelFormatField, -2, -1, -2).addComponent(this.swizzleField).addComponent(this.useAlphaField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clutAddressField, -2, -1, -2).addComponent(this.lblCLUTNumberBlocks).addComponent(this.clutNumberBlocksField, -2, -1, -2).addComponent(this.lblCLUTFormat).addComponent(this.clutFormatField, -2, -1, -2).addComponent(this.lblCLUT)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblBackgroundColor).addComponent(this.backgroundColorField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnGoToAddress).addComponent(this.btnGoToGE).addComponent(this.btnGoToFB)).addGap(18, 18, 18).addComponent(this.memoryImage, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnGoToAddressActionPerformed(ActionEvent evt) {
        this.goToAddress();
    }

    private void btnGoToGEActionPerformed(ActionEvent evt) {
        this.goToBufferInfo(Modules.sceDisplayModule.getBufferInfoGe());
    }

    private void btnGoToFBActionPerformed(ActionEvent evt) {
        this.goToBufferInfo(Modules.sceDisplayModule.getBufferInfoFb());
    }

    private void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.RefreshImage();
        }
    }

    private void changeImageActionPerformed(ActionEvent evt) {
        this.RefreshImage();
    }

    private class MemoryImage
    extends JPanel {
        private static final long serialVersionUID = 1372183323503668615L;

        @Override
        public void paintComponent(Graphics g) {
            if (Memory.isAddressGood(ImageViewer.this.startAddress)) {
                Insets insets = this.getInsets();
                int minWidth = Math.min(ImageViewer.this.imageWidth, ImageViewer.this.bufferWidth);
                g.setColor(backgroundColors[ImageViewer.this.backgroundColor]);
                g.fillRect(insets.left, insets.top, minWidth, ImageViewer.this.imageHeight);
                IMemoryReader imageReader = ImageReader.getImageReader(ImageViewer.this.startAddress, ImageViewer.this.imageWidth, ImageViewer.this.imageHeight, ImageViewer.this.bufferWidth, ImageViewer.this.pixelFormat, ImageViewer.this.imageSwizzle, ImageViewer.this.clutAddress, ImageViewer.this.clutFormat, ImageViewer.this.clutNumberBlocks, ImageViewer.this.clutStart, ImageViewer.this.clutShift, ImageViewer.this.clutMask, null, null);
                for (int y = 0; y < ImageViewer.this.imageHeight; ++y) {
                    for (int x = 0; x < minWidth; ++x) {
                        int colorABGR = imageReader.readNext();
                        int colorARGB = ImageReader.colorABGRtoARGB(colorABGR);
                        g.setColor(new Color(colorARGB, ImageViewer.this.useAlpha));
                        this.drawPixel(g, x + insets.left, y + insets.top);
                    }
                }
            }
        }

        private void drawPixel(Graphics g, int x, int y) {
            g.drawLine(x, y, x, y);
        }

        @Override
        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            return new Dimension(ImageViewer.this.imageWidth + insets.left + insets.right, ImageViewer.this.imageHeight + insets.top + insets.bottom);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

