/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.GUI;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import jpcsp.Emulator;
import jpcsp.GUI.CancelButton;
import jpcsp.MainGUI;
import jpcsp.WindowPropSaver;
import jpcsp.format.PBP;
import jpcsp.format.PSF;

public class MemStickBrowser
extends JDialog {
    private static final long serialVersionUID = 7788144302296106541L;
    private MainGUI main;
    private File path;
    private CancelButton btnCancel;
    private JButton btnLoad;
    private JButton btnRefresh;
    private JScrollPane jScrollPane1;
    private JTable tblPrograms;

    public MemStickBrowser(MainGUI main, File path) {
        super((Frame)main, true);
        this.main = main;
        this.path = path;
        this.initComponents();
        this.tblPrograms.getColumnModel().getColumn(0).setMinWidth(144);
        this.tblPrograms.getColumnModel().getColumn(0).setMaxWidth(144);
        this.tblPrograms.setDefaultRenderer(Icon.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setText("");
                this.setIcon((Icon)value);
                return this;
            }
        });
        this.tblPrograms.setDefaultRenderer(File.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                try {
                    String prgPath = ((File)value).getCanonicalPath();
                    File cwd = new File(".");
                    if (prgPath.startsWith(cwd.getCanonicalPath())) {
                        prgPath = prgPath.substring(cwd.getCanonicalPath().length() + 1);
                    }
                    this.setText(prgPath);
                }
                catch (IOException ioe) {
                    this.setText(ioe.getLocalizedMessage());
                    ioe.printStackTrace();
                }
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                return this;
            }
        });
        this.tblPrograms.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MemStickBrowser.this.btnLoad.setEnabled(!((ListSelectionModel)e.getSource()).isSelectionEmpty());
            }
        });
        this.refreshFiles();
        WindowPropSaver.loadWindowProperties(this);
    }

    public final void refreshFiles() {
        ((MemStickTableModel)this.tblPrograms.getModel()).refresh();
    }

    private void loadSelectedFile() {
        this.main.loadFile((File)this.tblPrograms.getValueAt(this.tblPrograms.getSelectedRow(), 2));
        this.dispose();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tblPrograms = new JTable();
        this.btnLoad = new JButton();
        this.btnRefresh = new JButton();
        this.btnCancel = new CancelButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
        this.setTitle(bundle.getString("MemStickBrowser.title"));
        this.setMinimumSize(new Dimension(600, 350));
        this.tblPrograms.setModel(new MemStickTableModel(this.path));
        this.tblPrograms.setAutoResizeMode(1);
        this.tblPrograms.setRowHeight(80);
        this.tblPrograms.setSelectionMode(0);
        this.tblPrograms.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MemStickBrowser.this.tblProgramsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tblPrograms);
        this.btnLoad.setText(bundle.getString("LoadButton.text"));
        this.btnLoad.setEnabled(false);
        this.btnLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemStickBrowser.this.btnLoadActionPerformed(evt);
            }
        });
        this.btnRefresh.setText(bundle.getString("MemStickBrowser.btnRefresh.text"));
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemStickBrowser.this.btnRefreshActionPerformed(evt);
            }
        });
        this.btnCancel.setText(bundle.getString("CancelButton.text"));
        this.btnCancel.setParent(this);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnRefresh).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLoad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel, -2, -1, -2)).addComponent(this.jScrollPane1, -1, 576, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 295, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnLoad).addComponent(this.btnRefresh).addComponent(this.btnCancel, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void btnLoadActionPerformed(ActionEvent evt) {
        this.loadSelectedFile();
    }

    private void tblProgramsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && evt.getButton() == 1) {
            this.loadSelectedFile();
        }
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        this.refreshFiles();
    }

    private final class MemStickTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -1675488447176776560L;
        private ImageIcon[] icons;
        private File[] programs;
        private PBP[] pbps;
        private PSF[] psfs;
        private File path;

        public MemStickTableModel(File path) {
            if (!path.isDirectory()) {
                Emulator.log.error((Object)("'" + path + "' is not a directory"));
                this.path = null;
            } else {
                this.path = path;
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Icon.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return File.class;
                }
            }
            throw new IndexOutOfBoundsException("column index out of range");
        }

        @Override
        public String getColumnName(int column) {
            ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
            switch (column) {
                case 0: {
                    return bundle.getString("MemStickBrowser.column.icon.text");
                }
                case 1: {
                    return bundle.getString("MemStickBrowser.column.title.text");
                }
                case 2: {
                    return bundle.getString("MemStickBrowser.column.path.text");
                }
            }
            throw new IndexOutOfBoundsException("column index out of range");
        }

        public void refresh() {
            if (this.path == null) {
                return;
            }
            this.programs = this.path.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String lower = file.getName().toLowerCase();
                    if (lower.endsWith(".pbp")) {
                        return true;
                    }
                    if (file.isDirectory() && !file.getName().startsWith("%") && !file.getName().endsWith("%")) {
                        File[] eboot = file.listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File arg0) {
                                return arg0.getName().equalsIgnoreCase("eboot.pbp");
                            }
                        });
                        return eboot.length != 0;
                    }
                    return false;
                }
            });
            this.icons = new ImageIcon[this.programs.length];
            this.pbps = new PBP[this.programs.length];
            this.psfs = new PSF[this.programs.length];
            for (int i = 0; i < this.programs.length; ++i) {
                try {
                    Image image;
                    File metapbp = this.programs[i];
                    if (this.programs[i].isDirectory()) {
                        File[] psffile;
                        File[] icon0file;
                        File[] eboot = this.programs[i].listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File arg0) {
                                return arg0.getName().equalsIgnoreCase("eboot.pbp");
                            }
                        });
                        metapbp = this.programs[i] = eboot[0];
                        File metadir = new File(this.programs[i].getParentFile().getParentFile().getPath() + File.separatorChar + "%" + this.programs[i].getParentFile().getName());
                        if (metadir.exists() && (eboot = metadir.listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File arg0) {
                                return arg0.getName().equalsIgnoreCase("eboot.pbp");
                            }
                        })).length > 0) {
                            metapbp = eboot[0];
                        }
                        if ((metadir = new File(this.programs[i].getParentFile().getParentFile().getPath() + File.separatorChar + this.programs[i].getParentFile().getName() + "%")).exists() && (eboot = metadir.listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File arg0) {
                                return arg0.getName().equalsIgnoreCase("eboot.pbp");
                            }
                        })).length > 0) {
                            metapbp = eboot[0];
                        }
                        if ((icon0file = this.programs[i].getParentFile().listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File arg0) {
                                return arg0.getName().equalsIgnoreCase("icon0.png");
                            }
                        })).length > 0) {
                            this.icons[i] = new ImageIcon(icon0file[0].getPath());
                        }
                        if ((psffile = this.programs[i].getParentFile().listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File arg0) {
                                return arg0.getName().equalsIgnoreCase("param.sfo");
                            }
                        })).length > 0) {
                            RandomAccessFile raf = new RandomAccessFile(psffile[0], "r");
                            FileChannel roChannel = raf.getChannel();
                            MappedByteBuffer readbuffer = roChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)roChannel.size());
                            this.psfs[i] = new PSF();
                            this.psfs[i].read(readbuffer);
                            raf.close();
                        }
                    }
                    if (this.programs[i].getName().toLowerCase().endsWith(".pbp")) {
                        RandomAccessFile raf = new RandomAccessFile(metapbp, "r");
                        FileChannel roChannel = raf.getChannel();
                        int size = Math.min((int)roChannel.size(), 102400);
                        MappedByteBuffer readbuffer = roChannel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                        this.pbps[i] = new PBP(readbuffer);
                        PSF psf = this.pbps[i].readPSF(readbuffer);
                        if (psf != null) {
                            this.psfs[i] = psf;
                        }
                        if (this.pbps[i].getSizeIcon0() > 0) {
                            byte[] icon0 = new byte[this.pbps[i].getSizeIcon0()];
                            ((ByteBuffer)readbuffer).position(this.pbps[i].getOffsetIcon0());
                            readbuffer.get(icon0);
                            this.icons[i] = new ImageIcon(icon0);
                        }
                        raf.close();
                    }
                    if (this.icons[i] == null) {
                        this.icons[i] = new ImageIcon(this.getClass().getResource("/jpcsp/images/icon0.png"));
                    }
                    if (this.icons[i] == null || (image = this.icons[i].getImage()).getWidth(null) <= 144 && image.getHeight(null) <= 80) continue;
                    image = image.getScaledInstance(144, 80, 4);
                    this.icons[i].setImage(image);
                    continue;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.programs != null ? this.programs.length : 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.icons[rowIndex];
                }
                case 1: {
                    String title;
                    if (this.psfs[rowIndex] == null || (title = this.psfs[rowIndex].getPrintableString("TITLE")) == null) {
                        title = this.programs[rowIndex].getParentFile().getName();
                    }
                    return title;
                }
                case 2: {
                    return this.programs[rowIndex];
                }
            }
            return null;
        }
    }
}

