/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.local;

import java.io.File;
import java.io.FileNotFoundException;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractVirtualFileSystem;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.local.LocalVirtualFile;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.kernel.types.ScePspDateTime;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.filesystems.SeekableRandomFile;
import jpcsp.hardware.MemoryStick;

public class LocalVirtualFileSystem
extends AbstractVirtualFileSystem {
    protected final String localPath;
    private static final String[] modeStrings = new String[]{"r", "r", "rw", "rw"};

    public LocalVirtualFileSystem(String localPath) {
        this.localPath = localPath;
    }

    protected File getFile(String fileName) {
        return new File(this.localPath + fileName);
    }

    protected static String getMode(int mode) {
        return modeStrings[mode & 3];
    }

    @Override
    public IVirtualFile ioOpen(String fileName, int flags, int mode) {
        SeekableRandomFile raf;
        File file = this.getFile(fileName);
        if (file.exists() && LocalVirtualFileSystem.hasFlag(flags, 512) && LocalVirtualFileSystem.hasFlag(flags, 2048)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"hleIoOpen - file already exists (PSP_O_CREAT + PSP_O_EXCL)");
            }
            throw new SceKernelErrorException(-2147418095);
        }
        if (!file.exists() && LocalVirtualFileSystem.hasFlag(flags, 512)) {
            String parentDir = file.getParent();
            new File(parentDir).mkdirs();
        }
        try {
            raf = new SeekableRandomFile(file, LocalVirtualFileSystem.getMode(flags));
        }
        catch (FileNotFoundException e) {
            return null;
        }
        LocalVirtualFile localVirtualFile = new LocalVirtualFile(raf);
        if (LocalVirtualFileSystem.hasFlag(flags, 2) && LocalVirtualFileSystem.hasFlag(flags, 1024)) {
            localVirtualFile.setTruncateAtNextWrite(true);
        }
        return localVirtualFile;
    }

    @Override
    public int ioGetstat(String fileName, SceIoStat stat) {
        File file = this.getFile(fileName);
        if (!file.exists()) {
            return -2147418110;
        }
        int attr = 0;
        if (file.isDirectory()) {
            attr |= 0x10;
        }
        if (file.isFile()) {
            attr |= 0x20;
        }
        int mode = (file.canRead() ? 4 : 0) + (file.canWrite() ? 2 : 0) + (file.canExecute() ? 1 : 0);
        mode = mode + (mode << 3) + (mode << 6);
        ScePspDateTime ctime = ScePspDateTime.fromUnixTime(file.lastModified());
        ScePspDateTime atime = ScePspDateTime.fromUnixTime(0L);
        ScePspDateTime mtime = ScePspDateTime.fromUnixTime(file.lastModified());
        stat.init(mode |= attr << 8, attr, file.length(), ctime, atime, mtime);
        return 0;
    }

    @Override
    public int ioRemove(String name) {
        File file = this.getFile(name);
        if (!file.delete()) {
            return -1;
        }
        return 0;
    }

    @Override
    public String[] ioDopen(String dirName) {
        File file = this.getFile(dirName);
        if (!file.isDirectory()) {
            if (file.exists()) {
                log.warn((Object)String.format("ioDopen file '%s' is not a directory", dirName));
            } else {
                log.warn((Object)String.format("ioDopen directory '%s' not found", dirName));
            }
            return null;
        }
        return file.list();
    }

    @Override
    public int ioMkdir(String name, int mode) {
        File file = this.getFile(name);
        if (file.exists()) {
            return -2147418095;
        }
        if (!file.mkdir()) {
            return -1;
        }
        return 0;
    }

    @Override
    public int ioRmdir(String name) {
        File file = this.getFile(name);
        if (!file.exists()) {
            return -2147418110;
        }
        if (!file.delete()) {
            return -1;
        }
        return 0;
    }

    @Override
    public int ioChstat(String fileName, SceIoStat stat, int bits) {
        File file = this.getFile(fileName);
        int mode = stat.mode;
        boolean successful = true;
        if ((bits & 1) != 0 && !file.setExecutable((mode & 1) != 0)) {
            successful = false;
        }
        if ((bits & 2) != 0 && !file.setWritable((mode & 2) != 0)) {
            successful = false;
        }
        if ((bits & 4) != 0 && !file.setReadable((mode & 4) != 0)) {
            successful = false;
        }
        if ((bits & 0x40) != 0 && !file.setExecutable((mode & 0x40) != 0, true)) {
            successful = false;
        }
        if ((bits & 0x80) != 0 && !file.setWritable((mode & 0x80) != 0, true)) {
            successful = false;
        }
        if ((bits & 0x100) != 0 && !file.setReadable((mode & 0x100) != 0, true)) {
            successful = false;
        }
        return successful ? 0 : -1;
    }

    @Override
    public int ioRename(String oldFileName, String newFileName) {
        File oldFile = this.getFile(oldFileName);
        File newFile = this.getFile(newFileName);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("ioRename: renaming file '%s' to '%s'", oldFileName, newFileName));
        }
        if (!oldFile.renameTo(newFile)) {
            log.warn((Object)String.format("ioRename failed: '%s' to '%s'", oldFileName, newFileName));
            return -1;
        }
        return 0;
    }

    @Override
    public int ioDevctl(String deviceName, int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        int result;
        switch (command) {
            case 37836833: {
                log.debug((Object)"sceIoDevctl register memorystick insert/eject callback (fatms0)");
                ThreadManForUser threadMan = Modules.ThreadManForUserModule;
                if (!deviceName.equals("fatms0:")) {
                    result = -2145255295;
                    break;
                }
                if (inputPointer.isAddressGood() && inputLength == 4) {
                    int cbid = inputPointer.getValue32();
                    int callbackType = 3;
                    if (threadMan.hleKernelRegisterCallback(3, cbid)) {
                        threadMan.hleKernelNotifyCallback(3, cbid, MemoryStick.getStateFatMs());
                        result = 0;
                        break;
                    }
                    result = -2147418090;
                    break;
                }
                result = -2147418090;
                break;
            }
            case 37836834: {
                log.debug((Object)"sceIoDevctl unregister memorystick insert/eject callback (fatms0)");
                ThreadManForUser threadMan = Modules.ThreadManForUserModule;
                if (!deviceName.equals("fatms0:")) {
                    result = -2145255295;
                    break;
                }
                if (inputPointer.isAddressGood() && inputLength == 4) {
                    int cbid = inputPointer.getValue32();
                    threadMan.hleKernelUnRegisterCallback(3, cbid);
                    result = 0;
                    break;
                }
                result = -2147418090;
                break;
            }
            case 37836835: {
                log.debug((Object)"sceIoDevctl set assigned device (fatms0)");
                if (!deviceName.equals("fatms0:")) {
                    result = -2145255295;
                    break;
                }
                if (inputPointer.isAddressGood() && inputLength >= 4) {
                    MemoryStick.setStateFatMs(inputPointer.getValue32());
                    result = 0;
                    break;
                }
                result = -1;
                break;
            }
            case 37902372: {
                log.debug((Object)"sceIoDevctl check write protection (fatms0)");
                if (!deviceName.equals("fatms0:") && !deviceName.equals("ms0:")) {
                    result = -2145255295;
                    break;
                }
                if (outputPointer.isAddressGood()) {
                    outputPointer.setValue32(0);
                    result = 0;
                    break;
                }
                result = -1;
                break;
            }
            case 37902360: {
                int maxClusters;
                log.debug((Object)"sceIoDevctl get MS capacity (fatms0)");
                int sectorSize = 512;
                int sectorCount = MemoryStick.getSectorSize() / sectorSize;
                int freeClusters = maxClusters = (int)(MemoryStick.getFreeSize() * 95L / 100L / (long)(sectorSize * sectorCount));
                int maxSectors = maxClusters;
                if (inputPointer.isAddressGood() && inputLength >= 4) {
                    int addr = inputPointer.getValue32();
                    if (Memory.isAddressGood(addr)) {
                        log.debug((Object)"sceIoDevctl refer ms free space");
                        Memory mem = Memory.getInstance();
                        mem.write32(addr, maxClusters);
                        mem.write32(addr + 4, freeClusters);
                        mem.write32(addr + 8, maxSectors);
                        mem.write32(addr + 12, sectorSize);
                        mem.write32(addr + 16, sectorCount);
                        result = 0;
                        break;
                    }
                    log.warn((Object)("sceIoDevctl 0x02425818 bad save address " + String.format("0x%08X", addr)));
                    result = -1;
                    break;
                }
                log.warn((Object)("sceIoDevctl 0x02425818 bad param address " + String.format("0x%08X", inputPointer) + " or size " + inputLength));
                result = -1;
                break;
            }
            case 37902371: {
                log.debug((Object)"sceIoDevctl check assigned device (fatms0)");
                if (!deviceName.equals("fatms0:")) {
                    result = -2145255295;
                    break;
                }
                if (outputPointer.isAddressGood() && outputLength >= 4) {
                    outputPointer.setValue32(MemoryStick.getStateFatMs());
                    result = 0;
                    break;
                }
                result = -1;
                break;
            }
            default: {
                result = super.ioDevctl(deviceName, command, inputPointer, inputLength, outputPointer, outputLength);
            }
        }
        return result;
    }
}

