/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import java.util.HashMap;
import java.util.Iterator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceKernelVplInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.ThreadManForUser;
import org.apache.log4j.Logger;

public class VplManager {
    public static Logger log = Modules.getLogger("ThreadManForUser");
    private HashMap<Integer, SceKernelVplInfo> vplMap;
    private VplWaitStateChecker vplWaitStateChecker;
    public static final int PSP_VPL_ATTR_FIFO = 0;
    public static final int PSP_VPL_ATTR_PRIORITY = 256;
    private static final int PSP_VPL_ATTR_PASS = 512;
    public static final int PSP_VPL_ATTR_ADDR_HIGH = 16384;
    public static final int PSP_VPL_ATTR_MASK = 17407;
    public static final VplManager singleton = new VplManager();

    public void reset() {
        this.vplMap = new HashMap();
        this.vplWaitStateChecker = new VplWaitStateChecker();
    }

    private boolean removeWaitingThread(SceKernelThreadInfo thread) {
        SceKernelVplInfo fpl = this.vplMap.get(thread.wait.Vpl_id);
        if (fpl == null) {
            return false;
        }
        fpl.threadWaitingList.removeWaitingThread(thread);
        return true;
    }

    public void onThreadWaitTimeout(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext._v0 = -2147352152;
        } else {
            log.warn((Object)"VPL deleted while we were waiting for it! (timeout expired)");
            thread.cpuContext._v0 = -2147352139;
        }
    }

    public void onThreadWaitReleased(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext._v0 = -2147352150;
        } else {
            log.warn((Object)"EventFlag deleted while we were waiting for it!");
            thread.cpuContext._v0 = -2147352139;
        }
    }

    public void onThreadDeleted(SceKernelThreadInfo thread) {
        if (thread.isWaitingForType(6)) {
            this.removeWaitingThread(thread);
        }
    }

    private void onVplDeletedCancelled(int vid, int result) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        Iterator<SceKernelThreadInfo> it = threadMan.iterator();
        while (it.hasNext()) {
            SceKernelThreadInfo thread = it.next();
            if (!thread.isWaitingFor(6, vid)) continue;
            thread.cpuContext._v0 = result;
            threadMan.hleChangeThreadState(thread, 2);
            reschedule = true;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private void onVplDeleted(int vid) {
        this.onVplDeletedCancelled(vid, -2147352139);
    }

    private void onVplCancelled(int vid) {
        this.onVplDeletedCancelled(vid, -2147352151);
    }

    private void onVplFree(SceKernelVplInfo info) {
        SceKernelThreadInfo thread;
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        SceKernelThreadInfo checkedThread = null;
        while (info.freeSize > 0 && (thread = info.threadWaitingList.getNextWaitingThread(checkedThread)) != null) {
            int addr = this.tryAllocateVpl(info, thread.wait.Vpl_size);
            if (addr != 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("onVplFree waking thread %s", thread));
                }
                thread.wait.Vpl_dataAddr.setValue(addr);
                info.threadWaitingList.removeWaitingThread(thread);
                thread.cpuContext._v0 = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
                continue;
            }
            checkedThread = thread;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private int tryAllocateVpl(SceKernelVplInfo info, int size) {
        return info.alloc(size);
    }

    public int checkVplID(int uid) {
        SceUidManager.checkUidPurpose(uid, "ThreadMan-Vpl", true);
        if (!this.vplMap.containsKey(uid)) {
            log.warn((Object)String.format("checkVplID unknown uid=0x%X", uid));
            throw new SceKernelErrorException(-2147352164);
        }
        return uid;
    }

    public int sceKernelCreateVpl(PspString name, int partitionid, int attr, int size, TPointer option) {
        if (name.isNull()) {
            return -2147352575;
        }
        if (option.isNotNull()) {
            int optionSize = option.getValue32();
            log.warn((Object)String.format("sceKernelCreateVpl option at %s, size=%d", option, optionSize));
        }
        int memType = 0;
        if ((attr & 0x4000) == 16384) {
            memType = 1;
        }
        if ((attr & 0xFFFFBC00) != 0) {
            log.warn((Object)("sceKernelCreateVpl bad attr value 0x" + Integer.toHexString(attr)));
            return -2147352175;
        }
        if (size == 0) {
            return -2147352137;
        }
        if (size < 0) {
            return -2147352176;
        }
        SceKernelVplInfo info = SceKernelVplInfo.tryCreateVpl(name.getString(), partitionid, attr, size, memType);
        if (info == null) {
            return -2147352176;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelCreateVpl returning %s", info));
        }
        this.vplMap.put(info.uid, info);
        return info.uid;
    }

    public int sceKernelDeleteVpl(int uid) {
        SceKernelVplInfo info = this.vplMap.remove(uid);
        if (info.freeSize < info.poolSize) {
            log.warn((Object)String.format("sceKernelDeleteVpl approx 0x%X unfreed bytes allocated", info.poolSize - info.freeSize));
        }
        info.delete();
        this.onVplDeleted(uid);
        return 0;
    }

    private int hleKernelAllocateVpl(int uid, int size, TPointer32 dataAddr, TPointer32 timeoutAddr, boolean wait, boolean doCallbacks) {
        SceKernelVplInfo vpl = this.vplMap.get(uid);
        if (size <= 0 || size > vpl.poolSize) {
            return -2147352137;
        }
        int addr = this.tryAllocateVpl(vpl, size);
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        if (addr == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleKernelAllocateVpl %s fast check failed", vpl));
            }
            if (!wait) {
                return -2147352153;
            }
            SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
            vpl.threadWaitingList.addWaitingThread(currentThread);
            currentThread.wait.Vpl_id = uid;
            currentThread.wait.Vpl_size = size;
            currentThread.wait.Vpl_dataAddr = dataAddr;
            threadMan.hleKernelThreadEnterWaitState(6, uid, this.vplWaitStateChecker, timeoutAddr.getAddress(), doCallbacks);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleKernelAllocateVpl %s fast check succeeded, allocated addr=0x%08X", vpl, addr));
            }
            dataAddr.setValue(addr);
        }
        return 0;
    }

    public int sceKernelAllocateVpl(int uid, int size, TPointer32 dataAddr, TPointer32 timeoutAddr) {
        return this.hleKernelAllocateVpl(uid, size, dataAddr, timeoutAddr, true, false);
    }

    public int sceKernelAllocateVplCB(int uid, int size, TPointer32 dataAddr, TPointer32 timeoutAddr) {
        return this.hleKernelAllocateVpl(uid, size, dataAddr, timeoutAddr, true, true);
    }

    public int sceKernelTryAllocateVpl(int uid, int size, TPointer32 dataAddr) {
        return this.hleKernelAllocateVpl(uid, size, dataAddr, TPointer32.NULL, false, false);
    }

    public int sceKernelFreeVpl(int uid, TPointer dataAddr) {
        SceKernelVplInfo info = this.vplMap.get(uid);
        if (!info.free(dataAddr.getAddress())) {
            return -2147352138;
        }
        this.onVplFree(info);
        return 0;
    }

    public int sceKernelCancelVpl(int uid, TPointer32 numWaitThreadAddr) {
        SceKernelVplInfo info = this.vplMap.get(uid);
        numWaitThreadAddr.setValue(info.getNumWaitingThreads());
        info.threadWaitingList.removeAllWaitingThreads();
        this.onVplCancelled(uid);
        return 0;
    }

    public int sceKernelReferVplStatus(int uid, TPointer infoAddr) {
        SceKernelVplInfo info = this.vplMap.get(uid);
        info.write(infoAddr);
        return 0;
    }

    private VplManager() {
    }

    private class VplWaitStateChecker
    implements IWaitStateChecker {
        private VplWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            SceKernelVplInfo vpl = (SceKernelVplInfo)VplManager.this.vplMap.get(wait.Vpl_id);
            if (vpl == null) {
                thread.cpuContext._v0 = -2147352164;
                return false;
            }
            int addr = VplManager.this.tryAllocateVpl(vpl, wait.Vpl_size);
            if (addr != 0) {
                wait.Vpl_dataAddr.setValue(addr);
                vpl.threadWaitingList.removeWaitingThread(thread);
                thread.cpuContext._v0 = 0;
                return false;
            }
            return true;
        }
    }
}

