/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.types.pspCharInfo;
import jpcsp.HLE.kernel.types.pspFontStyle;
import jpcsp.HLE.modules150.sceFont;
import jpcsp.format.PGF;
import jpcsp.util.Debug;

public class SceFontInfo {
    public static final int FONT_FILETYPE_PGF = 0;
    public static final int FONT_FILETYPE_BWFON = 1;
    public static final int FONT_PGF_BMP_H_ROWS = 1;
    public static final int FONT_PGF_BMP_V_ROWS = 2;
    public static final int FONT_PGF_BMP_OVERLAY = 3;
    public static final int FONT_PGF_METRIC_DIMENSION_INDEX = 4;
    public static final int FONT_PGF_METRIC_BEARING_X_INDEX = 8;
    public static final int FONT_PGF_METRIC_BEARING_Y_INDEX = 16;
    public static final int FONT_PGF_METRIC_ADVANCE_INDEX = 32;
    public static final int FONT_PGF_GLYPH_TYPE_CHAR = 0;
    public static final int FONT_PGF_GLYPH_TYPE_SHADOW = 1;
    protected String fileName;
    protected String fileType;
    protected int[] fontdata;
    protected long fontdataBits;
    protected int advancex;
    protected int advancey;
    protected int charmap_compr_len;
    protected int[] charmap_compr;
    protected int[] charmap;
    protected Glyph[] glyphs;
    protected int firstGlyph;
    protected int shadowScaleX;
    protected int shadowScaleY;
    protected Glyph[] shadowGlyphs;
    protected pspFontStyle fontStyle;

    private int[] getTable(int[] rawTable, int bpe, int length) {
        int[] table = new int[length];
        int i = 0;
        int bitPtr = 0;
        while (i < length) {
            table[i] = this.getBits(bpe, rawTable, bitPtr);
            ++i;
            bitPtr += bpe;
        }
        return table;
    }

    protected SceFontInfo() {
    }

    public SceFontInfo(PGF fontFile) {
        int i;
        this.fileName = fontFile.getFileNamez();
        this.fileType = fontFile.getPGFMagic();
        this.charmap = new int[fontFile.getCharMapLength() * 2];
        this.charmap_compr_len = fontFile.getRevision() == 3 ? 7 : 1;
        this.charmap_compr = new int[this.charmap_compr_len * 4];
        this.advancex = fontFile.getMaxAdvance()[0] / 16;
        this.advancey = fontFile.getMaxAdvance()[1] / 16;
        this.shadowScaleX = fontFile.getShadowScale()[0];
        this.shadowScaleY = fontFile.getShadowScale()[1];
        this.glyphs = new Glyph[fontFile.getCharPointerLength()];
        this.shadowGlyphs = new Glyph[fontFile.getShadowMapLength()];
        this.firstGlyph = fontFile.getFirstGlyphInCharMap();
        int[] rawCharMap = fontFile.getCharMap();
        for (int i2 = 0; i2 < fontFile.getCharMapLength(); ++i2) {
            this.charmap[i2] = this.getBits(fontFile.getCharMapBpe(), rawCharMap, i2 * fontFile.getCharMapBpe());
            if (this.charmap[i2] < this.glyphs.length) continue;
            this.charmap[i2] = 65535;
        }
        this.fontdata = fontFile.getFontdata();
        this.fontdataBits = (long)this.fontdata.length * 8L;
        int[] charPointers = this.getTable(fontFile.getCharPointerTable(), fontFile.getCharPointerBpe(), this.glyphs.length);
        int[] shadowMap = this.getTable(fontFile.getShadowCharMap(), fontFile.getShadowMapBpe(), this.shadowGlyphs.length);
        for (i = 0; i < this.glyphs.length; ++i) {
            this.glyphs[i] = this.getGlyph(this.fontdata, charPointers[i] * 4 * 8, 0, fontFile);
        }
        if (this.shadowGlyphs.length > 0) {
            for (i = 0; i < this.glyphs.length; ++i) {
                int charId;
                int shadowId = this.glyphs[i].shadowID;
                if (shadowId < 0 || shadowId >= shadowMap.length || shadowId >= this.shadowGlyphs.length || (charId = this.getCharID(shadowMap[shadowId])) < 0 || charId >= this.glyphs.length || this.shadowGlyphs[shadowId] != null) continue;
                this.shadowGlyphs[shadowId] = this.getGlyph(this.fontdata, charPointers[charId] * 4 * 8, 1, fontFile);
            }
        }
    }

    private int getBits(int bpe, int[] buf, long pos) {
        int v = 0;
        for (int i = 0; i < bpe; ++i) {
            v += (buf[(int)(pos / 8L)] >> (int)(pos % 8L) & 1) << i;
            ++pos;
        }
        return v;
    }

    private boolean isIncorrectFont(PGF fontFile) {
        String fontName = fontFile.getFontName();
        return fontName.startsWith("Liberation") || fontName.startsWith("Sazanami") || fontName.startsWith("UnDotum");
    }

    private Glyph getGlyph(int[] fontdata, long charPtr, int glyphType, PGF fontFile) {
        Glyph glyph = new Glyph();
        if (glyphType == 1) {
            if (charPtr + 96L > this.fontdataBits) {
                return null;
            }
            charPtr += (long)(this.getBits(14, fontdata, charPtr) * 8);
        }
        if (charPtr + 96L > this.fontdataBits) {
            return null;
        }
        glyph.w = this.getBits(7, fontdata, charPtr += 14L);
        glyph.h = this.getBits(7, fontdata, charPtr += 7L);
        glyph.left = this.getBits(7, fontdata, charPtr += 7L);
        charPtr += 7L;
        if (glyph.left >= 64) {
            glyph.left -= 128;
        }
        glyph.top = this.getBits(7, fontdata, charPtr);
        charPtr += 7L;
        if (glyph.top >= 64) {
            glyph.top -= 128;
        }
        glyph.flags = this.getBits(6, fontdata, charPtr);
        charPtr += 6L;
        if (glyphType == 0) {
            int unknown1 = this.getBits(2, fontdata, charPtr);
            int unknown2 = this.getBits(2, fontdata, charPtr += 2L);
            int unknown3 = this.getBits(3, fontdata, charPtr += 2L);
            charPtr += 3L;
            if (sceFont.log.isTraceEnabled()) {
                sceFont.log.trace((Object)String.format("unknown1=%d, unknown2=%d, unknown3=%d", unknown1, unknown2, unknown3));
            }
            glyph.shadowID = this.getBits(9, fontdata, charPtr);
            charPtr += 9L;
            if (glyph.hasFlag(4)) {
                int dimensionIndex = this.getBits(8, fontdata, charPtr);
                charPtr += 8L;
                if (dimensionIndex < fontFile.getDimensionTableLength()) {
                    int[][] dimensionTable = fontFile.getDimensionTable();
                    glyph.dimensionWidth = dimensionTable[0][dimensionIndex];
                    glyph.dimensionHeight = dimensionTable[1][dimensionIndex];
                }
                if (dimensionIndex == 0 && this.isIncorrectFont(fontFile)) {
                    glyph.dimensionWidth = glyph.w << 6;
                    glyph.dimensionHeight = glyph.h << 6;
                }
            } else {
                glyph.dimensionWidth = this.getBits(32, fontdata, charPtr);
                glyph.dimensionHeight = this.getBits(32, fontdata, charPtr += 32L);
                charPtr += 32L;
            }
            if (glyph.hasFlag(8)) {
                int xAdjustIndex = this.getBits(8, fontdata, charPtr);
                charPtr += 8L;
                if (xAdjustIndex < fontFile.getXAdjustTableLength()) {
                    int[][] xAdjustTable = fontFile.getXAdjustTable();
                    glyph.xAdjustH = xAdjustTable[0][xAdjustIndex];
                    glyph.xAdjustV = xAdjustTable[1][xAdjustIndex];
                }
                if (xAdjustIndex == 0 && this.isIncorrectFont(fontFile)) {
                    glyph.xAdjustH = glyph.left << 6;
                    glyph.xAdjustV = glyph.left << 6;
                }
            } else {
                glyph.xAdjustH = this.getBits(32, fontdata, charPtr);
                glyph.xAdjustV = this.getBits(32, fontdata, charPtr += 32L);
                charPtr += 32L;
            }
            if (glyph.hasFlag(16)) {
                int yAdjustIndex = this.getBits(8, fontdata, charPtr);
                charPtr += 8L;
                if (yAdjustIndex < fontFile.getYAdjustTableLength()) {
                    int[][] yAdjustTable = fontFile.getYAdjustTable();
                    glyph.yAdjustH = yAdjustTable[0][yAdjustIndex];
                    glyph.yAdjustV = yAdjustTable[1][yAdjustIndex];
                }
                if (yAdjustIndex == 0 && this.isIncorrectFont(fontFile)) {
                    glyph.yAdjustH = glyph.top << 6;
                    glyph.yAdjustV = glyph.top << 6;
                }
            } else {
                glyph.yAdjustH = this.getBits(32, fontdata, charPtr);
                glyph.yAdjustV = this.getBits(32, fontdata, charPtr += 32L);
                charPtr += 32L;
            }
            if (glyph.hasFlag(32)) {
                int advanceIndex = this.getBits(8, fontdata, charPtr);
                charPtr += 8L;
                if (advanceIndex < fontFile.getAdvanceTableLength()) {
                    int[][] advanceTable = fontFile.getAdvanceTable();
                    glyph.advanceH = advanceTable[0][advanceIndex];
                    glyph.advanceV = advanceTable[1][advanceIndex];
                }
            } else {
                glyph.advanceH = this.getBits(32, fontdata, charPtr);
                glyph.advanceV = this.getBits(32, fontdata, charPtr += 32L);
                charPtr += 32L;
            }
        } else {
            glyph.shadowID = 65535;
            glyph.advanceH = 0;
        }
        glyph.ptr = charPtr / 8L;
        return glyph;
    }

    private int getCharID(int charCode) {
        if ((charCode -= this.firstGlyph) >= 0 && charCode < this.charmap.length) {
            charCode = this.charmap[charCode];
        }
        return charCode;
    }

    private Glyph getCharGlyph(int charCode, int glyphType) {
        if (charCode < this.firstGlyph) {
            return null;
        }
        if ((charCode = this.getCharID(charCode)) < 0 || charCode >= this.glyphs.length) {
            return null;
        }
        Glyph glyph = this.glyphs[charCode];
        if (glyphType == 1) {
            int shadowID = glyph.shadowID;
            if (shadowID < 0 || shadowID >= this.shadowGlyphs.length) {
                return null;
            }
            glyph = this.shadowGlyphs[shadowID];
        }
        return glyph;
    }

    private void generateFontTexture(int base, int bpl, int bufWidth, int bufHeight, int x, int y, int clipX, int clipY, int clipWidth, int clipHeight, int pixelformat, int charCode, int altCharCode, int glyphType) {
        Glyph glyph = this.getCharGlyph(charCode, glyphType);
        if (glyph == null && (glyph = this.getCharGlyph(charCode = altCharCode, glyphType)) == null) {
            return;
        }
        if (glyph.w <= 0 || glyph.h <= 0) {
            return;
        }
        if ((glyph.flags & 3) != 1 && (glyph.flags & 3) != 2) {
            return;
        }
        long bitPtr = glyph.ptr * 8L;
        int nibbleBits = 4;
        int value = 0;
        boolean bitmapHorizontalRows = (glyph.flags & 3) == 1;
        int numberPixels = glyph.w * glyph.h;
        int pixelIndex = 0;
        int scaleX = 1;
        int scaleY = 1;
        if (glyphType == 1) {
            scaleX = 64 / this.shadowScaleX;
            scaleY = 64 / this.shadowScaleY;
        }
        while (pixelIndex < numberPixels && bitPtr + 8L < this.fontdataBits) {
            int count;
            int nibble = this.getBits(4, this.fontdata, bitPtr);
            bitPtr += 4L;
            if (nibble < 8) {
                value = this.getBits(4, this.fontdata, bitPtr);
                bitPtr += 4L;
                count = nibble + 1;
            } else {
                count = 16 - nibble;
            }
            for (int i = 0; i < count && pixelIndex < numberPixels; ++pixelIndex, ++i) {
                int yy;
                int xx;
                if (nibble >= 8) {
                    value = this.getBits(4, this.fontdata, bitPtr);
                    bitPtr += 4L;
                }
                if (bitmapHorizontalRows) {
                    xx = pixelIndex % glyph.w;
                    yy = pixelIndex / glyph.w;
                } else {
                    xx = pixelIndex / glyph.h;
                    yy = pixelIndex % glyph.h;
                }
                int pixelX = x + xx * scaleX;
                int pixelY = y + yy * scaleY;
                if (pixelX < clipX || pixelX >= clipX + clipWidth || pixelY < clipY || pixelY >= clipY + clipHeight) continue;
                int pixelColor = value;
                switch (pixelformat) {
                    case 2: {
                        pixelColor |= pixelColor << 4;
                        break;
                    }
                    case 3: {
                        pixelColor |= pixelColor << 4;
                        pixelColor |= pixelColor << 8;
                        pixelColor |= pixelColor << 8;
                        break;
                    }
                    case 4: {
                        pixelColor |= pixelColor << 4;
                        pixelColor |= pixelColor << 8;
                        pixelColor |= pixelColor << 16;
                    }
                }
                for (int yyy = 0; yyy < scaleY; ++yyy) {
                    for (int xxx = 0; xxx < scaleX; ++xxx) {
                        Debug.setFontPixel(base, bpl, bufWidth, bufHeight, pixelX + xxx, pixelY + yyy, pixelColor, pixelformat);
                    }
                }
            }
        }
    }

    public void printFont(int base, int bpl, int bufWidth, int bufHeight, int x, int y, int clipX, int clipY, int clipWidth, int clipHeight, int pixelformat, int charCode, int altCharCode, int glyphType) {
        this.generateFontTexture(base, bpl, bufWidth, bufHeight, x, y, clipX, clipY, clipWidth, clipHeight, pixelformat, charCode, altCharCode, glyphType);
    }

    public pspCharInfo getCharInfo(int charCode, int glyphType) {
        pspCharInfo charInfo = new pspCharInfo();
        Glyph glyph = this.getCharGlyph(charCode, glyphType);
        if (glyph == null) {
            return charInfo;
        }
        charInfo.bitmapWidth = glyph.w;
        charInfo.bitmapHeight = glyph.h;
        charInfo.bitmapLeft = glyph.left;
        charInfo.bitmapTop = glyph.top;
        charInfo.sfp26Width = glyph.dimensionWidth;
        charInfo.sfp26Height = glyph.dimensionHeight;
        charInfo.sfp26Ascender = glyph.top << 6;
        charInfo.sfp26Descender = glyph.h - glyph.top << 6;
        charInfo.sfp26BearingHX = glyph.xAdjustH;
        charInfo.sfp26BearingHY = glyph.yAdjustH;
        charInfo.sfp26BearingVX = glyph.xAdjustV;
        charInfo.sfp26BearingVY = glyph.yAdjustV;
        charInfo.sfp26AdvanceH = glyph.advanceH;
        charInfo.sfp26AdvanceV = glyph.advanceV;
        if (glyphType == 1) {
            int scaleX = 64 / this.shadowScaleX;
            int scaleY = 64 / this.shadowScaleY;
            charInfo.bitmapWidth *= scaleX;
            charInfo.bitmapHeight *= scaleY;
            charInfo.bitmapLeft *= scaleX;
            charInfo.bitmapTop *= scaleY;
            charInfo.sfp26Ascender *= scaleY;
            charInfo.sfp26Descender *= scaleY;
        }
        return charInfo;
    }

    public pspFontStyle getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(pspFontStyle fontStyle) {
        this.fontStyle = fontStyle;
    }

    public int getCharIndex(int charCode, int[] charmapCompressed) {
        int charIndex = 0;
        for (int i = 0; i < charmapCompressed.length; i += 2) {
            if (charCode >= charmapCompressed[i] && charCode < charmapCompressed[i] + charmapCompressed[i + 1]) {
                return charIndex += charCode - charmapCompressed[i];
            }
            charIndex += charmapCompressed[i + 1];
        }
        return -1;
    }

    protected static class Glyph {
        protected int x;
        protected int y;
        protected int w;
        protected int h;
        protected int left;
        protected int top;
        protected int flags;
        protected int shadowID;
        protected int advanceH;
        protected int advanceV;
        protected int dimensionWidth;
        protected int dimensionHeight;
        protected int xAdjustH;
        protected int xAdjustV;
        protected int yAdjustH;
        protected int yAdjustV;
        protected long ptr;

        protected Glyph() {
        }

        public boolean hasFlag(int flag) {
            return (this.flags & flag) == flag;
        }

        public String toString() {
            return String.format("Glyph[x=%d, y=%d, w=%d, h=%d, left=%d, top=%d, flags=0x%X, shadowID=%d, advance=%d, ptr=%d]", this.x, this.y, this.w, this.h, this.left, this.top, this.flags, this.shadowID, this.advanceH, this.ptr);
        }
    }
}

