/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import java.util.HashMap;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.managers.ThreadWaitingList;
import jpcsp.HLE.kernel.managers.VplManager;
import jpcsp.HLE.kernel.types.MemoryChunk;
import jpcsp.HLE.kernel.types.MemoryChunkList;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructureVariableLength;
import jpcsp.HLE.modules150.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.util.Utilities;

public class SceKernelVplInfo
extends pspAbstractMemoryMappedStructureVariableLength {
    public final String name;
    public final int attr;
    public final int poolSize;
    public int freeSize;
    public final ThreadWaitingList threadWaitingList;
    public static final int vplHeaderSize = 32;
    public static final int vplBlockHeaderSize = 8;
    public static final int vplAddrAlignment = 7;
    private final SysMemUserForUser.SysMemInfo sysMemInfo;
    public final int uid;
    public final int partitionid;
    private final int allocAddress;
    private HashMap<Integer, Integer> dataBlockMap;
    private MemoryChunkList freeMemoryChunks;

    private SceKernelVplInfo(String name, int partitionid, int attr, int size, int memType) {
        this.name = name;
        this.attr = attr;
        if (size <= 48) {
            size = 4096;
        }
        this.freeSize = this.poolSize = size - 32;
        this.dataBlockMap = new HashMap();
        this.uid = SceUidManager.getNewUid("ThreadMan-Vpl");
        this.threadWaitingList = ThreadWaitingList.createThreadWaitingList(6, this.uid, attr, 256);
        this.partitionid = partitionid;
        int totalVplSize = Utilities.alignUp(size, 7);
        this.sysMemInfo = Modules.SysMemUserForUserModule.malloc(partitionid, String.format("ThreadMan-Vpl-0x%x-%s", this.uid, name), memType, totalVplSize, 0);
        if (this.sysMemInfo == null) {
            throw new RuntimeException("SceKernelVplInfo: not enough free mem");
        }
        int addr = this.sysMemInfo.addr;
        Memory mem = Memory.getInstance();
        mem.write32(addr, addr - 1);
        mem.write32(addr + 4, size - 8);
        mem.write32(addr + 8, 0);
        mem.write32(addr + 12, addr + size - 16);
        mem.write32(addr + 16, 0);
        mem.write32(addr + 20, 0);
        this.allocAddress = addr;
        MemoryChunk initialMemoryChunk = new MemoryChunk(addr + 32, totalVplSize - 32);
        this.freeMemoryChunks = new MemoryChunkList(initialMemoryChunk);
    }

    public static SceKernelVplInfo tryCreateVpl(String name, int partitionid, int attr, int size, int memType) {
        int maxFreeSize;
        SceKernelVplInfo info = null;
        int totalVplSize = Utilities.alignUp(size, 7);
        if (totalVplSize <= (maxFreeSize = Modules.SysMemUserForUserModule.maxFreeMemSize())) {
            info = new SceKernelVplInfo(name, partitionid, attr, totalVplSize, memType);
        } else {
            VplManager.log.warn((Object)String.format("tryCreateVpl not enough free mem (want=%d ,free=%d, diff=%d)", totalVplSize, maxFreeSize, totalVplSize - maxFreeSize));
        }
        return info;
    }

    public void delete() {
        Modules.SysMemUserForUserModule.free(this.sysMemInfo);
    }

    @Override
    protected void write() {
        super.write();
        this.writeStringNZ(32, this.name);
        this.write32(this.attr);
        this.write32(this.poolSize);
        this.write32(this.freeSize);
        this.write32(this.getNumWaitingThreads());
    }

    public boolean free(int addr) {
        if (!this.dataBlockMap.containsKey(addr)) {
            if (VplManager.log.isDebugEnabled()) {
                VplManager.log.debug((Object)String.format("Free VPL 0x%08X address not allocated", addr));
            }
            return false;
        }
        Memory mem = Memory.getInstance();
        int top = mem.read32(addr - 8);
        if (top != this.allocAddress) {
            VplManager.log.warn((Object)String.format("Free VPL 0x%08X corrupted header", addr));
            return false;
        }
        int deallocSize = this.dataBlockMap.remove(addr);
        this.freeSize += deallocSize;
        MemoryChunk memoryChunk = new MemoryChunk(addr - 8, deallocSize);
        this.freeMemoryChunks.add(memoryChunk);
        if (VplManager.log.isDebugEnabled()) {
            VplManager.log.debug((Object)String.format("Free VPL: Block 0x%08X with size=%d freed", addr, deallocSize));
        }
        return true;
    }

    public int alloc(int size) {
        int addr = 0;
        int allocSize = Utilities.alignUp(size, 7) + 8;
        if (allocSize <= this.freeSize && (addr = (this.attr & 0x4000) == 16384 ? this.freeMemoryChunks.allocHigh(allocSize, 7) : this.freeMemoryChunks.allocLow(allocSize, 7)) != 0) {
            Memory mem = Memory.getInstance();
            mem.write32(addr, this.allocAddress);
            mem.write32(addr + 4, 0);
            this.freeSize -= allocSize;
            this.dataBlockMap.put(addr += 8, allocSize);
        }
        return addr;
    }

    public int getNumWaitingThreads() {
        return this.threadWaitingList.getNumWaitingThreads();
    }

    @Override
    public String toString() {
        return String.format("SceKernelVplInfo[uid=0x%X, name='%s', attr=0x%X, poolSize=0x%X, freeSize=0x%X]", this.uid, this.name, this.attr, this.poolSize, this.freeSize);
    }
}

