/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import java.util.LinkedList;
import java.util.List;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.modules150.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.NIDMapper;
import jpcsp.format.DeferredStub;
import jpcsp.format.PSF;
import jpcsp.format.PSPModuleInfo;
import jpcsp.util.Utilities;

public class SceModule {
    public int next;
    public short attribute;
    public byte[] version = new byte[2];
    public String modname;
    public final byte terminal = 0;
    public int status;
    public int unk1;
    public int modid;
    public int usermod_thid;
    public int memid;
    public int mpidtext;
    public int mpiddata;
    public int ent_top;
    public int ent_size;
    public int stub_top;
    public int stub_size;
    public int module_start_func;
    public int module_stop_func;
    public int module_bootstart_func;
    public int module_reboot_before_func;
    public int module_reboot_phase_func;
    public int entry_addr;
    public int gp_value;
    public int text_addr;
    public int text_size;
    public int data_size;
    public int bss_size;
    private List<SysMemUserForUser.SysMemInfo> allocatedMemory;
    public int nsegment;
    public int[] segmentaddr = new int[4];
    public int[] segmentsize = new int[4];
    public int module_start_thread_priority;
    public int module_start_thread_stacksize;
    public int module_start_thread_attr;
    public int module_stop_thread_priority;
    public int module_stop_thread_stacksize;
    public int module_stop_thread_attr;
    public int module_reboot_before_thread_priority;
    public int module_reboot_before_thread_stacksize;
    public int module_reboot_before_thread_attr;
    public static final int size = 196;
    public final int address;
    public final boolean isFlashModule;
    public boolean isLoaded;
    public boolean isStarted;
    public boolean isStopped;
    private static SceModule previousModule;
    public int fileFormat;
    public String pspfilename;
    public PSF psf;
    public int loadAddressLow;
    public int loadAddressHigh;
    public int baseAddress;
    public int[] initsection;
    public int[] finisection;
    public int[] stubtextsection;
    public List<DeferredStub> unresolvedImports;
    public int importFixupAttempts;
    public List<DeferredStub> resolvedImports;
    private static int sceModuleAddressOffset;

    public static void ResetAllocator() {
        sceModuleAddressOffset = 0x8400000;
    }

    public SceModule(boolean isFlashModule) {
        this.isFlashModule = isFlashModule;
        this.modid = SceUidManager.getNewUid("SceModule");
        this.address = sceModuleAddressOffset -= 256;
        if (previousModule != null) {
            SceModule.previousModule.next = this.address;
        }
        previousModule = this;
        this.fileFormat = 0;
        this.initsection = new int[2];
        this.finisection = new int[2];
        this.stubtextsection = new int[2];
        this.unresolvedImports = new LinkedList<DeferredStub>();
        this.importFixupAttempts = 0;
        this.resolvedImports = new LinkedList<DeferredStub>();
        this.allocatedMemory = new LinkedList<SysMemUserForUser.SysMemInfo>();
    }

    public void load() {
        this.isLoaded = true;
    }

    public void unload() {
        if (!this.resolvedImports.isEmpty()) {
            Memory mem = Memory.getInstance();
            for (DeferredStub deferredStub : this.resolvedImports) {
                deferredStub.unresolve(mem);
            }
            this.resolvedImports.clear();
        }
        NIDMapper.getInstance().removeModuleNids(this.modname);
        this.isLoaded = false;
        this.free();
    }

    public void start() {
        this.isStarted = true;
    }

    public void stop() {
        this.isStopped = true;
    }

    public boolean isModuleLoaded() {
        return this.isLoaded;
    }

    public boolean isModuleStarted() {
        return this.isStarted;
    }

    public boolean isModuleStopped() {
        return this.isStopped;
    }

    public void free() {
        for (SysMemUserForUser.SysMemInfo sysMemInfo : this.allocatedMemory) {
            Memory.getInstance().memset(sysMemInfo.addr, (byte)-1, sysMemInfo.size);
            Modules.SysMemUserForUserModule.free(sysMemInfo);
        }
        this.allocatedMemory.clear();
    }

    public void addAllocatedMemory(SysMemUserForUser.SysMemInfo sysMemInfo) {
        if (sysMemInfo != null) {
            this.allocatedMemory.add(sysMemInfo);
        }
    }

    public void write(Memory mem, int address) {
        mem.write32(address, this.next);
        mem.write16(address + 4, this.attribute);
        mem.write8(address + 6, this.version[0]);
        mem.write8(address + 7, this.version[1]);
        Utilities.writeStringNZ(mem, address + 8, 28, this.modname);
        mem.write32(address + 36, this.status);
        mem.write32(address + 40, this.unk1);
        mem.write32(address + 44, this.modid);
        mem.write32(address + 48, this.usermod_thid);
        mem.write32(address + 52, this.memid);
        mem.write32(address + 56, this.mpidtext);
        mem.write32(address + 60, this.mpiddata);
        mem.write32(address + 64, this.ent_top);
        mem.write32(address + 68, this.ent_size);
        mem.write32(address + 72, this.stub_top);
        mem.write32(address + 76, this.stub_size);
        mem.write32(address + 80, this.module_start_func);
        mem.write32(address + 84, this.module_stop_func);
        mem.write32(address + 88, this.module_bootstart_func);
        mem.write32(address + 92, this.module_reboot_before_func);
        mem.write32(address + 96, this.module_reboot_phase_func);
        mem.write32(address + 100, this.entry_addr);
        mem.write32(address + 104, this.gp_value);
        mem.write32(address + 108, this.text_addr);
        mem.write32(address + 112, this.text_size);
        mem.write32(address + 116, this.data_size);
        mem.write32(address + 120, this.bss_size);
        mem.write32(address + 124, this.nsegment);
        mem.write32(address + 128, this.segmentaddr[0]);
        mem.write32(address + 132, this.segmentaddr[1]);
        mem.write32(address + 136, this.segmentaddr[2]);
        mem.write32(address + 140, this.segmentaddr[3]);
        mem.write32(address + 144, this.segmentsize[0]);
        mem.write32(address + 148, this.segmentsize[1]);
        mem.write32(address + 152, this.segmentsize[2]);
        mem.write32(address + 156, this.segmentsize[3]);
        mem.write32(address + 160, this.module_start_thread_priority);
        mem.write32(address + 164, this.module_start_thread_stacksize);
        mem.write32(address + 168, this.module_start_thread_attr);
        mem.write32(address + 172, this.module_stop_thread_priority);
        mem.write32(address + 176, this.module_stop_thread_stacksize);
        mem.write32(address + 180, this.module_stop_thread_attr);
        mem.write32(address + 184, this.module_reboot_before_thread_priority);
        mem.write32(address + 188, this.module_reboot_before_thread_stacksize);
        mem.write32(address + 192, this.module_reboot_before_thread_attr);
    }

    public void read(Memory mem, int address) {
        this.next = mem.read32(address);
        this.attribute = (short)mem.read16(address + 4);
        this.version[0] = (byte)mem.read8(address + 6);
        this.version[1] = (byte)mem.read8(address + 7);
        this.modname = Utilities.readStringNZ(mem, address + 8, 28);
        this.status = mem.read32(address + 36);
        this.unk1 = mem.read32(address + 40);
        this.modid = mem.read32(address + 44);
        this.usermod_thid = mem.read32(address + 48);
        this.memid = mem.read32(address + 52);
        this.mpidtext = mem.read32(address + 56);
        this.mpiddata = mem.read32(address + 60);
        this.ent_top = mem.read32(address + 64);
        this.ent_size = mem.read32(address + 68);
        this.stub_top = mem.read32(address + 72);
        this.stub_size = mem.read32(address + 76);
        this.module_start_func = mem.read32(address + 80);
        this.module_stop_func = mem.read32(address + 84);
        this.module_bootstart_func = mem.read32(address + 88);
        this.module_reboot_before_func = mem.read32(address + 92);
        this.module_reboot_phase_func = mem.read32(address + 96);
        this.entry_addr = mem.read32(address + 100);
        this.gp_value = mem.read32(address + 104);
        this.text_addr = mem.read32(address + 108);
        this.text_size = mem.read32(address + 112);
        this.data_size = mem.read32(address + 116);
        this.bss_size = mem.read32(address + 120);
        this.nsegment = mem.read32(address + 124);
        this.segmentaddr[0] = mem.read32(address + 128);
        this.segmentaddr[1] = mem.read32(address + 132);
        this.segmentaddr[2] = mem.read32(address + 136);
        this.segmentaddr[3] = mem.read32(address + 140);
        this.segmentsize[0] = mem.read32(address + 144);
        this.segmentsize[1] = mem.read32(address + 148);
        this.segmentsize[2] = mem.read32(address + 152);
        this.segmentsize[3] = mem.read32(address + 156);
        this.module_start_thread_priority = mem.read32(address + 160);
        this.module_start_thread_stacksize = mem.read32(address + 164);
        this.module_start_thread_attr = mem.read32(address + 168);
        this.module_stop_thread_priority = mem.read32(address + 172);
        this.module_stop_thread_stacksize = mem.read32(address + 176);
        this.module_stop_thread_attr = mem.read32(address + 180);
        this.module_reboot_before_thread_priority = mem.read32(address + 184);
        this.module_reboot_before_thread_stacksize = mem.read32(address + 188);
        this.module_reboot_before_thread_attr = mem.read32(address + 192);
    }

    public void copy(PSPModuleInfo moduleInfo) {
        this.attribute = (short)(moduleInfo.getM_attr() & 0xFFFF);
        this.version[0] = (byte)(moduleInfo.getM_version() & 0xFF);
        this.version[1] = (byte)(moduleInfo.getM_version() >> 8 & 0xFF);
        this.modname = moduleInfo.getM_namez();
        this.gp_value = (int)((long)moduleInfo.getM_gp() & 0xFFFFFFFFL);
        this.ent_top = moduleInfo.getM_exports();
        this.ent_size = moduleInfo.getM_exp_end() - this.ent_top;
        this.stub_top = moduleInfo.getM_imports();
        this.stub_size = moduleInfo.getM_imp_end() - this.stub_top;
    }

    public String toString() {
        return String.format("SceModule '%s'", this.modname);
    }

    static {
        sceModuleAddressOffset = 0x8400000;
    }
}

