/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.crypto;

import java.nio.ByteBuffer;
import jpcsp.crypto.KIRK;
import jpcsp.crypto.KeyVault;

public class PRX {
    private static KIRK kirk;
    private TAG_INFO[] g_tagInfo = new TAG_INFO[]{new TAG_INFO(1284807920, KeyVault.keys210_vita_k0, 67), new TAG_INFO(1284805872, KeyVault.keys660_k1, 67), new TAG_INFO(1284806128, KeyVault.keys660_k2, 67), new TAG_INFO(1284804848, KeyVault.keys660_k3, 67), new TAG_INFO(1284805104, KeyVault.keys660_k8, 67), new TAG_INFO(1284805616, KeyVault.keys660_k4, 67), new TAG_INFO(1284806640, KeyVault.keys660_k5, 67), new TAG_INFO(1284805360, KeyVault.keys660_k6, 67), new TAG_INFO(1284806384, KeyVault.keys660_k7, 67), new TAG_INFO(1165725936, KeyVault.keys660_v1, 91), new TAG_INFO(1165726192, KeyVault.keys660_v7, 91), new TAG_INFO(1165726448, KeyVault.keys660_v6, 91), new TAG_INFO(1165726704, KeyVault.keys660_v3, 91), new TAG_INFO(939692272, KeyVault.keys660_v2, 90), new TAG_INFO(939692528, KeyVault.keys660_v8, 90), new TAG_INFO(939692784, KeyVault.keys660_v4, 90), new TAG_INFO(939693040, KeyVault.keys660_v5, 90), new TAG_INFO(1284803824, KeyVault.keys639_k3, 67), new TAG_INFO(1284804080, KeyVault.keys638_k4, 67), new TAG_INFO(1284803568, KeyVault.keys636_k2, 67), new TAG_INFO(1284803312, KeyVault.keys636_k1, 67), new TAG_INFO(1165724400, KeyVault.keys636_1, 91), new TAG_INFO(1284802544, KeyVault.keys630_k8, 67), new TAG_INFO(1165722608, KeyVault.keys630_k7, 91), new TAG_INFO(1284802288, KeyVault.keys630_k6, 67), new TAG_INFO(1165722352, KeyVault.keys630_k5, 91), new TAG_INFO(1165722096, KeyVault.keys630_k4, 91), new TAG_INFO(1284802032, KeyVault.keys630_k3, 67), new TAG_INFO(1165721840, KeyVault.keys630_k2, 91), new TAG_INFO(1284801776, KeyVault.keys630_k1, 67), new TAG_INFO(1165699312, KeyVault.keys620_e, 91), new TAG_INFO(1165692144, KeyVault.keys620_a, 91), new TAG_INFO(939665648, KeyVault.keys620_5v, 90), new TAG_INFO(1284778736, KeyVault.keys620_5k, 67), new TAG_INFO(1284778224, KeyVault.keys620_5, 67), new TAG_INFO(1284775408, KeyVault.keys620_1, 67), new TAG_INFO(1284775152, KeyVault.keys620_0, 67), new TAG_INFO(1284776688, KeyVault.keys600_2, 67), new TAG_INFO(1284775664, KeyVault.keys600_1, 67), new TAG_INFO(1284778480, KeyVault.keys570_5k, 67), new TAG_INFO(1165691888, KeyVault.keys505_a, 91), new TAG_INFO(1284774384, KeyVault.keys505_1, 67), new TAG_INFO(1284774128, KeyVault.keys505_0, 67), new TAG_INFO(1165696752, KeyVault.keys500_c, 91), new TAG_INFO(1284775920, KeyVault.keys500_2, 67), new TAG_INFO(1284773872, KeyVault.keys500_1, 67), new TAG_INFO(1284773616, KeyVault.keys500_0, 67), new TAG_INFO(1284773104, KeyVault.keys390_0, 67), new TAG_INFO(1284773360, KeyVault.keys390_1, 67), new TAG_INFO(1284772592, KeyVault.keys370_0, 67), new TAG_INFO(1284772848, KeyVault.keys370_1, 67), new TAG_INFO(1165693168, KeyVault.keys370_2, 91), new TAG_INFO(1284771312, KeyVault.keys360_0, 67), new TAG_INFO(1284772080, KeyVault.keys360_1, 67), new TAG_INFO(1284770800, KeyVault.keys330_0, 67), new TAG_INFO(1165691632, KeyVault.keys330_1, 91), new TAG_INFO(939657968, KeyVault.keys330_2, 90), new TAG_INFO(1284770544, KeyVault.keys330_3, 67), new TAG_INFO(1284771056, KeyVault.keys330_4, 67), new TAG_INFO(-806417936, KeyVault.keys310_0, 98), new TAG_INFO(1165691120, KeyVault.keys310_1, 91), new TAG_INFO(939657456, KeyVault.keys310_2, 90), new TAG_INFO(-806418192, KeyVault.keys310_3, 98), new TAG_INFO(-806418448, KeyVault.keys303_0, 98), new TAG_INFO(-806418704, KeyVault.keys300_0, 98), new TAG_INFO(1165690608, KeyVault.keys300_1, 91), new TAG_INFO(939656944, KeyVault.keys300_2, 90), new TAG_INFO(-806418960, KeyVault.keys280_0, 98), new TAG_INFO(1165690352, KeyVault.keys280_1, 91), new TAG_INFO(939656688, KeyVault.keys280_2, 90), new TAG_INFO(383098371, KeyVault.keys260_0, 98), new TAG_INFO(1981817859, KeyVault.keys260_1, 91), new TAG_INFO(251884291, KeyVault.keys260_2, 90), new TAG_INFO(1284771824, KeyVault.key_2DA8, 67), new TAG_INFO(1147617629, KeyVault.key_22E0, 89), new TAG_INFO(0, KeyVault.key_21C0, 66), new TAG_INFO(0x1000000, KeyVault.key_2250, 67), new TAG_INFO(777916656, KeyVault.key_2E5E10F0, 72), new TAG_INFO(777917168, KeyVault.key_2E5E12F0, 72), new TAG_INFO(777917424, KeyVault.key_2E5E13F0, 72), new TAG_INFO(802360304, KeyVault.key_2FD30BF0, 71), new TAG_INFO(802361840, KeyVault.key_2FD311F0, 71), new TAG_INFO(802362096, KeyVault.key_2FD312F0, 71), new TAG_INFO(802362352, KeyVault.key_2FD313F0, 71), new TAG_INFO(-652868112, KeyVault.key_D91605F0, 93), new TAG_INFO(-652867856, KeyVault.key_D91606F0, 93), new TAG_INFO(-652867344, KeyVault.key_D91608F0, 93), new TAG_INFO(-652867088, KeyVault.key_D91609F0, 93), new TAG_INFO(-652866832, KeyVault.key_D9160AF0, 93), new TAG_INFO(-652866576, KeyVault.key_D9160BF0, 93), new TAG_INFO(-652865040, KeyVault.key_D91611F0, 93), new TAG_INFO(-652864784, KeyVault.key_D91612F0, 93), new TAG_INFO(-652864528, KeyVault.key_D91613F0, 93), new TAG_INFO(-652864272, KeyVault.key_D91614F0, 93), new TAG_INFO(-652864016, KeyVault.key_D91615F0, 93), new TAG_INFO(-652863760, KeyVault.key_D91616F0, 93), new TAG_INFO(-652863504, KeyVault.key_D91617F0, 93), new TAG_INFO(-652863248, KeyVault.key_D91618F0, 93), new TAG_INFO(-652862992, KeyVault.key_D91619F0, 93), new TAG_INFO(-652862736, KeyVault.key_D9161AF0, 93), new TAG_INFO(-652861200, KeyVault.key_D91620F0, 93), new TAG_INFO(-652860944, KeyVault.key_D91621F0, 93), new TAG_INFO(-652860688, KeyVault.key_D91622F0, 93), new TAG_INFO(-652860432, KeyVault.key_D91623F0, 93), new TAG_INFO(-652860176, KeyVault.key_D91624F0, 93), new TAG_INFO(-652859152, KeyVault.key_D91628F0, 93), new TAG_INFO(-652836624, KeyVault.key_D91680F0, 93), new TAG_INFO(-652836368, KeyVault.key_D91681F0, 93), new TAG_INFO(-668790544, KeyVault.keys02G_E, 81), new TAG_INFO(-668786960, KeyVault.keys03G_E, 81), new TAG_INFO(-668784400, KeyVault.keys05G_E, 81), new TAG_INFO(664602864, KeyVault.oneseg_310, 97), new TAG_INFO(664602352, KeyVault.oneseg_300, 97), new TAG_INFO(664602096, KeyVault.oneseg_280, 97), new TAG_INFO(-697436413, KeyVault.oneseg_260_271, 97), new TAG_INFO(664604912, KeyVault.oneseg_slim, 97), new TAG_INFO(1009387760, KeyVault.ms_app_main, 103), new TAG_INFO(-1376582160, KeyVault.demokeys_280, 96), new TAG_INFO(-1376581904, KeyVault.demokeys_3XX_1, 96), new TAG_INFO(-1376581392, KeyVault.demokeys_3XX_2, 96), new TAG_INFO(-2147156733, KeyVault.ebootbin_271_new, 93), new TAG_INFO(-652868112, KeyVault.ebootbin_280_new, 93), new TAG_INFO(-652867856, KeyVault.ebootbin_300_new, 93), new TAG_INFO(-652867344, KeyVault.ebootbin_310_new, 93), new TAG_INFO(171305475, KeyVault.gameshare_260_271, 94), new TAG_INFO(2063926768, KeyVault.gameshare_280, 94), new TAG_INFO(2063927024, KeyVault.gameshare_300, 94), new TAG_INFO(2063927536, KeyVault.gameshare_310, 94), new TAG_INFO(939659504, KeyVault.key_380210F0, 90), new TAG_INFO(939688176, KeyVault.key_380280F0, 90), new TAG_INFO(939688944, KeyVault.key_380283F0, 90), new TAG_INFO(1081610480, KeyVault.key_407810F0, 106), new TAG_INFO(-383512336, KeyVault.drmkeys_6XX_1, 64), new TAG_INFO(1764233456, KeyVault.drmkeys_6XX_2, 64), new TAG_INFO(0, KeyVault.g_key0, 66, 0), new TAG_INFO(0x2000000, KeyVault.g_key2, 69, 0), new TAG_INFO(0x3000000, KeyVault.g_key3, 70, 0), new TAG_INFO(1147617629, KeyVault.g_key44, 89, 89), new TAG_INFO(544980783, KeyVault.g_key20, 90, 90), new TAG_INFO(986598862, KeyVault.g_key3A, 91, 91), new TAG_INFO(0x7000000, KeyVault.g_key_INDEXDAT1xx, 74), new TAG_INFO(0x8000000, KeyVault.g_keyEBOOT1xx, 75, 0), new TAG_INFO(-1060432260, KeyVault.g_keyEBOOT2xx, 93, 93), new TAG_INFO(0xB000000, KeyVault.g_keyUPDATER, 78, 0), new TAG_INFO(0xC000000, KeyVault.g_keyDEMOS27X, 79, 0), new TAG_INFO(0xF000000, KeyVault.g_keyMEIMG250, 82, 0), new TAG_INFO(-2044311343, KeyVault.g_keyMEIMG260, 82, 82), new TAG_INFO(544980783, KeyVault.g_keyUNK1, 90, 90), new TAG_INFO(0x9000000, KeyVault.g_key_GAMESHARE1xx, 76, 0), new TAG_INFO(-1150827105, KeyVault.g_key_GAMESHARE2xx, 94, 94)};

    public PRX() {
        kirk = new KIRK();
    }

    private TAG_INFO GetTagInfo(int tag) {
        for (int iTag = 0; iTag < this.g_tagInfo.length; ++iTag) {
            if (this.g_tagInfo[iTag].tag != tag) continue;
            return this.g_tagInfo[iTag];
        }
        return null;
    }

    private void ScramblePRX(byte[] buf, int size, byte code) {
        buf[0] = 0;
        buf[1] = 0;
        buf[2] = 0;
        buf[3] = 5;
        buf[4] = 0;
        buf[5] = 0;
        buf[6] = 0;
        buf[7] = 0;
        buf[8] = 0;
        buf[9] = 0;
        buf[10] = 0;
        buf[11] = 0;
        buf[12] = 0;
        buf[13] = 0;
        buf[14] = 0;
        buf[15] = code;
        buf[16] = (byte)(size >> 24 & 0xFF);
        buf[17] = (byte)(size >> 16 & 0xFF);
        buf[18] = (byte)(size >> 8 & 0xFF);
        buf[19] = (byte)(size & 0xFF);
        ByteBuffer bBuf = ByteBuffer.wrap(buf);
        kirk.hleUtilsBufferCopyWithRange(bBuf, size, bBuf, size, 7);
    }

    private static boolean isNullKey(byte[] key) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                if (key[i] == 0) continue;
                return false;
            }
        }
        return true;
    }

    private boolean TestBlacklist(byte[] inbuf, byte[] blacklist, int blacklistsize) {
        if (blacklistsize / 16 != 0) {
            for (int i = 0; i < blacklistsize / 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    byte b = blacklist[i * 16 + j];
                    byte bb = inbuf[320 + j];
                    if (b == bb) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void MixXOR(byte[] outbuf, int size, byte[] inbuf, byte[] xor) {
        for (int i = 0; i < size; ++i) {
            outbuf[i] = (byte)(inbuf[i] & 0xFF ^ xor[i] & 0xFF);
        }
    }

    private void RoundXOR(byte[] buf, int size, byte[] xor1, byte[] xor2) {
        for (int i = 0; i < size; ++i) {
            if (!PRX.isNullKey(xor1)) {
                int n = i;
                buf[n] = (byte)(buf[n] ^ xor1[i & 0xF]);
            }
            if (PRX.isNullKey(xor2)) continue;
            int n = i;
            buf[n] = (byte)(buf[n] ^ xor2[i & 0xF]);
        }
    }

    public int DecryptPRX(byte[] buf, int size, byte[] blacklist, int blacklistsize, int type, byte[] xor1, byte[] xor2) {
        byte[] buf1 = new byte[336];
        byte[] buf2 = new byte[336];
        byte[] buf3 = new byte[144];
        byte[] buf4 = new byte[180];
        byte[] buf5 = new byte[32];
        byte[] buf6 = new byte[40];
        byte[] sigbuf = new byte[40];
        byte[] sha1buf = new byte[20];
        int unk_0xD4 = 0;
        System.arraycopy(buf, 0, buf1, 0, 336);
        int tag = (buf[208] & 0xFF) << 24 | (buf[209] & 0xFF) << 16 | (buf[210] & 0xFF) << 8 | buf[211] & 0xFF;
        TAG_INFO pti = this.GetTagInfo(Integer.reverseBytes(tag));
        if (pti == null) {
            return -1;
        }
        if (blacklist != null && blacklistsize != 0 && this.TestBlacklist(buf1, blacklist, blacklistsize)) {
            return -1;
        }
        int retsize = (buf[179] & 0xFF) << 24 | (buf[178] & 0xFF) << 16 | (buf[177] & 0xFF) << 8 | buf[176] & 0xFF;
        if (pti.key.length > 16) {
            int i;
            byte[] oldbuf = new byte[size];
            byte[] oldbuf1 = new byte[336];
            System.arraycopy(buf, 0, oldbuf, 0, size);
            for (i = 0; i < 336; ++i) {
                oldbuf[i] = 0;
            }
            for (i = 0; i < 64; ++i) {
                oldbuf[i] = 85;
            }
            oldbuf[44] = 0;
            oldbuf[45] = 0;
            oldbuf[46] = 0;
            oldbuf[47] = 5;
            oldbuf[48] = 0;
            oldbuf[49] = 0;
            oldbuf[50] = 0;
            oldbuf[51] = 0;
            oldbuf[52] = 0;
            oldbuf[53] = 0;
            oldbuf[54] = 0;
            oldbuf[55] = 0;
            oldbuf[56] = 0;
            oldbuf[57] = 0;
            oldbuf[58] = 0;
            oldbuf[59] = (byte)pti.code;
            oldbuf[60] = 0;
            oldbuf[61] = 0;
            oldbuf[62] = 0;
            oldbuf[63] = 112;
            System.arraycopy(buf, 208, oldbuf1, 0, 128);
            System.arraycopy(buf, 128, oldbuf1, 128, 80);
            System.arraycopy(buf, 0, oldbuf1, 208, 128);
            if (pti.codeExtra != 0) {
                byte[] tmp = new byte[180];
                System.arraycopy(oldbuf1, 16, tmp, 20, 160);
                this.ScramblePRX(tmp, 160, (byte)pti.codeExtra);
                System.arraycopy(tmp, 0, oldbuf1, 16, 160);
            }
            System.arraycopy(oldbuf1, 64, oldbuf, 64, 64);
            for (int iXOR = 0; iXOR < 112; ++iXOR) {
                oldbuf[64 + iXOR] = (byte)(oldbuf[64 + iXOR] ^ (byte)pti.key[20 + iXOR]);
            }
            ByteBuffer bScrambleOut = ByteBuffer.allocate(oldbuf.length);
            ByteBuffer bScrambleIn = ByteBuffer.wrap(oldbuf);
            bScrambleIn.position(44);
            kirk.hleUtilsBufferCopyWithRange(bScrambleOut, 112, bScrambleIn, 112, 7);
            System.arraycopy(bScrambleOut.array(), 0, oldbuf, 44, 112);
            for (int iXOR = 111; iXOR >= 0; --iXOR) {
                oldbuf[64 + iXOR] = (byte)(oldbuf[44 + iXOR] ^ (byte)pti.key[32 + iXOR]);
            }
            for (int k = 0; k < 48; ++k) {
                oldbuf[k + 128] = 0;
            }
            oldbuf[160] = 0;
            oldbuf[161] = 0;
            oldbuf[162] = 0;
            oldbuf[163] = 1;
            System.arraycopy(buf, 176, oldbuf, 176, 32);
            System.arraycopy(buf, 0, oldbuf, 208, 128);
            ByteBuffer bDataOut = ByteBuffer.wrap(oldbuf);
            ByteBuffer bHeaderIn = bDataOut.duplicate();
            bHeaderIn.position(64);
            kirk.hleUtilsBufferCopyWithRange(bDataOut, size, bHeaderIn, size, 1);
            System.arraycopy(oldbuf, 0, buf, 0, size);
        } else {
            int i;
            int i2;
            if (type >= 2 && type <= 7 || type == 9 || type == 10) {
                for (i2 = 0; i2 < 9; ++i2) {
                    for (int j = 0; j < 16; ++j) {
                        buf2[20 + ((i2 << 4) + j)] = (byte)pti.key[j];
                    }
                    buf2[20 + (i2 << 4)] = (byte)i2;
                }
            } else {
                for (i2 = 0; i2 < 144; ++i2) {
                    buf2[20 + i2] = (byte)pti.key[i2];
                }
            }
            this.ScramblePRX(buf2, 144, (byte)(pti.code & 0xFF));
            if (!(type != 3 && type != 5 && type != 7 && type != 10 || PRX.isNullKey(xor2))) {
                this.RoundXOR(buf2, 144, xor2, null);
            }
            System.arraycopy(buf2, 0, buf3, 0, 144);
            if (type == 9 || type == 10) {
                System.arraycopy(buf, 260, buf6, 0, buf6.length);
                for (i2 = 0; i2 < buf6.length; ++i2) {
                    buf[260 + i2] = 0;
                }
                System.arraycopy(buf6, 0, sigbuf, 0, sigbuf.length);
                buf[0] = (byte)((size - 4 & 0xFF) << 24);
                buf[1] = (byte)((size - 4 & 0xFF) << 16);
                buf[2] = (byte)((size - 4 & 0xFF) << 8);
                buf[3] = (byte)(size - 4 & 0xFF);
                ByteBuffer bSHA1 = ByteBuffer.wrap(buf);
                kirk.hleUtilsBufferCopyWithRange(bSHA1, size, bSHA1, size, 11);
                System.arraycopy(buf, 0, sha1buf, 0, sha1buf.length);
                System.arraycopy(buf, 0, buf1, 0, 32);
                if ((tag << 16 & 0xFF & 0x16) == 22) {
                    System.arraycopy(KeyVault.g_pubkey_28752, 0, buf4, 0, KeyVault.g_pubkey_28752.length);
                } else if ((tag << 16 & 0xFF & 0x5E) == 94) {
                    System.arraycopy(KeyVault.g_pubkey_28712, 0, buf4, 0, KeyVault.g_pubkey_28712.length);
                } else {
                    System.arraycopy(KeyVault.g_pubkey_28672, 0, buf4, 0, KeyVault.g_pubkey_28672.length);
                }
                System.arraycopy(sha1buf, 0, buf4, 40, sha1buf.length);
                System.arraycopy(sigbuf, 0, buf4, 40 + sha1buf.length, sigbuf.length);
                ByteBuffer bECDSA = ByteBuffer.wrap(buf4);
                kirk.hleUtilsBufferCopyWithRange(null, 0, bECDSA, 100, 17);
            }
            if (type == 3) {
                System.arraycopy(buf1, 236, buf2, 0, 64);
                for (int i3 = 0; i3 < 80; ++i3) {
                    buf2[64 + i3] = 0;
                }
                buf2[96] = 3;
                buf2[112] = 80;
                System.arraycopy(buf1, 128, buf2, 144, 48);
                System.arraycopy(buf1, 192, buf2, 192, 16);
                System.arraycopy(buf1, 300, buf2, 208, 16);
                byte[] tmp = new byte[80];
                for (int i4 = 0; i4 < tmp.length; ++i4) {
                    tmp[i4] = buf2[144 + i4];
                }
                this.RoundXOR(tmp, 80, xor1, xor2);
                System.arraycopy(tmp, 0, buf2, 144, 80);
                ByteBuffer bSIGin = ByteBuffer.wrap(buf2);
                ByteBuffer bSIGout = ByteBuffer.wrap(buf4);
                kirk.hleUtilsBufferCopyWithRange(bSIGout, 180, bSIGin, 336, 3);
                System.arraycopy(buf1, 208, buf2, 0, 4);
                for (int i5 = 0; i5 < 88; ++i5) {
                    buf2[4 + i5] = 0;
                }
                System.arraycopy(buf1, 320, buf2, 92, 16);
                System.arraycopy(buf1, 300, buf2, 108, 20);
                System.arraycopy(buf4, 64, buf2, 108, 16);
                System.arraycopy(buf4, 0, buf2, 128, 48);
                System.arraycopy(buf4, 48, buf2, 176, 16);
                System.arraycopy(buf1, 176, buf2, 192, 16);
                System.arraycopy(buf1, 0, buf2, 208, 128);
            } else if (type == 5 || type == 7 || type == 10) {
                int i6;
                System.arraycopy(buf1, 128, buf2, 20, 48);
                System.arraycopy(buf1, 192, buf2, 68, 16);
                System.arraycopy(buf1, 300, buf2, 84, 16);
                byte[] tmp = new byte[80];
                for (i6 = 0; i6 < tmp.length; ++i6) {
                    tmp[i6] = buf2[20 + i6];
                }
                this.RoundXOR(tmp, 80, xor1, xor2);
                System.arraycopy(tmp, 0, buf2, 20, 80);
                this.ScramblePRX(buf2, 80, (byte)(pti.code & 0xFF));
                System.arraycopy(buf2, 0, buf4, 0, 80);
                System.arraycopy(buf1, 208, buf2, 0, 4);
                for (i6 = 0; i6 < 88; ++i6) {
                    buf2[4 + i6] = 0;
                }
                System.arraycopy(buf1, 320, buf2, 92, 16);
                System.arraycopy(buf1, 300, buf2, 108, 20);
                System.arraycopy(buf4, 64, buf2, 108, 16);
                System.arraycopy(buf4, 0, buf2, 128, 48);
                System.arraycopy(buf4, 48, buf2, 176, 16);
                System.arraycopy(buf1, 176, buf2, 192, 16);
                System.arraycopy(buf1, 0, buf2, 208, 128);
            } else if (type == 2 || type == 4 || type == 6 || type == 9) {
                System.arraycopy(buf1, 208, buf2, 0, 92);
                System.arraycopy(buf1, 320, buf2, 92, 16);
                System.arraycopy(buf1, 300, buf2, 108, 20);
                System.arraycopy(buf1, 128, buf2, 128, 48);
                System.arraycopy(buf1, 192, buf2, 176, 16);
                System.arraycopy(buf1, 176, buf2, 192, 16);
                System.arraycopy(buf1, 0, buf2, 208, 128);
            } else {
                System.arraycopy(buf1, 208, buf2, 0, 128);
                System.arraycopy(buf1, 128, buf2, 128, 80);
                System.arraycopy(buf1, 0, buf2, 208, 128);
            }
            if (type == 1) {
                System.arraycopy(buf2, 16, buf4, 20, 160);
                this.ScramblePRX(buf4, 160, (byte)(pti.code & 0xFF));
                System.arraycopy(buf4, 0, buf2, 16, 160);
            } else if (type >= 2 && type <= 7 || type == 9 || type == 10) {
                System.arraycopy(buf2, 92, buf4, 20, 96);
                if (type == 3 || type == 5 || type == 7 || type == 10) {
                    byte[] tmp = new byte[96];
                    for (int i7 = 0; i7 < tmp.length; ++i7) {
                        tmp[i7] = buf4[20 + i7];
                    }
                    this.RoundXOR(tmp, 96, xor1, null);
                    System.arraycopy(tmp, 0, buf4, 20, 96);
                }
                this.ScramblePRX(buf4, 96, (byte)(pti.code & 0xFF));
                System.arraycopy(buf4, 0, buf2, 92, 96);
            }
            if (type >= 2 && type <= 7 || type == 9 || type == 10) {
                int i8;
                System.arraycopy(buf2, 108, buf4, 0, 20);
                if (type == 4) {
                    System.arraycopy(buf2, 0, buf2, 24, 103);
                    for (i8 = 0; i8 < 24; ++i8) {
                        buf2[i8] = 0;
                    }
                } else {
                    System.arraycopy(buf2, 92, buf2, 112, 16);
                    if (type == 6 || type == 7) {
                        System.arraycopy(buf2, 60, buf5, 0, 32);
                        System.arraycopy(buf5, 0, buf2, 80, 32);
                        for (i8 = 0; i8 < 56; ++i8) {
                            buf2[24 + i8] = 0;
                        }
                    } else {
                        for (i8 = 0; i8 < 88; ++i8) {
                            buf2[24 + i8] = 0;
                        }
                    }
                    if (unk_0xD4 == 128) {
                        buf2[24] = -128;
                    }
                }
                System.arraycopy(buf2, 0, buf2, 4, 4);
                buf2[0] = 0;
                buf2[1] = 0;
                buf2[2] = 1;
                buf2[3] = 76;
                System.arraycopy(buf3, 0, buf2, 8, 16);
            } else {
                System.arraycopy(buf2, 4, buf4, 0, 20);
                buf2[0] = 0;
                buf2[1] = 0;
                buf2[2] = 1;
                buf2[3] = 76;
                System.arraycopy(buf3, 0, buf2, 4, 20);
            }
            ByteBuffer bSHA1Out = ByteBuffer.wrap(buf2);
            kirk.hleUtilsBufferCopyWithRange(bSHA1Out, 336, bSHA1Out, 336, 11);
            if (type >= 2 && type <= 7 || type == 9 || type == 10) {
                byte[] tmp1 = new byte[64];
                byte[] tmp2 = new byte[64];
                byte[] tmp3 = new byte[84];
                byte[] tmp4 = new byte[64];
                byte[] tmp5 = new byte[64];
                byte[] tmp6 = new byte[64];
                for (i = 0; i < 64; ++i) {
                    tmp1[i] = buf2[128 + i];
                    tmp2[i] = buf3[16 + i];
                }
                this.MixXOR(tmp1, 64, tmp1, tmp2);
                System.arraycopy(tmp1, 0, tmp3, 20, 64);
                this.ScramblePRX(tmp3, 64, (byte)(pti.code & 0xFF));
                System.arraycopy(tmp3, 0, buf2, 128, 64);
                for (i = 0; i < 64; ++i) {
                    tmp4[i] = buf[64 + i];
                    tmp5[i] = buf2[128 + i];
                    tmp6[i] = buf3[80 + i];
                }
                this.MixXOR(tmp4, 64, tmp5, tmp6);
                System.arraycopy(tmp4, 0, buf, 64, 64);
                if (type == 6 || type == 7) {
                    System.arraycopy(buf5, 0, buf, 128, 32);
                    for (i = 0; i < 16; ++i) {
                        buf[160 + i] = 0;
                    }
                    buf[164] = 0;
                    buf[165] = 0;
                    buf[166] = 0;
                    buf[167] = 1;
                    buf[160] = 0;
                    buf[161] = 0;
                    buf[162] = 0;
                    buf[163] = 1;
                } else {
                    for (i = 0; i < 48; ++i) {
                        buf[128 + i] = 0;
                    }
                    buf[160] = 0;
                    buf[161] = 0;
                    buf[162] = 0;
                    buf[163] = 1;
                }
                System.arraycopy(buf2, 192, buf, 176, 16);
                for (i = 0; i < 16; ++i) {
                    buf[192 + i] = 0;
                }
                System.arraycopy(buf2, 208, buf, 208, 128);
            } else {
                byte[] tmp7 = new byte[112];
                byte[] tmp8 = new byte[112];
                byte[] tmp9 = new byte[132];
                byte[] tmp10 = new byte[112];
                byte[] tmp11 = new byte[112];
                byte[] tmp12 = new byte[112];
                for (i = 0; i < 112; ++i) {
                    tmp7[i] = buf2[64 + i];
                    tmp8[i] = buf3[20 + i];
                }
                this.MixXOR(tmp7, 112, tmp7, tmp8);
                System.arraycopy(tmp7, 0, tmp9, 20, 112);
                this.ScramblePRX(tmp9, 112, (byte)(pti.code & 0xFF));
                System.arraycopy(tmp9, 0, buf2, 64, 64);
                for (i = 0; i < 112; ++i) {
                    tmp10[i] = buf[64 + i];
                    tmp11[i] = buf2[64 + i];
                    tmp12[i] = buf3[32 + i];
                }
                this.MixXOR(tmp10, 112, tmp11, tmp12);
                System.arraycopy(tmp10, 0, buf, 64, 112);
                System.arraycopy(buf2, 176, buf, 176, 160);
            }
            if (type == 8 && (buf[164] & 1) != 1) {
                return -1;
            }
            if (unk_0xD4 == 128) {
                if ((buf[1424] & 1) == 1) {
                    return -1;
                }
                buf[1424] = (byte)(buf[1424] | 0x80);
            }
            ByteBuffer bDataOut = ByteBuffer.wrap(buf);
            ByteBuffer bHeaderIn = bDataOut.duplicate();
            bHeaderIn.position(64);
            kirk.hleUtilsBufferCopyWithRange(bDataOut, size, bHeaderIn, size, 1);
            if (retsize < 336) {
                for (int i9 = 0; i9 < 336 - retsize; ++i9) {
                    buf[retsize + i9] = 0;
                }
            }
        }
        return retsize;
    }

    private class TAG_INFO {
        int tag;
        int[] key;
        int code;
        int codeExtra;

        public TAG_INFO(int tag, int[] key, int code, int codeExtra) {
            this.tag = tag;
            this.key = this.intArrayToTagArray(key);
            this.code = code;
            this.codeExtra = codeExtra;
        }

        public TAG_INFO(int tag, int[] key, int code) {
            this.tag = tag;
            this.key = key;
            this.code = code;
            this.codeExtra = 0;
        }

        private int[] intArrayToTagArray(int[] array) {
            int[] tagArray = new int[144];
            for (int i = 0; i < array.length; ++i) {
                tagArray[i * 4 + 3] = array[i] >> 24 & 0xFF;
                tagArray[i * 4 + 2] = array[i] >> 16 & 0xFF;
                tagArray[i * 4 + 1] = array[i] >> 8 & 0xFF;
                tagArray[i * 4 + 0] = array[i] & 0xFF;
            }
            return tagArray;
        }
    }
}

