/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.crypto;

import java.nio.ByteBuffer;
import jpcsp.Emulator;
import jpcsp.State;
import jpcsp.crypto.KIRK;
import jpcsp.crypto.KeyVault;
import jpcsp.format.PSF;

public class SAVEDATA {
    private static KIRK kirk;

    public SAVEDATA() {
        kirk = new KIRK();
    }

    private void ScrambleSD(byte[] buf, int size, int seed, int cbc, int kirk_code) {
        buf[0] = 0;
        buf[1] = 0;
        buf[2] = 0;
        buf[3] = (byte)cbc;
        buf[4] = 0;
        buf[5] = 0;
        buf[6] = 0;
        buf[7] = 0;
        buf[8] = 0;
        buf[9] = 0;
        buf[10] = 0;
        buf[11] = 0;
        buf[12] = 0;
        buf[13] = 0;
        buf[14] = 0;
        buf[15] = (byte)seed;
        buf[16] = (byte)(size >> 24 & 0xFF);
        buf[17] = (byte)(size >> 16 & 0xFF);
        buf[18] = (byte)(size >> 8 & 0xFF);
        buf[19] = (byte)(size & 0xFF);
        ByteBuffer bBuf = ByteBuffer.wrap(buf);
        kirk.hleUtilsBufferCopyWithRange(bBuf, size, bBuf, size, kirk_code);
    }

    private int hleSdSetIndex(SD_Ctx1 ctx, int encMode) {
        ctx.mode = encMode;
        return 0;
    }

    private int hleSdCreateList(SD_Ctx2 ctx, int encMode, int genMode, byte[] data, byte[] key) {
        if (key.length < 16) {
            return -1;
        }
        ctx.mode = encMode;
        ctx.unk = 1;
        if (genMode == 1) {
            int i;
            byte[] header = new byte[64];
            byte[] seed = new byte[20];
            byte[] tmp = new byte[44];
            ByteBuffer bSeed = ByteBuffer.wrap(seed);
            kirk.hleUtilsBufferCopyWithRange(bSeed, 20, null, 0, 14);
            System.arraycopy(seed, 0, tmp, 8, 20);
            for (i = 15; i >= 0; --i) {
                tmp[20 - i] = tmp[8 + i];
            }
            for (i = 0; i < 4; ++i) {
                tmp[40 + i] = 0;
            }
            System.arraycopy(tmp, 0, header, 20, 44);
            if (ctx.mode == 1) {
                this.ScrambleSD(header, 16, 4, 4, 4);
                System.arraycopy(header, 12, ctx.buf, 0, 16);
                System.arraycopy(header, 12, data, 0, 16);
                if (!SAVEDATA.isNullKey(key)) {
                    for (i = 0; i < 16; ++i) {
                        ((SD_Ctx2)ctx).buf[i] = (byte)(ctx.buf[i] ^ key[i]);
                    }
                }
                return 0;
            }
            if (ctx.mode == 2) {
                this.ScrambleSD(header, 16, 256, 4, 5);
                System.arraycopy(header, 12, ctx.buf, 0, 16);
                System.arraycopy(header, 12, data, 0, 16);
                if (!SAVEDATA.isNullKey(key)) {
                    for (i = 0; i < 16; ++i) {
                        ((SD_Ctx2)ctx).buf[i] = (byte)(ctx.buf[i] ^ key[i]);
                    }
                }
                return 0;
            }
            if (ctx.mode == 3) {
                for (i = 0; i < 16; ++i) {
                    header[32 + i] = (byte)(header[32 + i] ^ KeyVault.sdHashKey3[i]);
                }
                this.ScrambleSD(header, 16, 14, 4, 4);
                for (i = 0; i < 16; ++i) {
                    header[12 + i] = (byte)(header[12 + i] ^ KeyVault.sdHashKey4[i]);
                }
                System.arraycopy(header, 12, ctx.buf, 0, 16);
                System.arraycopy(header, 12, data, 0, 16);
                if (!SAVEDATA.isNullKey(key)) {
                    for (i = 0; i < 16; ++i) {
                        ((SD_Ctx2)ctx).buf[i] = (byte)(ctx.buf[i] ^ key[i]);
                    }
                }
                return 0;
            }
            if (ctx.mode == 4) {
                for (i = 0; i < 16; ++i) {
                    header[32 + i] = (byte)(header[32 + i] ^ KeyVault.sdHashKey3[i]);
                }
                this.ScrambleSD(header, 16, 256, 4, 5);
                for (i = 0; i < 16; ++i) {
                    header[12 + i] = (byte)(header[12 + i] ^ KeyVault.sdHashKey4[i]);
                }
                System.arraycopy(header, 12, ctx.buf, 0, 16);
                System.arraycopy(header, 12, data, 0, 16);
                if (!SAVEDATA.isNullKey(key)) {
                    for (i = 0; i < 16; ++i) {
                        ((SD_Ctx2)ctx).buf[i] = (byte)(ctx.buf[i] ^ key[i]);
                    }
                }
                return 0;
            }
            if (ctx.mode == 6) {
                for (i = 0; i < 16; ++i) {
                    header[32 + i] = (byte)(header[32 + i] ^ KeyVault.sdHashKey6[i]);
                }
                this.ScrambleSD(header, 16, 256, 4, 5);
                for (i = 0; i < 16; ++i) {
                    header[12 + i] = (byte)(header[12 + i] ^ KeyVault.sdHashKey7[i]);
                }
                System.arraycopy(header, 12, ctx.buf, 0, 16);
                System.arraycopy(header, 12, data, 0, 16);
                if (!SAVEDATA.isNullKey(key)) {
                    for (i = 0; i < 16; ++i) {
                        ((SD_Ctx2)ctx).buf[i] = (byte)(ctx.buf[i] ^ key[i]);
                    }
                }
                return 0;
            }
            for (i = 0; i < 16; ++i) {
                header[32 + i] = (byte)(header[32 + i] ^ KeyVault.sdHashKey6[i]);
            }
            this.ScrambleSD(header, 16, 18, 4, 4);
            for (i = 0; i < 16; ++i) {
                header[12 + i] = (byte)(header[12 + i] ^ KeyVault.sdHashKey7[i]);
            }
            System.arraycopy(header, 12, ctx.buf, 0, 16);
            System.arraycopy(header, 12, data, 0, 16);
            if (!SAVEDATA.isNullKey(key)) {
                for (i = 0; i < 16; ++i) {
                    ((SD_Ctx2)ctx).buf[i] = (byte)(ctx.buf[i] ^ key[i]);
                }
            }
            return 0;
        }
        if (genMode == 2) {
            System.arraycopy(data, 0, ctx.buf, 0, 16);
            if (!SAVEDATA.isNullKey(key)) {
                for (int i = 0; i < 16; ++i) {
                    ((SD_Ctx2)ctx).buf[i] = (byte)(ctx.buf[i] ^ key[i]);
                }
            }
            return 0;
        }
        return -1;
    }

    private int hleSdRemoveValue(SD_Ctx1 ctx, byte[] data, int length) {
        if (ctx.padSize > 16 || length < 0) {
            return -1;
        }
        if (ctx.padSize + length <= 16) {
            System.arraycopy(data, 0, ctx.pad, ctx.padSize, length);
            ctx.padSize += length;
            return 0;
        }
        int seed = 0;
        switch (ctx.mode) {
            case 6: {
                seed = 17;
                break;
            }
            case 4: {
                seed = 13;
                break;
            }
            case 2: {
                seed = 5;
                break;
            }
            case 1: {
                seed = 3;
                break;
            }
            case 3: {
                seed = 12;
                break;
            }
            default: {
                seed = 16;
            }
        }
        byte[] scrambleBuf = new byte[length + ctx.padSize + 20];
        System.arraycopy(ctx.pad, 0, scrambleBuf, 20, ctx.padSize);
        int kLen = ctx.padSize;
        ctx.padSize += length;
        ctx.padSize &= 15;
        if (ctx.padSize == 0) {
            ctx.padSize = 16;
        }
        System.arraycopy(data, length -= ctx.padSize, ctx.pad, 0, ctx.padSize);
        int blockSize = 0;
        int dataOffset = 0;
        while (length > 0) {
            blockSize = length + kLen >= 2048 ? 2048 : length + kLen;
            System.arraycopy(data, dataOffset, scrambleBuf, 20 + kLen, blockSize - kLen);
            for (int i = 0; i < 16; ++i) {
                scrambleBuf[20 + i] = (byte)(scrambleBuf[20 + i] ^ ctx.key[i]);
            }
            this.ScrambleSD(scrambleBuf, blockSize, seed, 4, 4);
            System.arraycopy(scrambleBuf, blockSize + 4 - 20, ctx.key, 0, 16);
            length -= blockSize - kLen;
            dataOffset += blockSize - kLen;
            kLen = 0;
        }
        return 0;
    }

    private int hleSdGetLastIndex(SD_Ctx1 ctx, byte[] hash, byte[] key) {
        int i;
        if (ctx.padSize > 16) {
            return -1;
        }
        byte[] scrambleEmptyBuf = new byte[36];
        byte[] keyBuf = new byte[16];
        byte[] scrambleKeyBuf = new byte[36];
        byte[] resultBuf = new byte[16];
        byte[] scrambleResultBuf = new byte[36];
        byte[] scrambleResultKeyBuf = new byte[36];
        int seed = 0;
        switch (ctx.mode) {
            case 6: {
                seed = 17;
                break;
            }
            case 4: {
                seed = 13;
                break;
            }
            case 2: {
                seed = 5;
                break;
            }
            case 1: {
                seed = 3;
                break;
            }
            case 3: {
                seed = 12;
                break;
            }
            default: {
                seed = 16;
            }
        }
        this.ScrambleSD(scrambleEmptyBuf, 16, seed, 4, 4);
        System.arraycopy(scrambleEmptyBuf, 0, keyBuf, 0, 16);
        int b = (keyBuf[0] & 0xFFFFFF80) != 0 ? -121 : 0;
        for (i = 0; i < 15; ++i) {
            keyBuf[i] = (byte)(keyBuf[i] << 1 | keyBuf[i + 1] >> 7 & 1);
        }
        keyBuf[15] = (byte)(keyBuf[15] << 1 ^ b);
        if (ctx.padSize < 16) {
            int i2;
            int bb = (keyBuf[0] & 0xFFFFFF80) != 0 ? -121 : 0;
            for (i2 = 0; i2 < 15; ++i2) {
                keyBuf[i2] = (byte)(keyBuf[i2] << 1 | keyBuf[i2 + 1] >> 7 & 1);
            }
            keyBuf[15] = (byte)(keyBuf[15] << 1 ^ bb);
            ((SD_Ctx1)ctx).pad[((SD_Ctx1)ctx).padSize] = -128;
            if (ctx.padSize + 1 < 16) {
                for (i2 = 0; i2 < 16 - ctx.padSize - 1; ++i2) {
                    ((SD_Ctx1)ctx).pad[((SD_Ctx1)ctx).padSize + 1 + i2] = 0;
                }
            }
        }
        for (i = 0; i < 16; ++i) {
            ((SD_Ctx1)ctx).pad[i] = (byte)(ctx.pad[i] ^ keyBuf[i]);
        }
        System.arraycopy(ctx.pad, 0, scrambleKeyBuf, 20, 16);
        System.arraycopy(ctx.key, 0, resultBuf, 0, 16);
        for (i = 0; i < 16; ++i) {
            scrambleKeyBuf[20 + i] = (byte)(scrambleKeyBuf[20 + i] ^ resultBuf[i]);
        }
        this.ScrambleSD(scrambleKeyBuf, 16, seed, 4, 4);
        System.arraycopy(scrambleKeyBuf, 0, resultBuf, 0, 16);
        if (ctx.mode == 6) {
            for (i = 0; i < 16; ++i) {
                resultBuf[i] = (byte)(resultBuf[i] ^ KeyVault.sdHashKey5[i]);
            }
        } else {
            for (i = 0; i < 16; ++i) {
                resultBuf[i] = (byte)(resultBuf[i] ^ KeyVault.sdHashKey2[i]);
            }
        }
        if (ctx.mode == 2 || ctx.mode == 4 || ctx.mode == 6) {
            System.arraycopy(resultBuf, 0, scrambleResultBuf, 20, 16);
            this.ScrambleSD(scrambleResultBuf, 16, 256, 4, 5);
            System.arraycopy(scrambleResultBuf, 0, scrambleResultBuf, 20, 16);
            for (i = 0; i < 20; ++i) {
                scrambleResultBuf[i] = 0;
            }
            this.ScrambleSD(scrambleResultBuf, 16, seed, 4, 4);
            System.arraycopy(scrambleResultBuf, 0, resultBuf, 0, 16);
        }
        if (key != null) {
            for (i = 0; i < 16; ++i) {
                resultBuf[i] = (byte)(resultBuf[i] ^ key[i]);
            }
            System.arraycopy(resultBuf, 0, scrambleResultKeyBuf, 20, 16);
            this.ScrambleSD(scrambleResultKeyBuf, 16, seed, 4, 4);
            System.arraycopy(scrambleResultKeyBuf, 0, resultBuf, 0, 16);
        }
        System.arraycopy(resultBuf, 0, hash, 0, 16);
        ctx.mode = 0;
        ctx.padSize = 0;
        for (i = 0; i < 16; ++i) {
            ((SD_Ctx1)ctx).pad[i] = 0;
        }
        for (i = 0; i < 16; ++i) {
            ((SD_Ctx1)ctx).key[i] = 0;
        }
        return 0;
    }

    private int hleSdSetMember(SD_Ctx2 ctx, byte[] data, int length) {
        int i;
        if (length <= 0) {
            return -1;
        }
        int finalSeed = 0;
        byte[] dataBuf = new byte[length + 20];
        byte[] keyBuf = new byte[32];
        byte[] hashBuf = new byte[16];
        System.arraycopy(ctx.buf, 0, dataBuf, 20, 16);
        if (ctx.mode == 1) {
            this.ScrambleSD(dataBuf, 16, 4, 5, 7);
            finalSeed = 83;
        } else if (ctx.mode == 2) {
            this.ScrambleSD(dataBuf, 16, 256, 5, 8);
            finalSeed = 83;
        } else if (ctx.mode == 3) {
            for (i = 0; i < 16; ++i) {
                dataBuf[20 + i] = (byte)(dataBuf[20 + i] ^ KeyVault.sdHashKey4[i]);
            }
            this.ScrambleSD(dataBuf, 16, 14, 5, 7);
            for (i = 0; i < 16; ++i) {
                dataBuf[i] = (byte)(dataBuf[i] ^ KeyVault.sdHashKey3[i]);
            }
            finalSeed = 87;
        } else if (ctx.mode == 4) {
            for (i = 0; i < 16; ++i) {
                dataBuf[20 + i] = (byte)(dataBuf[20 + i] ^ KeyVault.sdHashKey4[i]);
            }
            this.ScrambleSD(dataBuf, 16, 256, 5, 8);
            for (i = 0; i < 16; ++i) {
                dataBuf[i] = (byte)(dataBuf[i] ^ KeyVault.sdHashKey3[i]);
            }
            finalSeed = 87;
        } else if (ctx.mode == 6) {
            for (i = 0; i < 16; ++i) {
                dataBuf[20 + i] = (byte)(dataBuf[20 + i] ^ KeyVault.sdHashKey7[i]);
            }
            this.ScrambleSD(dataBuf, 16, 256, 5, 8);
            for (i = 0; i < 16; ++i) {
                dataBuf[i] = (byte)(dataBuf[i] ^ KeyVault.sdHashKey6[i]);
            }
            finalSeed = 100;
        } else {
            for (i = 0; i < 16; ++i) {
                dataBuf[20 + i] = (byte)(dataBuf[20 + i] ^ KeyVault.sdHashKey7[i]);
            }
            this.ScrambleSD(dataBuf, 16, 18, 5, 7);
            for (i = 0; i < 16; ++i) {
                dataBuf[i] = (byte)(dataBuf[i] ^ KeyVault.sdHashKey6[i]);
            }
            finalSeed = 100;
        }
        System.arraycopy(dataBuf, 0, keyBuf, 16, 16);
        if (ctx.unk != 1) {
            System.arraycopy(keyBuf, 16, keyBuf, 0, 12);
            keyBuf[12] = (byte)(ctx.unk - 1 & 0xFF);
            keyBuf[13] = (byte)(ctx.unk - 1 >> 8 & 0xFF);
            keyBuf[14] = (byte)(ctx.unk - 1 >> 16 & 0xFF);
            keyBuf[15] = (byte)(ctx.unk - 1 >> 24 & 0xFF);
        }
        for (i = 20; i < length + 20; i += 16) {
            System.arraycopy(keyBuf, 16, dataBuf, i, 12);
            dataBuf[i + 12] = (byte)(ctx.unk & 0xFF);
            dataBuf[i + 13] = (byte)(ctx.unk >> 8 & 0xFF);
            dataBuf[i + 14] = (byte)(ctx.unk >> 16 & 0xFF);
            dataBuf[i + 15] = (byte)(ctx.unk >> 24 & 0xFF);
            ctx.unk++;
        }
        System.arraycopy(dataBuf, length + 4, hashBuf, 0, 16);
        this.ScrambleSD(dataBuf, length, finalSeed, 5, 7);
        for (i = 0; i < 16; ++i) {
            dataBuf[i] = (byte)(dataBuf[i] ^ keyBuf[i]);
        }
        System.arraycopy(hashBuf, 0, keyBuf, 0, 16);
        for (i = 0; i < length; ++i) {
            data[i] = (byte)(data[i] ^ dataBuf[i]);
        }
        return 0;
    }

    private int hleChnnlsv_21BE78B4(SD_Ctx2 ctx) {
        ctx.mode = 0;
        ctx.unk = 0;
        for (int i = 0; i < 16; ++i) {
            ((SD_Ctx2)ctx).buf[i] = 0;
        }
        return 0;
    }

    private static boolean isNullKey(byte[] key) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                if (key[i] == 0) continue;
                return false;
            }
        }
        return true;
    }

    public byte[] DecryptSavedata(byte[] buf, int size, byte[] key) {
        SD_Ctx1 ctx1 = new SD_Ctx1();
        SD_Ctx2 ctx2 = new SD_Ctx2();
        int alignedSize = size + 15 >> 4 << 4;
        byte[] tmpbuf = new byte[alignedSize];
        byte[] hash = new byte[16];
        int sdDecMode = SAVEDATA.isNullKey(key) ? 1 : (Emulator.getInstance().getFirmwareVersion() > 271 && !State.discId.equals("ULUS10195") && !State.discId.equals("ULES00622") && !State.discId.equals("ULUS10193") && !State.discId.equals("ULES00608") && !State.discId.equals("ULUS10150") && !State.discId.equals("ULES00623") ? 5 : 3);
        this.hleSdSetIndex(ctx1, sdDecMode);
        this.hleSdCreateList(ctx2, sdDecMode, 2, buf, key);
        this.hleSdRemoveValue(ctx1, buf, 16);
        System.arraycopy(buf, 16, tmpbuf, 0, size - 16);
        this.hleSdRemoveValue(ctx1, tmpbuf, alignedSize);
        this.hleSdSetMember(ctx2, tmpbuf, alignedSize);
        this.hleChnnlsv_21BE78B4(ctx2);
        this.hleSdGetLastIndex(ctx1, hash, key);
        System.arraycopy(tmpbuf, 0, buf, 0, alignedSize - 16);
        return hash;
    }

    public byte[] EncryptSavedata(byte[] buf, int size, byte[] key) {
        SD_Ctx1 ctx1 = new SD_Ctx1();
        SD_Ctx2 ctx2 = new SD_Ctx2();
        int alignedSize = size + 15 >> 4 << 4;
        byte[] tmpbuf1 = new byte[alignedSize + 16];
        byte[] tmpbuf2 = new byte[alignedSize];
        byte[] hash = new byte[16];
        System.arraycopy(buf, 0, tmpbuf1, 16, size);
        int sdEncMode = SAVEDATA.isNullKey(key) ? 1 : (Emulator.getInstance().getFirmwareVersion() > 271 && !State.discId.equals("ULUS10195") && !State.discId.equals("ULES00622") && !State.discId.equals("ULUS10193") && !State.discId.equals("ULES00608") && !State.discId.equals("ULUS10150") && !State.discId.equals("ULES00623") ? 5 : 3);
        this.hleSdCreateList(ctx2, sdEncMode, 1, tmpbuf1, key);
        this.hleSdSetIndex(ctx1, sdEncMode);
        this.hleSdRemoveValue(ctx1, tmpbuf1, 16);
        System.arraycopy(tmpbuf1, 16, tmpbuf2, 0, alignedSize);
        this.hleSdSetMember(ctx2, tmpbuf2, alignedSize);
        for (int i = 0; i < alignedSize - size; ++i) {
            tmpbuf2[size + i] = 0;
        }
        this.hleSdRemoveValue(ctx1, tmpbuf2, alignedSize);
        System.arraycopy(tmpbuf2, 0, tmpbuf1, 16, alignedSize);
        System.arraycopy(tmpbuf1, 0, buf, 0, buf.length);
        this.hleChnnlsv_21BE78B4(ctx2);
        this.hleSdGetLastIndex(ctx1, hash, key);
        return hash;
    }

    private byte[] GenerateSavedataHash(byte[] data, int size, int mode, byte[] key) {
        SD_Ctx1 ctx1 = new SD_Ctx1();
        byte[] hash = new byte[16];
        this.hleSdSetIndex(ctx1, mode);
        this.hleSdRemoveValue(ctx1, data, size);
        this.hleSdGetLastIndex(ctx1, hash, key);
        return hash;
    }

    public void UpdateSavedataHashes(PSF psf, byte[] data, int size, byte[] params) {
        byte[] savedataParams = new byte[128];
        byte[] key = new byte[16];
        byte[] hash_0x70 = new byte[16];
        byte[] hash_0x20 = new byte[16];
        byte[] hash_0x10 = new byte[16];
        int mode = 4;
        int check_bit = 1;
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == 0) continue;
            mode = params[0] >> 4 & 0xF;
            check_bit = params[0] & 0xF;
            break;
        }
        if ((mode & 4) == 4) {
            hash_0x20 = this.GenerateSavedataHash(data, size, 6, key);
            hash_0x70 = this.GenerateSavedataHash(data, size, 5, key);
            savedataParams[0] = (byte)(savedataParams[0] | 0x40);
        } else if ((mode & 2) == 2) {
            hash_0x20 = this.GenerateSavedataHash(data, size, 4, key);
            hash_0x70 = this.GenerateSavedataHash(data, size, 3, key);
            savedataParams[0] = (byte)(savedataParams[0] | 0x20);
        } else {
            hash_0x20 = this.GenerateSavedataHash(data, size, 2, key);
            savedataParams[0] = (byte)(savedataParams[0] | 0);
        }
        if ((check_bit & 1) == 1) {
            hash_0x10 = this.GenerateSavedataHash(data, size, 1, key);
            savedataParams[0] = (byte)(savedataParams[0] | 1);
        }
        System.arraycopy(hash_0x20, 0, savedataParams, 32, 16);
        System.arraycopy(hash_0x70, 0, savedataParams, 112, 16);
        System.arraycopy(hash_0x10, 0, savedataParams, 16, 16);
        try {
            psf.put("SAVEDATA_PARAMS", savedataParams);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private class SD_Ctx2 {
        private int mode = 0;
        private int unk = 0;
        private byte[] buf = new byte[16];
    }

    private class SD_Ctx1 {
        private int mode = 0;
        private byte[] key = new byte[16];
        private byte[] pad = new byte[16];
        private int padSize = 0;
    }
}

