/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.filesystems.umdiso.iso9660;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Iso9660File {
    private int fileLBA;
    private int fileSize;
    private int fileProperties;
    private String fileName;
    private Date timestamp;

    private int Ubyte(byte b) {
        return b & 0xFF;
    }

    public Iso9660File(byte[] data, int length) throws IOException {
        this.fileLBA = this.Ubyte(data[1]) | this.Ubyte(data[2]) << 8 | this.Ubyte(data[3]) << 16 | data[4] << 24;
        this.fileSize = this.Ubyte(data[9]) | this.Ubyte(data[10]) << 8 | this.Ubyte(data[11]) << 16 | data[12] << 24;
        int year = this.Ubyte(data[17]);
        int month = this.Ubyte(data[18]);
        int day = this.Ubyte(data[19]);
        int hour = this.Ubyte(data[20]);
        int minute = this.Ubyte(data[21]);
        int second = this.Ubyte(data[22]);
        byte gmtOffset = data[23];
        int gmtOffsetHours = gmtOffset / 4;
        int gmtOffsetMinutes = gmtOffset % 4 * 15;
        String timeZoneName = "GMT";
        if (gmtOffset >= 0) {
            timeZoneName = timeZoneName + "+";
        }
        timeZoneName = timeZoneName + gmtOffsetHours;
        if (gmtOffsetMinutes > 0) {
            if (gmtOffsetMinutes < 10) {
                timeZoneName = timeZoneName + "0";
            }
            timeZoneName = timeZoneName + gmtOffsetMinutes;
        }
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneName);
        Calendar timestampCalendar = Calendar.getInstance(timeZone);
        timestampCalendar.set(1900 + year, month - 1, day, hour, minute, second);
        this.timestamp = timestampCalendar.getTime();
        this.fileProperties = data[24];
        if (this.fileLBA < 0 || this.fileSize < 0) {
            throw new IOException("WTF?! Size or lba < 0?!");
        }
        int fileNameLength = data[31];
        this.fileName = "";
        for (int i = 0; i < fileNameLength; ++i) {
            char c = (char)data[32 + i];
            if (c == '\u0000') {
                c = '.';
            }
            this.fileName = this.fileName + c;
        }
    }

    public int getLBA() {
        return this.fileLBA;
    }

    public int getSize() {
        return this.fileSize;
    }

    public int getProperties() {
        return this.fileProperties;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return this.fileName;
    }
}

