/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.capture;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules.sceDisplay;

public class CaptureFrameBufDetails {
    private static final int packetSize = 16;
    private int topaddrFb;
    private int bufferwidthFb;
    private int pixelformatFb;
    private int sync;

    public CaptureFrameBufDetails() {
        sceDisplay display = Modules.sceDisplayModule;
        this.topaddrFb = display.getTopAddrFb();
        this.bufferwidthFb = display.getBufferWidthFb();
        this.pixelformatFb = display.getPixelFormatFb();
        this.sync = display.getSync();
    }

    public void write(OutputStream out) throws IOException {
        DataOutputStream data = new DataOutputStream(out);
        data.writeInt(16);
        data.writeInt(this.topaddrFb);
        data.writeInt(this.bufferwidthFb);
        data.writeInt(this.pixelformatFb);
        data.writeInt(this.sync);
    }

    public static CaptureFrameBufDetails read(InputStream in) throws IOException {
        CaptureFrameBufDetails details = new CaptureFrameBufDetails();
        DataInputStream data = new DataInputStream(in);
        int sizeRemaining = data.readInt();
        if (sizeRemaining >= 16) {
            details.topaddrFb = data.readInt();
            sizeRemaining -= 4;
            details.bufferwidthFb = data.readInt();
            sizeRemaining -= 4;
            details.pixelformatFb = data.readInt();
            sizeRemaining -= 4;
        } else {
            throw new IOException("Not enough bytes remaining in stream");
        }
        details.sync = data.readInt();
        data.skipBytes(sizeRemaining -= 4);
        return details;
    }

    public void commit() {
        sceDisplay display = Modules.sceDisplayModule;
        display.hleDisplaySetFrameBuf(this.topaddrFb, this.bufferwidthFb, this.pixelformatFb, this.sync);
    }
}

