/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.capture;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CaptureHeader {
    public static final int PACKET_TYPE_RESERVED = 0;
    public static final int PACKET_TYPE_LIST = 1;
    public static final int PACKET_TYPE_RAM = 2;
    public static final int PACKET_TYPE_DISPLAY_DETAILS = 3;
    public static final int PACKET_TYPE_FRAMEBUF_DETAILS = 4;
    private static final int size = 4;
    private int packetType;

    public CaptureHeader(int packetType) {
        this.packetType = packetType;
    }

    public void write(OutputStream out) throws IOException {
        DataOutputStream data = new DataOutputStream(out);
        data.writeInt(4);
        data.writeInt(this.packetType);
    }

    private CaptureHeader() {
    }

    public static CaptureHeader read(InputStream in) throws IOException {
        CaptureHeader header = new CaptureHeader();
        DataInputStream data = new DataInputStream(in);
        int sizeRemaining = data.readInt();
        if (sizeRemaining < 4) {
            throw new IOException("Not enough bytes remaining in stream");
        }
        header.packetType = data.readInt();
        data.skipBytes(sizeRemaining -= 4);
        return header;
    }

    public int getPacketType() {
        return this.packetType;
    }
}

