/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.util;

import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.modules150.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceGu {
    private static Logger log = Logger.getLogger((String)"sceGu");
    private SysMemUserForUser.SysMemInfo sysMemInfo;
    private int bottomAddr;
    private int topAddr;
    private int listAddr;
    private IMemoryWriter listWriter;
    private int listId = -1;

    public sceGu(int totalMemorySize) {
        this.sysMemInfo = Modules.SysMemUserForUserModule.malloc(1, "sceGu", 0, totalMemorySize, 0);
        if (this.sysMemInfo == null) {
            log.error((Object)String.format("Cannot allocate sceGu memory, size=0x%X", totalMemorySize));
        }
    }

    public int sceGuGetMemory(int size) {
        if (this.topAddr - (size = Utilities.alignUp(size, 3)) < this.listWriter.getCurrentAddress()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceGuGetMemory size=0x%X - not enough memory, available=0x%X", size, this.topAddr - this.listWriter.getCurrentAddress()));
            }
            return 0;
        }
        this.topAddr -= size;
        return this.topAddr;
    }

    public void free() {
        if (this.sysMemInfo != null) {
            Modules.SysMemUserForUserModule.free(this.sysMemInfo);
            this.sysMemInfo = null;
        }
        this.bottomAddr = 0;
        this.topAddr = 0;
        this.listWriter = null;
    }

    public void sendCommandi(int cmd, int argument) {
        this.listWriter.writeNext(cmd << 24 | argument & 0xFFFFFF);
    }

    public void sendCommandf(int cmd, float argument) {
        this.sendCommandi(cmd, Float.floatToRawIntBits(argument) >> 8);
    }

    protected void sendCommandBase(int cmd, int address) {
        this.sendCommandi(16, (address & 0xFF000000) >>> 8);
        this.sendCommandi(cmd, address & 0xFFFFFF);
    }

    public void sceGuStart() {
        if (this.sysMemInfo != null) {
            this.bottomAddr = this.sysMemInfo.addr;
            this.topAddr = this.sysMemInfo.addr + this.sysMemInfo.size;
        } else {
            int reservedSize = 0x110000;
            this.bottomAddr = 0x4000000 + reservedSize;
            this.topAddr = this.bottomAddr + (0x200000 - reservedSize);
        }
        this.listAddr = this.bottomAddr;
        this.listWriter = MemoryWriter.getMemoryWriter(this.listAddr, 4);
        this.listId = -1;
        Memory.getInstance().memset(this.bottomAddr, (byte)0, this.topAddr - this.bottomAddr);
        this.sceGuOffsetAddr(0);
        this.sendCommandi(16, 0);
    }

    public void sceGuFinish() {
        this.sendCommandi(15, 0);
        this.sendCommandi(12, 0);
        if (this.topAddr < this.listWriter.getCurrentAddress()) {
            log.error((Object)String.format("sceGu memory overwrite mem=%s, listAddr=0x%08X, topAddr=0x%08X", this.sysMemInfo, this.listWriter.getCurrentAddress(), this.topAddr));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceGu memory usage free=0x%X, mem=%s, listAddr=0x%08X, topAddr=0x%08X", this.topAddr - this.listWriter.getCurrentAddress(), this.sysMemInfo, this.listWriter.getCurrentAddress(), this.topAddr));
        }
        this.listWriter.flush();
        int saveContextAddr = this.sceGuGetMemory(2048);
        Memory mem = Memory.getInstance();
        this.listId = Modules.sceGe_userModule.hleGeListEnQueue(new TPointer(mem, this.listAddr), TPointer.NULL, -1, TPointer.NULL, saveContextAddr);
    }

    public boolean isListDrawing() {
        if (this.listId < 0) {
            return false;
        }
        int listState = Modules.sceGe_userModule.hleGeListSync(this.listId);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceGu list 0x%X: state %d", this.listId, listState));
        }
        return listState == 2 || listState == 1;
    }

    private void sceGuSetFlag(int flag, int value) {
        switch (flag) {
            case 0: {
                this.sendCommandi(34, value);
                break;
            }
            case 1: {
                this.sendCommandi(35, value);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.sendCommandi(36, value);
                break;
            }
            case 4: {
                this.sendCommandi(33, value);
                break;
            }
            case 5: {
                this.sendCommandi(29, value);
                break;
            }
            case 6: {
                this.sendCommandi(32, value);
                break;
            }
            case 7: {
                this.sendCommandi(31, value);
                break;
            }
            case 8: {
                this.sendCommandi(28, value);
                break;
            }
            case 9: {
                this.sendCommandi(30, value);
                break;
            }
            case 10: {
                this.sendCommandi(23, value);
                break;
            }
            case 11: {
                this.sendCommandi(24, value);
                break;
            }
            case 12: {
                this.sendCommandi(25, value);
                break;
            }
            case 13: {
                this.sendCommandi(26, value);
                break;
            }
            case 14: {
                this.sendCommandi(27, value);
                break;
            }
            case 15: {
                this.sendCommandi(37, value);
                break;
            }
            case 16: {
                this.sendCommandi(38, value);
                break;
            }
            case 17: {
                this.sendCommandi(39, value);
                break;
            }
            case 18: {
                this.sendCommandi(40, value);
                break;
            }
            case 19: {
                this.sendCommandi(81, value);
                break;
            }
            case 20: {
                this.sendCommandi(56, value);
                break;
            }
        }
    }

    public void sceGuEnable(int flag) {
        this.sceGuSetFlag(flag, 1);
    }

    public void sceGuDisable(int flag) {
        this.sceGuSetFlag(flag, 0);
    }

    public void sceGuDrawArray(int prim, int vtype, int count, int indices, int vertices) {
        if (vtype != 0) {
            this.sendCommandi(18, vtype);
        }
        if (indices != 0) {
            this.sendCommandBase(2, indices);
        }
        if (vertices != 0) {
            this.sendCommandBase(1, vertices);
        }
        this.sendCommandi(4, prim << 16 | count & 0xFFFF);
    }

    private int getExp(int val) {
        int i;
        for (i = 9; i > 0 && (val >> i & 1) == 0; --i) {
        }
        return i;
    }

    public void sceGuTexImage(int mipmap, int width, int height, int tbw, int tbp) {
        this.sendCommandi(160 + mipmap, tbp & 0xFFFFFF);
        this.sendCommandi(168 + mipmap, (tbp & 0xFF000000) >>> 8 | tbw & 0xFFFF);
        this.sendCommandi(184 + mipmap, this.getExp(height) << 8 | this.getExp(width));
        this.sendCommandi(203, 0);
    }

    public void sceGuTexMode(int tpsm, int maxMipmaps, boolean swizzle) {
        this.sendCommandi(194, maxMipmaps << 16 | (swizzle ? 1 : 0));
        this.sendCommandi(195, tpsm);
    }

    public void sceGuClutMode(int cpsm, int shift, int mask, int start) {
        this.sendCommandi(197, cpsm | shift << 12 | mask << 8 | start << 16);
    }

    public void sceGuClutLoad(int numBlocks, int cbp) {
        this.sendCommandi(176, cbp & 0xFFFFFF);
        this.sendCommandi(177, (cbp & 0xFF000000) >>> 8);
        this.sendCommandi(196, numBlocks);
    }

    public void sceGuTexFunc(int textureFunc, boolean textureAlphaUsed, boolean textureColorDoubled) {
        this.sendCommandi(201, textureFunc | (textureAlphaUsed ? 1 : 0) << 8 | (textureColorDoubled ? 1 : 0) << 16);
    }

    public void sceGuBlendFunc(int op, int src, int dest, int srcFix, int destFix) {
        this.sendCommandi(223, src | dest << 4 | op << 8);
        if (src >= 10) {
            this.sendCommandi(224, srcFix);
        }
        if (dest >= 10) {
            this.sendCommandi(225, destFix);
        }
    }

    public void sceGuOffsetAddr(int offsetAddr) {
        this.sendCommandi(19, offsetAddr >>> 8);
    }

    public void sceGuTexEnvColor(int color) {
        this.sendCommandi(202, color & 0xFFFFFF);
    }

    public void sceGuTexWrap(int u, int v) {
        this.sendCommandi(199, v << 8 | u);
    }

    public void sceGuTexFilter(int min, int mag) {
        this.sendCommandi(198, mag << 8 | min);
    }

    public void sceGuDrawHorizontalLine(int x0, int x1, int y, int color) {
        this.sceGuDrawLine(x0, y, x1, y, color);
    }

    public void sceGuDrawLine(int x0, int y0, int x1, int y1, int color) {
        int numberOfVertex = 2;
        int lineVertexAddr = this.sceGuGetMemory(12 * numberOfVertex);
        IMemoryWriter lineVertexWriter = MemoryWriter.getMemoryWriter(lineVertexAddr, 2);
        lineVertexWriter.writeNext(color & 0xFFFF);
        lineVertexWriter.writeNext(color >>> 16);
        lineVertexWriter.writeNext(x0);
        lineVertexWriter.writeNext(y0);
        lineVertexWriter.writeNext(0);
        lineVertexWriter.writeNext(0);
        lineVertexWriter.writeNext(color & 0xFFFF);
        lineVertexWriter.writeNext(color >>> 16);
        lineVertexWriter.writeNext(x1);
        lineVertexWriter.writeNext(y1);
        lineVertexWriter.writeNext(0);
        lineVertexWriter.flush();
        lineVertexWriter.writeNext(0);
        this.sceGuDisable(9);
        this.sceGuDrawArray(1, 8388892, numberOfVertex, 0, lineVertexAddr);
    }

    public void sceGuDrawRectangle(int x0, int y0, int x1, int y1, int color) {
        int numberOfVertex = 2;
        int lineVertexAddr = this.sceGuGetMemory(12 * numberOfVertex);
        IMemoryWriter lineVertexWriter = MemoryWriter.getMemoryWriter(lineVertexAddr, 2);
        lineVertexWriter.writeNext(color & 0xFFFF);
        lineVertexWriter.writeNext(color >>> 16);
        lineVertexWriter.writeNext(x0);
        lineVertexWriter.writeNext(y0);
        lineVertexWriter.writeNext(0);
        lineVertexWriter.writeNext(0);
        lineVertexWriter.writeNext(color & 0xFFFF);
        lineVertexWriter.writeNext(color >>> 16);
        lineVertexWriter.writeNext(x1);
        lineVertexWriter.writeNext(y1);
        lineVertexWriter.writeNext(0);
        lineVertexWriter.writeNext(0);
        lineVertexWriter.flush();
        this.sceGuDisable(9);
        this.sceGuDrawArray(6, 8388892, numberOfVertex, 0, lineVertexAddr);
    }

    public void sceGuClear(int color) {
        this.sendCommandi(211, 1793);
        this.sceGuDrawRectangle(0, 0, 480, 272, color);
        this.sendCommandi(211, 0);
    }
}

