/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.mediatool.demos;

import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.IMediaWriter;
import com.xuggle.mediatool.MediaToolAdapter;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.mediatool.event.AudioSamplesEvent;
import com.xuggle.mediatool.event.IAddStreamEvent;
import com.xuggle.mediatool.event.IAudioSamplesEvent;
import com.xuggle.mediatool.event.ICloseCoderEvent;
import com.xuggle.mediatool.event.ICloseEvent;
import com.xuggle.mediatool.event.IOpenCoderEvent;
import com.xuggle.mediatool.event.IOpenEvent;
import com.xuggle.mediatool.event.IVideoPictureEvent;
import com.xuggle.mediatool.event.VideoPictureEvent;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.IVideoPicture;
import java.io.File;

public class ConcatenateAudioAndVideo {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Concatent two files.  The destination format will be guessed from the file extention.");
            System.out.println("");
            System.out.println("   ConcatentateTwoFiles <source-file1> <source-file2> <destination-file>");
            System.out.println("");
            System.out.println("The destination type will be guess from the supplied file extsion.");
            System.exit(0);
        }
        File source1 = new File(args[0]);
        File source2 = new File(args[1]);
        if (!source1.exists()) {
            System.out.println("Source file does not exist: " + source1);
            System.exit(0);
        }
        if (!source2.exists()) {
            System.out.println("Source file does not exist: " + source2);
            System.exit(0);
        }
        ConcatenateAudioAndVideo.concatenate(args[0], args[1], args[2]);
    }

    public static void concatenate(String sourceUrl1, String sourceUrl2, String destinationUrl) {
        System.out.printf("transcode %s + %s -> %s\n", sourceUrl1, sourceUrl2, destinationUrl);
        boolean videoStreamIndex = false;
        boolean videoStreamId = false;
        int width = 480;
        int height = 360;
        boolean audioStreamIndex = true;
        boolean audioStreamId = false;
        int channelCount = 2;
        int sampleRate = 44100;
        IMediaReader reader1 = ToolFactory.makeReader(sourceUrl1);
        IMediaReader reader2 = ToolFactory.makeReader(sourceUrl2);
        MediaConcatenator concatenator = new MediaConcatenator(1, 0);
        reader1.addListener(concatenator);
        reader2.addListener(concatenator);
        IMediaWriter writer = ToolFactory.makeWriter(destinationUrl);
        concatenator.addListener(writer);
        writer.addVideoStream(0, 0, 480, 360);
        writer.addAudioStream(1, 0, 2, 44100);
        while (reader1.readPacket() == null) {
        }
        while (reader2.readPacket() == null) {
        }
        writer.close();
    }

    static class MediaConcatenator
    extends MediaToolAdapter {
        private long mOffset = 0L;
        private long mNextVideo = 0L;
        private long mNextAudio = 0L;
        private final int mAudoStreamIndex;
        private final int mVideoStreamIndex;

        public MediaConcatenator(int audioStreamIndex, int videoStreamIndex) {
            this.mAudoStreamIndex = audioStreamIndex;
            this.mVideoStreamIndex = videoStreamIndex;
        }

        @Override
        public void onAudioSamples(IAudioSamplesEvent event) {
            IAudioSamples samples = event.getAudioSamples();
            long newTimeStamp = samples.getTimeStamp() + this.mOffset;
            this.mNextAudio = samples.getNextPts();
            samples.setTimeStamp(newTimeStamp);
            super.onAudioSamples(new AudioSamplesEvent(this, samples, this.mAudoStreamIndex));
        }

        @Override
        public void onVideoPicture(IVideoPictureEvent event) {
            IVideoPicture picture = event.getMediaData();
            long originalTimeStamp = picture.getTimeStamp();
            long newTimeStamp = originalTimeStamp + this.mOffset;
            this.mNextVideo = originalTimeStamp + 1L;
            picture.setTimeStamp(newTimeStamp);
            super.onVideoPicture(new VideoPictureEvent(this, picture, this.mVideoStreamIndex));
        }

        @Override
        public void onClose(ICloseEvent event) {
            this.mOffset = Math.max(this.mNextVideo, this.mNextAudio);
            if (this.mNextAudio < this.mNextVideo) {
                // empty if block
            }
        }

        @Override
        public void onAddStream(IAddStreamEvent event) {
        }

        @Override
        public void onOpen(IOpenEvent event) {
        }

        @Override
        public void onOpenCoder(IOpenCoderEvent event) {
        }

        @Override
        public void onCloseCoder(ICloseCoderEvent event) {
        }
    }
}

