/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler.nativeCode.graphics;

import jpcsp.Allegrex.compiler.nativeCode.AbstractNativeCodeSequence;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.PspGeList;
import jpcsp.Memory;
import jpcsp.graphics.AsyncVertexCache;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VideoEngine;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import org.apache.log4j.Logger;

public class sceGu
extends AbstractNativeCodeSequence {
    protected static Logger log = VideoEngine.log;
    private static final boolean writeTFLUSH = false;
    private static final boolean writeTSYNC = false;
    private static final boolean writeDUMMY = false;

    private static void sceGeListUpdateStallAddr(int addr) {
        PspGeList geList;
        VideoEngine videoEngine = VideoEngine.getInstance();
        if (videoEngine.numberDrawLists() == 0 && (geList = videoEngine.getCurrentList()) != null && geList.getStallAddr() != 0) {
            geList.setStallAddr(addr &= 0x3FFFFFFF);
        }
    }

    public static void sceGuDrawArray(int contextAddr1, int contextAddr2, int listCurrentOffset, int updateStall) {
        int cmd;
        Memory mem = sceGu.getMemory();
        int prim = sceGu.getGprA0();
        int vtype = sceGu.getGprA1();
        int count = sceGu.getGprA2();
        int indices = sceGu.getGprA3();
        int vertices = sceGu.getGprT0();
        int context = mem.read32(sceGu.getRelocatedAddress(contextAddr1, contextAddr2));
        int listCurrent = mem.read32(context + listCurrentOffset);
        if (vtype != 0) {
            cmd = 0x12000000 | vtype & 0xFFFFFF;
            mem.write32(listCurrent, cmd);
            listCurrent += 4;
        }
        if (indices != 0) {
            cmd = 0x10000000 | indices >> 8 & 0xF0000;
            mem.write32(listCurrent, cmd);
            cmd = 0x2000000 | indices & 0xFFFFFF;
            mem.write32(listCurrent += 4, cmd);
            listCurrent += 4;
        }
        if (vertices != 0) {
            cmd = 0x10000000 | vertices >> 8 & 0xF0000;
            mem.write32(listCurrent, cmd);
            cmd = 0x1000000 | vertices & 0xFFFFFF;
            mem.write32(listCurrent += 4, cmd);
            listCurrent += 4;
        }
        cmd = 0x4000000 | (prim & 7) << 16 | count;
        mem.write32(listCurrent, cmd);
        mem.write32(context + listCurrentOffset, listCurrent += 4);
        if (updateStall != 0) {
            sceGu.sceGeListUpdateStallAddr(listCurrent);
        }
        if (VideoEngine.getInstance().useAsyncVertexCache()) {
            AsyncVertexCache.getInstance().addAsyncCheck(prim, vtype, count, indices, vertices);
        }
    }

    public static void sceGuDrawArrayN(int contextAddr1, int contextAddr2, int listCurrentOffset, int updateStall) {
        int cmd;
        Memory mem = sceGu.getMemory();
        int prim = sceGu.getGprA0();
        int vtype = sceGu.getGprA1();
        int count = sceGu.getGprA2();
        int n = sceGu.getGprA3();
        int indices = sceGu.getGprT0();
        int vertices = sceGu.getGprT1();
        int context = mem.read32(sceGu.getRelocatedAddress(contextAddr1, contextAddr2));
        int listCurrent = mem.read32(context + listCurrentOffset);
        IMemoryWriter listWriter = MemoryWriter.getMemoryWriter(listCurrent, 5 + n << 2, 4);
        if (vtype != 0) {
            cmd = 0x12000000 | vtype & 0xFFFFFF;
            listWriter.writeNext(cmd);
            listCurrent += 4;
        }
        if (indices != 0) {
            cmd = 0x10000000 | indices >> 8 & 0xF0000;
            listWriter.writeNext(cmd);
            listCurrent += 4;
            cmd = 0x2000000 | indices & 0xFFFFFF;
            listWriter.writeNext(cmd);
            listCurrent += 4;
        }
        if (vertices != 0) {
            cmd = 0x10000000 | vertices >> 8 & 0xF0000;
            listWriter.writeNext(cmd);
            listCurrent += 4;
            cmd = 0x1000000 | vertices & 0xFFFFFF;
            listWriter.writeNext(cmd);
            listCurrent += 4;
        }
        if (n > 0) {
            cmd = 0x4000000 | (prim & 7) << 16 | count;
            for (int i = 0; i < n; ++i) {
                listWriter.writeNext(cmd);
            }
            listCurrent += n << 2;
        }
        mem.write32(context + listCurrentOffset, listCurrent);
        if (updateStall != 0) {
            sceGu.sceGeListUpdateStallAddr(listCurrent);
        }
    }

    public static void sceGuDrawSpline(int contextAddr1, int contextAddr2, int listCurrentOffset, int updateStall) {
        int cmd;
        Memory mem = sceGu.getMemory();
        int vtype = sceGu.getGprA0();
        int ucount = sceGu.getGprA1();
        int vcount = sceGu.getGprA2();
        int uedge = sceGu.getGprA3();
        int vedge = sceGu.getGprT0();
        int indices = sceGu.getGprT1();
        int vertices = sceGu.getGprT2();
        int context = mem.read32(sceGu.getRelocatedAddress(contextAddr1, contextAddr2));
        int listCurrent = mem.read32(context + listCurrentOffset);
        if (vtype != 0) {
            cmd = 0x12000000 | vtype & 0xFFFFFF;
            mem.write32(listCurrent, cmd);
            listCurrent += 4;
        }
        if (indices != 0) {
            cmd = 0x10000000 | indices >> 8 & 0xF0000;
            mem.write32(listCurrent, cmd);
            cmd = 0x2000000 | indices & 0xFFFFFF;
            mem.write32(listCurrent += 4, cmd);
            listCurrent += 4;
        }
        if (vertices != 0) {
            cmd = 0x10000000 | vertices >> 8 & 0xF0000;
            mem.write32(listCurrent, cmd);
            cmd = 0x1000000 | vertices & 0xFFFFFF;
            mem.write32(listCurrent += 4, cmd);
            listCurrent += 4;
        }
        cmd = 0x6000000 | vedge << 18 | uedge << 16 | vcount << 8 | ucount;
        mem.write32(listCurrent, cmd);
        mem.write32(context + listCurrentOffset, listCurrent += 4);
        if (updateStall != 0) {
            sceGu.sceGeListUpdateStallAddr(listCurrent);
        }
    }

    public static void sceGuCopyImage(int contextAddr1, int contextAddr2, int listCurrentOffset) {
        Memory mem = sceGu.getMemory();
        int psm = sceGu.getGprA0();
        int sx = sceGu.getGprA1();
        int sy = sceGu.getGprA2();
        int width = sceGu.getGprA3();
        int height = sceGu.getGprT0();
        int srcw = sceGu.getGprT1();
        int src = sceGu.getGprT2();
        int dx = sceGu.getGprT3();
        int dy = sceGu.getStackParam0();
        int destw = sceGu.getStackParam1();
        int dest = sceGu.getStackParam2();
        int context = mem.read32(sceGu.getRelocatedAddress(contextAddr1, contextAddr2));
        int listCurrent = mem.read32(context + listCurrentOffset);
        IMemoryWriter listWriter = MemoryWriter.getMemoryWriter(listCurrent, 32, 4);
        int cmd = 0xB2000000 | src & 0xFFFFFF;
        listWriter.writeNext(cmd);
        cmd = 0xB3000000 | src >> 8 & 0xF0000 | srcw;
        listWriter.writeNext(cmd);
        cmd = 0xEB000000 | sy << 10 | sx;
        listWriter.writeNext(cmd);
        cmd = 0xB4000000 | dest & 0xFFFFFF;
        listWriter.writeNext(cmd);
        cmd = 0xB5000000 | dest >> 8 & 0xF0000 | destw;
        listWriter.writeNext(cmd);
        cmd = 0xEC000000 | dy << 10 | dx;
        listWriter.writeNext(cmd);
        cmd = 0xEE000000 | height - 1 << 10 | width - 1;
        listWriter.writeNext(cmd);
        cmd = 0xEA000000 | (IRenderingEngine.sizeOfTextureType[psm] == 4 ? 1 : 0);
        listWriter.writeNext(cmd);
        listWriter.flush();
        mem.write32(context + listCurrentOffset, listCurrent + 32);
    }

    public static void sceGuTexImage(int contextAddr1, int contextAddr2, int listCurrentOffset) {
        Memory mem = sceGu.getMemory();
        int mipmap = sceGu.getGprA0();
        int width = sceGu.getGprA1();
        int height = sceGu.getGprA2();
        int tbw = sceGu.getGprA3();
        int tbp = sceGu.getGprT0();
        int context = mem.read32(sceGu.getRelocatedAddress(contextAddr1, contextAddr2));
        int listCurrent = mem.read32(context + listCurrentOffset);
        int cmd = 160 + mipmap << 24 | tbp & 0xFFFFFF;
        mem.write32(listCurrent, cmd);
        cmd = 168 + mipmap << 24 | tbp >> 8 & 0xF0000 | tbw;
        mem.write32(listCurrent += 4, cmd);
        int widthExp = 31 - Integer.numberOfLeadingZeros(width);
        int heightExp = 31 - Integer.numberOfLeadingZeros(height);
        cmd = 184 + mipmap << 24 | heightExp << 8 | widthExp;
        mem.write32(listCurrent += 4, cmd);
        mem.write32(context + listCurrentOffset, listCurrent += 4);
    }

    public static void sceGuTexSync(int contextAddr1, int contextAddr2, int listCurrentOffset) {
    }

    public static void sceGuTexMapMode(int contextAddr1, int contextAddr2, int listCurrentOffset, int texProjMapOffset, int texMapModeOffset) {
        Memory mem = sceGu.getMemory();
        int texMapMode = sceGu.getGprA0() & 3;
        int texShadeU = sceGu.getGprA1();
        int texShadeV = sceGu.getGprA2();
        int context = mem.read32(sceGu.getRelocatedAddress(contextAddr1, contextAddr2));
        int listCurrent = mem.read32(context + listCurrentOffset);
        int texProjMap = mem.read32(context + texProjMapOffset);
        mem.write32(context + texMapModeOffset, texMapMode);
        int cmd = 0xC0000000 | texProjMap << 8 | texMapMode;
        mem.write32(listCurrent, cmd);
        cmd = 0xC1000000 | texShadeV << 8 | texShadeU;
        mem.write32(listCurrent += 4, cmd);
        mem.write32(context + listCurrentOffset, listCurrent += 4);
    }

    public static void sceGuTexProjMapMode(int contextAddr1, int contextAddr2, int listCurrentOffset, int texProjMapOffset, int texMapModeOffset) {
        Memory mem = sceGu.getMemory();
        int texProjMap = sceGu.getGprA0() & 3;
        int context = mem.read32(sceGu.getRelocatedAddress(contextAddr1, contextAddr2));
        int listCurrent = mem.read32(context + listCurrentOffset);
        int texMapMode = mem.read32(context + texMapModeOffset);
        mem.write32(context + texProjMapOffset, texProjMap);
        int cmd = 0xC0000000 | texProjMap << 8 | texMapMode;
        mem.write32(listCurrent, cmd);
        mem.write32(context + listCurrentOffset, listCurrent += 4);
    }

    public static void sceGuTexLevelMode(int contextAddr1, int contextAddr2, int listCurrentOffset) {
        Memory mem = sceGu.getMemory();
        int mode = sceGu.getGprA0();
        float bias = sceGu.getFprF12();
        int context = mem.read32(sceGu.getRelocatedAddress(contextAddr1, contextAddr2));
        int listCurrent = mem.read32(context + listCurrentOffset);
        int offset = (int)(bias * 16.0f);
        if (offset > 127) {
            offset = 127;
        } else if (offset < -128) {
            offset = -128;
        }
        int cmd = 0xC8000000 | offset << 16 | mode;
        mem.write32(listCurrent, cmd);
        mem.write32(context + listCurrentOffset, listCurrent += 4);
    }

    public static void sceGuMaterial(int contextAddr1, int contextAddr2, int listCurrentOffset) {
        int mode = sceGu.getGprA0();
        int color = sceGu.getGprA1();
        int context = sceGu.getMemory().read32(sceGu.getRelocatedAddress(contextAddr1, contextAddr2));
        sceGu.sceGuMaterial(context, listCurrentOffset, mode, color);
    }

    public static void sceGuMaterial(int listCurrentOffset) {
        int context = sceGu.getGprA0();
        int mode = sceGu.getGprA1();
        int color = sceGu.getGprA2();
        sceGu.sceGuMaterial(context, listCurrentOffset, mode, color);
    }

    private static void sceGuMaterial(int context, int listCurrentOffset, int mode, int color) {
        int cmd;
        Memory mem = sceGu.getMemory();
        int listCurrent = mem.read32(context + listCurrentOffset);
        int rgb = color & 0xFFFFFF;
        if ((mode & 1) != 0) {
            cmd = 0x55000000 | rgb;
            mem.write32(listCurrent, cmd);
            cmd = 0x58000000 | color >>> 24;
            mem.write32(listCurrent += 4, cmd);
            listCurrent += 4;
        }
        if ((mode & 2) != 0) {
            cmd = 0x56000000 | rgb;
            mem.write32(listCurrent, cmd);
            listCurrent += 4;
        }
        if ((mode & 4) != 0) {
            cmd = 0x57000000 | rgb;
            mem.write32(listCurrent, cmd);
            listCurrent += 4;
        }
        mem.write32(context + listCurrentOffset, listCurrent);
    }

    public static void sceGuSetMatrix(int contextAddr1, int contextAddr2, int listCurrentOffset) {
        int type = sceGu.getGprA0();
        int matrix = sceGu.getGprA1();
        int context = sceGu.getMemory().read32(sceGu.getRelocatedAddress(contextAddr1, contextAddr2));
        sceGu.sceGuSetMatrix(context, listCurrentOffset, type, matrix);
    }

    public static void sceGuSetMatrix(int listCurrentOffset) {
        int context = sceGu.getGprA0();
        int type = sceGu.getGprA1();
        int matrix = sceGu.getGprA2();
        sceGu.sceGuSetMatrix(context, listCurrentOffset, type, matrix);
    }

    private static int sceGuSetMatrix4x4(IMemoryWriter listWriter, IMemoryReader matrixReader, int startCmd, int matrixCmd, int index) {
        listWriter.writeNext((startCmd << 24) + index);
        int cmd = matrixCmd << 24;
        for (int i = 0; i < 16; ++i) {
            listWriter.writeNext(cmd | matrixReader.readNext() >>> 8);
        }
        return 68;
    }

    private static int sceGuSetMatrix4x3(IMemoryWriter listWriter, IMemoryReader matrixReader, int startCmd, int matrixCmd, int index) {
        listWriter.writeNext((startCmd << 24) + index);
        int cmd = matrixCmd << 24;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 3; ++j) {
                listWriter.writeNext(cmd | matrixReader.readNext() >>> 8);
            }
            matrixReader.skip(1);
        }
        return 52;
    }

    private static void sceGuSetMatrix(int context, int listCurrentOffset, int type, int matrix) {
        Memory mem = sceGu.getMemory();
        int listCurrent = mem.read32(context + listCurrentOffset);
        IMemoryWriter listWriter = MemoryWriter.getMemoryWriter(listCurrent, 68, 4);
        IMemoryReader matrixReader = MemoryReader.getMemoryReader(matrix, 64, 4);
        switch (type) {
            case 0: {
                listCurrent += sceGu.sceGuSetMatrix4x4(listWriter, matrixReader, 62, 63, 0);
                break;
            }
            case 1: {
                listCurrent += sceGu.sceGuSetMatrix4x3(listWriter, matrixReader, 60, 61, 0);
                break;
            }
            case 2: {
                listCurrent += sceGu.sceGuSetMatrix4x3(listWriter, matrixReader, 58, 59, 0);
                break;
            }
            case 3: {
                listCurrent += sceGu.sceGuSetMatrix4x3(listWriter, matrixReader, 64, 65, 0);
            }
        }
        listWriter.flush();
        mem.write32(context + listCurrentOffset, listCurrent);
    }

    public static void sceGuBoneMatrix(int contextAddr1, int contextAddr2, int listCurrentOffset) {
        int index = sceGu.getGprA0();
        int matrix = sceGu.getGprA1();
        int context = sceGu.getMemory().read32(sceGu.getRelocatedAddress(contextAddr1, contextAddr2));
        sceGu.sceGuBoneMatrix(context, listCurrentOffset, index, matrix);
    }

    public static void sceGuBoneMatrix(int listCurrentOffset) {
        int context = sceGu.getGprA0();
        int index = sceGu.getGprA1();
        int matrix = sceGu.getGprA2();
        sceGu.sceGuBoneMatrix(context, listCurrentOffset, index, matrix);
    }

    private static void sceGuBoneMatrix(int context, int listCurrentOffset, int index, int matrix) {
        Memory mem = sceGu.getMemory();
        int listCurrent = mem.read32(context + listCurrentOffset);
        IMemoryWriter listWriter = MemoryWriter.getMemoryWriter(listCurrent, 56, 4);
        IMemoryReader matrixReader = MemoryReader.getMemoryReader(matrix, 64, 4);
        listWriter.flush();
        mem.write32(context + listCurrentOffset, listCurrent += sceGu.sceGuSetMatrix4x3(listWriter, matrixReader, 42, 43, index * 12));
    }

    public static void sceGuDrawSprite(int contextAddr1, int contextAddr2, int listCurrentOffset, int wOffset, int hOffset, int dxOffset, int dyOffset) {
        int x = sceGu.getGprA0();
        int y = sceGu.getGprA1();
        int z = sceGu.getGprA2();
        int u = sceGu.getGprA3();
        int v = sceGu.getGprT0();
        int flip = sceGu.getGprT1();
        int rotation = sceGu.getGprT2();
        int context = sceGu.getMemory().read32(sceGu.getRelocatedAddress(contextAddr1, contextAddr2));
        sceGu.sceGuDrawSprite(context, listCurrentOffset, x, y, z, u, v, flip, rotation, wOffset, hOffset, dxOffset, dyOffset);
    }

    public static void sceGuDrawSprite(int listCurrentOffset, int wOffset, int hOffset, int dxOffset, int dyOffset) {
        int context = sceGu.getGprA0();
        int x = sceGu.getGprA1();
        int y = sceGu.getGprA2();
        int z = sceGu.getGprA3();
        int u = sceGu.getGprT0();
        int v = sceGu.getGprT1();
        int flip = sceGu.getGprT2();
        int rotation = sceGu.getGprT3();
        sceGu.sceGuDrawSprite(context, listCurrentOffset, x, y, z, u, v, flip, rotation, wOffset, hOffset, dxOffset, dyOffset);
    }

    private static void sceGuDrawSprite(int context, int listCurrentOffset, int x, int y, int z, int u, int v, int flip, int rotation, int wOffset, int hOffset, int dxOffset, int dyOffset) {
        int tmp;
        Memory mem = sceGu.getMemory();
        int listCurrent = mem.read32(context + listCurrentOffset);
        int w = mem.read32(context + wOffset);
        int h = mem.read32(context + hOffset);
        int dx = mem.read32(context + dxOffset);
        int dy = mem.read32(context + dyOffset);
        IMemoryWriter listWriter = MemoryWriter.getMemoryWriter(listCurrent, 44, 4);
        int vertexAddress = listCurrent + 8;
        IMemoryWriter vertexWriter = MemoryWriter.getMemoryWriter(vertexAddress, 20, 2);
        int v0u = u;
        int v0v = v;
        int v0x = x;
        int v0y = y;
        int v1u = u + w;
        int v1v = v + h;
        int v1x = x + dx;
        int v1y = y + dy;
        if ((flip & 1) != 0) {
            tmp = v0u;
            v0u = v1u;
            v1u = tmp;
        }
        if ((flip & 2) != 0) {
            tmp = v0v;
            v0v = v1v;
            v1v = tmp;
        }
        switch (rotation) {
            case 1: {
                tmp = v0y;
                v0y = v1y;
                v1y = tmp;
                break;
            }
            case 2: {
                tmp = v0x;
                v0x = v1x;
                v1x = tmp;
                tmp = v0y;
                v0y = v1y;
                v1y = tmp;
                break;
            }
            case 3: {
                tmp = v0x;
                v0x = v1x;
                v1x = tmp;
                break;
            }
        }
        vertexWriter.writeNext(v0u);
        vertexWriter.writeNext(v0v);
        vertexWriter.writeNext(v0x);
        vertexWriter.writeNext(v0y);
        vertexWriter.writeNext(z);
        vertexWriter.writeNext(v1u);
        vertexWriter.writeNext(v1v);
        vertexWriter.writeNext(v1x);
        vertexWriter.writeNext(v1y);
        vertexWriter.writeNext(z);
        vertexWriter.flush();
        int jumpAddr = vertexAddress + 20;
        int cmd = 0x10000000 | jumpAddr >> 8 & 0xFF0000;
        listWriter.writeNext(cmd);
        cmd = 0x8000000 | jumpAddr & 0xFFFFFF;
        listWriter.writeNext(cmd);
        listWriter.skip(5);
        cmd = 310378754;
        listWriter.writeNext(cmd);
        cmd = 0x10000000 | vertexAddress >> 8 & 0xFF0000;
        listWriter.writeNext(cmd);
        cmd = 0x1000000 | vertexAddress & 0xFFFFFF;
        listWriter.writeNext(cmd);
        cmd = 67502082;
        listWriter.writeNext(cmd);
        listWriter.flush();
        mem.write32(context + listCurrentOffset, jumpAddr + 16);
    }

    private static int getListSize(int listAddr) {
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(listAddr, 4);
        int i = 1;
        int instruction;
        int cmd;
        while ((cmd = VideoEngine.command(instruction = memoryReader.readNext())) != 11) {
            ++i;
        }
        return i;
    }

    public static void sceGuCallList() {
        int callAddr = sceGu.getGprA0();
        if (Modules.ThreadManForUserModule.isCurrentThreadStackAddress(callAddr)) {
            int listSize = sceGu.getListSize(callAddr);
            int memorySize = listSize << 2;
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceGuCallList Stack address 0x%08X-0x%08X", callAddr, callAddr + memorySize));
            }
            int[] instructions = new int[listSize];
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(callAddr, memorySize, 4);
            for (int i = 0; i < listSize; ++i) {
                instructions[i] = memoryReader.readNext();
            }
            VideoEngine.getInstance().addCachedInstructions(callAddr, instructions);
        }
    }
}

