/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.GUI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.border.AbstractBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import jpcsp.Emulator;
import jpcsp.GUI.CancelButton;
import jpcsp.GUI.UmdBrowserPmf;
import jpcsp.GUI.UmdBrowserSound;
import jpcsp.MainGUI;
import jpcsp.WindowPropSaver;
import jpcsp.filesystems.umdiso.UmdIsoFile;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.format.PSF;
import jpcsp.settings.Settings;

public class UmdBrowser
extends JDialog {
    private static final long serialVersionUID = 7788144302296106541L;
    private File[] programs;
    private ImageIcon[] icons;
    private PSF[] psfs;
    private volatile boolean[] umdInfoLoaded;
    private UmdBrowserPmf umdBrowserPmf;
    private UmdBrowserSound umdBrowserSound;
    private int lastRowIndex = -1;
    private boolean isSwitchingUmd;
    private MainGUI gui;
    private File[] paths;
    private CancelButton cancelButton;
    private JLabel icon0Label;
    private JPanel imagePanel;
    private JScrollPane jScrollPane1;
    private JButton loadButton;
    private JLabel pic0Label;
    private JLabel pic1Label;
    private JTable table;

    public UmdBrowser(MainGUI gui, File[] paths) {
        super(gui);
        this.gui = gui;
        this.paths = paths;
        this.initPNG();
        this.initComponents();
        this.icon0Label.setBorder(new PmfBorder());
        this.table.getColumnModel().getColumn(0).setMinWidth(144);
        this.table.getColumnModel().getColumn(0).setMaxWidth(144);
        this.table.setDefaultRenderer(Icon.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setText("");
                this.setIcon((Icon)value);
                return this;
            }
        });
        this.table.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTextArea textArea = new JTextArea((String)value);
                textArea.setFont(this.getFont());
                if (isSelected) {
                    textArea.setForeground(table.getSelectionForeground());
                    textArea.setBackground(table.getSelectionBackground());
                } else {
                    textArea.setForeground(table.getForeground());
                    textArea.setBackground(table.getBackground());
                }
                return textArea;
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                UmdBrowser.this.onSelectionChanged(event);
            }
        });
        WindowPropSaver.loadWindowProperties(this);
    }

    private void initPNG() {
        try {
            this.getClass().getClassLoader().loadClass("sun.awt.image.PNGImageDecoder").getMethod("setCheckCRC", Boolean.TYPE).invoke(null, false);
        }
        catch (Throwable e) {
            Emulator.log.info((Object)e);
        }
    }

    private String getUmdBrowseCacheDirectory(String name) {
        return String.format("%1$s%2$cUmdBrowserCache%2$c%3$s%2$c", Settings.getInstance().readString("emu.tmppath"), Character.valueOf(File.separatorChar), name);
    }

    private void writeUmdBrowseCacheFile(String cacheDirectory, String name, byte[] content) {
        try {
            FileOutputStream os = new FileOutputStream(cacheDirectory + name);
            ((OutputStream)os).write(content);
            ((OutputStream)os).close();
        }
        catch (FileNotFoundException e) {
            Emulator.log.error((Object)e);
        }
        catch (IOException e) {
            Emulator.log.error((Object)e);
        }
    }

    private void loadUmdInfo(int rowIndex) {
        if (rowIndex >= this.umdInfoLoaded.length || this.umdInfoLoaded[rowIndex]) {
            return;
        }
        try {
            if (this.programs[rowIndex].isDirectory()) {
                File[] eboot = this.programs[rowIndex].listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File arg0) {
                        return arg0.getName().equalsIgnoreCase("eboot.pbp");
                    }
                });
                this.programs[rowIndex] = eboot[0];
            }
            if (!this.programs[rowIndex].isDirectory()) {
                String cacheDirectory = this.getUmdBrowseCacheDirectory(this.programs[rowIndex].getName());
                File sfoFile = new File(cacheDirectory + "param.sfo");
                if (sfoFile.canRead()) {
                    byte[] sfo = new byte[(int)sfoFile.length()];
                    FileInputStream is = new FileInputStream(sfoFile);
                    ((InputStream)is).read(sfo);
                    ((InputStream)is).close();
                    this.psfs[rowIndex] = new PSF();
                    this.psfs[rowIndex].read(ByteBuffer.wrap(sfo));
                    File icon0File = new File(cacheDirectory + "ICON0.PNG");
                    this.icons[rowIndex] = icon0File.canRead() ? new ImageIcon(icon0File.getPath()) : new ImageIcon(this.getClass().getResource("/jpcsp/images/icon0.png"));
                } else {
                    new File(cacheDirectory).mkdirs();
                    UmdIsoReader iso = new UmdIsoReader(this.programs[rowIndex].getPath());
                    UmdIsoFile paramSfo = iso.getFile("PSP_GAME/param.sfo");
                    byte[] sfo = new byte[(int)paramSfo.length()];
                    paramSfo.read(sfo);
                    paramSfo.close();
                    this.writeUmdBrowseCacheFile(cacheDirectory, "param.sfo", sfo);
                    ByteBuffer buf = ByteBuffer.wrap(sfo);
                    this.psfs[rowIndex] = new PSF();
                    this.psfs[rowIndex].read(buf);
                    UmdIsoFile icon0umd = iso.getFile("PSP_GAME/ICON0.PNG");
                    byte[] icon0 = new byte[(int)icon0umd.length()];
                    icon0umd.read(icon0);
                    icon0umd.close();
                    this.writeUmdBrowseCacheFile(cacheDirectory, "ICON0.PNG", icon0);
                    this.icons[rowIndex] = new ImageIcon(icon0);
                }
            }
        }
        catch (FileNotFoundException e) {
            try {
                UmdIsoReader iso = new UmdIsoReader(this.programs[rowIndex].getPath());
                UmdIsoFile paramSfo = iso.getFile("UMD_VIDEO/param.sfo");
                UmdIsoFile umdDataFile = iso.getFile("UMD_DATA.BIN");
                byte[] umdDataId = new byte[10];
                umdDataFile.readFully(umdDataId, 0, 9);
                String umdDataIdString = new String(umdDataId);
                byte[] sfo = new byte[(int)paramSfo.length()];
                paramSfo.read(sfo);
                paramSfo.close();
                ByteBuffer buf = ByteBuffer.wrap(sfo);
                this.psfs[rowIndex] = new PSF();
                this.psfs[rowIndex].read(buf);
                this.psfs[rowIndex].put("DISC_ID", umdDataIdString);
                UmdIsoFile icon0umd = iso.getFile("UMD_VIDEO/ICON0.PNG");
                byte[] icon0 = new byte[(int)icon0umd.length()];
                icon0umd.read(icon0);
                icon0umd.close();
                this.icons[rowIndex] = new ImageIcon(icon0);
            }
            catch (FileNotFoundException ve) {
                this.icons[rowIndex] = new ImageIcon(this.getClass().getResource("/jpcsp/images/icon0.png"));
            }
            catch (IOException ve) {
                Emulator.log.error((Object)ve);
            }
        }
        catch (IOException e) {
            Emulator.log.error((Object)e);
        }
        this.umdInfoLoaded[rowIndex] = true;
    }

    private void onSelectionChanged(ListSelectionEvent event) {
        this.loadButton.setEnabled(!((ListSelectionModel)event.getSource()).isSelectionEmpty());
        ImageIcon pic0Icon = null;
        ImageIcon pic1Icon = null;
        ImageIcon icon0Icon = null;
        try {
            int rowIndex = this.table.getSelectedRow();
            UmdIsoReader iso = new UmdIsoReader(this.programs[rowIndex].getPath());
            try {
                UmdIsoFile pic0umd = iso.getFile("PSP_GAME/PIC0.PNG");
                byte[] pic0 = new byte[(int)pic0umd.length()];
                pic0umd.read(pic0);
                pic0umd.close();
                pic0Icon = new ImageIcon(pic0);
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                Emulator.log.error((Object)e);
            }
            try {
                UmdIsoFile pic1umd = iso.getFile("PSP_GAME/PIC1.PNG");
                byte[] pic1 = new byte[(int)pic1umd.length()];
                pic1umd.read(pic1);
                pic1umd.close();
                pic1Icon = new ImageIcon(pic1);
            }
            catch (FileNotFoundException e) {
                try {
                    UmdIsoFile pic1umd = iso.getFile("UMD_VIDEO/PIC1.PNG");
                    byte[] pic1 = new byte[(int)pic1umd.length()];
                    pic1umd.read(pic1);
                    pic1umd.close();
                    pic1Icon = new ImageIcon(pic1);
                }
                catch (FileNotFoundException ve) {
                    pic1Icon = new ImageIcon();
                    BufferedImage image = new BufferedImage(480, 272, 2);
                    pic1Icon.setImage(image);
                }
                catch (IOException ve) {
                    Emulator.log.error((Object)ve);
                }
            }
            catch (IOException e) {
                Emulator.log.error((Object)e);
            }
            icon0Icon = this.icons[rowIndex];
            if (this.lastRowIndex != rowIndex) {
                this.stopVideo();
                this.umdBrowserPmf = new UmdBrowserPmf(iso, "PSP_GAME/ICON1.PMF", this.icon0Label);
                this.umdBrowserSound = new UmdBrowserSound(iso, "PSP_GAME/SND0.AT3");
            }
            this.lastRowIndex = rowIndex;
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Emulator.log.error((Object)e);
        }
        this.pic0Label.setIcon(pic0Icon);
        this.pic1Label.setIcon(pic1Icon);
        this.icon0Label.setIcon(icon0Icon);
    }

    private String getTitle(int rowIndex) {
        String title;
        if (this.psfs[rowIndex] == null || (title = this.psfs[rowIndex].getString("TITLE")) == null) {
            title = this.programs[rowIndex].getParentFile().getName();
        }
        return title;
    }

    private void scrollTo(char c) {
        c = Character.toLowerCase(c);
        int scrollToRow = -1;
        for (int rowIndex = 0; rowIndex < this.programs.length; ++rowIndex) {
            char firstChar;
            String title = this.getTitle(rowIndex);
            if (title == null || title.length() <= 0 || (firstChar = Character.toLowerCase(title.charAt(0))) != c) continue;
            scrollToRow = rowIndex;
            break;
        }
        if (scrollToRow >= 0) {
            this.table.scrollRectToVisible(this.table.getCellRect(scrollToRow, 0, true));
        }
    }

    private void stopVideo() {
        if (this.umdBrowserPmf != null) {
            this.umdBrowserPmf.stopVideo();
            this.umdBrowserPmf = null;
        }
        if (this.umdBrowserSound != null) {
            this.umdBrowserSound.stopVideo();
            this.umdBrowserSound = null;
        }
    }

    private void loadSelectedfile() {
        this.stopVideo();
        File selectedFile = this.programs[this.table.getSelectedRow()];
        if (this.isSwitchingUmd()) {
            this.gui.switchUMD(selectedFile);
            this.setVisible(false);
            this.dispose();
        } else {
            this.gui.loadUMD(selectedFile);
            this.dispose();
            this.gui.loadAndRun();
        }
    }

    @Override
    public void dispose() {
        this.stopVideo();
        super.dispose();
    }

    private static void sleep(long millis) {
        if (millis > 0L) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean isSwitchingUmd() {
        return this.isSwitchingUmd;
    }

    public void setSwitchingUmd(boolean isSwitchingUmd) {
        this.isSwitchingUmd = isSwitchingUmd;
        this.loadButton.setText(ResourceBundle.getBundle("jpcsp/languages/jpcsp").getString(this.isSwitchingUmd() ? "UmdBrowser.loadButtonSwitch.text" : "UmdBrowser.loadButton.text"));
    }

    private void initComponents() {
        this.loadButton = new JButton();
        this.cancelButton = new CancelButton();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.imagePanel = new JPanel();
        this.icon0Label = new JLabel();
        this.pic0Label = new JLabel();
        this.pic1Label = new JLabel();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
        this.setTitle(bundle.getString("UmdBrowser.title"));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.loadButton.setText(bundle.getString("LoadButton.text"));
        this.loadButton.setEnabled(false);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UmdBrowser.this.loadButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(bundle.getString("CancelButton.text"));
        this.cancelButton.setParent(this);
        this.table.setModel(new MemStickTableModel(this.paths));
        this.table.setAutoResizeMode(1);
        this.table.setRowHeight(80);
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                UmdBrowser.this.tableMouseClicked(evt);
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                UmdBrowser.this.tableKeyTyped(evt);
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                UmdBrowser.this.tableKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                UmdBrowser.this.tableKeyReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        this.imagePanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.imagePanel.setPreferredSize(new Dimension(480, 272));
        this.imagePanel.setLayout(new GridBagLayout());
        this.icon0Label.setBackground(new Color(255, 255, 255));
        this.icon0Label.setBorder(BorderFactory.createEmptyBorder(0, 22, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.imagePanel.add((Component)this.icon0Label, gridBagConstraints);
        this.pic0Label.setBackground(new Color(204, 204, 204));
        this.pic0Label.setMaximumSize(new Dimension(310, 180));
        this.pic0Label.setMinimumSize(new Dimension(310, 180));
        this.pic0Label.setPreferredSize(new Dimension(310, 180));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.imagePanel.add((Component)this.pic0Label, gridBagConstraints);
        this.pic1Label.setBackground(new Color(153, 153, 153));
        this.pic1Label.setMaximumSize(new Dimension(480, 272));
        this.pic1Label.setMinimumSize(new Dimension(480, 272));
        this.pic1Label.setPreferredSize(new Dimension(480, 272));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.imagePanel.add((Component)this.pic1Label, gridBagConstraints);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.loadButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.imagePanel, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 375, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.imagePanel, -1, -1, -2).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadButton).addComponent(this.cancelButton, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void tableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && evt.getButton() == 1) {
            this.loadSelectedfile();
        }
    }

    private void tableKeyPressed(KeyEvent evt) {
    }

    private void tableKeyReleased(KeyEvent evt) {
    }

    private void tableKeyTyped(KeyEvent evt) {
        this.scrollTo(evt.getKeyChar());
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
        this.loadSelectedfile();
    }

    static /* synthetic */ boolean[] access$002(UmdBrowser x0, boolean[] x1) {
        x0.umdInfoLoaded = x1;
        return x1;
    }

    static /* synthetic */ File[] access$102(UmdBrowser x0, File[] x1) {
        x0.programs = x1;
        return x1;
    }

    static /* synthetic */ ImageIcon[] access$202(UmdBrowser x0, ImageIcon[] x1) {
        x0.icons = x1;
        return x1;
    }

    static /* synthetic */ PSF[] access$302(UmdBrowser x0, PSF[] x1) {
        x0.psfs = x1;
        return x1;
    }

    private class PmfBorder
    extends AbstractBorder {
        private static final long serialVersionUID = -700510222853542503L;
        private static final int leftSpace = 20;
        private static final int topSpace = 8;
        private static final int borderWidth = 8;
        private static final int millisPerBeat = 1500;

        private PmfBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.set(8, 20, 8, 8);
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (UmdBrowser.this.icon0Label.getIcon() == null) {
                return;
            }
            long now = System.currentTimeMillis();
            float beat = (float)(now % 1500L) / 1500.0f;
            float noBeat = 0.5f;
            for (int i = 0; i < 8; ++i) {
                int alpha = this.getAlpha(noBeat, i);
                this.setColor(g, beat, alpha);
                g.drawLine(x + width - 8 + i, y + 8, x + width - 8 + i, y + height - 8);
                g.drawLine(x + 20, y + height - 8 + i, x + width - 8, y + height - 8 + i);
                alpha = this.getAlpha(beat, i);
                this.setColor(g, noBeat, alpha);
                g.drawLine(x + 20 - i, y + 8, x + 20 - i, y + height - 8);
                g.drawLine(x + 20, y + 8 - i, x + width - 8, y + 8 - i);
            }
            this.drawCorner(g, beat, noBeat, x + 20 - 8, y + 8 - 8, 8, 8);
            this.drawCorner(g, beat, noBeat, x + width - 8, y + 8 - 8, 0, 8);
            this.drawCorner(g, beat, noBeat, x + 20 - 8, y + height - 8, 8, 0);
            this.drawCorner(g, noBeat, beat, x + width - 8, y + height - 8, 0, 0);
        }

        private void drawCorner(Graphics g, float alphaBeat, float colorBeat, int x, int y, int centerX, int centerY) {
            for (int ix = 1; ix < 8; ++ix) {
                for (int iy = 1; iy < 8; ++iy) {
                    int alpha = this.getAlpha(alphaBeat, ix - centerX, iy - centerY);
                    this.setColor(g, colorBeat, alpha);
                    this.drawPoint(g, x + ix, y + iy);
                }
            }
        }

        private int getAlpha(float beat, int distanceX, int distanceY) {
            float distance = (float)Math.sqrt(distanceX * distanceX + distanceY * distanceY);
            return this.getAlpha(beat, distance);
        }

        private int getAlpha(float beat, float distance) {
            float maxDistance = 8.0f;
            int maxAlpha = 240;
            maxAlpha = beat < 0.5f ? (int)((float)maxAlpha * beat * 2.0f) : (int)((float)maxAlpha * (1.0f - beat) * 2.0f);
            distance = Math.abs(distance);
            distance = Math.min(distance, 8.0f);
            return maxAlpha - (int)(distance * (float)maxAlpha / 8.0f);
        }

        private void setColor(Graphics g, float beat, int alpha) {
            int color = 160;
            color = beat < 0.5f ? (int)((float)color * beat * 2.0f) : (int)((float)color * (1.0f - beat) * 2.0f);
            g.setColor(new Color(color, color, color, alpha));
        }

        private void drawPoint(Graphics g, int x, int y) {
            g.drawLine(x, y, x, y);
        }
    }

    private class UmdInfoLoader
    extends Thread {
        private UmdInfoLoader() {
        }

        @Override
        public void run() {
            for (int i = 0; i < UmdBrowser.this.umdInfoLoaded.length; ++i) {
                UmdBrowser.this.loadUmdInfo(i);
            }
        }
    }

    private final class MemStickTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -1675488447176776560L;
        private UmdInfoLoader umdInfoLoader;
        private String pathPrefix;

        public MemStickTableModel(File[] paths) {
            UmdBrowser.access$002(UmdBrowser.this, new boolean[0]);
            ArrayList<File> programList = new ArrayList<File>();
            for (File path : paths) {
                if (!path.isDirectory()) {
                    Emulator.log.error((Object)("'" + path + "' is not a directory."));
                    return;
                }
                try {
                    this.pathPrefix = path.getCanonicalPath();
                }
                catch (IOException e) {
                    this.pathPrefix = path.getPath();
                }
                File[] pathPrograms = path.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        String lower = file.getName().toLowerCase();
                        if (lower.endsWith(".cso") || lower.endsWith(".iso")) {
                            return true;
                        }
                        if (file.isDirectory()) {
                            File[] eboot = file.listFiles(new FileFilter(){

                                @Override
                                public boolean accept(File file) {
                                    return file.getName().equalsIgnoreCase("eboot.pbp");
                                }
                            });
                            return eboot.length != 0;
                        }
                        return false;
                    }
                });
                programList.addAll(Arrays.asList(pathPrograms));
            }
            Collections.sort(programList, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    String name2;
                    if (file1 == null) {
                        return file2 == null ? 0 : 1;
                    }
                    if (file2 == null) {
                        return -1;
                    }
                    String name1 = file1.getName().toLowerCase();
                    if (name1.equals(name2 = file2.getName().toLowerCase())) {
                        return this.compare(file1.getParentFile(), file2.getParentFile());
                    }
                    return name1.compareTo(name2);
                }
            });
            UmdBrowser.access$102(UmdBrowser.this, programList.toArray(new File[programList.size()]));
            UmdBrowser.access$202(UmdBrowser.this, new ImageIcon[UmdBrowser.this.programs.length]);
            UmdBrowser.access$302(UmdBrowser.this, new PSF[UmdBrowser.this.programs.length]);
            UmdBrowser.access$002(UmdBrowser.this, new boolean[UmdBrowser.this.programs.length]);
            for (int i = 0; i < UmdBrowser.this.programs.length; ++i) {
                ((UmdBrowser)UmdBrowser.this).umdInfoLoaded[i] = false;
            }
            UmdBrowser.this.loadUmdInfo(0);
            this.umdInfoLoader = new UmdInfoLoader();
            this.umdInfoLoader.setName("Umd Browser - Umd Info Loader");
            this.umdInfoLoader.setPriority(1);
            this.umdInfoLoader.setDaemon(true);
            this.umdInfoLoader.start();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Icon.class;
                }
                case 1: {
                    return String.class;
                }
            }
            throw new IndexOutOfBoundsException("column index out of range");
        }

        @Override
        public String getColumnName(int column) {
            ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
            switch (column) {
                case 0: {
                    return bundle.getString("MemStickBrowser.column.icon.text");
                }
                case 1: {
                    return bundle.getString("MemStickBrowser.column.title.text");
                }
            }
            throw new IndexOutOfBoundsException("column index out of range");
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return UmdBrowser.this.programs != null ? UmdBrowser.this.programs.length : 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= UmdBrowser.this.umdInfoLoaded.length) {
                return null;
            }
            try {
                while (!UmdBrowser.this.umdInfoLoaded[rowIndex]) {
                    UmdBrowser.sleep(1L);
                }
                switch (columnIndex) {
                    case 0: {
                        return UmdBrowser.this.icons[rowIndex];
                    }
                    case 1: {
                        String prgPath;
                        String firmware;
                        String discid;
                        String title = UmdBrowser.this.getTitle(rowIndex);
                        if (UmdBrowser.this.psfs[rowIndex] == null || (discid = UmdBrowser.this.psfs[rowIndex].getString("DISC_ID")) == null) {
                            discid = "No ID";
                        }
                        if (UmdBrowser.this.psfs[rowIndex] == null || (firmware = UmdBrowser.this.psfs[rowIndex].getString("PSP_SYSTEM_VER")) == null) {
                            firmware = "Not found";
                        }
                        if ((prgPath = UmdBrowser.this.programs[rowIndex].getCanonicalPath()).startsWith(this.pathPrefix)) {
                            prgPath = prgPath.substring(this.pathPrefix.length() + 1);
                        } else {
                            String cwdPath = new File(".").getCanonicalPath();
                            if (prgPath.startsWith(cwdPath)) {
                                prgPath = prgPath.substring(cwdPath.length() + 1);
                            }
                        }
                        ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
                        String text = String.format("%s\n%s: %s\n%s: %s\n%s", title, bundle.getString("UmdBrowser.strDiscID.text"), discid, bundle.getString("UmdBrowser.strFirmware.text"), firmware, prgPath);
                        return text;
                    }
                }
            }
            catch (IOException e) {
                Emulator.log.error((Object)e);
            }
            return null;
        }
    }
}

