/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS;

import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.kernel.types.SceIoDirent;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.util.Utilities;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class AbstractVirtualFileSystem
implements IVirtualFileSystem {
    protected static Logger log = Logger.getLogger((String)"vfs");
    public static final int IO_ERROR = -1;

    protected static boolean hasFlag(int mode, int flag) {
        return (mode & flag) == flag;
    }

    @Override
    public void ioInit() {
    }

    @Override
    public void ioExit() {
    }

    @Override
    public IVirtualFile ioOpen(String fileName, int flags, int mode) {
        return null;
    }

    @Override
    public int ioRead(IVirtualFile file, TPointer outputPointer, int outputLength) {
        return file.ioRead(outputPointer, outputLength);
    }

    @Override
    public int ioWrite(IVirtualFile file, TPointer inputPointer, int inputLength) {
        return file.ioWrite(inputPointer, inputLength);
    }

    @Override
    public long ioLseek(IVirtualFile file, long offset) {
        return file.ioLseek(offset);
    }

    @Override
    public int ioIoctl(IVirtualFile file, int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        return file.ioIoctl(command, inputPointer, inputLength, outputPointer, outputLength);
    }

    @Override
    public int ioClose(IVirtualFile file) {
        return file.ioClose();
    }

    @Override
    public int ioRemove(String name) {
        return -1;
    }

    @Override
    public int ioMkdir(String name, int mode) {
        return -1;
    }

    @Override
    public int ioRmdir(String name) {
        return -1;
    }

    @Override
    public String[] ioDopen(String dirName) {
        return null;
    }

    @Override
    public int ioDread(String dirName, SceIoDirent dir) {
        String fileName = dirName == null || dirName.length() == 0 ? dir.filename : dirName + "/" + dir.filename;
        int result = this.ioGetstat(fileName, dir.stat);
        if (result == 0) {
            return 1;
        }
        return result;
    }

    @Override
    public int ioDclose(String dirName) {
        return 0;
    }

    @Override
    public int ioGetstat(String fileName, SceIoStat stat) {
        return -1;
    }

    @Override
    public int ioChstat(String fileName, SceIoStat stat, int bits) {
        return -1;
    }

    @Override
    public int ioRename(String oldFileName, String newFileName) {
        return -1;
    }

    @Override
    public int ioChdir(String directoryName) {
        return -1;
    }

    @Override
    public int ioMount() {
        return -1;
    }

    @Override
    public int ioUmount() {
        return -1;
    }

    @Override
    public int ioDevctl(String deviceName, int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        if (log.isEnabledFor((Priority)Level.WARN)) {
            log.warn((Object)String.format("ioDevctl on '%s', 0x%08X unsupported command, inlen=%d, outlen=%d", deviceName, command, inputLength, outputLength));
            if (inputPointer.isAddressGood()) {
                log.warn((Object)String.format("ioDevctl indata: %s", Utilities.getMemoryDump(inputPointer.getAddress(), inputLength)));
            }
            if (outputPointer.isAddressGood()) {
                log.warn((Object)String.format("ioDevctl outdata: %s", Utilities.getMemoryDump(outputPointer.getAddress(), outputLength)));
            }
        }
        return -2147351771;
    }
}

