/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS;

import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.util.Utilities;

public class MemoryVirtualFile
implements IVirtualFile {
    private final int startAddress;
    private int address;
    private final int length;

    public MemoryVirtualFile(int address, int length) {
        this.startAddress = address;
        this.address = address;
        this.length = length;
    }

    @Override
    public int ioClose() {
        this.address = 0;
        return 0;
    }

    @Override
    public int ioRead(TPointer outputPointer, int outputLength) {
        outputLength = Math.min(outputLength, this.length - (this.address - this.startAddress));
        outputPointer.getMemory().memcpy(outputPointer.getAddress(), this.address, outputLength);
        this.address += outputLength;
        return outputLength;
    }

    @Override
    public int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        outputLength = Math.min(outputLength, this.length - (this.address - this.startAddress));
        Utilities.readBytes(this.address, outputLength, outputBuffer, outputOffset);
        this.address += outputLength;
        return outputLength;
    }

    @Override
    public int ioWrite(TPointer inputPointer, int inputLength) {
        inputLength = Math.min(inputLength, this.length - (this.address - this.startAddress));
        inputPointer.getMemory().memcpy(this.address, inputPointer.getAddress(), inputLength);
        this.address += inputLength;
        return inputLength;
    }

    @Override
    public int ioWrite(byte[] inputBuffer, int inputOffset, int inputLength) {
        inputLength = Math.min(inputLength, this.length - (this.address - this.startAddress));
        Utilities.writeBytes(this.address, inputLength, inputBuffer, inputOffset);
        this.address += inputLength;
        return inputLength;
    }

    @Override
    public long ioLseek(long offset) {
        this.address = this.startAddress + (int)offset;
        return offset;
    }

    @Override
    public int ioIoctl(int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        return -1;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public boolean isSectorBlockMode() {
        return false;
    }

    @Override
    public long getPosition() {
        return this.address - this.startAddress;
    }

    @Override
    public IVirtualFile duplicate() {
        MemoryVirtualFile vFile = new MemoryVirtualFile(this.startAddress, this.length);
        vFile.ioLseek(this.getPosition());
        return vFile;
    }

    public String toString() {
        return String.format("MemoryVirtualFile 0x%08X-0x%08X (length=0x%X)", this.startAddress, this.startAddress + this.length, this.length);
    }
}

