/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.emulator;

import java.io.IOException;
import java.nio.Buffer;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractVirtualFileSystem;
import jpcsp.HLE.modules150.sceDisplay;
import jpcsp.Memory;
import jpcsp.autotests.AutoTestsOutput;
import jpcsp.graphics.capture.CaptureImage;
import jpcsp.hardware.Screen;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;

public class EmulatorVirtualFileSystem
extends AbstractVirtualFileSystem {
    public static final int EMULATOR_DEVCTL_GET_HAS_DISPLAY = 1;
    public static final int EMULATOR_DEVCTL_SEND_OUTPUT = 2;
    public static final int EMULATOR_DEVCTL_IS_EMULATOR = 3;
    public static final int EMULATOR_DEVCTL_SEND_CTRLDATA = 16;
    public static final int EMULATOR_DEVCTL_EMIT_SCREENSHOT = 32;
    private static String screenshotFileName = "testResult.bmp";
    private static String screenshotFormat = "bmp";

    @Override
    public int ioDevctl(String deviceName, int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        switch (command) {
            case 1: {
                if (!outputPointer.isAddressGood() || outputLength < 4) {
                    return super.ioDevctl(deviceName, command, inputPointer, inputLength, outputPointer, outputLength);
                }
                outputPointer.setValue32(Screen.hasScreen());
                break;
            }
            case 2: {
                byte[] input = new byte[inputLength];
                IMemoryReader memoryReader = MemoryReader.getMemoryReader(inputPointer.getAddress(), inputLength, 1);
                for (int i = 0; i < inputLength; ++i) {
                    input[i] = (byte)memoryReader.readNext();
                }
                String outputString = new String(input);
                if (log.isDebugEnabled()) {
                    log.debug((Object)outputString);
                }
                AutoTestsOutput.appendString(outputString);
                break;
            }
            case 3: {
                break;
            }
            case 32: {
                sceDisplay.BufferInfo fb = Modules.sceDisplayModule.getBufferInfoFb();
                Buffer buffer = Memory.getInstance().getBuffer(fb.topAddr, fb.bufferWidth * fb.height * sceDisplay.getPixelFormatBytes(fb.pixelFormat));
                CaptureImage captureImage = new CaptureImage(fb.topAddr, 0, buffer, fb.width, fb.height, fb.bufferWidth, fb.pixelFormat, false, 0, false, true, null);
                captureImage.setFileName(EmulatorVirtualFileSystem.getScreenshotFileName());
                captureImage.setFileFormat(EmulatorVirtualFileSystem.getScreenshotFormat());
                try {
                    captureImage.write();
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)String.format("Screenshot 0x%08X-0x%08X saved under '%s'", fb.topAddr, fb.bottomAddr, captureImage.getFileName()));
                }
                catch (IOException e) {
                    log.error((Object)"Emit Screenshot", (Throwable)e);
                }
                break;
            }
            default: {
                return super.ioDevctl(deviceName, command, inputPointer, inputLength, outputPointer, outputLength);
            }
        }
        return 0;
    }

    public static String getScreenshotFileName() {
        return screenshotFileName;
    }

    public static void setScreenshotFileName(String screenshotFileName) {
        EmulatorVirtualFileSystem.screenshotFileName = screenshotFileName;
    }

    public static String getScreenshotFormat() {
        return screenshotFormat;
    }

    public static void setScreenshotFormat(String screenshotFormat) {
        EmulatorVirtualFileSystem.screenshotFormat = screenshotFormat;
    }
}

