/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import java.util.HashMap;
import java.util.Iterator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelFplInfo;
import jpcsp.HLE.kernel.types.SceKernelFplOptParam;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class FplManager {
    protected static Logger log = Modules.getLogger("ThreadManForUser");
    private HashMap<Integer, SceKernelFplInfo> fplMap;
    private FplWaitStateChecker fplWaitStateChecker;
    public static final int PSP_FPL_ATTR_FIFO = 0;
    public static final int PSP_FPL_ATTR_PRIORITY = 256;
    private static final int PSP_FPL_ATTR_MASK = 16895;
    private static final int PSP_FPL_ATTR_ADDR_HIGH = 16384;
    public static final FplManager singleton = new FplManager();

    public void reset() {
        this.fplMap = new HashMap();
        this.fplWaitStateChecker = new FplWaitStateChecker();
    }

    private boolean removeWaitingThread(SceKernelThreadInfo thread) {
        SceKernelFplInfo fpl = this.fplMap.get(thread.wait.Fpl_id);
        if (fpl == null) {
            return false;
        }
        fpl.threadWaitingList.removeWaitingThread(thread);
        return true;
    }

    public void onThreadWaitTimeout(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext._v0 = -2147352152;
        } else {
            log.warn((Object)"FPL deleted while we were waiting for it! (timeout expired)");
            thread.cpuContext._v0 = -2147352139;
        }
    }

    public void onThreadWaitReleased(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext._v0 = -2147352150;
        } else {
            log.warn((Object)"EventFlag deleted while we were waiting for it!");
            thread.cpuContext._v0 = -2147352139;
        }
    }

    public void onThreadDeleted(SceKernelThreadInfo thread) {
        if (thread.isWaitingForType(7)) {
            this.removeWaitingThread(thread);
        }
    }

    private void onFplDeletedCancelled(int fid, int result) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        Iterator<SceKernelThreadInfo> it = threadMan.iterator();
        while (it.hasNext()) {
            SceKernelThreadInfo thread = it.next();
            if (!thread.isWaitingFor(7, fid)) continue;
            thread.cpuContext._v0 = result;
            threadMan.hleChangeThreadState(thread, 2);
            reschedule = true;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private void onFplDeleted(int fid) {
        this.onFplDeletedCancelled(fid, -2147352139);
    }

    private void onFplCancelled(int fid) {
        this.onFplDeletedCancelled(fid, -2147352151);
    }

    private void onFplFree(SceKernelFplInfo info) {
        SceKernelThreadInfo thread;
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        SceKernelThreadInfo checkedThread = null;
        while (info.freeBlocks > 0 && (thread = info.threadWaitingList.getNextWaitingThread(checkedThread)) != null) {
            int addr = this.tryAllocateFpl(info);
            if (addr != 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("onFplFree waking thread %s", thread));
                }
                thread.wait.Fpl_dataAddr.setValue(addr);
                info.threadWaitingList.removeWaitingThread(thread);
                thread.cpuContext._v0 = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
                continue;
            }
            checkedThread = thread;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private int tryAllocateFpl(SceKernelFplInfo info) {
        int block;
        int addr = 0;
        if (info.freeBlocks == 0 || (block = info.findFreeBlock()) == -1) {
            log.warn((Object)("tryAllocateFpl no free blocks (numBlocks=" + info.numBlocks + ")"));
            return 0;
        }
        addr = info.allocateBlock(block);
        return addr;
    }

    public int checkFplID(int uid) {
        SceUidManager.checkUidPurpose(uid, "ThreadMan-Fpl", true);
        if (!this.fplMap.containsKey(uid)) {
            log.warn((Object)String.format("checkFplID unknown uid=0x%X", uid));
            throw new SceKernelErrorException(-2147352163);
        }
        return uid;
    }

    public int sceKernelCreateFpl(PspString name, int partitionid, int attr, int blocksize, int blocks, TPointer option) {
        if (name.isNull()) {
            return -2147352176;
        }
        int memType = 0;
        if ((attr & 0x4000) == 16384) {
            memType = 1;
        }
        int memAlign = 4;
        if (option.isNotNull()) {
            int optionSize = option.getValue32();
            if (optionSize >= 4 && optionSize <= 8) {
                SceKernelFplOptParam optParams = new SceKernelFplOptParam();
                optParams.read(option);
                memAlign = optParams.align;
                if (!Utilities.isPower2(memAlign)) {
                    return -2147352366;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceKernelCreateFpl options: struct size=%d, alignment=0x%X", optParams.sizeof(), optParams.align));
                }
            } else {
                log.warn((Object)String.format("sceKernelCreateFpl option at %s, size=%d", option, optionSize));
            }
        }
        if ((attr & 0xFFFFBE00) != 0) {
            log.warn((Object)String.format("sceKernelCreateFpl bad attr value 0x%X", attr));
            return -2147352175;
        }
        if (blocksize <= 0) {
            log.warn((Object)String.format("sceKernelCreateFpl bad blocksize %d", blocksize));
            return -2147352137;
        }
        if (blocks <= 0) {
            log.warn((Object)String.format("sceKernelCreateFpl bad number of blocks %d", blocks));
            return -2147352137;
        }
        if (blocks * blocksize < 0) {
            return -2147352176;
        }
        if ((long)(blocks * blocksize) != (long)blocks * (long)blocksize) {
            return -2147352137;
        }
        SceKernelFplInfo info = SceKernelFplInfo.tryCreateFpl(name.getString(), partitionid, attr, blocksize, blocks, memType, memAlign);
        if (info == null) {
            return -2147352176;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelCreateFpl returning %s", info));
        }
        this.fplMap.put(info.uid, info);
        return info.uid;
    }

    public int sceKernelDeleteFpl(int uid) {
        SceKernelFplInfo info = this.fplMap.remove(uid);
        if (info.freeBlocks < info.numBlocks) {
            log.warn((Object)String.format("sceKernelDeleteFpl %s unfreed blocks, deleting", info.numBlocks - info.freeBlocks));
        }
        info.deleteSysMemInfo();
        this.onFplDeleted(uid);
        return 0;
    }

    private int hleKernelAllocateFpl(int uid, TPointer32 dataAddr, TPointer32 timeoutAddr, boolean wait, boolean doCallbacks) {
        SceKernelFplInfo fpl = this.fplMap.get(uid);
        int addr = this.tryAllocateFpl(fpl);
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        if (addr == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleKernelAllocateFpl %s fast check failed", fpl));
            }
            if (!wait) {
                return -2147352153;
            }
            SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
            fpl.threadWaitingList.addWaitingThread(currentThread);
            currentThread.wait.Fpl_id = uid;
            currentThread.wait.Fpl_dataAddr = dataAddr;
            threadMan.hleKernelThreadEnterWaitState(7, uid, this.fplWaitStateChecker, timeoutAddr.getAddress(), doCallbacks);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleKernelAllocateFpl %s fast check succeeded", fpl));
            }
            dataAddr.setValue(addr);
        }
        return 0;
    }

    public int sceKernelAllocateFpl(int uid, TPointer32 dataAddr, TPointer32 timeoutAddr) {
        return this.hleKernelAllocateFpl(uid, dataAddr, timeoutAddr, true, false);
    }

    public int sceKernelAllocateFplCB(int uid, TPointer32 dataAddr, TPointer32 timeoutAddr) {
        return this.hleKernelAllocateFpl(uid, dataAddr, timeoutAddr, true, true);
    }

    public int sceKernelTryAllocateFpl(int uid, TPointer32 dataAddr) {
        return this.hleKernelAllocateFpl(uid, dataAddr, TPointer32.NULL, false, false);
    }

    public int sceKernelFreeFpl(int uid, TPointer dataAddr) {
        SceKernelFplInfo info = this.fplMap.get(uid);
        int block = info.findBlockByAddress(dataAddr.getAddress());
        if (block < 0) {
            log.warn((Object)String.format("sceKernelFreeFpl unknown block address=%s", dataAddr));
            return -2147352138;
        }
        info.freeBlock(block);
        this.onFplFree(info);
        return 0;
    }

    public int sceKernelCancelFpl(int uid, TPointer32 numWaitThreadAddr) {
        SceKernelFplInfo info = this.fplMap.get(uid);
        numWaitThreadAddr.setValue(info.getNumWaitThreads());
        info.threadWaitingList.removeAllWaitingThreads();
        this.onFplCancelled(uid);
        return 0;
    }

    public int sceKernelReferFplStatus(int uid, TPointer infoAddr) {
        SceKernelFplInfo info = this.fplMap.get(uid);
        info.write(infoAddr);
        return 0;
    }

    private FplManager() {
    }

    private class FplWaitStateChecker
    implements IWaitStateChecker {
        private FplWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            SceKernelFplInfo fpl = (SceKernelFplInfo)FplManager.this.fplMap.get(wait.Fpl_id);
            if (fpl == null) {
                thread.cpuContext._v0 = -2147352163;
                return false;
            }
            int addr = FplManager.this.tryAllocateFpl(fpl);
            if (addr != 0) {
                fpl.threadWaitingList.removeWaitingThread(thread);
                thread.wait.Fpl_dataAddr.setValue(addr);
                thread.cpuContext._v0 = 0;
                return false;
            }
            return true;
        }
    }
}

