/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.managers.ThreadWaitingList;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructureVariableLength;

public class SceKernelLwMutexInfo
extends pspAbstractMemoryMappedStructureVariableLength {
    public final String name;
    public final int attr;
    public final int lwMutexUid;
    public final TPointer lwMutexOpaqueWorkAreaAddr;
    public final int initCount;
    public int lockedCount;
    public final ThreadWaitingList threadWaitingList;
    public final int uid;
    public int threadid;

    public SceKernelLwMutexInfo(TPointer workArea, String name, int count, int attr) {
        this.lwMutexUid = 0;
        this.lwMutexOpaqueWorkAreaAddr = workArea;
        this.name = name;
        this.attr = attr;
        this.initCount = count;
        this.lockedCount = count;
        this.threadid = count > 0 ? Modules.ThreadManForUserModule.getCurrentThreadID() : -1;
        this.uid = SceUidManager.getNewUid("ThreadMan-LwMutex");
        this.threadWaitingList = ThreadWaitingList.createThreadWaitingList(13, this.uid, attr, 256);
        this.lwMutexOpaqueWorkAreaAddr.setValue32(this.uid);
    }

    @Override
    protected void write() {
        super.write();
        this.writeStringNZ(32, this.name);
        this.write32(this.attr);
        this.write32(this.lwMutexUid);
        this.write32(this.lwMutexOpaqueWorkAreaAddr.getAddress());
        this.write32(this.initCount);
        this.write32(this.lockedCount);
        this.write32(this.threadid);
        this.write32(this.getNumWaitThreads());
    }

    public int getNumWaitThreads() {
        return this.threadWaitingList.getNumWaitingThreads();
    }

    @Override
    public String toString() {
        return String.format("SceKernelLwMutexInfo(uid=0x%X, name=%s, mutexUid=0x%X, lwMutexOpaqueWorkAreaAddr=%s, initCount=%d, lockedCount=%d, numWaitThreads=%d, attr=0x%X, threadid=0x%X)", this.uid, this.name, this.lwMutexUid, this.lwMutexOpaqueWorkAreaAddr, this.initCount, this.lockedCount, this.getNumWaitThreads(), this.attr, this.threadid);
    }
}

