/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.GeneralJpcspException;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

@HLELogging
public class LoadExecForUser
extends HLEModule {
    public static Logger log = Modules.getLogger("LoadExecForUser");
    protected int registeredExitCallbackUid;
    protected static final String encryptedBootPath = "disc0:/PSP_GAME/SYSDIR/EBOOT.BIN";
    protected static final String unencryptedBootPath = "disc0:/PSP_GAME/SYSDIR/BOOT.BIN";

    @Override
    public String getName() {
        return "LoadExecForUser";
    }

    public void triggerExitCallback() {
        Modules.ThreadManForUserModule.hleKernelNotifyCallback(5, 0);
    }

    @HLELogging(level="info")
    @HLEFunction(nid=-1120989036, version=150, checkInsideInterrupt=true)
    public int sceKernelLoadExec(PspString filename, @CanBeNull TPointer32 optionAddr) {
        int optSize;
        String name = filename.getString();
        if (name.equals(unencryptedBootPath)) {
            log.info((Object)String.format("sceKernelLoadExec '%s' replaced by '%s'", name, encryptedBootPath));
            name = encryptedBootPath;
        }
        Modules.SysMemUserForUserModule.reset();
        byte[] arguments = null;
        int argSize = 0;
        if (optionAddr.isNotNull() && (optSize = optionAddr.getValue(0)) >= 16) {
            argSize = optionAddr.getValue(4);
            int argAddr = optionAddr.getValue(8);
            int keyAddr = optionAddr.getValue(12);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceKernelLoadExec params: optSize=%d, argSize=%d, argAddr=0x%08X, keyAddr=0x%08X: %s", optSize, argSize, argAddr, keyAddr, Utilities.getMemoryDump(argAddr, argSize)));
            }
            arguments = new byte[argSize];
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(argAddr, argSize, 1);
            for (int i = 0; i < argSize; ++i) {
                arguments[i] = (byte)memoryReader.readNext();
            }
        }
        try {
            SeekableDataInput moduleInput = Modules.IoFileMgrForUserModule.getFile(name, 1);
            if (moduleInput != null) {
                byte[] moduleBytes = new byte[(int)moduleInput.length()];
                moduleInput.readFully(moduleBytes);
                moduleInput.close();
                ByteBuffer moduleBuffer = ByteBuffer.wrap(moduleBytes);
                SceModule module = Emulator.getInstance().load(name, moduleBuffer, true);
                Emulator.getClock().resume();
                int pathIndex = name.lastIndexOf("/");
                if (pathIndex >= 0) {
                    Modules.IoFileMgrForUserModule.setHost0Path(name.substring(0, pathIndex + 1));
                }
                if ((module.fileFormat & 1) != 1) {
                    log.warn((Object)"sceKernelLoadExec - failed, target is not an ELF");
                    throw new SceKernelErrorException(-2147352244);
                }
                SceKernelThreadInfo rootThread = Modules.ThreadManForUserModule.getCurrentThread();
                Modules.ThreadManForUserModule.hleKernelSetThreadArguments(rootThread, arguments, argSize);
            }
        }
        catch (GeneralJpcspException e) {
            log.error((Object)"General Error", (Throwable)e);
            Emulator.PauseEmu();
        }
        catch (IOException e) {
            log.error((Object)String.format("sceKernelLoadExec - Error while loading module '%s'", name), (Throwable)e);
            return -2147352249;
        }
        return 0;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=717854027, version=150, checkInsideInterrupt=true)
    public int sceKernelExitGameWithStatus(int status) {
        Emulator.PauseEmuWithStatus(status);
        RuntimeContext.reset();
        Modules.ThreadManForUserModule.stop();
        return 0;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=89598559, version=150, checkInsideInterrupt=true)
    public int sceKernelExitGame() {
        Emulator.PauseEmu();
        RuntimeContext.reset();
        Modules.ThreadManForUserModule.stop();
        return 0;
    }

    @HLEFunction(nid=1254455619, version=150, checkInsideInterrupt=true)
    public int sceKernelRegisterExitCallback(int uid) {
        if (Modules.ThreadManForUserModule.hleKernelRegisterCallback(5, uid)) {
            this.registeredExitCallbackUid = uid;
        }
        return 0;
    }
}

