/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.nio.ByteBuffer;
import java.util.HashMap;
import jpcsp.Emulator;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEUidClass;
import jpcsp.HLE.HLEUidObjectMapping;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import jpcsp.media.MediaEngine;
import jpcsp.media.PacketChannel;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

@HLELogging
public class sceMp3
extends HLEModule {
    public static Logger log = Modules.getLogger("sceMp3");
    protected int mp3HandleCount;
    protected HashMap<Integer, Mp3Stream> mp3Map;
    protected static final int compressionFactor = 10;
    protected static final int PSP_MP3_LOOP_NUM_INFINITE = -1;
    protected static final int mp3DecodeDelay = 4000;
    private boolean useMediaEngine = false;
    static final int ERROR_MP3_NOT_FOUND = 0;

    @Override
    public String getName() {
        return "sceMp3";
    }

    @Override
    public void start() {
        this.mp3Map = new HashMap();
        this.setSettingsListener("emu.useMediaEngine", new EnableMediaEngineSettingsListerner());
        super.start();
    }

    protected boolean checkMediaEngineState() {
        return this.useMediaEngine;
    }

    private void setEnableMediaEngine(boolean state) {
        this.useMediaEngine = state;
    }

    protected int endianSwap(int x) {
        return x << 24 | x << 8 & 0xFF0000 | x >> 8 & 0xFF00 | x >> 24 & 0xFF;
    }

    public int makeFakeMp3StreamHandle() {
        return 0xA300 | this.mp3HandleCount++ & 0xFFFF;
    }

    private void delayThread(long startMicros, int delayMicros) {
        long now = Emulator.getClock().microTime();
        int threadDelayMicros = delayMicros - (int)(now - startMicros);
        if (threadDelayMicros > 0) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(threadDelayMicros, false);
        }
    }

    @HLEFunction(nid=132919834, version=150, checkInsideInterrupt=true)
    public Mp3Stream sceMp3ReserveMp3Handle(TPointer mp3args) {
        Mp3Stream mp3Stream = new Mp3Stream(mp3args.getAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp3ReserveMp3Handle returning %s", mp3Stream));
        }
        return mp3Stream;
    }

    @HLEFunction(nid=229722612, version=150, checkInsideInterrupt=true)
    public int sceMp3NotifyAddStreamData(Mp3Stream mp3Stream, int size) {
        mp3Stream.addMp3StreamData(size);
        return 0;
    }

    @HLEFunction(nid=708216417, version=150, checkInsideInterrupt=true)
    public int sceMp3ResetPlayPosition(Mp3Stream mp3Stream) {
        mp3Stream.setMp3BufCurrentPos(0);
        return 0;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=896860272, version=150, checkInsideInterrupt=true)
    public int sceMp3InitResource() {
        return 0;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=1009754200, version=150, checkInsideInterrupt=true)
    public int sceMp3TermResource() {
        return 0;
    }

    @HLEFunction(nid=1022314575, version=150, checkInsideInterrupt=true)
    public int sceMp3SetLoopNum(Mp3Stream mp3Stream, int loopNbr) {
        mp3Stream.setMp3LoopNum(loopNbr);
        return 0;
    }

    @HLEFunction(nid=1155559721, version=150, checkInsideInterrupt=true)
    public int sceMp3Init(Mp3Stream mp3Stream) {
        mp3Stream.init();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Initializing Mp3 data: channels=%d, samplerate=%dkHz, bitrate=%dkbps.", mp3Stream.getMp3ChannelNum(), mp3Stream.getMp3SamplingRate(), mp3Stream.getMp3BitRate()));
        }
        return 0;
    }

    @HLEFunction(nid=2137614210, version=150, checkInsideInterrupt=true)
    public int sceMp3GetMp3ChannelNum(Mp3Stream mp3Stream) {
        return mp3Stream.getMp3ChannelNum();
    }

    @HLEFunction(nid=-1891300968, version=150, checkInsideInterrupt=true)
    public int sceMp3GetSamplingRate(Mp3Stream mp3Stream) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp3GetSamplingRate returning 0x%X", mp3Stream.getMp3SamplingRate()));
        }
        return mp3Stream.getMp3SamplingRate();
    }

    @HLEFunction(nid=-1492910577, version=150, checkInsideInterrupt=true)
    public int sceMp3GetInfoToAddStreamData(Mp3Stream mp3Stream, @CanBeNull TPointer32 mp3BufPtr, @CanBeNull TPointer32 mp3BufToWritePtr, @CanBeNull TPointer32 mp3PosPtr) {
        mp3BufPtr.setValue(mp3Stream.isStreamDataEnd() ? 0 : mp3Stream.getMp3BufWriteAddr());
        int mp3BufToWrite = mp3Stream.isStreamDataEnd() ? 0 : (mp3Stream.getMp3InputFileSize() == 0L ? mp3Stream.getMaxAddStreamDataSize() * 2 : mp3Stream.getMaxAddStreamDataSize());
        mp3BufToWrite = Math.min(mp3BufToWrite, mp3Stream.getMp3AvailableSequentialWriteSize());
        mp3BufToWritePtr.setValue(mp3BufToWrite);
        mp3PosPtr.setValue((int)mp3Stream.getMp3InputFileSize());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp3GetInfoToAddStreamData returning mp3Buf=0x%08X, mp3BufToWrite=0x%X, mp3Pos=0x%X", mp3BufPtr.getValue(), mp3BufToWritePtr.getValue(), mp3PosPtr.getValue()));
        }
        return 0;
    }

    @HLEFunction(nid=-803094277, version=150, checkInsideInterrupt=true)
    public int sceMp3Decode(Mp3Stream mp3Stream, TPointer32 outPcmPtr) {
        long startTime = Emulator.getClock().microTime();
        int decodeBuffer = mp3Stream.getDecodeBuffer();
        int pcmBytes = mp3Stream.decode(decodeBuffer, mp3Stream.getDecodeBufferSize());
        outPcmPtr.setValue(decodeBuffer);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp3Decode returning 0x%X bytes (%d samples) at 0x%08X", pcmBytes, mp3Stream.getMp3DecodedSamples(), outPcmPtr.getValue()));
        }
        this.delayThread(startTime, 4000);
        return pcmBytes;
    }

    @HLEFunction(nid=-794467690, version=150, checkInsideInterrupt=true)
    public boolean sceMp3CheckStreamDataNeeded(Mp3Stream mp3Stream) {
        boolean dataNeeded = mp3Stream.isStreamDataNeeded();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp3CheckStreamDataNeeded returning %b", dataNeeded));
        }
        return dataNeeded;
    }

    @HLEFunction(nid=-179862989, version=150, checkInsideInterrupt=true)
    public int sceMp3ReleaseMp3Handle(Mp3Stream mp3Stream) {
        HLEUidObjectMapping.removeObject(mp3Stream);
        return 0;
    }

    @HLEFunction(nid=894248938, version=150)
    public int sceMp3GetSumDecodedSample(Mp3Stream mp3Stream) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp3GetSumDecodedSample returning %d", mp3Stream.getMp3SumDecodedSamples()));
        }
        return mp3Stream.getMp3SumDecodedSamples();
    }

    @HLEFunction(nid=-2023260608, version=150, checkInsideInterrupt=true)
    public int sceMp3GetBitRate(Mp3Stream mp3Stream) {
        return mp3Stream.getMp3BitRate();
    }

    @HLEFunction(nid=-2017303599, version=150, checkInsideInterrupt=true)
    public int sceMp3GetMaxOutputSample(Mp3Stream mp3Stream) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp3GetMaxOutputSample returning 0x%X", mp3Stream.getMp3MaxSamples()));
        }
        return mp3Stream.getMp3MaxSamples();
    }

    @HLEFunction(nid=-655013295, version=150, checkInsideInterrupt=true)
    public int sceMp3GetLoopNum(Mp3Stream mp3Stream) {
        return mp3Stream.getMp3LoopNum();
    }

    @HLEUnimplemented
    @HLEFunction(nid=893955784, version=150)
    public int sceMp3GetFrameNum(Mp3Stream mp3Stream) {
        return 0;
    }

    @HLEFunction(nid=-1368580057, version=150)
    public int sceMp3GetVersion(Mp3Stream mp3Stream) {
        return mp3Stream.getMp3Version();
    }

    @HLEFunction(nid=138471432, version=150, checkInsideInterrupt=true)
    public int sceMp3ResetPlayPosition2(Mp3Stream mp3Stream, int position) {
        mp3Stream.setMp3BufCurrentPos(position);
        return 0;
    }

    @HLEUidClass(moduleMethodUidGenerator="makeFakeMp3StreamHandle", errorValueOnNotFound=0)
    protected class Mp3Stream {
        private static final int ME_READ_AHEAD = 32768;
        private final long mp3StreamStart;
        private final long mp3StreamEnd;
        private final int mp3Buf;
        private final int mp3BufSize;
        private final int mp3PcmBuf;
        private final int mp3PcmBufSize;
        private final int mp3CompleteBuf;
        private final int mp3CompleteBufSize;
        private long mp3InputFileSize;
        private int mp3InputFileReadPos;
        private int mp3InputBufWritePos;
        private int mp3InputBufSize;
        private int mp3DecodedBytes;
        private int mp3SumDecodedSamples;
        private int mp3SampleRate;
        private int mp3LoopNum;
        private int mp3BitRate;
        private int mp3MaxSamples;
        private int mp3Channels;
        private int mp3Version;
        protected MediaEngine me;
        protected PacketChannel mp3Channel;
        private byte[] mp3PcmBuffer;
        private int decodeCount;

        public Mp3Stream(int args) {
            Memory mem = Memory.getInstance();
            this.mp3StreamStart = mem.read64(args);
            this.mp3StreamEnd = mem.read64(args + 8);
            this.mp3CompleteBuf = mem.read32(args + 16);
            this.mp3CompleteBufSize = mem.read32(args + 20);
            this.mp3PcmBuf = mem.read32(args + 24);
            this.mp3PcmBufSize = mem.read32(args + 28);
            int reservedSize = 1472;
            this.mp3Buf = this.mp3CompleteBuf + 1472;
            this.mp3BufSize = this.mp3CompleteBufSize - 1472;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceMp3ReserveMp3Handle Stream start=0x%X, end=0x%X", this.mp3StreamStart, this.mp3StreamEnd));
                log.debug((Object)String.format("sceMp3ReserveMp3Handle Mp3Buf 0x%08X, size=0x%X", this.mp3CompleteBuf, this.mp3CompleteBufSize));
                log.debug((Object)String.format("sceMp3ReserveMp3Handle PcmBuf 0x%08X, size=0x%X", this.mp3PcmBuf, this.mp3PcmBufSize));
            }
            this.mp3InputFileReadPos = 0;
            this.mp3InputFileSize = 0L;
            this.mp3InputBufWritePos = this.mp3InputFileReadPos;
            this.mp3InputBufSize = 0;
            this.initMp3MaxSamples(2);
            this.mp3LoopNum = -1;
            this.mp3DecodedBytes = 0;
            this.mp3SumDecodedSamples = 0;
            if (sceMp3.this.checkMediaEngineState()) {
                this.me = new MediaEngine();
                this.me.setAudioSamplesSize(this.mp3MaxSamples);
                this.mp3Channel = new PacketChannel();
            }
            this.mp3PcmBuffer = new byte[this.mp3PcmBufSize];
        }

        private void initMp3MaxSamples(int mp3Channels) {
            int maxSampleBytes = mp3Channels == 1 ? 2304 : 4608;
            this.mp3MaxSamples = Math.min(this.mp3PcmBufSize, maxSampleBytes) / 4;
        }

        private void parseMp3FrameHeader() {
            Memory mem = Memory.getInstance();
            int header = sceMp3.this.endianSwap(Utilities.readUnaligned32(mem, this.mp3Buf + (int)this.mp3StreamStart));
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Mp3 header: 0x%08X", header));
            }
            this.mp3Version = header >> 19 & 3;
            int mp3Layer = header >> 17 & 3;
            this.mp3Channels = this.calculateMp3Channels(header >> 6 & 3);
            this.mp3SampleRate = this.calculateMp3SampleRate(header >> 10 & 3, this.mp3Version);
            this.mp3BitRate = this.calculateMp3Bitrate(header >> 12 & 0xF, this.mp3Version, mp3Layer);
            this.initMp3MaxSamples(this.mp3Channels);
        }

        private int calculateMp3Bitrate(int bitVal, int mp3Version, int mp3Layer) {
            int[] valueMapping = null;
            block0 : switch (mp3Version) {
                case 3: {
                    switch (mp3Layer) {
                        case 3: {
                            valueMapping = new int[]{0, 32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448, -1};
                            break;
                        }
                        case 2: {
                            valueMapping = new int[]{0, 32, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384, -1};
                            break;
                        }
                        case 1: {
                            valueMapping = new int[]{0, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, -1};
                        }
                    }
                    break;
                }
                case 0: 
                case 2: {
                    switch (mp3Layer) {
                        case 3: {
                            valueMapping = new int[]{0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256, -1};
                            break block0;
                        }
                        case 1: 
                        case 2: {
                            valueMapping = new int[]{0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, -1};
                        }
                    }
                }
            }
            if (valueMapping == null) {
                return -1;
            }
            return (int)valueMapping[bitVal];
        }

        private int calculateMp3SampleRate(int bitVal, int mp3Version) {
            int[] valueMapping = null;
            switch (mp3Version) {
                case 3: {
                    valueMapping = new int[]{44100, 48000, 32000, -1};
                    break;
                }
                case 2: {
                    valueMapping = new int[]{22050, 24000, 16000, -1};
                    break;
                }
                case 0: {
                    valueMapping = new int[]{11025, 12000, 8000, -1};
                }
            }
            if (valueMapping == null) {
                return 0;
            }
            return (int)valueMapping[bitVal];
        }

        private int calculateMp3Channels(int bitVal) {
            if (bitVal == 0 || bitVal == 1 || bitVal == 2) {
                return 2;
            }
            if (bitVal == 3) {
                return 1;
            }
            return 0;
        }

        private int getMaxAddStreamDataSize() {
            return this.mp3BufSize >> 1;
        }

        public int getMp3AvailableSequentialWriteSize() {
            return Math.min(this.getMp3AvailableWriteSize(), this.mp3BufSize - this.mp3InputBufWritePos);
        }

        public int getMp3AvailableReadSize() {
            return this.mp3InputBufSize;
        }

        public int getMp3AvailableWriteSize() {
            return this.mp3BufSize - this.getMp3AvailableReadSize();
        }

        private int consumeRead(int size) {
            size = Math.min(size, this.getMp3AvailableReadSize());
            this.mp3InputBufSize -= size;
            this.mp3InputFileReadPos += size;
            return size;
        }

        private int consumeWrite(int size) {
            size = Math.min(size, this.getMp3AvailableWriteSize());
            this.mp3InputBufSize += size;
            this.mp3InputBufWritePos += size;
            if (this.mp3InputBufWritePos >= this.mp3BufSize) {
                this.mp3InputBufWritePos -= this.mp3BufSize;
            }
            return size;
        }

        public void init() {
            this.parseMp3FrameHeader();
            if (sceMp3.this.checkMediaEngineState()) {
                this.me.finish();
            }
        }

        private boolean checkMediaEngineChannel() {
            if (sceMp3.this.checkMediaEngineState()) {
                int minimumChannelLength = (int)Math.min(32768L, this.mp3StreamEnd - this.mp3StreamStart);
                if (this.mp3Channel.length() < minimumChannelLength) {
                    int neededLength = 32768 - this.mp3Channel.length();
                    this.consumeRead(neededLength);
                    return false;
                }
            }
            return true;
        }

        public int getDecodeBuffer() {
            int decodeBuffer = this.mp3PcmBuf;
            if ((this.decodeCount & 1) != 0) {
                decodeBuffer += this.getDecodeBufferSize();
            }
            return decodeBuffer;
        }

        public int getDecodeBufferSize() {
            return this.mp3PcmBufSize >> 1;
        }

        public int decode(int decodeBuffer, int decodeBufferSize) {
            ++this.decodeCount;
            if (sceMp3.this.checkMediaEngineState()) {
                if (this.me.getContainer() != null || this.checkMediaEngineChannel()) {
                    if (this.me.getContainer() == null) {
                        this.me.init(this.mp3Channel, false, true, 0, 0);
                    }
                    this.me.stepAudio(this.getMp3MaxSamples() * this.getBytesPerSample(), this.getMp3DecodeNumberOfChannels());
                    this.mp3DecodedBytes = this.copySamplesToMem(decodeBuffer, decodeBufferSize, this.mp3PcmBuffer);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("decoded %d samples: %s", this.mp3DecodedBytes, Utilities.getMemoryDump(decodeBuffer, this.mp3DecodedBytes)));
                    }
                } else {
                    int fakeSamples = 1;
                    this.mp3DecodedBytes = fakeSamples * this.getBytesPerSample();
                    Memory.getInstance().memset(decodeBuffer, (byte)0, decodeBufferSize);
                }
            } else {
                this.mp3DecodedBytes = this.getMp3MaxSamples() * this.getBytesPerSample();
                Memory.getInstance().memset(decodeBuffer, (byte)0, this.mp3DecodedBytes);
                int mp3BufReadConsumed = Math.min(this.mp3DecodedBytes / 10, this.getMp3AvailableReadSize());
                this.consumeRead(mp3BufReadConsumed);
            }
            this.mp3SumDecodedSamples += this.mp3DecodedBytes / this.getBytesPerSample();
            return this.mp3DecodedBytes;
        }

        public int getBytesPerSample() {
            return this.getMp3DecodeNumberOfChannels() * 2;
        }

        public boolean isStreamDataNeeded() {
            if (this.isStreamDataEnd()) {
                return false;
            }
            if (sceMp3.this.checkMediaEngineState()) {
                this.checkMediaEngineChannel();
                if (this.mp3Channel.length() >= 32768) {
                    return false;
                }
            }
            return this.getMp3AvailableSequentialWriteSize() >= this.getMaxAddStreamDataSize();
        }

        public boolean isStreamDataEnd() {
            return this.mp3InputFileSize >= this.mp3StreamEnd;
        }

        public int addMp3StreamData(int size) {
            if (sceMp3.this.checkMediaEngineState()) {
                this.mp3Channel.write(this.getMp3BufWriteAddr(), size);
            }
            this.mp3InputFileSize += (long)size;
            return this.consumeWrite(size);
        }

        private int copySamplesToMem(int address, int maxLength, byte[] buffer) {
            Memory mem = Memory.getInstance();
            int bytes = this.me.getCurrentAudioSamples(buffer);
            if (bytes > 0) {
                mem.copyToMemory(address, ByteBuffer.wrap(buffer, 0, bytes), bytes);
            }
            return bytes;
        }

        public int getMp3BufWriteAddr() {
            return this.getMp3BufAddr() + this.getMp3InputBufWritePos();
        }

        public int getMp3LoopNum() {
            return this.mp3LoopNum;
        }

        public int getMp3BufAddr() {
            return this.mp3Buf;
        }

        public int getMp3PcmBufAddr() {
            return this.mp3PcmBuf;
        }

        public int getMp3PcmBufSize() {
            return this.mp3PcmBufSize;
        }

        public int getMp3InputFileReadPos() {
            return this.mp3InputFileReadPos;
        }

        public int getMp3InputBufWritePos() {
            return this.mp3InputBufWritePos;
        }

        public int getMp3BufSize() {
            return this.mp3BufSize;
        }

        public int getMp3DecodedSamples() {
            return this.mp3DecodedBytes / this.getBytesPerSample();
        }

        public int getMp3MaxSamples() {
            return this.mp3MaxSamples;
        }

        public int getMp3BitRate() {
            return this.mp3BitRate;
        }

        public int getMp3ChannelNum() {
            return this.mp3Channels;
        }

        public int getMp3DecodeNumberOfChannels() {
            return 2;
        }

        public int getMp3SamplingRate() {
            return this.mp3SampleRate;
        }

        public long getMp3InputFileSize() {
            return this.mp3InputFileSize;
        }

        public void setMp3LoopNum(int n) {
            this.mp3LoopNum = n;
        }

        public void setMp3BufCurrentPos(int pos) {
            this.mp3InputFileReadPos = pos;
            this.mp3InputBufWritePos = pos;
            this.mp3InputBufSize = 0;
            this.mp3InputFileSize = 0L;
            this.mp3DecodedBytes = 0;
        }

        public int getMp3Version() {
            return this.mp3Version;
        }

        public int getMp3SumDecodedSamples() {
            return this.mp3SumDecodedSamples;
        }

        public String toString() {
            return String.format("Mp3Stream(maxSize=%d, availableSize=%d, readPos=%d, writePos=%d)", this.mp3BufSize, this.mp3InputBufSize, this.mp3InputFileReadPos, this.mp3InputBufWritePos);
        }
    }

    private class EnableMediaEngineSettingsListerner
    extends AbstractBoolSettingsListener {
        private EnableMediaEngineSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceMp3.this.setEnableMediaEngine(value);
        }
    }
}

