/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import jpcsp.Emulator;
import jpcsp.GeneralJpcspException;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.SceKernelLMOption;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules150.IoFileMgrForUser;
import jpcsp.State;
import jpcsp.connector.PGDFileConnector;
import jpcsp.crypto.CryptoEngine;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.filesystems.SeekableRandomFile;
import org.apache.log4j.Logger;

@HLELogging
public class scePspNpDrm_user
extends HLEModule {
    public static Logger log = Modules.getLogger("scePspNpDrm_user");
    public static final int PSP_NPDRM_KEY_LENGHT = 16;
    private byte[] npDrmKey = new byte[16];
    private PGDFileConnector edatFileConnector;

    @Override
    public String getName() {
        return "scePspNpDrm_user";
    }

    protected boolean isEmptyDrmKey() {
        for (int i = 0; i < this.npDrmKey.length; ++i) {
            if (this.npDrmKey[i] == 0) continue;
            return false;
        }
        return true;
    }

    protected String getFileNameFromPath(String path) {
        String pcfilename = Modules.IoFileMgrForUserModule.getDeviceFilePath(path);
        String[] name = pcfilename.split("/");
        String fName = "";
        for (int i = 0; i < name.length; ++i) {
            if (!name[i].toUpperCase().contains("EDAT")) continue;
            fName = name[i];
        }
        return fName;
    }

    protected String getDLCPathFromFilePath(String path) {
        String pcfilename = Modules.IoFileMgrForUserModule.getDeviceFilePath(path);
        String[] name = pcfilename.split("/");
        String fName = "";
        for (int i = 0; i < name.length; ++i) {
            String uname = name[i].toUpperCase();
            if (name[i].contains("ms0") || !uname.contains("PSP") || !uname.contains("GAME") || !uname.contains(State.discId) || !uname.contains("EDAT")) continue;
            fName = fName + File.separatorChar + name[i];
        }
        if (fName.length() == 0) {
            return fName;
        }
        return fName.substring(1);
    }

    @HLEFunction(nid=-1590468463, version=150, checkInsideInterrupt=true)
    public int sceNpDrmSetLicenseeKey(TPointer npDrmKeyAddr) {
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            this.npDrmKey[i] = npDrmKeyAddr.getValue8(i);
            key.append(String.format("%02X", this.npDrmKey[i] & 0xFF));
        }
        log.info((Object)String.format("NPDRM Encryption key detected: 0x%s", key.toString()));
        return 0;
    }

    @HLEFunction(nid=-1686874814, version=150, checkInsideInterrupt=true)
    public int sceNpDrmClearLicenseeKey() {
        Arrays.fill(this.npDrmKey, (byte)0);
        return 0;
    }

    @HLELogging(level="warn")
    @HLEFunction(nid=660178897, version=150, checkInsideInterrupt=true)
    public int sceNpDrmRenameCheck(PspString fileName) {
        CryptoEngine crypto = new CryptoEngine();
        int result = 0;
        if (this.isEmptyDrmKey()) {
            result = -2141910762;
        } else {
            try {
                String pcfilename = Modules.IoFileMgrForUserModule.getDeviceFilePath(fileName.getString());
                SeekableRandomFile file = new SeekableRandomFile(pcfilename, "r");
                String[] name = pcfilename.split("/");
                String fName = "";
                for (int i = 0; i < name.length; ++i) {
                    if (!name[i].contains("EDAT")) continue;
                    fName = name[i];
                }
                byte[] inBuf = new byte[128];
                byte[] nameHash = new byte[16];
                file.readFully(inBuf);
                file.close();
                System.arraycopy(inBuf, 64, nameHash, 0, 16);
                if (!crypto.getPGDEngine().CheckEDATRenameKey(nameHash, this.npDrmKey, fName.getBytes())) {
                    result = 0;
                }
            }
            catch (FileNotFoundException e) {
                result = -2141910783;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNpDrmRenameCheck: file '%s' not found: %s", fileName.getString(), e.toString()));
                }
            }
            catch (Exception e) {
                log.error((Object)"sceNpDrmRenameCheck", (Throwable)e);
            }
        }
        return result;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=148474004, version=150, checkInsideInterrupt=true)
    public int sceNpDrmEdataSetupKey(int edataFd) {
        String dlcPath;
        String decFileName;
        SeekableDataInput decInput;
        if (this.isEmptyDrmKey()) {
            return -2141910762;
        }
        IoFileMgrForUser.IoInfo info = Modules.IoFileMgrForUserModule.getFileIoInfo(edataFd);
        if (info == null) {
            return 0;
        }
        CryptoEngine crypto = new CryptoEngine();
        int result = 0;
        if (this.edatFileConnector == null) {
            this.edatFileConnector = new PGDFileConnector();
        }
        if ((decInput = this.edatFileConnector.loadDecryptedEDATPGDFile(decFileName = (dlcPath = this.edatFileConnector.getBaseDLCDirectory() + this.getDLCPathFromFilePath(info.filename)) + File.separatorChar + this.getFileNameFromPath(info.filename))) != null) {
            info.readOnlyFile = decInput;
        } else {
            try {
                int pgdHeaderSize = 144;
                int pgdHeaderDataOffset = 48;
                int edatPGDOffset = 144;
                byte[] fileBuf = new byte[(int)info.readOnlyFile.length()];
                byte[] encHeaderBuf = new byte[pgdHeaderSize];
                long startPosition = info.readOnlyFile.getFilePointer();
                info.readOnlyFile.readFully(fileBuf);
                info.readOnlyFile.seek(startPosition);
                if (fileBuf[0] != 0 || fileBuf[1] != 80 || fileBuf[2] != 83 || fileBuf[3] != 80 || fileBuf[4] != 69 || fileBuf[5] != 68 || fileBuf[6] != 65 || fileBuf[7] != 84) {
                    log.warn((Object)"PSPEDAT header not found!");
                    return 0;
                }
                System.arraycopy(fileBuf, edatPGDOffset, encHeaderBuf, 0, pgdHeaderSize);
                byte[] decKey = crypto.getPGDEngine().GetEDATPGDKey(encHeaderBuf, pgdHeaderSize);
                byte[] decHeader = crypto.getPGDEngine().DecryptEDATPGDHeader(encHeaderBuf, pgdHeaderSize, decKey);
                System.arraycopy(decHeader, 0, fileBuf, edatPGDOffset + pgdHeaderDataOffset, decHeader.length);
                int dataSize = decHeader[20] & 0xFF | (decHeader[21] & 0xFF) << 8 | (decHeader[22] & 0xFF) << 16 | (decHeader[23] & 0xFF) << 24;
                int chunkSize = decHeader[24] & 0xFF | (decHeader[25] & 0xFF) << 8 | (decHeader[26] & 0xFF) << 16 | (decHeader[27] & 0xFF) << 24;
                int hashOffset = decHeader[28] & 0xFF | (decHeader[29] & 0xFF) << 8 | (decHeader[30] & 0xFF) << 16 | (decHeader[31] & 0xFF) << 24;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("PGD dataSize=0x%08x, chunkSize=0x%08x, hashOffset=0x%08x", dataSize, chunkSize, hashOffset));
                }
                byte[] inBuf = new byte[fileBuf.length - edatPGDOffset];
                System.arraycopy(fileBuf, edatPGDOffset, inBuf, 0, inBuf.length);
                byte[] outBuf = crypto.getPGDEngine().DecryptEDATPGD(inBuf, dataSize, hashOffset, chunkSize, decKey);
                if (hashOffset < 0 || dataSize < 0) {
                    log.warn((Object)String.format("Incorrect PGD header: dataSize=%d, chunkSize=%d, hashOffset=%d", dataSize, chunkSize, hashOffset));
                    result = -2142174716;
                } else {
                    new File(dlcPath).mkdirs();
                    SeekableRandomFile decFile = new SeekableRandomFile(decFileName, "rw");
                    decFile.write(outBuf);
                    decFile.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                info.readOnlyFile.seek(info.position);
            }
            catch (Exception e) {
                // empty catch block
            }
            info.readOnlyFile = this.edatFileConnector.loadDecryptedEDATPGDFile(decFileName);
        }
        return result;
    }

    @HLEFunction(nid=564065740, version=150, checkInsideInterrupt=true)
    public int sceNpDrmEdataGetDataSize(int edataFd) {
        IoFileMgrForUser.IoInfo info = Modules.IoFileMgrForUserModule.getFileIoInfo(edataFd);
        int size = 0;
        if (info != null) {
            try {
                size = (int)info.readOnlyFile.length();
            }
            catch (IOException e) {
                log.error((Object)"sceNpDrmEdataGetDataSize", (Throwable)e);
            }
        }
        return size;
    }

    @HLEUnimplemented
    @HLEFunction(nid=732578452, version=150, checkInsideInterrupt=true)
    public int sceNpDrmOpen(PspString name, int flags, int permissions) {
        if (this.isEmptyDrmKey()) {
            return -2141910762;
        }
        int fd = Modules.IoFileMgrForUserModule.hleIoOpen(name, flags | 0x40000000, permissions, true);
        return this.sceNpDrmEdataSetupKey(fd);
    }

    @HLEFunction(nid=-971452239, version=150, checkInsideInterrupt=true)
    public int sceKernelLoadModuleNpDrm(PspString path, int flags, @CanBeNull TPointer optionAddr) {
        SceKernelLMOption lmOption = null;
        if (optionAddr.isNotNull()) {
            lmOption = new SceKernelLMOption();
            lmOption.read(optionAddr);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceKernelLoadModuleNpDrm partition=%d, position=%d", lmOption.mpidText, lmOption.position));
            }
        }
        return Modules.ModuleMgrForUserModule.hleKernelLoadModule(path.getString(), flags, 0, false);
    }

    @HLEFunction(nid=-1436563365, version=150, checkInsideInterrupt=true)
    public int sceKernelLoadExecNpDrm(PspString fileName, @CanBeNull TPointer optionAddr) {
        int result;
        Modules.SysMemUserForUserModule.reset();
        if (optionAddr.isNotNull()) {
            int optSize = optionAddr.getValue32(0);
            int argSize = optionAddr.getValue32(4);
            int argAddr = optionAddr.getValue32(8);
            int keyAddr = optionAddr.getValue32(12);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceKernelLoadExecNpDrm (params: optSize=%d, argSize=%d, argAddr=0x%08X, keyAddr=0x%08X)", optSize, argSize, argAddr, keyAddr));
            }
        }
        try {
            SeekableDataInput moduleInput = Modules.IoFileMgrForUserModule.getFile(fileName.getString(), 1);
            if (moduleInput != null) {
                byte[] moduleBytes = new byte[(int)moduleInput.length()];
                moduleInput.readFully(moduleBytes);
                moduleInput.close();
                ByteBuffer moduleBuffer = ByteBuffer.wrap(moduleBytes);
                SceModule module = Emulator.getInstance().load(fileName.getString(), moduleBuffer, true);
                Emulator.getClock().resume();
                if ((module.fileFormat & 1) == 1) {
                    result = 0;
                } else {
                    log.warn((Object)"sceKernelLoadExecNpDrm - failed, target is not an ELF");
                    result = -2147352244;
                }
            } else {
                result = -2147352249;
            }
        }
        catch (GeneralJpcspException e) {
            log.error((Object)"sceKernelLoadExecNpDrm", (Throwable)e);
            result = -2147352249;
        }
        catch (IOException e) {
            log.error((Object)String.format("sceKernelLoadExecNpDrm - Error while loading module '%s'", fileName), (Throwable)e);
            result = -2147352249;
        }
        return result;
    }
}

