/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.export;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Locale;
import jpcsp.graphics.GeContext;
import jpcsp.graphics.VertexState;
import jpcsp.graphics.VideoEngine;
import jpcsp.graphics.export.IGraphicsExporter;
import org.apache.log4j.Logger;

public class WavefrontExporter
implements IGraphicsExporter {
    private static Logger log = VideoEngine.log;
    private static Locale l = Locale.ENGLISH;
    private GeContext context;
    private BufferedWriter exportObj;
    private BufferedWriter exportMtl;
    private int exportVertexCount;
    private int exportTextureCount;
    private int exportNormalCount;
    private int exportModelCount;
    private int exportMaterialCount;
    private static final boolean exportNormal = false;

    protected void exportObjLine(String line) {
        if (this.exportObj != null) {
            try {
                this.exportObj.write(line);
                this.exportObj.newLine();
            }
            catch (IOException e) {
                log.error((Object)"Error writing export.obj file", (Throwable)e);
            }
        }
    }

    protected void exportMtlLine(String line) {
        if (this.exportMtl != null) {
            try {
                this.exportMtl.write(line);
                this.exportMtl.newLine();
            }
            catch (IOException e) {
                log.error((Object)"Error writing export.mtl file", (Throwable)e);
            }
        }
    }

    public static String getExportDirectory() {
        int i = 1;
        String directory;
        while (new File(directory = String.format("%sExport-%d%c", "export/", i, Character.valueOf(File.separatorChar))).exists()) {
            ++i;
        }
        return directory;
    }

    @Override
    public void startExport(GeContext context, String directory) {
        this.context = context;
        try {
            this.exportObj = new BufferedWriter(new FileWriter(String.format("%sexport.obj", directory)));
            this.exportMtl = new BufferedWriter(new FileWriter(String.format("%sexport.mtl", directory)));
        }
        catch (IOException e) {
            log.error((Object)"Error creating the export files", (Throwable)e);
        }
        this.exportVertexCount = 1;
        this.exportModelCount = 1;
        this.exportTextureCount = 1;
        this.exportMaterialCount = 1;
        this.exportObjLine(String.format("mtllib export.mtl", new Object[0]));
    }

    @Override
    public void endExport() {
        if (this.exportObj != null) {
            try {
                this.exportObj.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.exportObj = null;
        }
        if (this.exportMtl != null) {
            try {
                this.exportMtl.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.exportMtl = null;
        }
    }

    @Override
    public void startPrimitive(int numberOfVertex, int primitiveType) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Exporting Object model%d", this.exportModelCount));
        }
        this.exportObjLine(String.format("# modelCount=%d, vertexCount=%d, textureCount=%d, normalCount=%d", this.exportModelCount, this.exportVertexCount, this.exportTextureCount, this.exportNormalCount));
    }

    @Override
    public void exportVertex(VertexState originalV, VertexState transformedV) {
        this.exportObjLine(String.format(l, "v %f %f %f", Float.valueOf(transformedV.p[0]), Float.valueOf(transformedV.p[1]), Float.valueOf(transformedV.p[2])));
        if (this.context.vinfo.texture != 0) {
            this.exportObjLine(String.format(l, "vt %f %f", Float.valueOf(transformedV.t[0]), Float.valueOf(transformedV.t[1])));
        }
    }

    @Override
    public void endVertex(int numberOfVertex, int primitiveType) {
        this.exportObjLine(String.format("g model%d", this.exportModelCount));
        this.exportObjLine(String.format("usemtl material%d", this.exportMaterialCount));
        this.exportObjLine("");
        switch (primitiveType) {
            case 3: {
                boolean clockwise = this.context.frontFaceCw;
                for (int i = 0; i < numberOfVertex; i += 3) {
                    if (clockwise) {
                        this.exportFace(i + 1, i, i + 2);
                        continue;
                    }
                    this.exportFace(i, i + 1, i + 2);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < numberOfVertex - 2; ++i) {
                    boolean clockwise;
                    boolean bl = clockwise = i % 2 == 0;
                    if (!this.context.frontFaceCw) {
                        boolean bl2 = clockwise = !clockwise;
                    }
                    if (clockwise) {
                        this.exportFace(i + 1, i, i + 2);
                        continue;
                    }
                    this.exportFace(i, i + 1, i + 2);
                }
                break;
            }
        }
    }

    @Override
    public void endPrimitive(int numberOfVertex, int primitiveType) {
        this.exportVertexCount += numberOfVertex;
        if (this.context.vinfo.texture != 0) {
            this.exportTextureCount += numberOfVertex;
        }
        ++this.exportModelCount;
        ++this.exportMaterialCount;
    }

    @Override
    public void exportTexture(String fileName) {
        int illum = 1;
        this.exportMtlLine(String.format("newmtl material%d", this.exportMaterialCount));
        this.exportMtlLine(String.format("illum %d", illum));
        this.exportColor(l, "Ka", this.context.mat_ambient);
        this.exportColor(l, "Kd", this.context.mat_diffuse);
        this.exportColor(l, "Ks", this.context.mat_specular);
        if (fileName != null) {
            this.exportMtlLine(String.format("map_Kd %s", fileName));
        }
    }

    private void exportFace(int i1, int i2, int i3) {
        int p1 = i1 + this.exportVertexCount;
        int p2 = i2 + this.exportVertexCount;
        int p3 = i3 + this.exportVertexCount;
        if (this.context.vinfo.texture != 0) {
            int t1 = i1 + this.exportTextureCount;
            int t2 = i2 + this.exportTextureCount;
            int t3 = i3 + this.exportTextureCount;
            this.exportObjLine(String.format("f %d/%d %d/%d %d/%d", p1, t1, p2, t2, p3, t3));
        } else {
            this.exportObjLine(String.format("f %d %d %d", p1, p2, p3));
        }
    }

    private void exportColor(Locale l, String name, float[] color) {
        this.exportMtlLine(String.format(l, "%s %f %f %f", name, Float.valueOf(color[0]), Float.valueOf(color[1]), Float.valueOf(color[2])));
    }
}

