/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.textures;

import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VideoEngine;
import jpcsp.graphics.textures.TextureCache;
import jpcsp.util.Hash;

public class Texture {
    private int addr;
    private int lineWidth;
    private int width;
    private int height;
    private int pixelStorage;
    private int clutAddr;
    private int clutMode;
    private int clutStart;
    private int clutShift;
    private int clutMask;
    private int clutNumBlocks;
    private int hashCode;
    private int mipmapLevels;
    private boolean mipmapShareClut;
    private int textureId = -1;
    private boolean loaded = false;
    private TextureCache textureCache;
    private static final int defaultHashStride = 72;
    private static final int smallHashStride = 12;
    private short[] cachedValues16;
    private int[] cachedValues32;
    private int bufferLengthInBytes;
    private int lineWidthInBytes;
    private int hashStrideInBytes;

    public Texture(TextureCache textureCache, int addr, int lineWidth, int width, int height, int pixelStorage, int clutAddr, int clutMode, int clutStart, int clutShift, int clutMask, int clutNumBlocks, int mipmapLevels, boolean mipmapShareClut, short[] values16, int[] values32) {
        this.textureCache = textureCache;
        this.addr = addr;
        this.lineWidth = lineWidth;
        this.width = width;
        this.height = height;
        this.pixelStorage = pixelStorage;
        this.clutAddr = clutAddr;
        this.clutMode = clutMode;
        this.clutStart = clutStart;
        this.clutShift = clutShift;
        this.clutMask = clutMask;
        this.clutNumBlocks = clutNumBlocks;
        this.mipmapLevels = mipmapLevels;
        this.mipmapShareClut = mipmapShareClut;
        this.bufferLengthInBytes = lineWidth * height;
        this.lineWidthInBytes = lineWidth;
        this.hashStrideInBytes = 72;
        int bytesPerPixel = IRenderingEngine.sizeOfTextureType[pixelStorage];
        if (bytesPerPixel <= 0) {
            switch (pixelStorage) {
                case 8: {
                    this.bufferLengthInBytes = VideoEngine.getCompressedTextureSize(lineWidth, height, 8);
                    break;
                }
                case 9: 
                case 10: {
                    this.bufferLengthInBytes = VideoEngine.getCompressedTextureSize(lineWidth, height, 4);
                    break;
                }
                case 4: {
                    this.bufferLengthInBytes >>= 1;
                    this.lineWidthInBytes >>= 1;
                    this.hashStrideInBytes = 12;
                }
            }
        } else {
            this.bufferLengthInBytes *= bytesPerPixel;
            this.lineWidthInBytes *= bytesPerPixel;
        }
        if (values16 != null) {
            this.cachedValues16 = new short[lineWidth];
            System.arraycopy(values16, 0, this.cachedValues16, 0, lineWidth);
        } else if (values32 != null) {
            this.cachedValues32 = new int[lineWidth];
            System.arraycopy(values32, 0, this.cachedValues32, 0, lineWidth);
        } else {
            if (this.lineWidthInBytes < this.hashStrideInBytes) {
                this.hashStrideInBytes = this.lineWidthInBytes <= 32 ? 0 : this.lineWidthInBytes - 4;
            }
            this.hashCode = Texture.hashCode(addr, this.bufferLengthInBytes, this.lineWidthInBytes, this.hashStrideInBytes, clutAddr, clutNumBlocks, mipmapLevels);
        }
    }

    private static int hashCode(int addr, int bufferLengthInBytes, int lineWidthInBytes, int strideInBytes, int clutAddr, int clutNumBlocks, int mipmapLevels) {
        int hashCode = mipmapLevels;
        if (addr != 0) {
            if (VideoEngine.log.isDebugEnabled()) {
                VideoEngine.log.debug((Object)("Texture.hashCode: " + bufferLengthInBytes + " bytes"));
            }
            hashCode = Hash.getHashCode(hashCode, addr, bufferLengthInBytes, strideInBytes);
        }
        if (clutAddr != 0) {
            hashCode = Hash.getHashCode(hashCode, clutAddr, clutNumBlocks * 32);
        }
        return hashCode;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(int addr, int lineWidth, int width, int height, int pixelStorage, int clutAddr, int clutMode, int clutStart, int clutShift, int clutMask, int clutNumBlocks, int mipmapLevels, boolean mipmapShareClut, short[] values16, int[] values32) {
        if (this.addr != addr || this.lineWidth != lineWidth || this.width != width || this.height != height || this.pixelStorage != pixelStorage || this.clutAddr != clutAddr || this.clutMode != clutMode || this.clutStart != clutStart || this.clutShift != clutShift || this.clutMask != clutMask || this.clutNumBlocks != clutNumBlocks || this.mipmapLevels != mipmapLevels || this.mipmapShareClut != mipmapShareClut) {
            return false;
        }
        if (!this.textureCache.textureAlreadyHashed(addr, clutAddr)) {
            if (values16 != null) {
                return this.equals(values16);
            }
            if (values32 != null) {
                return this.equals(values32);
            }
            int hashCode = Texture.hashCode(addr, this.bufferLengthInBytes, this.lineWidthInBytes, this.hashStrideInBytes, clutAddr, clutNumBlocks, mipmapLevels);
            if (hashCode != this.hashCode()) {
                return false;
            }
            this.textureCache.setTextureAlreadyHashed(addr, clutAddr);
        }
        return true;
    }

    private boolean equals(short[] values16) {
        if (this.cachedValues16 == null) {
            return false;
        }
        for (int i = 0; i < this.lineWidth; ++i) {
            if (values16[i] == this.cachedValues16[i]) continue;
            return false;
        }
        return true;
    }

    private boolean equals(int[] values32) {
        if (this.cachedValues32 == null) {
            return false;
        }
        for (int i = 0; i < this.lineWidth; ++i) {
            if (values32[i] == this.cachedValues32[i]) continue;
            return false;
        }
        return true;
    }

    public void bindTexture(IRenderingEngine re) {
        re.bindTexture(this.getTextureId(re));
    }

    public int getTextureId(IRenderingEngine re) {
        if (this.textureId == -1) {
            this.textureId = re.genTexture();
        }
        return this.textureId;
    }

    public void deleteTexture(IRenderingEngine re) {
        if (this.textureId != -1) {
            re.deleteTexture(this.textureId);
            this.textureId = -1;
        }
        this.setLoaded(false);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setIsLoaded() {
        this.setLoaded(true);
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public int getAddr() {
        return this.addr;
    }

    public int getClutAddr() {
        return this.clutAddr;
    }

    public int getGlId() {
        return this.textureId;
    }

    public int getMipmapLevels() {
        return this.mipmapLevels;
    }

    public boolean isInsideMemory(int fromAddr, int toAddr) {
        if (this.addr >= fromAddr && this.addr < toAddr) {
            return true;
        }
        return this.addr + this.bufferLengthInBytes >= fromAddr && this.addr + this.bufferLengthInBytes < toAddr;
    }

    public String toString() {
        return String.format("Texture[0x%08X, %dx%d, bufferWidth=%d, %s]", this.addr, this.width, this.height, this.lineWidth, VideoEngine.getPsmName(this.pixelStorage));
    }
}

