/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import jpcsp.HLE.Modules;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Utilities;

public class FastMemory
extends Memory {
    private int[] all;
    private static final boolean traceRead = false;
    private static final boolean traceWrite = false;
    public static final int[] zero = new int[32768];
    private static final int[] memory8Shift = new int[]{0, 8, 16, 24};
    private static final int[] memory8Mask = new int[]{-256, -65281, -16711681, 0xFFFFFF};
    private static final int[] memory16Shift = new int[]{0, 0, 16, 16};
    private static final int[] memory16Mask = new int[]{-65536, -65536, 65535, 65535};
    private static final boolean[] isIntAligned = new boolean[]{true, false, false, false};

    @Override
    public boolean allocate() {
        this.all = null;
        int allSize = MemoryMap.END_RAM + 1 >> 2;
        try {
            this.all = new int[allSize];
        }
        catch (OutOfMemoryError e) {
            Memory.log.warn((Object)"Cannot allocate FastMemory: add the option '-Xmx256m' to the Java Virtual Machine startup command to improve Performance");
            Memory.log.info((Object)("The current Java Virtual Machine has been started using '-Xmx" + Runtime.getRuntime().maxMemory() / 0x100000L + "m'"));
            return false;
        }
        return super.allocate();
    }

    @Override
    public void Initialise() {
        Arrays.fill(zero, 0);
        Arrays.fill(this.all, 0);
    }

    @Override
    public int read8(int address) {
        int data = this.all[(address &= 0x3FFFFFFF) >> 2] >> memory8Shift[address & 3] & 0xFF;
        return data;
    }

    @Override
    public int read16(int address) {
        int data = this.all[(address &= 0x3FFFFFFF) >> 2] >> memory16Shift[address & 2] & 0xFFFF;
        return data;
    }

    @Override
    public int read32(int address) {
        try {
            int data = this.all[(address &= 0x3FFFFFFF) >> 2];
            return data;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (this.read32AllowedInvalidAddress(address)) {
                return 0;
            }
            this.invalidMemoryAddress(address, "read32", 4);
            return 0;
        }
    }

    @Override
    public long read64(int address) {
        long data = (long)this.all[((address &= 0x3FFFFFFF) >> 2) + 1] << 32 | (long)this.all[address >> 2] & 0xFFFFFFFFL;
        return data;
    }

    @Override
    public void write8(int address, byte data) {
        int memData;
        int index = (address &= 0x3FFFFFFF) & 3;
        this.all[address >> 2] = memData = this.all[address >> 2] & memory8Mask[index] | (data & 0xFF) << memory8Shift[index];
        Modules.sceDisplayModule.write8(address);
    }

    @Override
    public void write16(int address, short data) {
        int memData;
        int index = (address &= 0x3FFFFFFF) & 2;
        this.all[address >> 2] = memData = this.all[address >> 2] & memory16Mask[index] | (data & 0xFFFF) << memory16Shift[index];
        Modules.sceDisplayModule.write16(address);
    }

    @Override
    public void write32(int address, int data) {
        this.all[(address &= 0x3FFFFFFF) >> 2] = data;
        Modules.sceDisplayModule.write32(address);
    }

    @Override
    public void write64(int address, long data) {
        this.all[(address &= 0x3FFFFFFF) >> 2] = (int)data;
        this.all[(address >> 2) + 1] = (int)(data >> 32);
    }

    @Override
    public IntBuffer getMainMemoryByteBuffer() {
        return IntBuffer.wrap(this.all, 0x2000000, MemoryMap.SIZE_RAM >> 2);
    }

    @Override
    public IntBuffer getBuffer(int address, int length) {
        address = FastMemory.normalizeAddress(address);
        IntBuffer buffer = this.getMainMemoryByteBuffer();
        buffer.position(address >> 2);
        buffer.limit(Utilities.round4(address + length) >> 2);
        return buffer.slice();
    }

    private static boolean isIntAligned(int n) {
        return isIntAligned[n & 3];
    }

    @Override
    public void memset(int address, byte data, int length) {
        address = FastMemory.normalizeAddress(address);
        Modules.sceDisplayModule.write8(address);
        while (!FastMemory.isIntAligned(address) && length > 0) {
            this.write8(address, data);
            ++address;
            --length;
        }
        int count4 = length >> 2;
        if (count4 > 0) {
            if (data == 0) {
                for (int i = 0; i < count4; i += zero.length) {
                    System.arraycopy(zero, 0, this.all, (address >> 2) + i, Math.min(zero.length, count4 - i));
                }
            } else {
                int data1 = data & 0xFF;
                int data4 = data1 << 24 | data1 << 16 | data1 << 8 | data1;
                Arrays.fill(this.all, address >> 2, (address >> 2) + count4, data4);
            }
            address += count4 << 2;
            length -= count4 << 2;
        }
        while (length > 0) {
            this.write8(address, data);
            ++address;
            --length;
        }
    }

    @Override
    public void copyToMemory(int address, ByteBuffer source, int length) {
        while (!FastMemory.isIntAligned(address) && length > 0 && source.hasRemaining()) {
            byte b = source.get();
            this.write8(address, b);
            ++address;
            --length;
        }
        int countInt = Math.min(length, source.remaining()) >> 2;
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(address, countInt << 2, 4);
        for (int i = 0; i < countInt; ++i) {
            int data1 = source.get() & 0xFF;
            int data2 = source.get() & 0xFF;
            int data3 = source.get() & 0xFF;
            int data4 = source.get() & 0xFF;
            int data = data4 << 24 | data3 << 16 | data2 << 8 | data1;
            memoryWriter.writeNext(data);
        }
        memoryWriter.flush();
        int copyLength = countInt << 2;
        length -= copyLength;
        address += copyLength;
        while (length > 0 && source.hasRemaining()) {
            byte b = source.get();
            this.write8(address, b);
            ++address;
            --length;
        }
    }

    public int[] getAll() {
        return this.all;
    }

    private void memcpyAligned4(int destination, int source, int length, boolean checkOverlap) {
        if (checkOverlap || !this.areOverlapping(destination, source, length)) {
            System.arraycopy(this.all, source >> 2, this.all, destination >> 2, length >> 2);
        } else {
            int src = source >> 2;
            int dst = destination >> 2;
            for (int i = 0; i < length; i += 4) {
                this.all[dst++] = this.all[src++];
            }
        }
    }

    @Override
    protected void memcpy(int destination, int source, int length, boolean checkOverlap) {
        if (length <= 0) {
            return;
        }
        destination = FastMemory.normalizeAddress(destination);
        source = FastMemory.normalizeAddress(source);
        Modules.sceDisplayModule.write8(destination);
        if (FastMemory.isIntAligned(source) && FastMemory.isIntAligned(destination) && FastMemory.isIntAligned(length)) {
            this.memcpyAligned4(destination, source, length, checkOverlap);
        } else if (!((source & 3) != (destination & 3) || checkOverlap && this.areOverlapping(destination, source, length))) {
            while (!FastMemory.isIntAligned(source) && length > 0) {
                this.write8(destination, (byte)this.read8(source));
                ++source;
                ++destination;
                --length;
            }
            int length4 = length & 0xFFFFFFFC;
            if (length4 > 0) {
                this.memcpyAligned4(destination, source, length4, checkOverlap);
                source += length4;
                destination += length4;
                length -= length4;
            }
            while (length > 0) {
                this.write8(destination, (byte)this.read8(source));
                ++destination;
                ++source;
                --length;
            }
        } else if (!checkOverlap || source >= destination || !this.areOverlapping(destination, source, length)) {
            if (this.areOverlapping(destination, source, 4)) {
                for (int i = 0; i < length; ++i) {
                    this.write8(destination + i, (byte)this.read8(source + i));
                }
            } else {
                IMemoryReader sourceReader = MemoryReader.getMemoryReader(source, length, 1);
                IMemoryWriter destinationWriter = MemoryWriter.getMemoryWriter(destination, length, 1);
                for (int i = 0; i < length; ++i) {
                    destinationWriter.writeNext(sourceReader.readNext());
                }
                destinationWriter.flush();
            }
        } else {
            for (int i = length - 1; i >= 0; --i) {
                this.write8(destination + i, (byte)this.read8(source + i));
            }
        }
    }
}

