/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory;

import java.util.LinkedList;
import java.util.List;
import jpcsp.memory.MemorySection;

public class MemorySections {
    private static MemorySections instance;
    private List<MemorySection> allMemorySections = new LinkedList<MemorySection>();
    private List<MemorySection> readMemorySections = new LinkedList<MemorySection>();
    private List<MemorySection> writeMemorySections = new LinkedList<MemorySection>();
    private List<MemorySection> executeMemorySections = new LinkedList<MemorySection>();

    public static MemorySections getInstance() {
        if (instance == null) {
            instance = new MemorySections();
        }
        return instance;
    }

    private MemorySections() {
    }

    public void reset() {
        this.allMemorySections.clear();
        this.readMemorySections.clear();
        this.writeMemorySections.clear();
        this.executeMemorySections.clear();
    }

    public void addMemorySection(MemorySection memorySection) {
        this.allMemorySections.add(memorySection);
        if (memorySection.canRead()) {
            this.readMemorySections.add(memorySection);
        }
        if (memorySection.canWrite()) {
            this.writeMemorySections.add(memorySection);
        }
        if (memorySection.canExecute()) {
            this.executeMemorySections.add(memorySection);
        }
    }

    public MemorySection getMemorySection(int address) {
        for (MemorySection memorySection : this.allMemorySections) {
            if (!memorySection.contains(address)) continue;
            return memorySection;
        }
        return null;
    }

    private boolean contains(List<MemorySection> memorySections, int address, boolean defaultValue) {
        for (MemorySection memorySection : memorySections) {
            if (!memorySection.contains(address)) continue;
            return true;
        }
        return defaultValue;
    }

    public boolean canRead(int address, boolean defaultValue) {
        return this.contains(this.readMemorySections, address, defaultValue);
    }

    public boolean canWrite(int address, boolean defaultValue) {
        return this.contains(this.writeMemorySections, address, defaultValue);
    }

    public boolean canExecute(int address, boolean defaultValue) {
        return this.contains(this.executeMemorySections, address, defaultValue);
    }
}

