/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.sound;

import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.sound.ISampleSource;
import jpcsp.sound.SoundVoice;

public class SampleSourcePCM
implements ISampleSource {
    private SoundVoice voice;
    private int addr;
    private int size;
    private IMemoryReader memoryReader;
    private int sampleIndex;
    private int currentSampleIndex;
    private int samples;
    private int numberSamples;

    public SampleSourcePCM(SoundVoice voice, int addr, int samples, int loopMode) {
        this.voice = voice;
        this.addr = addr;
        this.samples = samples;
        this.size = samples << 1;
        this.sampleIndex = samples;
        this.numberSamples = loopMode < 0 ? samples : 0x10000000;
    }

    @Override
    public int getNextSample() {
        if (this.sampleIndex >= this.samples) {
            if (!this.voice.isOn()) {
                this.numberSamples = this.currentSampleIndex;
                return 0;
            }
            this.memoryReader = MemoryReader.getMemoryReader(this.addr, this.size, 2);
            this.sampleIndex = 0;
        }
        ++this.currentSampleIndex;
        ++this.sampleIndex;
        return this.memoryReader.readNext();
    }

    @Override
    public void setSampleIndex(int index) {
    }

    @Override
    public int getSampleIndex() {
        return this.currentSampleIndex;
    }

    @Override
    public int getNumberSamples() {
        return this.numberSamples;
    }
}

