/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.ferry;

import com.xuggle.ferry.JNIMemoryParachute;
import com.xuggle.ferry.JNIReference;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JNIMemoryAllocator {
    private static final Logger log = LoggerFactory.getLogger(JNIMemoryAllocator.class);
    private final Set<byte[]> mBuffers = new HashSet<byte[]>();
    private final ReentrantLock mLock = new ReentrantLock();
    private static final int MAX_ALLOCATION_ATTEMPTS = 5;
    private static final double FALLBACK_TIME_DECAY = 1.5;
    private static final boolean SHOULD_RETRY_FAILED_ALLOCS = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToBuffer(byte[] mem) {
        this.mLock.lock();
        try {
            if (!this.mBuffers.add(mem)) assert (false) : "buffers already added";
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromBuffer(byte[] mem) {
        this.mLock.lock();
        try {
            if (!this.mBuffers.remove(mem)) assert (false) : "buffer not in memory";
        }
        finally {
            this.mLock.unlock();
        }
    }

    JNIMemoryAllocator() {
    }

    public byte[] malloc(int size) {
        byte[] retval = null;
        JNIMemoryParachute.getParachute().packChute();
        try {
            int allocationAttempts = 0;
            int backoffTimeout = 10;
            while (true) {
                try {
                    retval = new byte[size];
                }
                catch (OutOfMemoryError e) {
                    if (++allocationAttempts >= 5) {
                        JNIMemoryParachute.getParachute().pullCord();
                        JNIReference.getMgr().gcInternal();
                        throw e;
                    }
                    log.debug("retrying ({}) allocation of {} bytes", (Object)allocationAttempts, (Object)size);
                    try {
                        if (allocationAttempts <= 1) {
                            Thread.yield();
                        } else {
                            Thread.sleep(backoffTimeout);
                            backoffTimeout = (int)((double)backoffTimeout * 1.5);
                        }
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        throw e;
                    }
                    JNIReference.getMgr().gcInternal();
                    continue;
                }
                break;
            }
            this.addToBuffer(retval);
            retval[retval.length - 1] = 0;
        }
        catch (Throwable t) {
            retval = null;
        }
        return retval;
    }

    public void free(byte[] mem) {
        this.removeFromBuffer(mem);
    }

    public static native void setAllocator(long var0, JNIMemoryAllocator var2);

    public static native JNIMemoryAllocator getAllocator(long var0);
}

