/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.IADataForComplexProperty;
import ch.qos.logback.core.joran.action.ImplicitAction;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.Pattern;
import ch.qos.logback.core.joran.spi.PropertySetter;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.AggregationType;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.util.Stack;
import org.xml.sax.Attributes;

public class NestedComplexPropertyIA
extends ImplicitAction {
    Stack<IADataForComplexProperty> actionDataStack = new Stack();

    public boolean isApplicable(Pattern pattern, Attributes attributes, InterpretationContext ec) {
        String nestedElementTagName = pattern.peekLast();
        if (ec.isEmpty()) {
            return false;
        }
        Object o = ec.peekObject();
        PropertySetter parentBean = new PropertySetter(o);
        parentBean.setContext(this.context);
        AggregationType aggregationType = parentBean.computeAggregationType(nestedElementTagName);
        switch (aggregationType) {
            case NOT_FOUND: 
            case AS_BASIC_PROPERTY: 
            case AS_BASIC_PROPERTY_COLLECTION: {
                return false;
            }
            case AS_COMPLEX_PROPERTY_COLLECTION: 
            case AS_COMPLEX_PROPERTY: {
                IADataForComplexProperty ad = new IADataForComplexProperty(parentBean, aggregationType, nestedElementTagName);
                this.actionDataStack.push(ad);
                return true;
            }
        }
        this.addError("PropertySetter.computeAggregationType returned " + (Object)((Object)aggregationType));
        return false;
    }

    public void begin(InterpretationContext ec, String localName, Attributes attributes) {
        IADataForComplexProperty actionData = this.actionDataStack.peek();
        String className = attributes.getValue("class");
        if (OptionHelper.isEmpty(className = ec.subst(className))) {
            PropertySetter parentBean = actionData.parentBean;
            className = parentBean.getClassNameViaImplicitRules(actionData.getComplexPropertyName(), actionData.getAggregationType());
        }
        if (OptionHelper.isEmpty(className)) {
            actionData.inError = true;
            String errMsg = "No class name attribute in [" + localName + "]";
            this.addError(errMsg);
            return;
        }
        try {
            actionData.setNestedComplexProperty(Loader.loadClass(className, this.context).newInstance());
            if (actionData.getNestedComplexProperty() instanceof ContextAware) {
                ((ContextAware)actionData.getNestedComplexProperty()).setContext(this.context);
            }
            this.addInfo("Pushing component [" + localName + "] on top of the object stack.");
            ec.pushObject(actionData.getNestedComplexProperty());
        }
        catch (Exception oops) {
            actionData.inError = true;
            String msg = "Could not create component [" + localName + "] of type [" + className + "]";
            this.addError(msg, oops);
        }
    }

    public void end(InterpretationContext ec, String tagName) {
        Object o;
        IADataForComplexProperty actionData = this.actionDataStack.pop();
        if (actionData.inError) {
            return;
        }
        PropertySetter nestedBean = new PropertySetter(actionData.getNestedComplexProperty());
        nestedBean.setContext(this.context);
        if (nestedBean.computeAggregationType("parent") == AggregationType.AS_COMPLEX_PROPERTY) {
            nestedBean.setComplexProperty("parent", actionData.parentBean.getObj());
        }
        if (actionData.getNestedComplexProperty() instanceof LifeCycle) {
            ((LifeCycle)actionData.getNestedComplexProperty()).start();
        }
        if ((o = ec.peekObject()) != actionData.getNestedComplexProperty()) {
            this.addError("The object on the top the of the stack is not the component pushed earlier.");
        } else {
            ec.popObject();
            switch (actionData.aggregationType) {
                case AS_COMPLEX_PROPERTY: {
                    actionData.parentBean.setComplexProperty(tagName, actionData.getNestedComplexProperty());
                    break;
                }
                case AS_COMPLEX_PROPERTY_COLLECTION: {
                    actionData.parentBean.addComplexProperty(tagName, actionData.getNestedComplexProperty());
                }
            }
        }
    }
}

