/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import java.util.HashMap;
import java.util.Iterator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelSemaInfo;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.ThreadManForUser;
import org.apache.log4j.Logger;

public class SemaManager {
    protected static Logger log = Modules.getLogger("ThreadManForUser");
    private HashMap<Integer, SceKernelSemaInfo> semaMap;
    private SemaWaitStateChecker semaWaitStateChecker;
    public static final int PSP_SEMA_ATTR_FIFO = 0;
    public static final int PSP_SEMA_ATTR_PRIORITY = 256;
    public static final SemaManager singleton = new SemaManager();

    public void reset() {
        this.semaMap = new HashMap();
        this.semaWaitStateChecker = new SemaWaitStateChecker();
    }

    private boolean removeWaitingThread(SceKernelThreadInfo thread) {
        SceKernelSemaInfo sema = this.semaMap.get(thread.wait.Semaphore_id);
        if (sema == null) {
            return false;
        }
        sema.threadWaitingList.removeWaitingThread(thread);
        return true;
    }

    public void onThreadWaitTimeout(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext._v0 = -2147352152;
        } else {
            log.warn((Object)"Sema deleted while we were waiting for it! (timeout expired)");
            thread.cpuContext._v0 = -2147352139;
        }
    }

    public void onThreadWaitReleased(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext._v0 = -2147352150;
        } else {
            log.warn((Object)"EventFlag deleted while we were waiting for it!");
            thread.cpuContext._v0 = -2147352139;
        }
    }

    public void onThreadDeleted(SceKernelThreadInfo thread) {
        if (thread.isWaitingForType(3)) {
            this.removeWaitingThread(thread);
        }
    }

    private void onSemaphoreDeletedCancelled(int semaid, int result) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        Iterator<SceKernelThreadInfo> it = threadMan.iterator();
        while (it.hasNext()) {
            SceKernelThreadInfo thread = it.next();
            if (!thread.isWaitingFor(3, semaid)) continue;
            thread.cpuContext._v0 = result;
            threadMan.hleChangeThreadState(thread, 2);
            reschedule = true;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private void onSemaphoreDeleted(int semaid) {
        this.onSemaphoreDeletedCancelled(semaid, -2147352139);
    }

    private void onSemaphoreCancelled(int semaid) {
        this.onSemaphoreDeletedCancelled(semaid, -2147352151);
    }

    private void onSemaphoreModified(SceKernelSemaInfo sema) {
        SceKernelThreadInfo thread;
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        SceKernelThreadInfo checkedThread = null;
        while (sema.currentCount > 0 && (thread = sema.threadWaitingList.getNextWaitingThread(checkedThread)) != null) {
            if (this.tryWaitSemaphore(sema, thread.wait.Semaphore_signal)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("onSemaphoreModified waking thread %s", thread));
                }
                sema.threadWaitingList.removeWaitingThread(thread);
                thread.cpuContext._v0 = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
                continue;
            }
            checkedThread = thread;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private boolean tryWaitSemaphore(SceKernelSemaInfo sema, int signal) {
        boolean success = false;
        if (sema.currentCount >= signal) {
            sema.currentCount -= signal;
            success = true;
        }
        return success;
    }

    public int checkSemaID(int semaid) {
        SceUidManager.checkUidPurpose(semaid, "ThreadMan-sema", true);
        if (!this.semaMap.containsKey(semaid)) {
            if (semaid == 0) {
                log.debug((Object)String.format("checkSemaID - unknown uid 0x%X", semaid));
            } else {
                log.warn((Object)String.format("checkSemaID - unknown uid 0x%X", semaid));
            }
            throw new SceKernelErrorException(-2147352167);
        }
        return semaid;
    }

    public SceKernelSemaInfo hleKernelCreateSema(String name, int attr, int initVal, int maxVal, TPointer option) {
        if (option.isNotNull()) {
            int optionSize = option.getValue32();
            log.warn((Object)String.format("sceKernelCreateSema option at %s, size=%d", option, optionSize));
        }
        SceKernelSemaInfo sema = new SceKernelSemaInfo(name, attr, initVal, maxVal);
        this.semaMap.put(sema.uid, sema);
        return sema;
    }

    public int hleKernelWaitSema(SceKernelSemaInfo sema, int signal, TPointer32 timeoutAddr, boolean doCallbacks) {
        if (!this.tryWaitSemaphore(sema, signal)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleKernelWaitSema %s fast check failed", sema));
            }
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
            sema.threadWaitingList.addWaitingThread(currentThread);
            currentThread.wait.Semaphore_id = sema.uid;
            currentThread.wait.Semaphore_signal = signal;
            threadMan.hleKernelThreadEnterWaitState(3, sema.uid, this.semaWaitStateChecker, timeoutAddr.getAddress(), doCallbacks);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleKernelWaitSema %s fast check succeeded", sema));
        }
        return 0;
    }

    private int hleKernelWaitSema(int semaid, int signal, TPointer32 timeoutAddr, boolean doCallbacks) {
        if (signal <= 0) {
            log.warn((Object)String.format("hleKernelWaitSema - bad signal %d", signal));
            return -2147352131;
        }
        SceKernelSemaInfo sema = this.semaMap.get(semaid);
        if (signal > sema.maxCount) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleKernelWaitSema returning 0x%08X(ERROR_KERNEL_ILLEGAL_COUNT)", -2147352131));
            }
            return -2147352131;
        }
        return this.hleKernelWaitSema(sema, signal, timeoutAddr, doCallbacks);
    }

    public int hleKernelPollSema(SceKernelSemaInfo sema, int signal) {
        if (signal > sema.currentCount) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleKernelPollSema returning 0x%08X(ERROR_KERNEL_SEMA_ZERO)", -2147352147));
            }
            return -2147352147;
        }
        sema.currentCount -= signal;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleKernelPollSema returning 0, %s", sema));
        }
        return 0;
    }

    public int hleKernelSignalSema(SceKernelSemaInfo sema, int signal) {
        int newCount = sema.currentCount + signal;
        if (newCount > sema.maxCount) {
            Iterator<SceKernelThreadInfo> it = Modules.ThreadManForUserModule.iterator();
            while (it.hasNext()) {
                SceKernelThreadInfo thread = it.next();
                if (!thread.isWaitingForType(3) || thread.wait.Semaphore_id != sema.uid) continue;
                newCount -= thread.wait.Semaphore_signal;
            }
            if (newCount > sema.maxCount) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("hleKernelSignalSema returning 0x%08X(ERROR_KERNEL_SEMA_OVERFLOW)", -2147352146));
                }
                return -2147352146;
            }
        }
        sema.currentCount += signal;
        this.onSemaphoreModified(sema);
        if (sema.currentCount > sema.maxCount) {
            log.error((Object)String.format("hleKernelSignalSema currentCount %d exceeding maxCount %d", sema.currentCount, sema.maxCount));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleKernelSignalSema returning 0, %s", sema));
        }
        return 0;
    }

    public int sceKernelCreateSema(String name, int attr, int initVal, int maxVal, TPointer option) {
        SceKernelSemaInfo sema = this.hleKernelCreateSema(name, attr, initVal, maxVal, option);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelCreateSema %s", sema));
        }
        return sema.uid;
    }

    public int sceKernelDeleteSema(int semaid) {
        this.semaMap.remove(semaid);
        this.onSemaphoreDeleted(semaid);
        return 0;
    }

    public int sceKernelWaitSema(int semaid, int signal, TPointer32 timeoutAddr) {
        return this.hleKernelWaitSema(semaid, signal, timeoutAddr, false);
    }

    public int sceKernelWaitSemaCB(int semaid, int signal, TPointer32 timeoutAddr) {
        return this.hleKernelWaitSema(semaid, signal, timeoutAddr, true);
    }

    public int sceKernelSignalSema(int semaid, int signal) {
        SceKernelSemaInfo sema = this.semaMap.get(semaid);
        return this.hleKernelSignalSema(sema, signal);
    }

    public int sceKernelPollSema(int semaid, int signal) {
        if (signal <= 0) {
            log.warn((Object)String.format("sceKernelPollSema id=0x%X, signal=%d: bad signal", semaid, signal));
            return -2147352131;
        }
        SceKernelSemaInfo sema = this.semaMap.get(semaid);
        return this.hleKernelPollSema(sema, signal);
    }

    public int sceKernelCancelSema(int semaid, int newcount, TPointer32 numWaitThreadAddr) {
        SceKernelSemaInfo sema = this.semaMap.get(semaid);
        if (newcount > sema.maxCount) {
            return -2147352131;
        }
        numWaitThreadAddr.setValue(sema.getNumWaitThreads());
        sema.threadWaitingList.removeAllWaitingThreads();
        sema.currentCount = newcount < 0 ? sema.initCount : newcount;
        this.onSemaphoreCancelled(semaid);
        return 0;
    }

    public int sceKernelReferSemaStatus(int semaid, TPointer addr) {
        SceKernelSemaInfo sema = this.semaMap.get(semaid);
        sema.write(addr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelReferSemaStatus returning %s", sema));
        }
        return 0;
    }

    private SemaManager() {
    }

    private class SemaWaitStateChecker
    implements IWaitStateChecker {
        private SemaWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            SceKernelSemaInfo sema = (SceKernelSemaInfo)SemaManager.this.semaMap.get(wait.Semaphore_id);
            if (sema == null) {
                thread.cpuContext._v0 = -2147352167;
                return false;
            }
            if (SemaManager.this.tryWaitSemaphore(sema, wait.Semaphore_signal)) {
                sema.threadWaitingList.removeWaitingThread(thread);
                thread.cpuContext._v0 = 0;
                return false;
            }
            return true;
        }
    }
}

