/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import jpcsp.HLE.Modules;
import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.kernel.types.SceIoDirent;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.kernel.types.ScePspDateTime;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.HLE.kernel.types.pspUtilityDialogCommon;
import jpcsp.Memory;
import jpcsp.crypto.CryptoEngine;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.filesystems.SeekableRandomFile;
import jpcsp.format.PSF;
import jpcsp.hardware.MemoryStick;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Utilities;

public class SceUtilitySavedataParam
extends pspAbstractMemoryMappedStructure {
    public static final String savedataPath = "ms0:/PSP/SAVEDATA/";
    public static final String savedataFilePath = "ms0/PSP/SAVEDATA/";
    public static final String icon0FileName = "ICON0.PNG";
    public static final String icon1PNGFileName = "ICON1.PNG";
    public static final String icon1PMFFileName = "ICON1.PMF";
    public static final String pic1FileName = "PIC1.PNG";
    public static final String snd0FileName = "SND0.AT3";
    public static final String paramSfoFileName = "PARAM.SFO";
    private static final String[] systemFileNames = new String[]{"PARAM.SFO", "ICON0.PNG", "ICON1.PNG", "ICON1.PMF", "PIC1.PNG", "SND0.AT3"};
    public static final String anyFileName = "<>";
    public pspUtilityDialogCommon base;
    public int mode;
    public static final int MODE_AUTOLOAD = 0;
    public static final int MODE_AUTOSAVE = 1;
    public static final int MODE_LOAD = 2;
    public static final int MODE_SAVE = 3;
    public static final int MODE_LISTLOAD = 4;
    public static final int MODE_LISTSAVE = 5;
    public static final int MODE_LISTDELETE = 6;
    public static final int MODE_DELETE = 7;
    public static final int MODE_SIZES = 8;
    public static final int MODE_AUTODELETE = 9;
    public static final int MODE_SINGLEDELETE = 10;
    public static final int MODE_LIST = 11;
    public static final int MODE_FILES = 12;
    public static final int MODE_MAKEDATASECURE = 13;
    public static final int MODE_MAKEDATA = 14;
    public static final int MODE_READSECURE = 15;
    public static final int MODE_READ = 16;
    public static final int MODE_WRITESECURE = 17;
    public static final int MODE_WRITE = 18;
    public static final int MODE_ERASESECURE = 19;
    public static final int MODE_ERASE = 20;
    public static final int MODE_DELETEDATA = 21;
    public static final int MODE_GETSIZE = 22;
    public static final String[] modeNames = new String[]{"AUTOLOAD", "AUTOSAVE", "LOAD", "SAVE", "LISTLOAD", "LISTSAVE", "LISTDELETE", "DELETE", "SIZES", "AUTODELETE", "SINGLEDELETE", "LIST", "FILES", "MAKEDATASECURE", "MAKEDATA", "READSECURE", "READ", "WRITESECURE", "WRITE", "ERASESECURE", "ERASE", "DELETEDATA", "GETSIZE"};
    public int bind;
    public static final int BIND_NOT_USED = 0;
    public static final int BIND_IS_OK = 1;
    public static final int BIND_IS_REJECTED = 2;
    public static final int BIND_IS_NOT_SUPPORTED = 3;
    public boolean overwrite;
    public String gameName;
    public String saveName;
    public String fileName;
    public String[] saveNameList;
    public int saveNameListAddr;
    public int dataBuf;
    public int dataBufSize;
    public int dataSize;
    public PspUtilitySavedataSFOParam sfoParam;
    public PspUtilitySavedataFileData icon0FileData;
    public PspUtilitySavedataFileData icon1FileData;
    public PspUtilitySavedataFileData pic1FileData;
    public PspUtilitySavedataFileData snd0FileData;
    int newDataAddr;
    public PspUtilitySavedataListSaveNewData newData;
    public int focus;
    public static final int FOCUS_UNKNOWN = 0;
    public static final int FOCUS_FIRSTLIST = 1;
    public static final int FOCUS_LASTLIST = 2;
    public static final int FOCUS_LATEST = 3;
    public static final int FOCUS_OLDEST = 4;
    public static final int FOCUS_FIRSTEMPTY = 7;
    public static final int FOCUS_LASTEMPTY = 8;
    public int abortStatus;
    public int msFreeAddr;
    public int msDataAddr;
    public int utilityDataAddr;
    public byte[] key = new byte[16];
    public int secureVersion;
    public int multiStatus;
    public static final int MULTI_STATUS_SINGLE = 0;
    public static final int MULTI_STATUS_INIT = 1;
    public static final int MULTI_STATUS_RELAY = 2;
    public static final int MULTI_STATUS_FINISH = 3;
    public int idListAddr;
    public int fileListAddr;
    public int sizeAddr;

    @Override
    protected void read() {
        this.base = new pspUtilityDialogCommon();
        this.read(this.base);
        this.setMaxSize(this.base.totalSizeof());
        this.mode = this.read32();
        this.bind = this.read32();
        this.overwrite = this.read32() != 0;
        this.gameName = this.readStringNZ(13);
        this.readUnknown(3);
        this.saveName = this.readStringNZ(20);
        this.saveNameListAddr = this.read32();
        if (Memory.isAddressGood(this.saveNameListAddr)) {
            ArrayList<String> newSaveNameList = new ArrayList<String>();
            boolean endOfList = false;
            int i = 0;
            while (!endOfList) {
                String saveNameItem = Utilities.readStringNZ(this.mem, this.saveNameListAddr + i, 20);
                if (saveNameItem == null || saveNameItem.length() == 0) {
                    endOfList = true;
                } else {
                    newSaveNameList.add(saveNameItem);
                }
                i += 20;
            }
            this.saveNameList = newSaveNameList.toArray(new String[newSaveNameList.size()]);
        }
        this.fileName = this.readStringNZ(13);
        this.readUnknown(3);
        this.dataBuf = this.read32();
        this.dataBufSize = this.read32();
        this.dataSize = this.read32();
        this.sfoParam = new PspUtilitySavedataSFOParam();
        this.read(this.sfoParam);
        this.icon0FileData = new PspUtilitySavedataFileData();
        this.read(this.icon0FileData);
        this.icon1FileData = new PspUtilitySavedataFileData();
        this.read(this.icon1FileData);
        this.pic1FileData = new PspUtilitySavedataFileData();
        this.read(this.pic1FileData);
        this.snd0FileData = new PspUtilitySavedataFileData();
        this.read(this.snd0FileData);
        this.newDataAddr = this.read32();
        if (this.newDataAddr != 0) {
            this.newData = new PspUtilitySavedataListSaveNewData();
            this.newData.read(this.mem, this.newDataAddr);
        } else {
            this.newData = null;
        }
        this.focus = this.read32();
        this.abortStatus = this.read32();
        this.msFreeAddr = this.read32();
        this.msDataAddr = this.read32();
        this.utilityDataAddr = this.read32();
        this.read8Array(this.key);
        this.secureVersion = this.read32();
        this.multiStatus = this.read32();
        this.idListAddr = this.read32();
        this.fileListAddr = this.read32();
        this.sizeAddr = this.read32();
    }

    @Override
    protected void write() {
        this.write(this.base);
        this.setMaxSize(this.base.totalSizeof());
        this.write32(this.mode);
        this.write32(this.bind);
        this.write32(this.overwrite ? 1 : 0);
        this.writeStringNZ(13, this.gameName);
        this.writeUnknown(3);
        this.writeStringNZ(20, this.saveName);
        this.write32(this.saveNameListAddr);
        this.writeStringNZ(13, this.fileName);
        this.writeUnknown(3);
        this.write32(this.dataBuf);
        this.write32(this.dataBufSize);
        this.write32(this.dataSize);
        this.write(this.sfoParam);
        this.write(this.icon0FileData);
        this.write(this.icon1FileData);
        this.write(this.pic1FileData);
        this.write(this.snd0FileData);
        this.write32(this.newDataAddr);
        if (this.newDataAddr != 0) {
            this.newData.write(this.mem, this.newDataAddr);
        }
        this.write32(this.focus);
        this.write32(this.abortStatus);
        this.write32(this.msFreeAddr);
        this.write32(this.msDataAddr);
        this.write32(this.utilityDataAddr);
        this.write8Array(this.key);
        this.write32(this.secureVersion);
        this.write32(this.multiStatus);
        this.write32(this.idListAddr);
        this.write32(this.fileListAddr);
        this.write32(this.sizeAddr);
    }

    public String getBasePath() {
        return this.getBasePath(this.gameName, this.saveName);
    }

    public String getBasePath(String saveName) {
        return this.getBasePath(this.gameName, saveName);
    }

    public String getBasePath(String gameName, String saveName) {
        String path = savedataPath + gameName;
        if (saveName != null && !anyFileName.equals(saveName)) {
            path = path + saveName;
        }
        path = path + "/";
        return path;
    }

    public String getFileName(String saveName, String fileName) {
        return this.getFileName(this.gameName, saveName, fileName);
    }

    public String getFileName(String gameName, String saveName, String fileName) {
        return this.getBasePath(gameName, saveName) + fileName;
    }

    private static int computeMemoryStickRequiredSpaceKb(int sizeByte) {
        int sizeKb = Utilities.getSizeKb(sizeByte);
        int sectorSizeKb = MemoryStick.getSectorSizeKb();
        int numberSectors = (sizeKb + sectorSizeKb - 1) / sectorSizeKb;
        return numberSectors * sectorSizeKb;
    }

    public int getRequiredSizeKb() {
        int requiredSpaceKb = 0;
        requiredSpaceKb += MemoryStick.getSectorSizeKb();
        if (this.fileName != null && this.fileName.length() > 0) {
            requiredSpaceKb += SceUtilitySavedataParam.computeMemoryStickRequiredSpaceKb(this.dataSize + 15);
        }
        requiredSpaceKb += SceUtilitySavedataParam.computeMemoryStickRequiredSpaceKb(this.icon0FileData.size);
        requiredSpaceKb += SceUtilitySavedataParam.computeMemoryStickRequiredSpaceKb(this.icon1FileData.size);
        requiredSpaceKb += SceUtilitySavedataParam.computeMemoryStickRequiredSpaceKb(this.pic1FileData.size);
        return requiredSpaceKb += SceUtilitySavedataParam.computeMemoryStickRequiredSpaceKb(this.snd0FileData.size);
    }

    public int getSizeKb(String gameName, String saveName) {
        String[] fileNames;
        StringBuilder localFileName;
        int sizeKb = 0;
        String path = this.getBasePath(gameName, saveName);
        IVirtualFileSystem vfs = Modules.IoFileMgrForUserModule.getVirtualFileSystem(path, localFileName = new StringBuilder());
        if (vfs != null && (fileNames = vfs.ioDopen(localFileName.toString())) != null) {
            for (int i = 0; i < fileNames.length; ++i) {
                SceIoStat stat = new SceIoStat();
                SceIoDirent dirent = new SceIoDirent(stat, fileNames[i]);
                int result = vfs.ioDread(localFileName.toString(), dirent);
                if (result <= 0) continue;
                sizeKb += Utilities.getSizeKb((int)stat.size);
            }
            vfs.ioDclose(localFileName.toString());
        }
        return sizeKb;
    }

    private SeekableDataInput getDataInput(String path, String name) {
        SeekableDataInput fileInput = Modules.IoFileMgrForUserModule.getFile(path + name, 1);
        return fileInput;
    }

    private SeekableRandomFile getDataOutput(String path, String name) {
        SeekableDataInput fileInput = Modules.IoFileMgrForUserModule.getFile(path + name, 515);
        if (fileInput instanceof SeekableRandomFile) {
            return (SeekableRandomFile)fileInput;
        }
        return null;
    }

    public void load(Memory mem) throws IOException {
        String path = this.getBasePath();
        this.dataSize = CryptoEngine.getSavedataCryptoStatus() ? this.loadEncryptedFile(mem, path, this.fileName, this.dataBuf, this.dataBufSize, this.key) : this.loadFile(mem, path, this.fileName, this.dataBuf, this.dataBufSize);
        this.safeLoad(mem, icon0FileName, this.icon0FileData);
        if (this.icon1FileData.buf == 0) {
            this.icon1FileData.size = 0;
        } else {
            String icon1FileName = mem.read8(this.icon1FileData.buf) != 137 ? icon1PMFFileName : icon1PNGFileName;
            this.safeLoad(mem, icon1FileName, this.icon1FileData);
        }
        this.safeLoad(mem, pic1FileName, this.pic1FileData);
        this.safeLoad(mem, snd0FileName, this.snd0FileData);
        this.loadPsf(mem, path, paramSfoFileName, this.sfoParam);
        this.bind = 1;
        this.abortStatus = 0;
    }

    private void safeLoad(Memory mem, String filename, PspUtilitySavedataFileData fileData) throws IOException {
        String path = this.getBasePath();
        try {
            fileData.size = this.loadFile(mem, path, filename, fileData.buf, fileData.bufSize);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
    }

    public void save(Memory mem) throws IOException {
        this.save(mem, false);
    }

    public void save(Memory mem, boolean secure) throws IOException {
        String path = this.getBasePath();
        Modules.IoFileMgrForUserModule.mkdirs(path);
        if (CryptoEngine.getSavedataCryptoStatus()) {
            this.writeEncryptedFile(mem, path, this.fileName, this.dataBuf, this.dataSize, this.key);
        } else {
            this.writeFile(mem, path, this.fileName, this.dataBuf, this.dataSize);
        }
        this.writeFile(mem, path, icon0FileName, this.icon0FileData.buf, this.icon0FileData.size);
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(this.icon1FileData.buf, 1);
        String icon1FileName = (byte)memoryReader.readNext() != -119 ? icon1PMFFileName : icon1PNGFileName;
        this.writeFile(mem, path, icon1FileName, this.icon1FileData.buf, this.icon1FileData.size);
        this.writeFile(mem, path, pic1FileName, this.pic1FileData.buf, this.pic1FileData.size);
        this.writeFile(mem, path, snd0FileName, this.snd0FileData.buf, this.snd0FileData.size);
        this.writePsf(mem, path, paramSfoFileName, this.sfoParam, CryptoEngine.getSavedataCryptoStatus(), this.fileName, this.key);
    }

    private int loadFile(Memory mem, String path, String name, int address, int maxLength) throws IOException {
        if (name == null || name.length() <= 0 || address == 0) {
            return 0;
        }
        SeekableDataInput fileInput = this.getDataInput(path, name);
        if (fileInput == null) {
            throw new FileNotFoundException("File not found '" + path + "' '" + name + "'");
        }
        int fileSize = (int)fileInput.length();
        if (fileSize > maxLength && maxLength > 0) {
            fileSize = maxLength;
        }
        Utilities.readFully(fileInput, address, fileSize);
        fileInput.close();
        return fileSize;
    }

    private void writeEncryptedFile(Memory mem, String path, String name, int address, int length, byte[] key) throws IOException {
        if (name == null || name.length() <= 0 || address == 0) {
            return;
        }
        SeekableRandomFile fileOutput = this.getDataOutput(path, name);
        CryptoEngine crypto = new CryptoEngine();
        if (fileOutput == null) {
            return;
        }
        byte[] inBuf = new byte[length + 16];
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, 1);
        for (int i = 0; i < length; ++i) {
            inBuf[i] = (byte)memoryReader.readNext();
        }
        this.key = crypto.getSAVEDATAEngine().EncryptSavedata(inBuf, length, key);
        fileOutput.write(inBuf, 0, inBuf.length);
        fileOutput.close();
    }

    private int loadEncryptedFile(Memory mem, String path, String name, int address, int maxLength, byte[] key) throws IOException {
        if (name == null || name.length() <= 0 || address == 0) {
            return 0;
        }
        SeekableDataInput fileInput = this.getDataInput(path, name);
        CryptoEngine crypto = new CryptoEngine();
        if (fileInput == null) {
            throw new FileNotFoundException("File not found '" + path + "' '" + name + "'");
        }
        int fileSize = (int)fileInput.length();
        byte[] inBuf = new byte[fileSize];
        fileInput.readFully(inBuf);
        crypto.getSAVEDATAEngine().DecryptSavedata(inBuf, fileSize, key);
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(address, 1);
        int length = Math.min(inBuf.length, maxLength);
        for (int i = 0; i < length; ++i) {
            memoryWriter.writeNext(inBuf[i]);
        }
        memoryWriter.flush();
        return length;
    }

    private void writeFile(Memory mem, String path, String name, int address, int length) throws IOException {
        if (name == null || name.length() <= 0 || address == 0) {
            return;
        }
        SeekableRandomFile fileOutput = this.getDataOutput(path, name);
        if (fileOutput == null) {
            return;
        }
        Utilities.write(fileOutput, address, length);
        fileOutput.close();
    }

    private PSF readPsf(String path, String name) throws IOException {
        PSF psf = null;
        SeekableDataInput fileInput = this.getDataInput(path, name);
        if (fileInput != null && fileInput.length() > 0L) {
            byte[] buffer = new byte[(int)fileInput.length()];
            fileInput.readFully(buffer);
            fileInput.close();
            psf = new PSF();
            psf.read(ByteBuffer.wrap(buffer));
        }
        return psf;
    }

    private void loadPsf(Memory mem, String path, String name, PspUtilitySavedataSFOParam sfoParam) throws IOException {
        PSF psf = this.readPsf(path, name);
        if (psf != null) {
            sfoParam.parentalLevel = psf.getNumeric("PARENTAL_LEVEL");
            sfoParam.title = psf.getString("TITLE");
            sfoParam.detail = psf.getString("SAVEDATA_DETAIL");
            sfoParam.savedataTitle = psf.getString("SAVEDATA_TITLE");
        }
    }

    private void writePsf(Memory mem, String path, String psfName, PspUtilitySavedataSFOParam sfoParam, boolean cryptoMode, String dataName, byte[] key) throws IOException {
        SeekableRandomFile psfOutput = this.getDataOutput(path, psfName);
        if (psfOutput == null) {
            return;
        }
        PSF psf = new PSF();
        PSF encryptedPsf = new PSF();
        byte[] savedata_params_old = new byte[128];
        PSF oldPsf = this.readPsf(path, psfName);
        if (oldPsf != null) {
            savedata_params_old = (byte[])oldPsf.get("SAVEDATA_PARAMS");
        }
        psf.put("CATEGORY", "MS", 4);
        encryptedPsf.put("CATEGORY", "MS", 4);
        psf.put("PARENTAL_LEVEL", sfoParam.parentalLevel);
        encryptedPsf.put("PARENTAL_LEVEL", sfoParam.parentalLevel);
        psf.put("SAVEDATA_DETAIL", sfoParam.detail, 1024);
        encryptedPsf.put("SAVEDATA_DETAIL", sfoParam.detail, 1024);
        if (this.saveName.equals(anyFileName)) {
            psf.put("SAVEDATA_DIRECTORY", this.gameName, 64);
            encryptedPsf.put("SAVEDATA_DIRECTORY", this.gameName, 64);
        } else {
            psf.put("SAVEDATA_DIRECTORY", this.gameName + this.saveName, 64);
            encryptedPsf.put("SAVEDATA_DIRECTORY", this.gameName + this.saveName, 64);
        }
        PspUtilitySavedataSecureFileList secureFileList = this.getSecureFileList(null);
        if (key != null) {
            if (secureFileList == null) {
                secureFileList = new PspUtilitySavedataSecureFileList();
            }
            secureFileList.add(dataName, key);
        }
        if (secureFileList != null) {
            psf.put("SAVEDATA_FILE_LIST", secureFileList.getBytes());
            encryptedPsf.put("SAVEDATA_FILE_LIST", secureFileList.getBytes());
        }
        byte[] savedata_params = new byte[128];
        psf.put("SAVEDATA_PARAMS", savedata_params);
        psf.put("SAVEDATA_TITLE", sfoParam.savedataTitle, 128);
        psf.put("TITLE", sfoParam.title, 128);
        ByteBuffer buf = ByteBuffer.allocate(4912);
        psf.write(buf);
        if (cryptoMode) {
            CryptoEngine crypto = new CryptoEngine();
            int sfoSize = buf.array().length;
            byte[] sfoData = buf.array();
            crypto.getSAVEDATAEngine().UpdateSavedataHashes(encryptedPsf, sfoData, sfoSize, savedata_params_old);
            encryptedPsf.put("SAVEDATA_TITLE", sfoParam.savedataTitle, 128);
            encryptedPsf.put("TITLE", sfoParam.title, 128);
            encryptedPsf.write(psfOutput);
        } else {
            psf.write(psfOutput);
        }
        psfOutput.close();
    }

    public boolean test(Memory mem) throws IOException {
        String path = this.getBasePath();
        boolean result = this.testFile(mem, path, this.fileName);
        return result;
    }

    private boolean testFile(Memory mem, String path, String name) throws IOException {
        if (name == null || name.length() <= 0) {
            return false;
        }
        SeekableDataInput fileInput = this.getDataInput(path, name);
        if (fileInput == null) {
            throw new FileNotFoundException("File not found '" + path + "' '" + name + "'");
        }
        fileInput.close();
        return true;
    }

    public String getAnySaveName(String gameName, String saveName) {
        File f;
        String[] entries;
        if ((saveName == null || saveName.length() <= 0 || anyFileName.equals(saveName)) && (entries = (f = new File(savedataFilePath)).list()) != null) {
            for (int i = 0; i < f.list().length; ++i) {
                if (!entries[i].startsWith(gameName)) continue;
                saveName = entries[i].replace(gameName, "");
                break;
            }
        }
        return saveName;
    }

    public boolean isDirectoryPresent(String gameName, String saveName) {
        String path = this.getBasePath(gameName, saveName = this.getAnySaveName(gameName, saveName));
        SceIoStat stat = Modules.IoFileMgrForUserModule.statFile(path);
        return stat != null && (stat.attr & 0x20) == 0;
    }

    public boolean isPresent(String gameName, String saveName) {
        saveName = this.getAnySaveName(gameName, saveName);
        if (this.fileName == null || this.fileName.length() <= 0) {
            File f = new File(savedataFilePath + gameName + saveName);
            return f.list() != null;
        }
        String path = this.getBasePath(gameName, saveName);
        try {
            SeekableDataInput fileInput = this.getDataInput(path, this.fileName);
            if (fileInput != null) {
                fileInput.close();
                return true;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return false;
    }

    public boolean isPresent() {
        return this.isPresent(this.gameName, this.saveName);
    }

    public boolean isGameDirectoryPresent() {
        String path = this.getBasePath();
        SceIoStat gameDirectoryStat = Modules.IoFileMgrForUserModule.statFile(path);
        return gameDirectoryStat != null;
    }

    public long getTimestamp(String gameName, String saveName) {
        String sfoFileName = this.getFileName(gameName, saveName, paramSfoFileName);
        SceIoStat sfoStat = Modules.IoFileMgrForUserModule.statFile(sfoFileName);
        if (sfoStat != null) {
            Calendar cal = Calendar.getInstance();
            ScePspDateTime pspTime = sfoStat.mtime;
            cal.set(pspTime.year, pspTime.month, pspTime.day, pspTime.hour, pspTime.minute, pspTime.second);
            return cal.getTimeInMillis();
        }
        return 0L;
    }

    public Calendar getSavedTime() {
        return this.getSavedTime(this.saveName);
    }

    public Calendar getSavedTime(String saveName) {
        String sfoFileName = this.getFileName(saveName, paramSfoFileName);
        SceIoStat sfoStat = Modules.IoFileMgrForUserModule.statFile(sfoFileName);
        if (sfoStat == null) {
            return null;
        }
        ScePspDateTime pspTime = sfoStat.mtime;
        Calendar savedTime = Calendar.getInstance();
        savedTime.set(pspTime.year, pspTime.month - 1, pspTime.day, pspTime.hour, pspTime.minute, pspTime.second);
        return savedTime;
    }

    @Override
    public int sizeof() {
        return this.base.totalSizeof();
    }

    public String getModeName() {
        if (this.mode < 0 || this.mode >= modeNames.length) {
            return String.format("UNKNOWN_MODE%d", this.mode);
        }
        return modeNames[this.mode];
    }

    public static boolean isSystemFile(String fileName) {
        for (int i = 0; i < systemFileNames.length; ++i) {
            if (!systemFileNames[i].equalsIgnoreCase(fileName)) continue;
            return true;
        }
        return false;
    }

    private boolean isPreR3306(String fileName) {
        SceIoStat stat = Modules.IoFileMgrForUserModule.statFile(this.getBasePath() + fileName);
        if (stat == null) {
            return false;
        }
        ScePspDateTime mtime = stat.mtime;
        if (mtime == null) {
            return false;
        }
        if (mtime.year < 2013) {
            return true;
        }
        if (mtime.year > 2013) {
            return false;
        }
        if (mtime.month < 7) {
            return true;
        }
        if (mtime.month > 7) {
            return false;
        }
        return mtime.day < 12;
    }

    private PspUtilitySavedataSecureFileList getSecureFileList(String fileName) {
        PSF psf = null;
        try {
            psf = this.readPsf(this.getBasePath(), paramSfoFileName);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (psf == null) {
            return null;
        }
        Object savedataFileList = psf.get("SAVEDATA_FILE_LIST");
        boolean addFileName = false;
        if (fileName != null && this.isPreR3306(fileName)) {
            addFileName = true;
        }
        PspUtilitySavedataSecureFileList fileList = null;
        if (savedataFileList == null ? !addFileName : !(savedataFileList instanceof byte[])) {
            return null;
        }
        if (savedataFileList != null) {
            fileList = new PspUtilitySavedataSecureFileList();
            fileList.read((byte[])savedataFileList);
        }
        if (addFileName) {
            if (fileList == null) {
                fileList = new PspUtilitySavedataSecureFileList();
            }
            fileList.add(fileName, null);
        }
        return fileList;
    }

    public boolean isSecureFile(String fileName) {
        PspUtilitySavedataSecureFileList fileList = this.getSecureFileList(fileName);
        if (fileList == null) {
            return false;
        }
        return fileList.contains(fileName);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(String.format("Address 0x%08X, mode=%d(%s), gameName=%s, saveName=%s, fileName=%s, secureVersion=%d", this.getBaseAddress(), this.mode, this.getModeName(), this.gameName, this.saveName, this.fileName, this.secureVersion));
        for (int i = 0; this.saveNameList != null && i < this.saveNameList.length; ++i) {
            if (i == 0) {
                s.append(", saveNameList=[");
            } else {
                s.append(", ");
            }
            s.append(this.saveNameList[i]);
            if (i != this.saveNameList.length - 1) continue;
            s.append("]");
        }
        return s.toString();
    }

    public static class PspUtilitySavedataSecureFileList {
        public static final int NUMBER_FILES = 99;
        public static final int SIZEOF = 3168;
        public List<PspUtilitySavedataSecureFile> fileList = new LinkedList<PspUtilitySavedataSecureFile>();

        public byte[] getBytes() {
            byte[] bytes = new byte[3168];
            int offset = 0;
            for (PspUtilitySavedataSecureFile file : this.fileList) {
                file.write(bytes, offset);
                offset += 32;
            }
            return bytes;
        }

        public void read(byte[] buffer) {
            PspUtilitySavedataSecureFile file;
            this.fileList.clear();
            for (int offset = 0; offset < 3168 && (file = new PspUtilitySavedataSecureFile()).read(buffer, offset); offset += 32) {
                this.fileList.add(file);
            }
        }

        public boolean contains(String fileName) {
            for (PspUtilitySavedataSecureFile file : this.fileList) {
                if (!file.fileName.equals(fileName)) continue;
                return true;
            }
            return false;
        }

        public void add(String fileName, byte[] key) {
            if (this.contains(fileName)) {
                return;
            }
            PspUtilitySavedataSecureFile file = new PspUtilitySavedataSecureFile(fileName, key);
            this.fileList.add(file);
        }
    }

    public static class PspUtilitySavedataSecureFile {
        public static final int SIZEOF = 32;
        private static final int FILENAME_LENGTH = 13;
        public String fileName;
        public byte[] key = new byte[16];

        public PspUtilitySavedataSecureFile() {
        }

        public PspUtilitySavedataSecureFile(String fileName, byte[] key) {
            this.fileName = fileName;
            if (key != null) {
                System.arraycopy(key, 0, this.key, 0, this.key.length);
            }
        }

        public void write(byte[] buffer, int offset) {
            byte[] fileNameBytes = this.fileName.getBytes();
            System.arraycopy(fileNameBytes, 0, buffer, offset, fileNameBytes.length);
            if (fileNameBytes.length < 13) {
                Arrays.fill(buffer, offset + fileNameBytes.length, offset + 13, (byte)0);
            }
            System.arraycopy(this.key, 0, buffer, offset + 13, this.key.length);
        }

        public boolean read(byte[] buffer, int offset) {
            int fileNameLength;
            if (offset + 32 > buffer.length) {
                return false;
            }
            for (fileNameLength = 13; fileNameLength > 0 && buffer[offset + fileNameLength - 1] == 0; --fileNameLength) {
            }
            if (fileNameLength <= 0) {
                return false;
            }
            this.fileName = new String(buffer, offset, fileNameLength);
            System.arraycopy(buffer, offset + 13, this.key, 0, this.key.length);
            return true;
        }
    }

    public static class PspUtilitySavedataListSaveNewData
    extends pspAbstractMemoryMappedStructure {
        public PspUtilitySavedataFileData icon0;
        public int titleAddr;
        public String title;

        @Override
        protected void read() {
            this.icon0 = new PspUtilitySavedataFileData();
            this.read(this.icon0);
            this.titleAddr = this.read32();
            this.title = this.titleAddr != 0 ? Utilities.readStringZ(this.mem, this.titleAddr) : null;
        }

        @Override
        protected void write() {
            this.write(this.icon0);
            this.write32(this.titleAddr);
            if (this.titleAddr != 0) {
                Utilities.writeStringZ(this.mem, this.titleAddr, this.title);
            }
        }

        @Override
        public int sizeof() {
            return this.icon0.sizeof() + 4;
        }
    }

    public static class PspUtilitySavedataFileData
    extends pspAbstractMemoryMappedStructure {
        public int buf;
        public int bufSize;
        public int size;

        @Override
        protected void read() {
            this.buf = this.read32();
            this.bufSize = this.read32();
            this.size = this.read32();
            this.readUnknown(4);
        }

        @Override
        protected void write() {
            this.write32(this.buf);
            this.write32(this.bufSize);
            this.write32(this.size);
            this.writeUnknown(4);
        }

        @Override
        public int sizeof() {
            return 16;
        }
    }

    public static class PspUtilitySavedataSFOParam
    extends pspAbstractMemoryMappedStructure {
        public String title;
        public String savedataTitle;
        public String detail;
        public int parentalLevel;

        @Override
        protected void read() {
            this.title = this.readStringNZ(128);
            this.savedataTitle = this.readStringNZ(128);
            this.detail = this.readStringNZ(1024);
            this.parentalLevel = this.read32();
        }

        @Override
        protected void write() {
            this.writeStringNZ(128, this.title);
            this.writeStringNZ(128, this.savedataTitle);
            this.writeStringNZ(1024, this.detail);
            this.write32(this.parentalLevel);
        }

        @Override
        public int sizeof() {
            return 1284;
        }
    }
}

