/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.util.Utilities;

public class pspFileBuffer {
    private int addr;
    private int maxSize;
    private int currentSize;
    private int readPosition;
    private int writePosition;
    private int filePosition;
    private int fileMaxSize;

    public pspFileBuffer() {
    }

    public pspFileBuffer(int addr, int maxSize) {
        this.addr = addr;
        this.maxSize = maxSize;
    }

    public pspFileBuffer(int addr, int maxSize, int readSize) {
        this.addr = addr;
        this.maxSize = maxSize;
        this.notifyWrite(readSize);
    }

    public void setFileMaxSize(int fileMaxSize) {
        this.fileMaxSize = fileMaxSize;
    }

    public boolean isFileEnd() {
        return this.filePosition >= this.fileMaxSize;
    }

    public int getWriteAddr() {
        return this.addr + this.writePosition;
    }

    public int getWriteSize() {
        return Utilities.min(this.maxSize - this.currentSize, this.maxSize - this.writePosition, this.fileMaxSize - this.filePosition);
    }

    public int getFilePosition() {
        return this.filePosition;
    }

    public int getReadAddr() {
        return this.addr + this.readPosition;
    }

    public int getReadSize() {
        return Utilities.min(this.currentSize, this.maxSize - this.readPosition);
    }

    public int getCurrentSize() {
        return this.currentSize;
    }

    public void reset(int readSize, int filePosition) {
        this.currentSize = 0;
        this.readPosition = 0;
        this.writePosition = 0;
        this.notifyWrite(readSize);
        this.filePosition = filePosition;
    }

    public void notifyRead(int size) {
        if (size > 0) {
            size = Utilities.min(size, this.currentSize);
            this.readPosition = this.incrementPosition(this.readPosition, size);
            this.currentSize -= size;
        }
    }

    public void notifyReadAll() {
        this.notifyRead(this.currentSize);
    }

    public void notifyWrite(int size) {
        if (size > 0) {
            size = Utilities.min(size, this.getMaxSize() - this.currentSize);
            this.writePosition = this.incrementPosition(this.writePosition, size);
            this.filePosition += size;
            this.currentSize += size;
        }
    }

    private int incrementPosition(int position, int size) {
        if ((position += size) >= this.maxSize) {
            position -= this.maxSize;
        }
        return position;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getAddr() {
        return this.addr;
    }

    public void setAddr(int addr) {
        this.addr = addr;
    }

    public boolean isEmpty() {
        return this.currentSize == 0;
    }

    public String toString() {
        return String.format("pspFileBuffer(addr=0x%08X, maxSize=0x%X, currentSize=0x%X, readPosition=0x%X, writePosition=0x%X, filePosition=0x%X, fileMaxSize=0x%X)", this.getAddr(), this.getMaxSize(), this.currentSize, this.readPosition, this.writePosition, this.getFilePosition(), this.fileMaxSize);
    }
}

