/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import jpcsp.Clock;
import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.TPointer64;
import jpcsp.HLE.kernel.types.ScePspDateTime;
import jpcsp.HLE.modules.HLEModule;
import org.apache.log4j.Logger;

@HLELogging
public class sceRtc
extends HLEModule {
    public static Logger log = Modules.getLogger("sceRtc");
    static final int PSP_TIME_INVALID_YEAR = -1;
    static final int PSP_TIME_INVALID_MONTH = -2;
    static final int PSP_TIME_INVALID_DAY = -3;
    static final int PSP_TIME_INVALID_HOUR = -4;
    static final int PSP_TIME_INVALID_MINUTES = -5;
    static final int PSP_TIME_INVALID_SECONDS = -6;
    static final int PSP_TIME_INVALID_MICROSECONDS = -7;
    static final int PSP_TIME_SECONDS_IN_MINUTE = 60;
    static final int PSP_TIME_SECONDS_IN_HOUR = 3600;
    static final int PSP_TIME_SECONDS_IN_DAY = 86400;
    static final int PSP_TIME_SECONDS_IN_WEEK = 604800;
    static final int PSP_TIME_SECONDS_IN_MONTH = 2629743;
    static final int PSP_TIME_SECONDS_IN_YEAR = 31556926;
    private long rtcMagicOffset = 62135596800000000L;
    protected static SimpleDateFormat rfc3339 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    @Override
    public String getName() {
        return "sceRtc";
    }

    protected long hleGetCurrentTick() {
        Clock.TimeNanos timeNanos = Emulator.getClock().currentTimeNanos();
        return (long)(timeNanos.micros + timeNanos.millis * 1000) + (long)timeNanos.seconds * 1000000L + this.rtcMagicOffset;
    }

    protected int hleRtcTickAdd64(TPointer64 dstPtr, TPointer64 srcPtr, long value, long multiplier) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleRtcTickAdd64 dstPtr=%s, srcPtr=%s(%d), %d * %d", dstPtr, srcPtr, srcPtr.getValue(), value, multiplier));
        }
        long src = srcPtr.getValue();
        dstPtr.setValue(src + multiplier * value);
        return 0;
    }

    protected int hleRtcTickAdd32(TPointer64 dstPtr, TPointer64 srcPtr, int value, long multiplier) {
        log.debug((Object)("hleRtcTickAdd32 " + multiplier + " * " + value));
        long src = srcPtr.getValue();
        dstPtr.setValue(src + multiplier * (long)value);
        return 0;
    }

    protected Date getDateFromTick(long tick) {
        return new Date((tick - this.rtcMagicOffset) / 1000L);
    }

    protected String formatRFC3339(Date date) {
        String result = rfc3339.format(date);
        result = result.replaceFirst("(\\d\\d)(\\d\\d)$", "$1:$2");
        return result;
    }

    protected TimeZone getLocalTimeZone() {
        return TimeZone.getDefault();
    }

    @HLEFunction(nid=-1004787629, version=150)
    public int sceRtcGetTickResolution() {
        return 1000000;
    }

    @HLEFunction(nid=1065015143, version=150)
    public int sceRtcGetCurrentTick(TPointer64 currentTick) {
        currentTick.setValue(this.hleGetCurrentTick());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRtcGetCurrentTick returning %d", currentTick.getValue()));
        }
        return 0;
    }

    @HLEFunction(nid=18809793, version=150)
    public long sceRtcGetAccumulativeTime() {
        return this.hleGetCurrentTick();
    }

    @HLEFunction(nid=43819955, version=150)
    public long sceRtcGetAccumlativeTime() {
        return this.hleGetCurrentTick();
    }

    @HLEFunction(nid=1291474864, version=150)
    public int sceRtcGetCurrentClock(TPointer addr, int tz) {
        ScePspDateTime pspTime = new ScePspDateTime(tz);
        pspTime.write(addr);
        return 0;
    }

    @HLEFunction(nid=-406684389, version=150)
    public int sceRtcGetCurrentClockLocalTime(TPointer addr) {
        ScePspDateTime pspTime = new ScePspDateTime();
        pspTime.write(addr);
        return 0;
    }

    @HLEFunction(nid=881352205, version=150)
    public int sceRtcConvertUtcToLocalTime(TPointer64 utcPtr, TPointer64 localPtr) {
        TimeZone localTimeZone = this.getLocalTimeZone();
        this.hleRtcTickAdd64(localPtr, utcPtr, localTimeZone.getRawOffset(), 1000L);
        return 0;
    }

    @HLEFunction(nid=2006074018, version=150)
    public int sceRtcConvertLocalTimeToUTC(TPointer64 localPtr, TPointer64 utcPtr) {
        TimeZone localTimeZone = this.getLocalTimeZone();
        this.hleRtcTickAdd64(utcPtr, localPtr, -localTimeZone.getRawOffset(), 1000L);
        return 0;
    }

    @HLEFunction(nid=1110473239, version=150)
    public boolean sceRtcIsLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    @HLEFunction(nid=99562028, version=150)
    public int sceRtcGetDaysInMonth(int year, int month) {
        GregorianCalendar cal = new GregorianCalendar(year, month - 1, 1);
        int days = ((Calendar)cal).getActualMaximum(5);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRtcGetDaysInMonth returning %d", days));
        }
        return days;
    }

    @HLEFunction(nid=1467116481, version=150)
    public int sceRtcGetDayOfWeek(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day);
        int dayOfWeekNumber = cal.get(7);
        dayOfWeekNumber = (dayOfWeekNumber - 1 + 7) % 7;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRtcGetDayOfWeek returning %d", dayOfWeekNumber));
        }
        return dayOfWeekNumber;
    }

    @HLEFunction(nid=1260084866, version=150)
    public int sceRtcCheckValid(ScePspDateTime time) {
        GregorianCalendar cal = new GregorianCalendar(time.year, time.month - 1, time.day, time.hour, time.minute, time.second);
        int result = 0;
        if (time.year < 1582 || time.year > 3000) {
            result = -1;
        } else if (time.month < 1 || time.month > 12) {
            result = -2;
        } else if (time.day < 1 || time.day > 31) {
            result = -3;
        } else if (time.hour < 0 || time.hour > 23) {
            result = -4;
        } else if (time.minute < 0 || time.minute > 59) {
            result = -5;
        } else if (time.second < 0 || time.second > 59) {
            result = -6;
        } else if (time.microsecond < 0 || time.microsecond >= 1000000) {
            result = -7;
        } else if (cal.get(5) != time.day) {
            result = -3;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRtcCheckValid time=%s, cal=%s, returning 0x%08X", time, cal, result));
        }
        return result;
    }

    @HLEFunction(nid=981499080, version=150)
    public int sceRtcSetTime_t(TPointer dateAddr, int time) {
        ScePspDateTime dateTime = ScePspDateTime.fromUnixTime(time);
        dateTime.write(dateAddr);
        return 0;
    }

    @HLEFunction(nid=667179340, version=150)
    public int sceRtcGetTime_t(ScePspDateTime dateTime, TPointer32 timeAddr) {
        Calendar cal = Calendar.getInstance();
        cal.set(dateTime.year, dateTime.month - 1, dateTime.day, dateTime.hour, dateTime.minute, dateTime.second);
        int unixtime = (int)(cal.getTime().getTime() / 1000L);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRtcGetTime_t returning %d", unixtime));
        }
        timeAddr.setValue(unixtime);
        return 0;
    }

    @HLEFunction(nid=-267980188, version=150)
    public int sceRtcSetDosTime(TPointer dateAddr, int time) {
        ScePspDateTime dateTime = ScePspDateTime.fromMSDOSTime(time);
        dateTime.write(dateAddr);
        return 0;
    }

    @HLEFunction(nid=906450279, version=150)
    public int sceRtcGetDosTime(ScePspDateTime dateTime, TPointer32 timeAddr) {
        Calendar cal = Calendar.getInstance();
        cal.set(dateTime.year, dateTime.month - 1, dateTime.day, dateTime.hour, dateTime.minute, dateTime.second);
        int dostime = (int)(cal.getTime().getTime() / 1000L);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRtcGetDosTime returning %d", dostime));
        }
        timeAddr.setValue(dostime);
        return 0;
    }

    @HLEFunction(nid=2060340228, version=150)
    public int sceRtcSetWin32FileTime(TPointer dateAddr, long time) {
        ScePspDateTime dateTime = ScePspDateTime.fromFILETIMETime(time);
        dateTime.write(dateAddr);
        return 0;
    }

    @HLEFunction(nid=-816441197, version=150)
    public int sceRtcGetWin32FileTime(ScePspDateTime dateTime, TPointer64 timeAddr) {
        Calendar cal = Calendar.getInstance();
        cal.set(dateTime.year, dateTime.month - 1, dateTime.day, dateTime.hour, dateTime.minute, dateTime.second);
        int filetimetime = (int)(cal.getTime().getTime() / 1000L);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRtcGetWin32FileTime returning %d", filetimetime));
        }
        timeAddr.setValue(filetimetime);
        return 0;
    }

    @HLEFunction(nid=2127732288, version=150)
    public int sceRtcSetTick(TPointer timeAddr, TPointer64 ticksAddr) {
        long ticks = ticksAddr.getValue() - this.rtcMagicOffset;
        ScePspDateTime time = ScePspDateTime.fromMicros(ticks);
        time.write(timeAddr);
        return 0;
    }

    @HLEFunction(nid=1878264524, version=150)
    public int sceRtcGetTick(ScePspDateTime time, TPointer64 ticksAddr) {
        GregorianCalendar cal = new GregorianCalendar(time.year, time.month - 1, time.day, time.hour, time.minute, time.second);
        cal.set(14, time.microsecond / 1000);
        ((Calendar)cal).setTimeZone(ScePspDateTime.GMT);
        long ticks = this.rtcMagicOffset + cal.getTimeInMillis() * 1000L + (long)(time.microsecond % 1000);
        ticksAddr.setValue(ticks);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRtcGetTick returning %d", ticks));
        }
        return 0;
    }

    @HLEFunction(nid=-1630491001, version=150)
    public int sceRtcCompareTick(TPointer64 firstPtr, TPointer64 secondPtr) {
        long tick2;
        long tick1 = firstPtr.getValue();
        if (tick1 < (tick2 = secondPtr.getValue())) {
            return -1;
        }
        if (tick1 > tick2) {
            return 1;
        }
        return 0;
    }

    @HLEFunction(nid=1156865541, version=150)
    public int sceRtcTickAddTicks(TPointer64 dstPtr, TPointer64 srcPtr, long value) {
        log.debug((Object)"sceRtcTickAddTicks redirecting to hleRtcTickAdd64(1)");
        return this.hleRtcTickAdd64(dstPtr, srcPtr, value, 1L);
    }

    @HLEFunction(nid=651319901, version=150)
    public int sceRtcTickAddMicroseconds(TPointer64 dstPtr, TPointer64 srcPtr, long value) {
        log.debug((Object)"sceRtcTickAddMicroseconds redirecting to hleRtcTickAdd64(1)");
        return this.hleRtcTickAdd64(dstPtr, srcPtr, value, 1L);
    }

    @HLEFunction(nid=-224088091, version=150)
    public int sceRtcTickAddSeconds(TPointer64 dstPtr, TPointer64 srcPtr, long value) {
        log.debug((Object)"sceRtcTickAddSeconds redirecting to hleRtcTickAdd64(1000000)");
        return this.hleRtcTickAdd64(dstPtr, srcPtr, value, 1000000L);
    }

    @HLEFunction(nid=-429892662, version=150)
    public int sceRtcTickAddMinutes(TPointer64 dstPtr, TPointer64 srcPtr, long value) {
        log.debug((Object)"sceRtcTickAddMinutes redirecting to hleRtcTickAdd64(60*1000000)");
        return this.hleRtcTickAdd64(dstPtr, srcPtr, value, 60000000L);
    }

    @HLEFunction(nid=651665994, version=150)
    public int sceRtcTickAddHours(TPointer64 dstPtr, TPointer64 srcPtr, int value) {
        log.debug((Object)"sceRtcTickAddHours redirecting to hleRtcTickAdd32(60*60*1000000)");
        return this.hleRtcTickAdd32(dstPtr, srcPtr, value, 3600000000L);
    }

    @HLEFunction(nid=-451196038, version=150)
    public int sceRtcTickAddDays(TPointer64 dstPtr, TPointer64 srcPtr, int value) {
        log.debug((Object)"sceRtcTickAddDays redirecting to hleRtcTickAdd32(24*60*60*1000000)");
        return this.hleRtcTickAdd32(dstPtr, srcPtr, value, 86400000000L);
    }

    @HLEFunction(nid=-818271064, version=150)
    public int sceRtcTickAddWeeks(TPointer64 dstPtr, TPointer64 srcPtr, int value) {
        log.debug((Object)"sceRtcTickAddWeeks redirecting to hleRtcTickAdd32(7*24*60*60*1000000)");
        return this.hleRtcTickAdd32(dstPtr, srcPtr, value, 604800000000L);
    }

    @HLEFunction(nid=-604549349, version=150)
    public int sceRtcTickAddMonths(TPointer64 dstPtr, TPointer64 srcPtr, int value) {
        log.debug((Object)"sceRtcTickAddMonths redirecting to hleRtcTickAdd32(30*24*60*60*1000000)");
        return this.hleRtcTickAdd32(dstPtr, srcPtr, value, 2629743000000L);
    }

    @HLEFunction(nid=1115958391, version=150)
    public int sceRtcTickAddYears(TPointer64 dstPtr, TPointer64 srcPtr, int value) {
        log.debug((Object)"sceRtcTickAddYears redirecting to hleRtcTickAdd32(365*24*60*60*1000000)");
        return this.hleRtcTickAdd32(dstPtr, srcPtr, value, 31556926000000L);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-966544455, version=150)
    public int sceRtcFormatRFC2822() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2112254235, version=150)
    public int sceRtcFormatRFC2822LocalTime() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=77134652, version=150)
    public int sceRtcFormatRFC3339() {
        return 0;
    }

    @HLEFunction(nid=670664003, version=150)
    public int sceRtcFormatRFC3339LocalTime(TPointer resultString, TPointer64 srcPtr) {
        Date date = this.getDateFromTick(srcPtr.getValue());
        String result = this.formatRFC3339(date);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRtcFormatRFC3339LocalTime src=%d, returning '%s'", srcPtr.getValue(), result));
        }
        resultString.setStringZ(result);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-541303018, version=150)
    public int sceRtcParseDateTime() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=685894024, version=150)
    public int sceRtcParseRFC3339() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2099232467, version=150)
    public int sceRtcSetAlarmTick(TPointer64 srcPtr) {
        return 0;
    }
}

