/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules150.sceAudio;
import jpcsp.sound.SoundChannel;
import org.apache.log4j.Logger;

@HLELogging
public class sceVaudio
extends HLEModule {
    public static Logger log = Modules.getLogger("sceVaudio");
    protected static final int PSP_VAUDIO_VOLUME_BASE = 32768;
    protected static final int PSP_VAUDIO_SAMPLE_MIN = 256;
    protected static final int PSP_VAUDIO_SAMPLE_MAX = 2048;
    protected static final int PSP_VAUDIO_FORMAT_MONO = 0;
    protected static final int PSP_VAUDIO_FORMAT_STEREO = 2;
    protected static final int PSP_VAUDIO_EFFECT_TYPE_NONE = 0;
    protected static final int PSP_VAUDIO_EFFECT_TYPE_1 = 1;
    protected static final int PSP_VAUDIO_EFFECT_TYPE_2 = 2;
    protected static final int PSP_VAUDIO_EFFECT_TYPE_3 = 3;
    protected static final int PSP_VAUDIO_EFFECT_TYPE_4 = 4;
    protected static final int PSP_VAUDIO_ALC_MODE_NONE = 0;
    protected static final int PSP_VAUDIO_ALC_MODE_1 = 1;
    protected SoundChannel pspVaudioChannel;
    protected boolean pspVaudioChannelReserved;

    @Override
    public String getName() {
        return "sceVaudio";
    }

    @Override
    public void start() {
        SoundChannel.init();
        this.pspVaudioChannel = Modules.sceAudioModule.pspSRCChannel;
        this.pspVaudioChannelReserved = false;
        super.start();
    }

    public int checkSampleCount(int sampleCount) {
        if (sampleCount < 256 || sampleCount > 2048) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Invalid sampleCount 0x%X", sampleCount));
            }
            throw new SceKernelErrorException(-2147483388);
        }
        return sampleCount;
    }

    public int checkFrequency(int frequency) {
        switch (frequency) {
            case 0: 
            case 8000: 
            case 11025: 
            case 12000: 
            case 16000: 
            case 22050: 
            case 24000: 
            case 32000: 
            case 48000: {
                break;
            }
            default: {
                Modules.ThreadManForUserModule.hleYieldCurrentThread();
                throw new SceKernelErrorException(-2144993270);
            }
        }
        return frequency;
    }

    public int checkChannelCount(int channelCount) {
        if (channelCount != 2 && channelCount != 4) {
            throw new SceKernelErrorException(-2147483384);
        }
        return channelCount;
    }

    protected int doAudioOutput(SoundChannel channel, int pvoid_buf) {
        return sceAudio.doAudioOutput(channel, pvoid_buf);
    }

    protected void blockThreadOutput(SoundChannel channel, int addr, int leftVolume, int rightVolume) {
        sceAudio.blockThreadOutput(channel, addr, leftVolume, rightVolume);
    }

    protected int changeChannelVolume(SoundChannel channel, int leftvol, int rightvol) {
        return sceAudio.changeChannelVolume(channel, leftvol, rightvol);
    }

    @HLEFunction(nid=1733844477, version=150, checkInsideInterrupt=true)
    public int sceVaudioChRelease() {
        if (!this.pspVaudioChannel.isReserved()) {
            return -2144993272;
        }
        this.pspVaudioChannelReserved = false;
        this.pspVaudioChannel.release();
        this.pspVaudioChannel.setReserved(false);
        return 0;
    }

    @HLEFunction(nid=62292093, version=150, checkInsideInterrupt=true)
    public int sceVaudioChReserve(@CheckArgument(value="checkSampleCount") int sampleCount, @CheckArgument(value="checkFrequency") int freq, @CheckArgument(value="checkChannelCount") int format) {
        if (this.pspVaudioChannelReserved) {
            return -2147483615;
        }
        if (this.pspVaudioChannel.isReserved()) {
            Modules.ThreadManForUserModule.hleYieldCurrentThread();
            return -2144960510;
        }
        this.pspVaudioChannelReserved = true;
        this.pspVaudioChannel.setReserved(true);
        this.pspVaudioChannel.setSampleLength(sampleCount);
        this.pspVaudioChannel.setSampleRate(freq);
        this.pspVaudioChannel.setFormat(format == 0 ? 16 : 0);
        Modules.ThreadManForUserModule.hleYieldCurrentThread();
        return 0;
    }

    @HLEFunction(nid=-1987696290, version=150, checkInsideInterrupt=true)
    public int sceVaudioOutputBlocking(int vol, TPointer buf) {
        int result = 0;
        if (!this.pspVaudioChannel.isOutputBlocking()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceVaudioOutputBlocking[not blocking] %s", this.pspVaudioChannel));
            }
            if ((vol & 0x8000) != 32768) {
                this.changeChannelVolume(this.pspVaudioChannel, vol, vol);
            }
            result = this.doAudioOutput(this.pspVaudioChannel, buf.getAddress());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceVaudioOutputBlocking[not blocking] returning %d (%s)", result, this.pspVaudioChannel));
            }
            Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceVaudioOutputBlocking[blocking] %s", this.pspVaudioChannel));
            }
            this.blockThreadOutput(this.pspVaudioChannel, buf.getAddress(), vol, vol);
        }
        return result;
    }

    @HLEUnimplemented
    @HLEFunction(nid=879738516, version=150, checkInsideInterrupt=true)
    public int sceVaudioSetEffectType(int type, int vol) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-875254703, version=150, checkInsideInterrupt=true)
    public int sceVaudioSetAlcMode(int alcMode) {
        return 0;
    }
}

