/*
 * Decompiled with CFR 0.152.
 */
package jpcsp;

import jpcsp.Allegrex.CpuState;
import jpcsp.Memory;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class ParameterReader {
    private CpuState cpu;
    private Memory memory;
    private int parameterIndex = 0;
    private int parameterIndexFloat = 0;
    protected static final int maxParameterInGprRegisters = 8;
    protected static final int maxParameterInFprRegisters = 8;
    protected static final int firstParameterInGpr = 4;
    protected static final int firstParameterInFpr = 12;

    public ParameterReader(CpuState cpu, Memory memory) {
        this.cpu = cpu;
        this.memory = memory;
    }

    public void setCpu(CpuState cpu) {
        this.cpu = cpu;
    }

    public void resetReading() {
        this.parameterIndex = 0;
        this.parameterIndexFloat = 0;
    }

    private int getParameterIntAt(int index) {
        if (index >= 8) {
            return this.memory.read32(this.cpu._sp + (index - 8) * 4);
        }
        return this.cpu.getRegister(4 + index);
    }

    private float getParameterFloatAt(int index) {
        if (index >= 8) {
            throw new NotImplementedException();
        }
        return this.cpu.fpr[12 + index];
    }

    private long getParameterLongAt(int index) {
        if (index % 2 != 0) {
            throw new RuntimeException("Parameter misalignment");
        }
        return (long)this.getParameterIntAt(index) + (long)this.getParameterIntAt(index + 1) << 32;
    }

    protected int moveParameterIndex(int size) {
        while (this.parameterIndex % size != 0) {
            ++this.parameterIndex;
        }
        int retParameterIndex = this.parameterIndex;
        this.parameterIndex += size;
        return retParameterIndex;
    }

    protected int moveParameterIndexFloat(int size) {
        while (this.parameterIndexFloat % size != 0) {
            ++this.parameterIndexFloat;
        }
        int retParameterIndexFloat = this.parameterIndexFloat;
        this.parameterIndexFloat += size;
        return retParameterIndexFloat;
    }

    public int getNextInt() {
        return this.getParameterIntAt(this.moveParameterIndex(1));
    }

    public long getNextLong() {
        return this.getParameterLongAt(this.moveParameterIndex(2));
    }

    public float getNextFloat() {
        return this.getParameterFloatAt(this.moveParameterIndexFloat(1));
    }

    public void setReturnValueInt(int value) {
        this.cpu._v0 = value;
    }

    public void setReturnValueFloat(float value) {
        this.cpu.fpr[0] = value;
    }

    public void setReturnValueLong(long value) {
        this.cpu._v0 = (int)(value >> 0 & 0xFFFFFFFFFFFFFFFFL);
        this.cpu._v1 = (int)(value >> 32 & 0xFFFFFFFFFFFFFFFFL);
    }
}

