/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.autotests;

import java.awt.DisplayMode;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeoutException;
import javax.imageio.ImageIO;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.GUI.IMainGUI;
import jpcsp.HLE.Modules;
import jpcsp.HLE.VFS.emulator.EmulatorVirtualFileSystem;
import jpcsp.HLE.modules.HLEModuleManager;
import jpcsp.HLE.modules150.IoFileMgrForUser;
import jpcsp.autotests.AutoTestsOutput;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.graphics.VideoEngine;
import jpcsp.hardware.Screen;
import jpcsp.log.LoggingOutputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class AutoTestsRunner {
    Emulator emulator = new Emulator(new DummyGUI());
    private static final String rootDirectory = "../pspautotests";
    private static final Logger log = Logger.getLogger((String)"pspautotests");
    private static final int FAIL_TIMEOUT = 10;

    public AutoTestsRunner() {
        this.emulator.setFirmwareVersion(630);
    }

    public void run() {
        DOMConfigurator.configure((String)"LogSettings.xml");
        System.setOut(new PrintStream(new LoggingOutputStream(Logger.getLogger((String)"emu"), Level.INFO)));
        Screen.setHasScreen(false);
        IoFileMgrForUser.IoOperation.iodevctl.setDelayMillis(0);
        Modules.sceDisplayModule.setCalledFromCommandLine();
        try {
            this.runImpl();
        }
        catch (Throwable o) {
            o.printStackTrace();
        }
        System.exit(0);
    }

    protected void runImpl() throws Throwable {
        this.runTestFolder("../pspautotests/tests");
    }

    protected void runTestFolder(String folderPath) throws Throwable {
        for (File file : new File(folderPath).listFiles()) {
            String name;
            if (file.getName().charAt(0) == '.') continue;
            if (file.isDirectory()) {
                this.runTestFolder(file.getPath());
                continue;
            }
            if (!file.isFile() || !(name = file.getPath()).substring(name.length() - 9).equals(".expected")) continue;
            this.runTest(name.substring(0, name.length() - 9));
        }
    }

    protected boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    }

    protected void runTest(String baseFileName) throws Throwable {
        new File(EmulatorVirtualFileSystem.getScreenshotFileName()).delete();
        boolean timeout = false;
        try {
            this.runFile(baseFileName + ".prx");
        }
        catch (TimeoutException toe) {
            timeout = true;
        }
        this.checkOutput(baseFileName, baseFileName + ".expected", timeout);
    }

    protected BufferedImage readBmp(File imageFile) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(imageFile));
        int magic = VideoEngine.readLittleEndianShort(is);
        int fileSize = VideoEngine.readLittleEndianInt(is);
        ((InputStream)is).skip(4L);
        int dataOffset = VideoEngine.readLittleEndianInt(is);
        int dibHeaderLength = VideoEngine.readLittleEndianInt(is);
        int imageWidth = VideoEngine.readLittleEndianInt(is);
        int imageHeight = VideoEngine.readLittleEndianInt(is);
        int numberPlanes = VideoEngine.readLittleEndianShort(is);
        int bitsPerPixel = VideoEngine.readLittleEndianShort(is);
        ((InputStream)is).skip(dataOffset - 14 - 16);
        BufferedImage img = null;
        if (magic == 19778 && dibHeaderLength >= 16 && fileSize >= dataOffset && numberPlanes == 1 && bitsPerPixel == 32) {
            img = new BufferedImage(imageWidth, imageHeight, 2);
            for (int y = imageHeight - 1; y >= 0; --y) {
                for (int x = 0; x < imageWidth; ++x) {
                    int argb = VideoEngine.readLittleEndianInt(is);
                    img.setRGB(x, y, argb);
                }
            }
        }
        ((InputStream)is).close();
        return img;
    }

    protected boolean areColorsEqual(int color1, int color2) {
        return (color1 & 0xFFFFFF) == (color2 & 0xFFFFFF);
    }

    protected boolean compareScreenshots(File expected, File result, File compare) {
        boolean equals = false;
        try {
            BufferedImage resultImg;
            BufferedImage expectedImg = ImageIO.read(expected);
            try {
                resultImg = ImageIO.read(result);
            }
            catch (RuntimeException e) {
                resultImg = this.readBmp(result);
            }
            int width = Math.min(expectedImg.getWidth(), resultImg.getWidth());
            int height = Math.min(expectedImg.getHeight(), resultImg.getHeight());
            BufferedImage compareImg = new BufferedImage(width, height, 1);
            equals = true;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int resultColor;
                    int expectedColor = expectedImg.getRGB(x, y);
                    if (this.areColorsEqual(expectedColor, resultColor = resultImg.getRGB(x, y))) {
                        compareImg.setRGB(x, y, 0);
                        continue;
                    }
                    compareImg.setRGB(x, y, 0xFF0000);
                    equals = false;
                }
            }
            ImageIO.write((RenderedImage)compareImg, "bmp", compare);
        }
        catch (IOException e) {
            log.error((Object)"comparing screenshots", (Throwable)e);
        }
        return equals;
    }

    protected void checkOutput(String baseFileName, String fileName, boolean timeout) throws IOException {
        String expectedOutput;
        String actualOutput = AutoTestsOutput.getOutput().trim();
        if (actualOutput.equals(expectedOutput = AutoTestsRunner.readFileAsString(fileName).trim())) {
            log.info((Object)String.format("%s: OK", baseFileName));
        } else {
            if (timeout) {
                log.error((Object)String.format("%s: FAIL, TIMEOUT", baseFileName));
            } else {
                log.error((Object)String.format("%s: FAIL", baseFileName));
            }
            AutoTestsRunner.diff(expectedOutput, actualOutput);
        }
        File screenshotExpected = new File(fileName + ".bmp");
        if (screenshotExpected.canRead()) {
            File screenshotResult = new File(EmulatorVirtualFileSystem.getScreenshotFileName());
            if (screenshotResult.canRead()) {
                File savedScreenshotResult = new File(baseFileName + ".result.bmp");
                savedScreenshotResult.delete();
                if (screenshotResult.renameTo(savedScreenshotResult)) {
                    log.info((Object)String.format("%s: saved screenshot under '%s'", baseFileName, savedScreenshotResult));
                    File compareScreenshot = new File(baseFileName + ".compare.bmp");
                    if (this.compareScreenshots(screenshotExpected, savedScreenshotResult, compareScreenshot)) {
                        log.info((Object)String.format("%s: screenshots are identical", baseFileName));
                    } else {
                        log.error((Object)String.format("%s: screenshots differ, see '%s'", baseFileName, compareScreenshot));
                    }
                } else {
                    log.error((Object)String.format("%s: cannot save screenshot from '%s' to '%s'", baseFileName, screenshotResult, savedScreenshotResult));
                }
            } else {
                log.error((Object)String.format("%s: FAIL, no result screenshot found", baseFileName));
            }
        }
    }

    public static void diff(String x, String y) {
        AutoTestsRunner.diff(x.split("\\n"), y.split("\\n"));
    }

    public static void diff(String[] x, String[] y) {
        int j;
        int i;
        int M = x.length;
        int N = y.length;
        int[][] opt = new int[M + 1][N + 1];
        for (i = M - 1; i >= 0; --i) {
            for (j = N - 1; j >= 0; --j) {
                opt[i][j] = x[i].equals(y[j]) ? opt[i + 1][j + 1] + 1 : Math.max(opt[i + 1][j], opt[i][j + 1]);
            }
        }
        i = 0;
        j = 0;
        while (i < M && j < N) {
            if (x[i].equals(y[j])) {
                log.debug((Object)("  " + x[i]));
                ++i;
                ++j;
                continue;
            }
            if (opt[i + 1][j] >= opt[i][j + 1]) {
                log.info((Object)("- " + x[i++]));
                continue;
            }
            log.info((Object)("+ " + y[j++]));
        }
        while (i < M || j < N) {
            if (i == M) {
                log.info((Object)("+ " + y[j++]));
                continue;
            }
            if (j != N) continue;
            log.info((Object)("- " + x[i++]));
        }
    }

    protected void reset() {
        AutoTestsOutput.clearOutput();
        Emulator.PauseEmuWithStatus(64);
        Emulator.getInstance().initNewPsp(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runFile(String fileName) throws Throwable {
        File file = new File(fileName);
        this.reset();
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            try {
                FileChannel roChannel = raf.getChannel();
                try {
                    MappedByteBuffer readbuffer = roChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)roChannel.size());
                    this.emulator.load(file.getPath(), readbuffer);
                }
                finally {
                    roChannel.close();
                }
            }
            finally {
                raf.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        RuntimeContext.setIsHomebrew(true);
        UmdIsoReader umdIsoReader = new UmdIsoReader("../pspautotests/input/cube.cso");
        Modules.IoFileMgrForUserModule.setIsoReader(umdIsoReader);
        Modules.sceUmdUserModule.setIsoReader(umdIsoReader);
        Modules.IoFileMgrForUserModule.setfilepath(file.getParent());
        log.debug((Object)String.format("Running: %s...", fileName));
        RuntimeContext.setIsHomebrew(false);
        HLEModuleManager.getInstance().startModules(false);
        Modules.sceDisplayModule.setUseSoftwareRenderer(true);
        this.emulator.RunEmu();
        long startTime = System.currentTimeMillis();
        while (!Emulator.pause) {
            Modules.sceDisplayModule.step();
            if (System.currentTimeMillis() - startTime > 10000L) {
                throw new TimeoutException();
            }
            Thread.sleep(1L);
        }
        HLEModuleManager.getInstance().stopModules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileAsString(String filePath) throws IOException {
        StringBuilder s = new StringBuilder();
        BufferedReader f = null;
        try {
            String line;
            f = new BufferedReader(new FileReader(filePath));
            while ((line = f.readLine()) != null) {
                s.append(line);
                s.append('\n');
            }
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
        return s.toString();
    }

    class DummyGUI
    implements IMainGUI {
        DummyGUI() {
        }

        @Override
        public void setMainTitle(String title) {
        }

        @Override
        public void RefreshButtons() {
        }

        @Override
        public void setLocation() {
        }

        @Override
        public DisplayMode getDisplayMode() {
            return new DisplayMode(480, 272, 32, 60);
        }

        @Override
        public void endWindowDialog() {
        }

        @Override
        public boolean isFullScreen() {
            return false;
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        @Override
        public void pack() {
        }

        @Override
        public void setFullScreenDisplaySize() {
        }

        @Override
        public void startWindowDialog(Window window) {
        }

        @Override
        public void startBackgroundWindowDialog(Window window) {
        }

        @Override
        public Rectangle getCaptureRectangle() {
            return null;
        }

        @Override
        public void onUmdChange() {
        }

        @Override
        public void setDisplayMinimumSize(int width, int height) {
        }

        @Override
        public void setDisplaySize(int width, int height) {
        }
    }
}

